/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.chem;

import java.util.ArrayList;
import java.util.List;
import neurord.model.InjectionStim;
import neurord.numeric.BaseCalc;
import neurord.numeric.chem.ReactionTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StimulationTable {
    static final Logger log = LogManager.getLogger();
    private final ArrayList<Stimulation> stims = new ArrayList();
    private final int nspec;

    public StimulationTable(List<InjectionStim> stims, ReactionTable rtab) {
        this.nspec = rtab.getSpecies().length;
        if (stims != null) {
            for (InjectionStim stim : stims) {
                Stimulation.addTo(this.stims, rtab.getSpecieIndex(stim.getSpecies()), stim);
            }
        }
    }

    public double[][] getStimsForInterval(double time, double dt) {
        double[][] ret = new double[this.stims.size()][this.nspec];
        for (int i = 0; i < ret.length; ++i) {
            Stimulation stim = this.stims.get(i);
            double f = stim.effectiveRate(time, dt);
            if (!(f > 0.0)) continue;
            ret[i][stim.species] = f * stim.rate * dt;
        }
        return ret;
    }

    public ArrayList<Stimulation> getStimulations() {
        return this.stims;
    }

    public String[] getTargetIDs() {
        String[] ret = new String[this.stims.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.stims.get((int)i).site;
        }
        return ret;
    }

    public static class Stimulation {
        public final int species;
        public final String site;
        public final BaseCalc.distribution_t distribution;
        public final double rate;
        public final double onset;
        public final double duration;
        public final double period;
        public final double end;

        public Stimulation(int species, String site, BaseCalc.distribution_t distribution, int train, double rate, double onset, double duration, double iti, double period, double end) {
            double real_end;
            double train_offset;
            if (Double.isNaN(rate) || Double.isNaN(onset)) {
                throw new RuntimeException("rate and onset cannot be NaN");
            }
            if (Double.isNaN(duration) && Double.isNaN(end)) {
                throw new RuntimeException("duration and end cannot be both NaN");
            }
            this.species = species;
            this.site = site;
            this.distribution = distribution;
            if (Double.isNaN(period)) {
                train_offset = duration + iti;
                real_end = onset + duration;
            } else {
                train_offset = end - onset + iti;
                real_end = end + (double)train * train_offset;
            }
            this.rate = rate;
            this.onset = onset + (double)train * train_offset;
            this.duration = duration;
            this.period = period;
            this.end = real_end;
        }

        public String toString() {
            return String.format("%s \u2192%s %s rate=%g onset=%f duration=%f period=%f end=%f", new Object[]{this.getClass().getSimpleName(), this.site, this.distribution, this.rate, this.onset, this.duration, this.period, this.end});
        }

        public double effectiveRate(double start, double dt) {
            if (Double.isNaN(this.period)) {
                return Stimulation.pulseOverlap(start, dt, this.onset, this.duration);
            }
            int ipulse = (int)((start - this.onset) / this.period + 0.5);
            double pons = this.onset + (double)ipulse * this.period;
            double duration = this.duration;
            if (!Double.isNaN(this.end)) {
                duration = Math.max(Math.min(duration, this.end - pons), 0.0);
            }
            return Stimulation.pulseOverlap(start, dt, pons, duration);
        }

        private static double pulseOverlap(double t, double dt, double onset, double duration) {
            if (t + dt < onset || t > onset + duration) {
                return 0.0;
            }
            if (t >= onset && t + dt <= onset + duration) {
                return 1.0;
            }
            if (t <= onset && t + dt >= onset + duration) {
                return duration / dt;
            }
            if (t <= onset) {
                return (t + dt - onset) / dt;
            }
            return (onset + duration - t) / dt;
        }

        public static void addTo(ArrayList<Stimulation> stims, int species, InjectionStim stim) {
            double[][] rates = stim.getRates();
            if (rates != null) {
                for (int i = 0; i < rates.length; ++i) {
                    double time = rates[i][0];
                    double rate = rates[i][1];
                    if (rate == 0.0) continue;
                    double duration = i < rates.length - 1 ? rates[i + 1][0] - time : Double.POSITIVE_INFINITY;
                    stims.add(new Stimulation(species, stim.getInjectionSite(), stim.getDistribution(), 0, rate, time, duration, 0.0, Double.NaN, Double.NaN));
                }
            } else {
                for (int i = 0; i < stim.getNumTrains(); ++i) {
                    stims.add(new Stimulation(species, stim.getInjectionSite(), stim.getDistribution(), i, stim.getRate(), stim.getOnset(), stim.getDuration(), stim.getInterTrainInterval(), stim.getPeriod(), stim.getEnd()));
                }
            }
        }
    }
}

