/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.grid;

import java.util.ArrayList;
import java.util.Collection;
import neurord.SDCalcType;
import neurord.model.SDRun;
import neurord.numeric.grid.IGridCalc;
import neurord.numeric.grid.NextEventQueue;
import neurord.numeric.grid.StochasticGridCalc;
import neurord.util.ArrayUtil;
import neurord.util.Logging;
import neurord.util.Settings;
import neurord.util.TimeUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdaptiveGridCalc
extends StochasticGridCalc {
    public static final Logger log = LogManager.getLogger();
    static final boolean curtail_leaps = Settings.getProperty("neurord.curtail_leaps", "Do not allow leaps to extend past reporting time", false);
    private long real_start_time;
    NextEventQueue neq;
    ArrayList<IGridCalc.Happening> events = log_events ? new ArrayList() : null;
    int[][] eventStatistics;

    public AdaptiveGridCalc(int trial, SDRun sdm) {
        super(trial, sdm);
    }

    @Override
    public final void init() {
        super.init();
        SDCalcType calculationType = SDCalcType.valueOf(this.sdRun.calculation);
        assert (calculationType == SDCalcType.GRID_EXACT || calculationType == SDCalcType.GRID_ADAPTIVE);
        boolean adaptive = calculationType == SDCalcType.GRID_ADAPTIVE;
        String statistics = this.sdRun.getStatistics();
        this.neq = NextEventQueue.create(this.wkA, this.random, null, this.sdRun.getVolumeGrid(), this.rtab, this.sdRun.getStimulationTable(), adaptive, this.sdRun.tolerance, this.sdRun.leap_min_jump, this.trial() == 0, statistics);
        int stat_count = this.neq.stat_count(this.sdRun.getStatistics(), this.sdRun.getSpecies());
        if (stat_count > 0) {
            this.eventStatistics = new int[stat_count][2];
        }
        this.real_start_time = System.currentTimeMillis();
    }

    @Override
    public void footer() {
        super.footer();
        log.info("Queue suffered {} swaps", this.neq.queue.swaps);
        log.log(Logging.NOTICE, "Accuracy control parameter \u03b5={}", this.neq.tolerance);
        log.log(Logging.NOTICE, "Leapt {} ({} firings, {} f/l average), waited {} times", this.neq.leap_extent, this.neq.leaps, (double)this.neq.leap_extent / (double)this.neq.leaps, this.neq.normal_waits);
        if (this.sdRun.getStatisticsInterval() == 0.0 && (this.sdRun.getStatistics().equals("injections") || this.sdRun.getStatistics().equals("by-channel")) && this.eventStatistics != null) {
            for (int i = 0; i < this.eventStatistics.length; ++i) {
                NextEventQueue.IndexDescription desc = this.neq.stat_descriptions.get(i);
                if (!desc.description.startsWith("Stim")) continue;
                log.info("{}: {} events, {} molecules", desc.description, this.eventStatistics[i][0], this.eventStatistics[i][1]);
            }
        }
        long time = System.currentTimeMillis() - this.real_start_time;
        double speed = 1000.0 * (this.sdRun.getEndTime() - this.sdRun.getStartTime()) / (double)time;
        log.log(Logging.NOTICE, "Real simulation took {} ({} ms, {} ms/s)", TimeUtil.formatTimespan(time), time, speed);
    }

    @Override
    protected long eventCount() {
        return this.neq.leaps + this.neq.normal_waits;
    }

    @Override
    public double advance(double tnow, double tend) {
        double endtime = this.endtime();
        double time = tnow;
        while (time < tend) {
            double next = this.neq.advance(time, tend, curtail_leaps ? tend : endtime, this.eventStatistics, this.events);
            assert (next >= time) : next;
            time = next;
        }
        return tend - tnow;
    }

    public static double calculatePropensity(int[] ri, int[] pi, int[] rs, int[] ps, int[] rp, double rate, double vol, int[] nstart) {
        double ans = rate * vol / 1.660538783162726;
        for (int i = 0; i < ri.length; ++i) {
            int n = nstart[ri[i]];
            if (n < rs[i]) {
                return 0.0;
            }
            for (int p = 0; p < rp[i]; ++p) {
                ans *= (double)(n - p) * 1.660538783162726 / vol;
            }
        }
        return ans;
    }

    @Override
    public int[][] getEventStatistics() {
        return this.eventStatistics;
    }

    @Override
    protected void resetEventStatistics() {
        if (this.eventStatistics != null) {
            ArrayUtil.fill(this.eventStatistics, 0);
        }
    }

    @Override
    public Collection<IGridCalc.Event> getEvents() {
        return this.neq.getEvents();
    }

    @Override
    public Collection<IGridCalc.Happening> getHappenings() {
        ArrayList<IGridCalc.Happening> recent = this.events;
        if (recent != null) {
            this.events = new ArrayList();
        }
        return recent;
    }
}

