/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.grid;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import neurord.model.IOutputSet;
import neurord.numeric.grid.IGridCalc;
import neurord.numeric.grid.ResultWriter;
import neurord.numeric.morph.VolumeGrid;
import neurord.util.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultWriterText
implements ResultWriter {
    static final Logger log = LogManager.getLogger();
    final File outputFile;
    OutputStreamWriter writer;
    boolean closed = false;
    boolean continuation = false;
    final boolean writeConcentration;
    protected final HashMap<String, ResultWriterText> siblings = new HashMap();
    final String[] species;
    final int[] ispecout;
    final int nel;
    final IOutputSet outputSet;
    final List<? extends IOutputSet> outputSets;
    final VolumeGrid grid;

    public ResultWriterText(File output, IOutputSet primary, List<? extends IOutputSet> outputSets, String[] species, VolumeGrid grid, boolean writeConcentration) {
        this.writeConcentration = writeConcentration;
        this.outputFile = new File(output + ".out");
        this.species = species;
        this.grid = grid;
        if (primary != null) {
            this.ispecout = primary.getIndicesOfOutputSpecies(species);
            this.outputSet = primary;
        } else {
            this.ispecout = null;
            this.outputSet = null;
        }
        this.outputSets = outputSets;
        this.nel = grid.size();
    }

    public boolean isContinuation() {
        return this.continuation && this.outputFile.exists();
    }

    @Override
    public File outputFile() {
        return this.outputFile;
    }

    @Override
    public void init(String magic) {
        try {
            if (this.isContinuation()) {
                this.writer = new OutputStreamWriter(new FileOutputStream(this.outputFile, true));
            } else {
                this.writer = new OutputStreamWriter(new FileOutputStream(this.outputFile));
                if (magic != null) {
                    this.writer.write(magic + "\n");
                }
            }
        }
        catch (Exception ex) {
            log.error("cannot create file writer", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void writeString(String sdat) {
        if (this.writer != null) {
            try {
                this.writer.write(sdat, 0, sdat.length());
            }
            catch (Exception ex) {
                log.error("cannot write:", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            log.info("Closing output file {}", this.outputFile);
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Exception ex) {
                    log.error("Closing failed", (Throwable)ex);
                }
                this.writer = null;
            } else {
                log.error("data not written (earlier errors)");
            }
            for (ResultWriterText rw : this.siblings.values()) {
                rw.close();
            }
            this.closed = true;
        }
    }

    public ResultWriterText getSibling(String extn, String magic) {
        ResultWriterText ret = this.getRawSibling(extn);
        ret.init(magic);
        return ret;
    }

    public ResultWriterText getRawSibling(String extn) {
        ResultWriterText ret = this.siblings.get(extn);
        log.debug("getRawSibling {} \u2192 {}", extn, ret);
        if (ret == null) {
            String fnm = FileUtil.getRootName(this.outputFile) + extn;
            File f = new File(this.outputFile.getParentFile(), fnm);
            ret = new ResultWriterText(f, null, null, this.species, this.grid, this.writeConcentration);
            ret.init(null);
            this.siblings.put(extn, ret);
        }
        return ret;
    }

    public File getSiblingFile(String extn) {
        ResultWriterText rw = this.getSibling(extn, null);
        return rw.getFile();
    }

    private File getFile() {
        return this.outputFile;
    }

    public void writeToSiblingFileAndClose(String txt, String extn) {
        ResultWriterText rw = this.getSibling(extn, null);
        rw.writeString(txt);
        rw.close();
    }

    public void writeToSiblingFile(String txt, String extn) {
        this.writeToSiblingFile(txt, extn, null);
    }

    public void writeToFinalSiblingFile(String txt, String extn) {
        this.writeToFinalSiblingFile(txt, extn, null);
    }

    public void writeToSiblingFile(String txt, String extn, String magic) {
        ResultWriterText rw = this.getRawSibling(extn);
        rw.writeString(txt);
    }

    public void writeToFinalSiblingFile(String txt, String extn, String magic) {
        ResultWriterText rw = this.getSibling(extn, magic);
        rw.writeString(txt);
        rw.close();
    }

    public String readSibling(String fnm) {
        String ret = null;
        File fin = new File(this.outputFile.getParentFile(), fnm);
        if (fin.exists()) {
            ret = FileUtil.readStringFromFile(fin);
        } else {
            log.error("No such file \"{}\"", fin.getAbsolutePath());
        }
        return ret;
    }

    public void pruneFrom(String match, int idx, double value) {
        this.continuation = true;
        File fcopy = this.outputFile.getAbsoluteFile();
        File fwk = new File(fcopy.getParentFile(), fcopy.getName() + ".wk");
        fcopy.renameTo(fwk);
        try {
            BufferedReader br = new BufferedReader(new FileReader(fwk));
            BufferedWriter bw = new BufferedWriter(new FileWriter(fcopy));
            while (br.ready()) {
                StringTokenizer st;
                String sl = br.readLine();
                if ((match == null || match.length() == 0 || sl.startsWith(match)) && (st = new StringTokenizer(sl, " ")).countTokens() > idx) {
                    String stok = "";
                    for (int i = 0; i <= idx; ++i) {
                        stok = st.nextToken();
                    }
                    try {
                        double d = Double.parseDouble(stok);
                        if (d >= value - 1.0E-9) {
                            break;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                bw.write(sl);
                bw.write("\n");
            }
            bw.close();
            br.close();
            fwk.delete();
        }
        catch (Exception ex) {
            log.error("Cannot prune data file", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void writeGrid(VolumeGrid vgrid, double startTime, IGridCalc source) {
        assert (vgrid.isCurved() || vgrid.isCuboid());
        if (!this.isContinuation()) {
            this.writeString(vgrid.getAsText());
        }
        this.writeToSiblingFileAndClose(vgrid.getAsTableText(), "-mesh.txt");
        if (vgrid.isCurved()) {
            this.writeToSiblingFileAndClose(vgrid.getAsElementsText(), "-elements.tri");
        }
        log.info("Written elements mesh file");
        if (this.outputSets != null) {
            for (IOutputSet iOutputSet : this.outputSets) {
                String sibsuf = "-" + iOutputSet.getIdentifier() + "-conc.txt";
                String shead = this.getGridConcsHeadings_dumb(iOutputSet, vgrid, source);
                StringTokenizer st = new StringTokenizer(shead);
                int nt = st.countTokens();
                if (this.isContinuation()) {
                    ResultWriterText sibrw = this.getRawSibling(sibsuf);
                    sibrw.pruneFrom("", 0, startTime);
                    sibrw.init(null);
                    continue;
                }
                this.writeToSiblingFile(shead, sibsuf);
            }
        }
    }

    private String formatNumber(int i, int outj, IGridCalc source) {
        if (this.writeConcentration) {
            double conc = source.getGridPartConc(i, outj);
            return ResultWriterText.stringd(conc);
        }
        int numb = source.getGridPartNumb(i, outj);
        return ResultWriterText.stringi(numb);
    }

    private String getGridConcsText(double time, int[] ispecout, IGridCalc source) {
        int i;
        String[] species = source.getSource().getSpecies();
        StringBuffer sb = new StringBuffer();
        int nspecout = ispecout.length;
        if (nspecout == 0) {
            return "";
        }
        sb.append("gridConcentrations " + this.nel + " " + nspecout + " " + time + " ");
        for (i = 0; i < nspecout; ++i) {
            sb.append(species[ispecout[i]] + " ");
        }
        sb.append("\n");
        for (i = 0; i < this.nel; ++i) {
            for (int j = 0; j < nspecout; ++j) {
                sb.append(this.formatNumber(i, ispecout[j], source));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void writeOutputInterval(double time, IGridCalc source) {
        String concs = this.getGridConcsText(time, this.ispecout, source);
        this.writeString(concs);
    }

    private String getGridConcsPlainText_dumb(IOutputSet output, double time, IGridCalc source) {
        String[] species = source.getSource().getSpecies();
        VolumeGrid grid = source.getSource().getVolumeGrid();
        String region = output.getRegion();
        int[] indices = output.getIndicesOfOutputSpecies(species);
        StringBuffer sb = new StringBuffer();
        sb.append(ResultWriterText.stringd(time));
        for (int specie : indices) {
            for (int i = 0; i < this.nel; ++i) {
                if (region != null && !region.equals(grid.getElementRegion(i))) continue;
                sb.append(this.formatNumber(i, specie, source));
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    private String getGridConcsHeadings_dumb(IOutputSet output, VolumeGrid vgrid, IGridCalc source) {
        String[] species = source.getSource().getSpecies();
        boolean[] submembranes = vgrid.getSubmembranes();
        String[] regionLabels = vgrid.getRegionLabels();
        VolumeGrid grid = source.getSource().getVolumeGrid();
        StringBuffer sb = new StringBuffer();
        sb.append("time");
        int[] indices = output.getIndicesOfOutputSpecies(species);
        String region = output.getRegion();
        for (int specie : indices) {
            for (int i = 0; i < this.nel; ++i) {
                if (region != null && !region.equals(grid.getElementRegion(i))) continue;
                sb.append(" Vol_" + i);
                sb.append("_" + grid.getElementRegion(i));
                String tempLabel = vgrid.getLabel(i);
                if (vgrid.getGroupID(i) != null) {
                    sb.append("." + vgrid.getGroupID(i));
                } else if (tempLabel != null && tempLabel.indexOf(".") > 0) {
                    sb.append("." + tempLabel.substring(0, tempLabel.indexOf(".")));
                }
                if (submembranes[i]) {
                    sb.append("_submembrane");
                } else {
                    sb.append("_cytosol");
                }
                if (tempLabel != null) {
                    if (tempLabel.indexOf(".") > 0) {
                        sb.append("_" + tempLabel.substring(tempLabel.indexOf(".") + 1, tempLabel.length()));
                    } else {
                        sb.append("_" + vgrid.getLabel(i));
                    }
                }
                sb.append("_Spc_" + species[specie]);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public void writeOutputScheme(int i, double time, IGridCalc source) {
        IOutputSet output = this.outputSets.get(i);
        String fnamepart = output.getIdentifier();
        log.debug("writeOutputScheme: i={} time={} nel={} fnamepart={}", i, time, this.nel, fnamepart);
        String text = this.getGridConcsPlainText_dumb(output, time, source);
        this.writeToSiblingFile(text, "-" + fnamepart + "-conc.txt");
    }

    @Override
    public void writeEventStatistics(double time, IGridCalc source) {
    }

    public static String stringd(double d) {
        if (d == 0.0) {
            return "0.0 ";
        }
        return String.format("%.5g ", d);
    }

    public static String stringi(int id) {
        if (id == 0) {
            return "00 ";
        }
        return String.format("%d ", id);
    }

    @Override
    public void closeTrial(IGridCalc source) {
    }
}

