/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.grid;

import java.util.Collection;
import neurord.model.SDRun;
import neurord.numeric.grid.IGridCalc;
import neurord.numeric.grid.StochasticGridCalc;
import neurord.numeric.morph.VolumeGrid;
import neurord.numeric.stochastic.StepGenerator;
import neurord.util.ArrayUtil;
import neurord.util.Logging;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SteppedStochasticGridCalc
extends StochasticGridCalc {
    static final Logger log = LogManager.getLogger();
    public static final int SHARED_DIFF_PARTICLES = 4;
    double[] lnfdiff;
    double[][] lnCC;
    int[][] wkB;
    int[][] reactantIndices;
    int[][] productIndices;
    int[][] reactantStoichiometry;
    int[][] productStoichiometry;
    int[][] reactantPowers;
    double[] lnvolumes;
    double[] lnrates;
    double lndt;
    StepGenerator stepper;
    int nngowarn = 0;
    double[][] pSharedOut;
    double[][][] fSharedExit;
    long event_count = 0L;
    private int reactionStep_nwarn1;
    private int reactionStep_nwarn2;

    public SteppedStochasticGridCalc(int trial, SDRun sdm) {
        super(trial, sdm);
    }

    @Override
    public final void init() {
        int k;
        int iel;
        super.init();
        this.lnrates = ArrayUtil.log(this.rtab.getRates());
        log.debug("lnrates: {}", new Object[]{this.lnrates});
        this.reactantIndices = this.rtab.getReactantIndices();
        this.productIndices = this.rtab.getProductIndices();
        this.reactantStoichiometry = this.rtab.getReactantStoichiometry();
        this.productStoichiometry = this.rtab.getProductStoichiometry();
        this.reactantPowers = this.rtab.getReactantPowers();
        this.lnvolumes = ArrayUtil.log(this.volumes);
        log.debug("lnvolumes: {}", new Object[]{this.lnvolumes});
        this.lnfdiff = ArrayUtil.log(this.fdiff);
        VolumeGrid grid = this.sdRun.getVolumeGrid();
        this.lnCC = ArrayUtil.log(grid.getPerElementCouplingConstants());
        this.wkB = new int[this.nel][this.nspec];
        ArrayUtil.copy(this.wkA, this.wkB);
        this.lndt = Math.log(this.dt);
        this.stepper = new StepGenerator(this.random);
        log.info("Using {} destination allocation", new Object[]{this.algoID});
        this.pSharedOut = new double[this.nel][this.nspec];
        this.fSharedExit = new double[this.nel][this.nspec][];
        int maxnn = 0;
        for (iel = 0; iel < this.nel; ++iel) {
            for (k = 0; k < this.nspec; ++k) {
                int nn = this.neighbors[iel].length;
                this.fSharedExit[iel][k] = new double[nn];
                if (nn <= maxnn) continue;
                maxnn = nn;
            }
        }
        log.info("max no of neighbors for a single element is {}", maxnn);
        for (iel = 0; iel < this.nel; ++iel) {
            for (k = 0; k < this.nspec; ++k) {
                int j;
                double ptot = 0.0;
                double[] pcnbr = new double[this.neighbors[iel].length];
                for (j = 0; j < pcnbr.length; ++j) {
                    double lnpgo = this.lnfdiff[k] + this.lnCC[iel][j] + this.lndt - this.lnvolumes[iel];
                    double p = Math.exp(lnpgo);
                    pcnbr[j] = ptot += p;
                }
                if (ptot > 0.36787944117144233) {
                    System.out.println("WK===================================");
                    System.out.println("In DIFFUSION: probability TOO HIGH!");
                    System.out.println("Reduce your timestep, and try again...");
                    System.out.println("WK====================================");
                    System.exit(3);
                }
                this.pSharedOut[iel][k] = ptot;
                for (j = 0; j < pcnbr.length; ++j) {
                    this.fSharedExit[iel][k][j] = pcnbr[j] / ptot;
                }
            }
        }
    }

    @Override
    public double advance(double tnow, double tend) {
        int iel;
        double[][] stims = this.sdRun.getStimulationTable().getStimsForInterval(tnow, this.dt);
        for (int i = 0; i < stims.length; ++i) {
            double[] astim = stims[i];
            for (int j = 0; j < astim.length; ++j) {
                if (!(astim[j] > 0.0)) continue;
                int[][] stimtargets = this.sdRun.getStimulationTargets();
                int nk = stimtargets[i].length;
                if (nk > 0) {
                    double as = astim[j] / (double)nk;
                    for (int k = 0; k < nk; ++k) {
                        int nin = this.random.round(as);
                        int tgt = stimtargets[i][k];
                        int[] nArray = this.wkA[tgt];
                        int n = j;
                        nArray[n] = nArray[n] + nin;
                    }
                }
                ++this.event_count;
            }
        }
        ArrayUtil.copy(this.wkA, this.wkB);
        for (iel = 0; iel < this.nel; ++iel) {
            for (int k = 0; k < this.nspec; ++k) {
                if (!(this.lnfdiff[k] > -90.0)) continue;
                int np0 = this.wkA[iel][k];
                if (np0 > 0) {
                    switch (this.algoID) {
                        case INDEPENDENT: 
                        case SHARED: {
                            this.parallelAndSharedDiffusionStep(iel, k);
                            break;
                        }
                        case PARTICLE: {
                            this.particleDiffusionStep(iel, k);
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                }
                ++this.event_count;
            }
        }
        ArrayUtil.copy(this.wkB, this.wkA);
        for (iel = 0; iel < this.nel; ++iel) {
            int[] nstart = this.wkB[iel];
            int[] nend = this.wkA[iel];
            for (int ireac = 0; ireac < this.rtab.getNReaction(); ++ireac) {
                this.reactionStep(nstart, nend, iel, ireac);
                ++this.event_count;
            }
        }
        if (tend - tnow - this.dt > 0.01 * this.dt) {
            log.warn("Step {} is different than dt={}", tend - tnow, this.dt);
        }
        return this.dt;
    }

    @Override
    public void footer() {
        super.footer();
        log.log(Logging.NOTICE, "Leapt {} times", this.eventCount());
    }

    @Override
    protected long eventCount() {
        return this.event_count;
    }

    protected void reactionStep(int[] nstart, int[] nend, int iel, int ireac) {
        int[] ri = this.reactantIndices[ireac];
        int[] pi = this.productIndices[ireac];
        int[] rs = this.reactantStoichiometry[ireac];
        int[] ps = this.productStoichiometry[ireac];
        Object[] java_sucks = SteppedStochasticGridCalc.calculatePropensity(ri, pi, rs, ps, this.reactantPowers[ireac], this.lnrates[ireac], this.lnvolumes[iel], nstart);
        double lnp = (Double)java_sucks[0];
        int n = (Integer)java_sucks[1];
        if ((lnp += this.lndt) > 0.0) {
            if (++this.reactionStep_nwarn1 < 500) {
                log.warn("p too large at element {} reaction {}: capping {} to 100%", iel, ireac, Math.exp(lnp));
            }
            lnp = 0.0;
        }
        if (n > 0) {
            int ngo = this.stepper.versatile_ngo(n, Math.exp(lnp));
            if (this.rtab.getRates()[ireac] == 0.0 && ngo > 0) {
                log.warn("n={} -> ngo={} (lnp={})", n, ngo, lnp);
            }
            if (ri.length > 0) {
                int navail = nend[ri[0]] / rs[0];
                for (int k = 1; k < ri.length; ++k) {
                    int navail2 = nend[ri[k]] / rs[k];
                    if (navail2 >= navail) continue;
                    navail = navail2;
                }
                if (ngo > navail) {
                    if (++this.reactionStep_nwarn2 < 500) {
                        log.warn("reaction {} ran out of particles - need {} but have {}", ireac, ngo, navail);
                    }
                    ngo = navail;
                }
            }
            if (ngo > 0) {
                int k;
                for (k = 0; k < ri.length; ++k) {
                    int n2 = ri[k];
                    nend[n2] = nend[n2] - ngo * rs[k];
                    if (nend[ri[k]] >= 0) continue;
                    log.error("nend is negative: {}", new Object[]{nend});
                    log.info("reaction {}: ri={} pi={} rs={} ps={}", ireac, ri, pi, rs, ps);
                }
                for (k = 0; k < pi.length; ++k) {
                    int n3 = pi[k];
                    nend[n3] = nend[n3] + ngo * ps[k];
                }
            }
        }
    }

    private final void parallelAndSharedDiffusionStep(int iel, int k) {
        int np0 = this.wkA[iel][k];
        int[] inbr = this.neighbors[iel];
        double[] fshare = this.fSharedExit[iel][k];
        int ngo = this.stepper.versatile_ngo(np0, this.pSharedOut[iel][k]);
        assert (ngo >= 0);
        if (ngo <= inbr.length * 4) {
            int[] nArray = this.wkB[iel];
            int n = k;
            nArray[n] = nArray[n] - ngo;
            for (int i = 0; i < ngo; ++i) {
                double r = this.random.random();
                int io = 0;
                while (r > fshare[io]) {
                    ++io;
                }
                int[] nArray2 = this.wkB[inbr[io]];
                int n2 = k;
                nArray2[n2] = nArray2[n2] + 1;
            }
        } else {
            double prev = 0.0;
            for (int j = 0; j < inbr.length - 1; ++j) {
                double pgoTmp = (this.fSharedExit[iel][k][j] - prev) / (this.fSharedExit[iel][k][inbr.length - 1] - prev);
                prev = this.fSharedExit[iel][k][j];
                int ngo2 = this.stepper.versatile_ngo(ngo, pgoTmp);
                assert (ngo2 >= 0);
                if (ngo2 > ngo) {
                    if (++this.nngowarn < 10) {
                        log.warn("parallelAndSharedDiffusionStep multinomial: ngo2 = {} > {} = ngo, setting ngo2=ngo ", ngo2, ngo);
                    }
                    ngo2 = ngo;
                }
                int[] nArray = this.wkB[iel];
                int n = k;
                nArray[n] = nArray[n] - ngo2;
                int[] nArray3 = this.wkB[inbr[j]];
                int n3 = k;
                nArray3[n3] = nArray3[n3] + ngo2;
                ngo -= ngo2;
            }
            int[] nArray = this.wkB[iel];
            int n = k;
            nArray[n] = nArray[n] - ngo;
            int[] nArray4 = this.wkB[inbr[inbr.length - 1]];
            int n4 = k;
            nArray4[n4] = nArray4[n4] + ngo;
            if (this.wkB[iel][k] < 0) {
                log.warn("parallelAndSharedDiffusionStep multinomial: wkB[iel][k] = {} is negative", this.wkB[iel][k]);
            }
        }
    }

    private final void particleDiffusionStep(int iel, int k) {
        int np0 = this.wkA[iel][k];
        int[] inbr = this.neighbors[iel];
        double[] fshare = this.fSharedExit[iel][k];
        double ptot = this.pSharedOut[iel][k];
        for (int i = 0; i < np0; ++i) {
            double r = this.random.random();
            if (!(r < ptot)) continue;
            int[] nArray = this.wkB[iel];
            int n = k;
            nArray[n] = nArray[n] - 1;
            double fr = r / ptot;
            int io = 0;
            while (fr > fshare[io]) {
                ++io;
            }
            int[] nArray2 = this.wkB[inbr[io]];
            int n2 = k;
            nArray2[n2] = nArray2[n2] + 1;
        }
    }

    public static Object[] calculatePropensity(int[] ri, int[] pi, int[] rs, int[] ps, int[] rp, double lnrate, double lnvol, int[] nstart) {
        double lnp = lnrate + lnvol;
        int ns = Integer.MAX_VALUE;
        for (int k = 0; k < ri.length; ++k) {
            int n = nstart[ri[k]];
            int p = rp[k];
            int nks = n / rs[k];
            if (nks < ns) {
                ns = nks;
            }
            if (p < 1) continue;
            lnp += SteppedStochasticGridCalc.intlog(n) - lnvol;
            if (p <= 1) continue;
            lnp += (double)(p - 1) * (SteppedStochasticGridCalc.intlog(n) - lnvol - LN_PARTICLES_PUVC);
        }
        if (ns > 0) {
            lnp -= SteppedStochasticGridCalc.intlog(ns);
        }
        return new Object[]{lnp, ns};
    }

    @Override
    public int[][] getEventStatistics() {
        return null;
    }

    @Override
    protected void resetEventStatistics() {
    }

    @Override
    public Collection<IGridCalc.Event> getEvents() {
        return null;
    }

    @Override
    public Collection<IGridCalc.Happening> getHappenings() {
        return null;
    }
}

