/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.math;

public final class Column {
    int n;
    double[] dat;

    public Column(int n0) {
        this.n = n0;
        this.dat = new double[this.n];
    }

    public Column(double[] d) {
        this.dat = d;
        this.n = d.length;
    }

    public Column plus(double d) {
        double[] ret = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            ret[i] = this.dat[i] + d;
        }
        return new Column(ret);
    }

    public Column times(double d) {
        double[] ret = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            ret[i] = this.dat[i] * d;
        }
        return new Column(ret);
    }

    public void incrementBy(double d) {
        int i = 0;
        while (i < this.n) {
            int n = i++;
            this.dat[n] = this.dat[n] + d;
        }
    }

    public void incrementBy(double[] r) {
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.dat[n] = this.dat[n] + r[i];
        }
    }

    public void incrementBy(Column v) {
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.dat[n] = this.dat[n] + v.dat[i];
        }
    }

    public void multiuplyBy(double d) {
        int i = 0;
        while (i < this.n) {
            int n = i++;
            this.dat[n] = this.dat[n] * d;
        }
    }

    public double[] getData() {
        return this.dat;
    }

    public int size() {
        return this.n;
    }

    public double avgAbs() {
        double r = 0.0;
        for (int i = 0; i < this.n; ++i) {
            r += Math.abs(this.dat[i]);
        }
        return r /= (double)this.n;
    }

    public void decrementBy(Column v) {
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.dat[n] = this.dat[n] - v.dat[i];
        }
    }

    public Column copy() {
        double[] d = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            d[i] = this.dat[i];
        }
        return new Column(d);
    }

    public void increment(int i, double d) {
        int n = i;
        this.dat[n] = this.dat[n] + d;
    }

    public Column plus(Column vdc) {
        Column ret = this.copy();
        ret.incrementBy(vdc);
        return ret;
    }

    public void print() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.n; ++i) {
            sb.append("" + this.dat[i]);
            if (i >= this.n - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        System.out.println("column: " + sb.toString());
    }

    public void positivize() {
        for (int i = 0; i < this.n; ++i) {
            if (!(this.dat[i] < 0.0)) continue;
            this.dat[i] = 0.0;
        }
    }

    public void writeTo(double[] dout) {
        if (this.dat != dout) {
            for (int i = 0; i < this.n; ++i) {
                dout[i] = this.dat[i];
            }
        }
    }
}

