/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.morph;

import java.util.ArrayList;
import java.util.HashMap;
import neurord.geom.Position;

public class TreePoint
implements Position {
    private double x;
    private double y;
    private double z;
    private double r;
    public TreePoint[] nbr = new TreePoint[6];
    public int nnbr = 0;
    public TreePoint parent;
    public TreePoint subAreaPeer = null;
    public String label;
    public int iwork;
    public boolean dead = false;
    public double dgx;
    public double dgy;
    private ArrayList<TreePoint> offsetChildren;
    private HashMap<TreePoint, String> segidHM;
    private HashMap<TreePoint, String> regionHM;
    private String firstRegion = null;
    public String name;
    public double partBranchOffset = 0.0;

    public TreePoint() {
    }

    public TreePoint(double x, double y, double z, double r) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
    }

    public double getRadius() {
        return this.r;
    }

    public void setRadius(double r) {
        this.r = r;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    public String getLabel() {
        return this.label;
    }

    public TreePoint getParent() {
        return this.parent;
    }

    public TreePoint makeCopy() {
        return new TreePoint(this.x, this.y, this.z, this.r);
    }

    public void setWork(int iw) {
        this.iwork = iw;
    }

    public int getWork() {
        return this.iwork;
    }

    public String toString() {
        return "(point x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",r=" + this.r + ",nnbr=" + this.nnbr + ")";
    }

    public void locateBetween(TreePoint cpa, TreePoint cpb, double f) {
        double wf = 1.0 - f;
        this.x = f * cpb.x + wf * cpa.x;
        this.y = f * cpb.y + wf * cpa.y;
        this.z = f * cpb.z + wf * cpa.z;
        this.r = f * cpb.r + wf * cpa.r;
    }

    public void addNeighbor(TreePoint cpn) {
        for (int i = 0; i < this.nnbr; ++i) {
            if (this.nbr[i] != cpn) continue;
            throw new RuntimeException("adding a neighbor we already have ");
        }
        if (this.nnbr >= this.nbr.length) {
            TreePoint[] pn = new TreePoint[2 * this.nnbr];
            for (int i = 0; i < this.nnbr; ++i) {
                pn[i] = this.nbr[i];
            }
            this.nbr = pn;
        }
        this.nbr[this.nnbr++] = cpn;
    }

    public void removeNeighbor(TreePoint cp) {
        int i;
        int ii = -1;
        for (i = 0; i < this.nnbr; ++i) {
            if (this.nbr[i] != cp) continue;
            ii = i;
        }
        if (ii >= 0) {
            for (i = ii; i < this.nnbr - 1; ++i) {
                this.nbr[i] = this.nbr[i + 1];
            }
            --this.nnbr;
        }
    }

    public void replaceNeighbor(TreePoint cp, TreePoint cr) {
        int ii = -1;
        for (int i = 0; i < this.nnbr; ++i) {
            if (this.nbr[i] != cp) continue;
            ii = i;
        }
        if (ii < 0) {
            throw new RuntimeException("(replaceNeighbor) couldn't find nbr " + cp + " in nbrs list of " + this);
        }
        this.nbr[ii] = cr;
        if (this.segidHM != null && this.segidHM.containsKey(cp)) {
            this.segidHM.put(cr, this.segidHM.get(cp));
        }
        if (this.regionHM != null && this.regionHM.containsKey(cp)) {
            this.regionHM.put(cr, this.regionHM.get(cp));
        }
    }

    public boolean hasNeighbor(TreePoint cp) {
        for (int i = 0; i < this.nnbr; ++i) {
            if (this.nbr[i] != cp) continue;
            return true;
        }
        return false;
    }

    public void removeDeadNeighbors() {
        for (int i = this.nnbr - 1; i >= 0; --i) {
            if (!this.nbr[i].dead) continue;
            this.removeNeighbor(this.nbr[i]);
        }
    }

    public void addOffsetChild(TreePoint p) {
        if (this.offsetChildren == null) {
            this.offsetChildren = new ArrayList();
        }
        this.offsetChildren.add(p);
    }

    public boolean hasOffsetChildren() {
        return this.offsetChildren != null;
    }

    public ArrayList<TreePoint> getOffsetChildren() {
        return this.offsetChildren;
    }

    public double distanceTo(TreePoint cp) {
        double dx = this.x - cp.x;
        double dy = this.y - cp.y;
        double dz = this.z - cp.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public void movePerp(TreePoint ca, TreePoint cb, double dperp) {
        double dx = cb.x - ca.x;
        double dy = cb.y - ca.y;
        double f = Math.sqrt(dx * dx + dy * dy);
        this.x += dperp * (dy /= f);
        this.y -= dperp * (dx /= f);
    }

    public static void neighborize(TreePoint tp, TreePoint tpn) {
        tp.addNeighbor(tpn);
        tpn.addNeighbor(tp);
    }

    public ArrayList<TreePoint> getNeighbors() {
        ArrayList<TreePoint> ret = new ArrayList<TreePoint>();
        for (int i = 0; i < this.nnbr; ++i) {
            ret.add(this.nbr[i]);
        }
        return ret;
    }

    public boolean isEndPoint() {
        return this.nnbr == 1;
    }

    public TreePoint oppositeNeighbor(TreePoint tpp) {
        if (this.nnbr != 2) {
            return null;
        }
        if (tpp == this.nbr[0]) {
            return this.nbr[1];
        }
        return this.nbr[0];
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public synchronized void setIDWith(TreePoint point, String s) {
        if (this.segidHM == null) {
            this.segidHM = new HashMap();
        }
        this.segidHM.put(point, s);
    }

    public synchronized void setRegionWith(TreePoint point, String s) {
        if (this.regionHM == null) {
            this.regionHM = new HashMap();
            this.firstRegion = s;
        }
        this.regionHM.put(point, s);
    }

    public String regionClassWith(TreePoint tp) {
        String ret = null;
        if (this.regionHM != null) {
            ret = this.regionHM.get(tp);
        }
        if (ret == null) {
            ret = this.soleRegion();
        }
        return ret;
    }

    public String soleRegion() {
        if (this.regionHM != null && this.regionHM.size() == 1) {
            return this.firstRegion;
        }
        return null;
    }

    public String segmentIDWith(TreePoint tp) {
        if (this.segidHM != null) {
            return this.segidHM.get(tp);
        }
        return null;
    }

    public void setSubAreaOf(TreePoint cpa) {
        this.subAreaPeer = cpa;
    }

    public void alignTop(TreePoint tpon, TreePoint tpdir, double offset) {
        double dx = tpon.getX() - tpdir.getX();
        double dy = tpon.getY() - tpdir.getY();
        double l = Math.sqrt(dx * dx + dy * dy);
        double vx = -dy / l;
        double vy = dx / l;
        double dist = offset - (tpon.getRadius() - this.getRadius());
        this.x = tpon.getX() + dist * vx;
        this.y = tpon.getY() + dist * vy;
        this.z = tpon.getZ();
    }

    public TreePoint largestNeighborNot(TreePoint cpb) {
        TreePoint ret = null;
        for (int i = 0; i < this.nnbr; ++i) {
            if ((ret != null || this.nbr[i] == cpb) && (ret == null || !(this.nbr[i].r > ret.r))) continue;
            ret = this.nbr[i];
        }
        return ret;
    }
}

