/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.morph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import neurord.disc.CurvedVolumeSlice;
import neurord.geom.Geom;
import neurord.geom.Position;
import neurord.numeric.morph.CurvedVolumeElement;
import neurord.numeric.morph.ElementConnection;
import neurord.numeric.morph.VolumeElement;
import neurord.numeric.morph.VolumeLine;
import neurord.numeric.morph.VolumeSlice;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VolumeGrid {
    static final Logger log = LogManager.getLogger();
    ArrayList<VolumeElement> elements = new ArrayList();
    HashMap<String, ArrayList<VolumeElement>> regionHM = new HashMap();
    int nelement;
    String[] eltLabels;
    String[] eltGroupIDs;
    String[] regionLabels;
    double[] volumes;
    double[][] positions;
    double[] exposedAreas;
    boolean[] submembranes;
    int[][] conI;
    double[] conG;
    int[][] eltNbrs;
    double[][] eltNbrG;
    boolean hasCuboids = false;
    boolean hasCurveds = false;

    public void importSlices(ArrayList<VolumeSlice> slices) {
        this.hasCuboids = true;
        for (VolumeSlice slice : slices) {
            this.addElements(slice.getElements());
        }
    }

    public void importSmoothSlices(ArrayList<CurvedVolumeSlice> slices) {
        this.hasCurveds = true;
        for (CurvedVolumeSlice slice : slices) {
            this.addElements(slice.getElements());
        }
    }

    public void importLines(ArrayList<VolumeLine> lines) {
        this.hasCuboids = true;
        for (VolumeLine line : lines) {
            this.addElements(line.getElements());
        }
    }

    public void addElements(List<? extends VolumeElement> elements) {
        for (VolumeElement volumeElement : elements) {
            this.addElement(volumeElement);
        }
    }

    public void addElement(VolumeElement ve) {
        ve.setNumber(this.elements.size());
        this.elements.add(ve);
        String region = ve.getRegion();
        if (region == null) {
            log.debug("VolumeElement has null region and cannot be accessed");
            return;
        }
        log.debug("Processing VolumeElement {} from region {}", ve.getAsText(), region);
        if (this.regionHM.containsKey(region)) {
            this.regionHM.get(region).add(ve);
        } else {
            ArrayList<VolumeElement> ave = new ArrayList<VolumeElement>();
            ave.add(ve);
            this.regionHM.put(region, ave);
        }
    }

    public VolumeElement getElement(int i) {
        VolumeElement el = this.elements.get(i);
        assert (el.getNumber() == i);
        return el;
    }

    public ArrayList<VolumeElement> getElementsInRegion(String reg) {
        if (this.regionHM.containsKey(reg)) {
            return this.regionHM.get(reg);
        }
        return new ArrayList<VolumeElement>();
    }

    public void fix() {
        int i;
        int i2;
        assert (this.nelement == 0);
        assert (this.eltLabels == null);
        assert (this.eltGroupIDs == null);
        assert (this.regionLabels == null);
        assert (this.volumes == null);
        assert (this.positions == null);
        assert (this.exposedAreas == null);
        assert (this.submembranes == null);
        assert (this.conI == null);
        assert (this.conG == null);
        assert (this.eltNbrs == null);
        assert (this.eltNbrG == null);
        ArrayList<ElementConnection> connections = new ArrayList<ElementConnection>();
        for (VolumeElement ve : this.elements) {
            connections.addAll(ve.getConnections());
        }
        ArrayList<String> rA = new ArrayList<String>();
        rA.add("default");
        this.nelement = this.elements.size();
        this.volumes = new double[this.nelement];
        this.exposedAreas = new double[this.nelement];
        this.positions = new double[this.nelement][3];
        this.eltLabels = new String[this.nelement];
        this.eltGroupIDs = new String[this.nelement];
        this.submembranes = new boolean[this.nelement];
        for (i2 = 0; i2 < this.nelement; ++i2) {
            VolumeElement ve = this.elements.get(i2);
            this.volumes[i2] = ve.getVolume();
            this.exposedAreas[i2] = ve.getExposedArea();
            this.positions[i2][0] = ve.getX();
            this.positions[i2][1] = ve.getY();
            this.positions[i2][2] = ve.getZ();
            this.eltLabels[i2] = ve.getLabel();
            this.eltGroupIDs[i2] = ve.getGroupID();
            this.submembranes[i2] = ve.isSubmembrane();
            if (rA.contains(ve.getRegion())) continue;
            rA.add(ve.getRegion());
        }
        this.regionLabels = rA.toArray(new String[0]);
        this.conI = new int[connections.size()][2];
        this.conG = new double[connections.size()];
        for (i2 = 0; i2 < connections.size(); ++i2) {
            ElementConnection ec = (ElementConnection)connections.get(i2);
            int ia = ec.getElementA().getNumber();
            int ib = ec.getElementB().getNumber();
            this.conI[i2][0] = ia;
            this.conI[i2][1] = ib;
            double d = Geom.distanceBetween(this.positions[ia], this.positions[ib]);
            this.conG[i2] = ec.getContactArea() / d;
        }
        int[] nnbr = new int[this.nelement];
        for (i = 0; i < connections.size(); ++i) {
            int n = this.conI[i][0];
            nnbr[n] = nnbr[n] + 1;
            int n2 = this.conI[i][1];
            nnbr[n2] = nnbr[n2] + 1;
        }
        this.eltNbrs = new int[this.nelement][];
        this.eltNbrG = new double[this.nelement][];
        for (i = 0; i < this.nelement; ++i) {
            this.eltNbrs[i] = new int[nnbr[i]];
            this.eltNbrG[i] = new double[nnbr[i]];
        }
        int[] inbr = new int[this.nelement];
        for (int i3 = 0; i3 < connections.size(); ++i3) {
            int i1;
            int i0 = this.conI[i3][0];
            this.eltNbrs[i0][inbr[i0]] = i1 = this.conI[i3][1];
            this.eltNbrG[i0][inbr[i0]] = this.conG[i3];
            int n = i0;
            inbr[n] = inbr[n] + 1;
            this.eltNbrs[i1][inbr[i1]] = i0;
            this.eltNbrG[i1][inbr[i1]] = this.conG[i3];
            int n3 = i1;
            inbr[n3] = inbr[n3] + 1;
        }
    }

    public int size() {
        assert (this.volumes != null) : "volumes not fixed";
        return this.nelement;
    }

    public double[] getElementVolumes() {
        return this.volumes;
    }

    public double[] getExposedAreas() {
        return this.exposedAreas;
    }

    public boolean[] getSubmembranes() {
        return this.submembranes;
    }

    public int[][] getPerElementNeighbors() {
        return this.eltNbrs;
    }

    public double[][] getPerElementCouplingConstants() {
        return this.eltNbrG;
    }

    public String getElementRegion(int element) {
        return this.elements.get(element).getRegion();
    }

    public String[] getElementRegions() {
        String[] ans = new String[this.elements.size()];
        for (int i = 0; i < ans.length; ++i) {
            ans[i] = this.getElementRegion(i);
        }
        return ans;
    }

    public String[] getRegionLabels() {
        return this.regionLabels;
    }

    public String getAsText() {
        StringBuffer sb = new StringBuffer();
        sb.append("volumeGrid " + this.nelement);
        sb.append("\n");
        for (int i = 0; i < this.nelement; ++i) {
            sb.append("" + this.elements.get(i).getAsText());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getAsTableText() {
        StringBuffer sb = new StringBuffer();
        sb.append("element_index " + this.elements.get(0).getHeadings());
        sb.append("\n");
        for (int i = 0; i < this.nelement; ++i) {
            sb.append("" + i + " " + this.elements.get(i).getAsPlainText());
            sb.append("\n");
        }
        return sb.toString();
    }

    public Vector<Object> gridData() {
        double[] x0 = new double[this.nelement];
        double[] y0 = new double[this.nelement];
        double[] z0 = new double[this.nelement];
        double[] x1 = new double[this.nelement];
        double[] y1 = new double[this.nelement];
        double[] z1 = new double[this.nelement];
        double[] x2 = new double[this.nelement];
        double[] y2 = new double[this.nelement];
        double[] z2 = new double[this.nelement];
        double[] x3 = new double[this.nelement];
        double[] y3 = new double[this.nelement];
        double[] z3 = new double[this.nelement];
        double[] volume = new double[this.nelement];
        double[] deltaZ = new double[this.nelement];
        int i = 0;
        for (VolumeElement el : this.elements) {
            Position[] boundary = el.getBoundary();
            assert (boundary.length == 4);
            x0[i] = boundary[0].getX();
            y0[i] = boundary[0].getY();
            z0[i] = boundary[0].getZ();
            x1[i] = boundary[1].getX();
            y1[i] = boundary[1].getY();
            z1[i] = boundary[1].getZ();
            x2[i] = boundary[2].getX();
            y2[i] = boundary[2].getY();
            z2[i] = boundary[2].getZ();
            x3[i] = boundary[3].getX();
            y3[i] = boundary[3].getY();
            z3[i] = boundary[3].getZ() + el.getDeltaZ();
            volume[i] = el.getVolume();
            deltaZ[i] = el.getDeltaZ();
            ++i;
        }
        return new Vector<Object>(Arrays.asList(x0, y0, z0, x1, y1, z1, x2, y2, z2, x3, y3, z3, volume, deltaZ));
    }

    public String getLabel(int i) {
        return this.eltLabels[i];
    }

    public String getGroupID(int i) {
        return this.eltGroupIDs[i];
    }

    public int[][] getAreaIndexes(String[] targets) {
        int[][] ret = new int[targets.length][];
        for (int i = 0; i < targets.length; ++i) {
            ArrayList<VolumeElement> matched = this.filterElementsByLabel(targets[i]);
            ret[i] = new int[matched.size()];
            for (int j = 0; j < ret[i].length; ++j) {
                ret[i][j] = matched.get(j).getNumber();
            }
        }
        return ret;
    }

    private ArrayList<VolumeElement> getMatches(String sti) {
        int rangemax;
        int rangemin;
        ArrayList<VolumeElement> matched = new ArrayList<VolumeElement>();
        int iob = sti.indexOf("[");
        int icb = sti.indexOf("]");
        String pre = sti.substring(0, iob + 1);
        String post = sti.substring(icb, sti.length());
        String range = sti.substring(iob + 1, icb);
        range = range.replace(" ", "");
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (range.indexOf(":") >= 0) {
            String rpre = range.substring(0, range.indexOf(":"));
            String rpost = range.substring(range.indexOf(":") + 1, range.length());
            rangemin = rpre.length() > 0 ? Integer.parseInt(rpre) : 0;
            rangemax = rpost.length() > 0 ? Integer.parseInt(rpost) : Integer.MAX_VALUE;
        } else if (range.equals("*")) {
            rangemin = 0;
            rangemax = Integer.MAX_VALUE;
        } else {
            String[] split = range.split(",");
            for (String index : split) {
                indices.add(Integer.parseInt(index));
            }
            rangemax = -1;
            rangemin = -1;
        }
        log.debug("Looking for {}{}:{} or {}{}", pre, rangemin, rangemax, indices, post);
        for (VolumeElement el : this.elements) {
            String sin;
            int ind;
            String s = el.getLabel();
            if (s == null || !s.startsWith(pre) || !s.endsWith(post) || (rangemin > (ind = Integer.parseInt(sin = s.substring(pre.length(), s.indexOf(post)))) || rangemax < ind) && !indices.contains(ind)) continue;
            matched.add(el);
        }
        if (matched.isEmpty()) {
            throw new RuntimeException("There are no matches for target: " + sti);
        }
        return matched;
    }

    public ArrayList<VolumeElement> filterElementsByLabel(String label) {
        boolean submembrane = label.endsWith(":submembrane");
        if (submembrane) {
            label = label.substring(0, label.length() - ":submembrane".length());
        }
        if (label.indexOf("[") >= 0) {
            if (submembrane) {
                throw new RuntimeException("\":submembrane\" is not allowed with labelled elements");
            }
            return this.getMatches(label);
        }
        ArrayList<VolumeElement> ans = new ArrayList<VolumeElement>();
        for (VolumeElement el : this.elements) {
            if (el.getLabel() == null || !el.getLabel().equals(label) || submembrane && !el.isSubmembrane()) continue;
            ans.add(el);
        }
        if (!ans.isEmpty()) {
            return ans;
        }
        for (VolumeElement el : this.elements) {
            if (el.getRegion() == null || !el.getRegion().equals(label) || submembrane && !el.isSubmembrane()) continue;
            ans.add(el);
        }
        if (!ans.isEmpty()) {
            return ans;
        }
        throw new RuntimeException("no elements labeled by \"" + label + "\"");
    }

    public boolean isCuboid() {
        return this.hasCuboids && !this.hasCurveds;
    }

    public boolean isCurved() {
        return this.hasCurveds && !this.hasCuboids;
    }

    public String getAsElementsText() {
        StringBuffer sb = new StringBuffer();
        int ielt = 0;
        for (VolumeElement ve : this.elements) {
            if (!(ve instanceof CurvedVolumeElement)) {
                String msg = "cannot handle " + ve + " in element export";
                throw new RuntimeException(msg);
            }
            sb.append("" + ielt + " ");
            sb.append(((CurvedVolumeElement)ve).getText3D());
            ++ielt;
        }
        return sb.toString();
    }

    public static enum geometry_t {
        GEOM_2D,
        GEOM_3D;


        public static geometry_t fromString(String sg) {
            if (sg.toLowerCase().equals("2d")) {
                return GEOM_2D;
            }
            if (sg.toLowerCase().equals("3d")) {
                return GEOM_3D;
            }
            throw new RuntimeException("unrecognized geometry " + sg + " should be 2D or 3D");
        }
    }
}

