/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.pool;

import neurord.model.SDRun;
import neurord.numeric.math.Column;
import neurord.numeric.math.Matrix;
import neurord.numeric.pool.DeterministicPoolCalc;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImplicitEulerPoolCalc
extends DeterministicPoolCalc {
    static final Logger log = LogManager.getLogger();
    int maxIterationsSoFar;

    public ImplicitEulerPoolCalc(int trial, SDRun sdm) {
        super(trial, sdm);
    }

    @Override
    public void dpcInit() {
        this.maxIterationsSoFar = 0;
    }

    @Override
    public double advance() {
        double tol = 1.0E-7;
        Column c = this.mconc;
        Column dc = new Column(c.size());
        int iit = 0;
        double erhs = 0.0;
        do {
            Column rhs = this.rtab.stepResiduals(c, dc, this.dt);
            erhs = rhs.avgAbs();
            ++iit;
            if (erhs > tol) {
                if (iit > this.maxIterationsSoFar) {
                    this.maxIterationsSoFar = iit;
                }
                Matrix m = this.numderivs(c, dc, this.dt);
                Column w = m.LUSolve(rhs);
                dc.decrementBy(w);
            }
            if (iit <= 12) continue;
            log.error("Failed to converge");
            break;
        } while (erhs > 1.0E-7);
        this.mconc.incrementBy(dc);
        return this.dt;
    }

    private final Matrix numderivs(Column vc, Column vdc, double deltat) {
        int n = this.rtab.getNSpecies();
        Matrix m = new Matrix(n);
        double[] r0 = this.rtab.stepResiduals(vc, vdc, deltat).getData();
        double delta = 1.0E-6;
        for (int j = 0; j < n; ++j) {
            Column vdelta = vdc.copy();
            vdelta.increment(j, delta);
            double[] rd = this.rtab.stepResiduals(vc, vdelta, deltat).getData();
            for (int i = 0; i < n; ++i) {
                m.set(i, j, (rd[i] - r0[i]) / delta);
            }
        }
        return m;
    }

    @Override
    public long getParticleCount() {
        return 0L;
    }
}

