/*
 * Decompiled with CFR 0.152.
 */
package neurord.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import neurord.util.Settings;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.MemoryMappedFileAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="CustomFile", category="core", elementType="appender", printObject=true)
public final class CustomFileAppender
extends AbstractAppender {
    public static final Integer dummy = 0;
    static final boolean mmap_appender = Settings.getProperty("neurord.mmap_appender", "User MemoryMappedFileAppender", true);
    private final List<AbstractOutputStreamAppender<? extends OutputStreamManager>> appenders = new ArrayList<AbstractOutputStreamAppender<? extends OutputStreamManager>>();
    private static CustomFileAppender instance = null;

    private CustomFileAppender(String name, Filter filter, Layout layout, boolean handleException) {
        super(name, filter, layout, handleException);
    }

    @Override
    public void append(LogEvent e) {
        for (Appender appender : this.appenders) {
            appender.append(e);
        }
    }

    @PluginFactory
    public static CustomFileAppender createAppender(@PluginAttribute(value="fileName") String fileName, @PluginAttribute(value="append") String append, @PluginAttribute(value="locking") String locking, @PluginAttribute(value="name") String name, @PluginAttribute(value="immediateFlush") String immediateFlush, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginAttribute(value="bufferedIo") String bufferedIo, @PluginAttribute(value="bufferSize") String bufferSizeStr, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="advertise") String advertise, @PluginAttribute(value="advertiseUri") String advertiseUri, @PluginConfiguration Configuration config) {
        if (name == null) {
            LOGGER.error("No name provided for CustomFileAppender");
            return null;
        }
        CustomFileAppender instance = new CustomFileAppender(name, filter, (Layout)layout, false);
        if (CustomFileAppender.instance != null) {
            LOGGER.error("No support for multiple CustomFileAppenders");
            return null;
        }
        CustomFileAppender.instance = instance;
        return instance;
    }

    public static void addFileAppender(String filename) {
        if (instance == null) {
            LOGGER.error("CustomFileAppender hasn't been initalized, ignoring output " + filename);
            return;
        }
        AbstractOutputStreamAppender appender = mmap_appender ? MemoryMappedFileAppender.createAppender(filename, "false", filename, "false", "8192", "false", instance.getLayout(), instance.getFilter(), "false", "false", new DefaultConfiguration()) : FileAppender.createAppender(filename, "false", "false", filename, "false", "false", "true", "8192", instance.getLayout(), instance.getFilter(), "false", "false", new DefaultConfiguration());
        LOGGER.info("registering custom logfile '{}'", appender);
        CustomFileAppender.instance.appenders.add(appender);
    }

    public static void close() {
        if (instance == null) {
            return;
        }
        for (Appender appender : CustomFileAppender.instance.appenders) {
            appender.stop();
        }
    }
}

