/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import org.jblas.DoubleMatrix;
import org.jblas.FloatMatrix;

public class Geometry {
    public static DoubleMatrix pairwiseSquaredDistances(DoubleMatrix X, DoubleMatrix Y) {
        if (X.rows != Y.rows) {
            throw new IllegalArgumentException("Matrices must have same number of rows");
        }
        DoubleMatrix XX = X.mul(X).columnSums();
        DoubleMatrix YY = Y.mul(Y).columnSums();
        DoubleMatrix Z = X.transpose().mmul(Y);
        Z.muli(-2.0);
        Z.addiColumnVector(XX);
        Z.addiRowVector(YY);
        return Z;
    }

    public static DoubleMatrix center(DoubleMatrix x) {
        return x.subi(x.mean());
    }

    public static DoubleMatrix centerRows(DoubleMatrix x) {
        DoubleMatrix temp = new DoubleMatrix(x.columns);
        for (int r = 0; r < x.rows; ++r) {
            x.putRow(r, Geometry.center(x.getRow(r, temp)));
        }
        return x;
    }

    public static DoubleMatrix centerColumns(DoubleMatrix x) {
        DoubleMatrix temp = new DoubleMatrix(x.rows);
        for (int c = 0; c < x.columns; ++c) {
            x.putColumn(c, Geometry.center(x.getColumn(c, temp)));
        }
        return x;
    }

    public static DoubleMatrix normalize(DoubleMatrix x) {
        return x.divi(x.norm2());
    }

    public static DoubleMatrix normalizeRows(DoubleMatrix x) {
        DoubleMatrix temp = new DoubleMatrix(x.columns);
        for (int r = 0; r < x.rows; ++r) {
            x.putRow(r, Geometry.normalize(x.getRow(r, temp)));
        }
        return x;
    }

    public static DoubleMatrix normalizeColumns(DoubleMatrix x) {
        DoubleMatrix temp = new DoubleMatrix(x.rows);
        for (int c = 0; c < x.columns; ++c) {
            x.putColumn(c, Geometry.normalize(x.getColumn(c, temp)));
        }
        return x;
    }

    public static FloatMatrix pairwiseSquaredDistances(FloatMatrix X, FloatMatrix Y) {
        if (X.rows != Y.rows) {
            throw new IllegalArgumentException("Matrices must have same number of rows");
        }
        FloatMatrix XX = X.mul(X).columnSums();
        FloatMatrix YY = Y.mul(Y).columnSums();
        FloatMatrix Z = X.transpose().mmul(Y);
        Z.muli(-2.0f);
        Z.addiColumnVector(XX);
        Z.addiRowVector(YY);
        return Z;
    }

    public static FloatMatrix center(FloatMatrix x) {
        return x.subi(x.mean());
    }

    public static FloatMatrix centerRows(FloatMatrix x) {
        FloatMatrix temp = new FloatMatrix(x.columns);
        for (int r = 0; r < x.rows; ++r) {
            x.putRow(r, Geometry.center(x.getRow(r, temp)));
        }
        return x;
    }

    public static FloatMatrix centerColumns(FloatMatrix x) {
        FloatMatrix temp = new FloatMatrix(x.rows);
        for (int c = 0; c < x.columns; ++c) {
            x.putColumn(c, Geometry.center(x.getColumn(c, temp)));
        }
        return x;
    }

    public static FloatMatrix normalize(FloatMatrix x) {
        return x.divi(x.norm2());
    }

    public static FloatMatrix normalizeRows(FloatMatrix x) {
        FloatMatrix temp = new FloatMatrix(x.columns);
        for (int r = 0; r < x.rows; ++r) {
            x.putRow(r, Geometry.normalize(x.getRow(r, temp)));
        }
        return x;
    }

    public static FloatMatrix normalizeColumns(FloatMatrix x) {
        FloatMatrix temp = new FloatMatrix(x.rows);
        for (int c = 0; c < x.columns; ++c) {
            x.putColumn(c, Geometry.normalize(x.getColumn(c, temp)));
        }
        return x;
    }
}

