/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;

public class H5ScalarDS
extends ScalarDS {
    private static final long serialVersionUID = 2887517608230611642L;
    private List attributeList;
    private byte[] paletteRefs;
    private boolean isVLEN = false;
    private boolean isEnum = false;
    private boolean isExternal = false;
    private boolean isArrayOfCompound = false;
    private boolean isNativeDatatype = true;
    private boolean isRegRef = false;
    private int nAttributes = -1;
    private H5O_info_t obj_info;

    public H5ScalarDS(FileFormat theFile, String theName, String thePath) {
        this(theFile, theName, thePath, null);
    }

    @Deprecated
    public H5ScalarDS(FileFormat theFile, String theName, String thePath, long[] oid) {
        super(theFile, theName, thePath, oid);
        this.unsignedConverted = false;
        this.paletteRefs = null;
        this.obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
        if (oid == null && theFile != null) {
            try {
                byte[] ref_buf = H5.H5Rcreate(theFile.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(ref_buf, 0);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttribute() {
        this.obj_info.num_attrs = this.nAttributes;
        if (this.obj_info.num_attrs < 0L) {
            int did;
            block56: {
                did = this.open();
                this.obj_info.num_attrs = 0L;
                int aid = -1;
                int atid = -1;
                int tid = 0;
                try {
                    this.obj_info = H5.H5Oget_info(did);
                    this.nAttributes = (int)this.obj_info.num_attrs;
                    tid = H5.H5Dget_type(did);
                    int tclass = H5.H5Tget_class(tid);
                    this.isText = tclass == HDF5Constants.H5T_STRING;
                    this.isVLEN = tclass == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str(tid);
                    this.isEnum = tclass == HDF5Constants.H5T_ENUM;
                    aid = H5.H5Aopen_by_name(did, ".", "CLASS", HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                    atid = H5.H5Aget_type(aid);
                    int aclass = H5.H5Tget_class(atid);
                    if (aclass == HDF5Constants.H5T_STRING) {
                        int size = H5.H5Tget_size(atid);
                        byte[] attrValue = new byte[size];
                        H5.H5Aread(aid, atid, attrValue);
                        String strValue = new String(attrValue).trim();
                        this.isImageDisplay = this.isImage = strValue.equalsIgnoreCase("IMAGE");
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    try {
                        H5.H5Tclose(atid);
                    }
                    catch (HDF5Exception ex) {}
                    try {
                        H5.H5Aclose(aid);
                    }
                    catch (HDF5Exception ex) {}
                    try {
                        H5.H5Tclose(tid);
                    }
                    catch (HDF5Exception ex) {}
                }
                int asid = -1;
                try {
                    aid = H5.H5Aopen_by_name(did, ".", "IMAGE_MINMAXRANGE", HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                    if (aid <= 0) break block56;
                    int tmptid = atid = H5.H5Aget_type(aid);
                    atid = H5.H5Tget_native_type(tmptid);
                    try {
                        H5.H5Tclose(tmptid);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    asid = H5.H5Aget_space(aid);
                    long[] adims = null;
                    int arank = H5.H5Sget_simple_extent_ndims(asid);
                    if (arank > 0) {
                        adims = new long[arank];
                        H5.H5Sget_simple_extent_dims(asid, adims, null);
                    }
                    long lsize = 1L;
                    for (int j = 0; j < adims.length; ++j) {
                        lsize *= adims[j];
                    }
                    Object avalue = H5Datatype.allocateArray(atid, (int)lsize);
                    if (avalue == null) break block56;
                    H5.H5Aread(aid, atid, avalue);
                    double x0 = 0.0;
                    double x1 = 0.0;
                    try {
                        x0 = Double.valueOf(Array.get(avalue, 0).toString());
                        x1 = Double.valueOf(Array.get(avalue, 1).toString());
                    }
                    catch (Exception ex2) {
                        x1 = 0.0;
                        x0 = 0.0;
                    }
                    if (x1 > x0) {
                        this.imageDataRange = new double[2];
                        this.imageDataRange[0] = x0;
                        this.imageDataRange[1] = x1;
                    }
                }
                catch (Exception ex) {
                }
                finally {
                    try {
                        H5.H5Tclose(atid);
                    }
                    catch (HDF5Exception ex) {}
                    try {
                        H5.H5Sclose(asid);
                    }
                    catch (HDF5Exception ex) {}
                    try {
                        H5.H5Aclose(aid);
                    }
                    catch (HDF5Exception ex) {}
                }
            }
            this.close(did);
        }
        return this.obj_info.num_attrs > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.rank > 0) {
            this.resetSelection();
            return;
        }
        int did = -1;
        int sid = -1;
        int tid = -1;
        did = this.open();
        this.paletteRefs = this.getPaletteRefs(did);
        int pid = -1;
        try {
            sid = H5.H5Dget_space(did);
            tid = H5.H5Dget_type(did);
            int tclass = H5.H5Tget_class(tid);
            this.rank = H5.H5Sget_simple_extent_ndims(sid);
            this.isText = tclass == HDF5Constants.H5T_STRING;
            this.isVLEN = tclass == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str(tid);
            this.isEnum = tclass == HDF5Constants.H5T_ENUM;
            this.isUnsigned = H5Datatype.isUnsigned(tid);
            this.isRegRef = H5.H5Tequal(tid, HDF5Constants.H5T_STD_REF_DSETREG);
            if (tclass == HDF5Constants.H5T_ARRAY) {
                int basetid = H5.H5Tget_super(tid);
                int baseclass = H5.H5Tget_class(basetid);
                this.isArrayOfCompound = baseclass == HDF5Constants.H5T_COMPOUND;
            }
            try {
                pid = H5.H5Dget_create_plist(did);
                int nfiles = H5.H5Pget_external_count(pid);
                this.isExternal = nfiles > 0;
            }
            catch (Exception ex) {
                // empty catch block
            }
            int tmptid = 0;
            try {
                tmptid = H5.H5Tget_native_type(tid);
                this.isNativeDatatype = H5.H5Tequal(tid, tmptid);
                int[] fillStatus = new int[]{0};
                if (H5.H5Pfill_value_defined(pid, fillStatus) >= 0 && fillStatus[0] == HDF5Constants.H5D_FILL_VALUE_USER_DEFINED) {
                    this.fillValue = H5Datatype.allocateArray(tmptid, 1);
                    try {
                        H5.H5Pget_fill_value(pid, tmptid, this.fillValue);
                    }
                    catch (Exception ex2) {
                        this.fillValue = null;
                    }
                }
            }
            catch (HDF5Exception ex) {
            }
            finally {
                try {
                    H5.H5Tclose(tmptid);
                }
                catch (HDF5Exception ex) {}
                try {
                    H5.H5Pclose(pid);
                }
                catch (Exception ex) {}
            }
            if (this.rank == 0) {
                this.rank = 1;
                this.dims = new long[1];
                this.dims[0] = 1L;
            } else {
                this.dims = new long[this.rank];
                this.maxDims = new long[this.rank];
                H5.H5Sget_simple_extent_dims(sid, this.dims, this.maxDims);
            }
        }
        catch (HDF5Exception ex) {
        }
        finally {
            try {
                H5.H5Tclose(tid);
            }
            catch (HDF5Exception ex2) {}
            try {
                H5.H5Sclose(sid);
            }
            catch (HDF5Exception ex2) {}
        }
        if (this.rank >= 3 && this.isImage) {
            this.interlace = -1;
            this.isTrueColor = this.isStringAttributeOf(did, "IMAGE_SUBCLASS", "IMAGE_TRUECOLOR");
            if (this.isTrueColor) {
                this.interlace = 0;
                if (this.isStringAttributeOf(did, "INTERLACE_MODE", "INTERLACE_PLANE")) {
                    this.interlace = 2;
                }
            }
        }
        this.close(did);
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        this.resetSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStringAttributeOf(int objID, String name, String value) {
        boolean retValue = false;
        int aid = -1;
        int atid = -1;
        try {
            aid = H5.H5Aopen_by_name(objID, ".", name, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            atid = H5.H5Aget_type(aid);
            int size = H5.H5Tget_size(atid);
            byte[] attrValue = new byte[size];
            H5.H5Aread(aid, atid, attrValue);
            String strValue = new String(attrValue).trim();
            retValue = strValue.equalsIgnoreCase(value);
        }
        catch (Exception ex) {
        }
        finally {
            try {
                H5.H5Tclose(atid);
            }
            catch (HDF5Exception ex) {}
            try {
                H5.H5Aclose(aid);
            }
            catch (HDF5Exception ex) {}
        }
        return retValue;
    }

    private void resetSelection() {
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
            if (this.selectedStride == null) continue;
            this.selectedStride[i] = 1L;
        }
        if (this.interlace == 0) {
            this.selectedDims[2] = 3L;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedIndex[2] = 2;
        } else if (this.interlace == 2) {
            this.selectedDims[0] = 3L;
            this.selectedDims[1] = this.dims[1];
            this.selectedDims[2] = this.dims[2];
            this.selectedIndex[0] = 1;
            this.selectedIndex[1] = 2;
            this.selectedIndex[2] = 0;
        } else if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            if (this.isImage) {
                this.selectedIndex[1] = this.rank - 1;
                this.selectedIndex[0] = this.rank - 2;
                this.selectedIndex[2] = this.rank - 3;
            } else {
                this.selectedIndex[0] = 0;
                this.selectedIndex[1] = 1;
                this.selectedIndex[2] = 2;
            }
            this.selectedDims[this.selectedIndex[0]] = this.dims[this.selectedIndex[0]];
            this.selectedDims[this.selectedIndex[1]] = this.dims[this.selectedIndex[1]];
        }
        if (this.rank > 1 && this.isText) {
            this.selectedIndex[0] = this.rank - 1;
            this.selectedIndex[1] = 0;
            this.selectedDims[0] = 1L;
            this.selectedDims[this.selectedIndex[0]] = this.dims[this.selectedIndex[0]];
        }
        this.isDataLoaded = false;
        this.isDefaultImageOrder = true;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dataset copy(Group pgroup, String dstName, long[] dims, Object buff) throws Exception {
        if (pgroup == null) {
            return null;
        }
        H5ScalarDS dataset = null;
        int srcdid = -1;
        int dstdid = -1;
        int tid = -1;
        int sid = -1;
        int plist = -1;
        String dname = null;
        String path = null;
        path = pgroup.isRoot() ? "/" : pgroup.getPath() + pgroup.getName() + "/";
        dname = path + dstName;
        try {
            srcdid = this.open();
            tid = H5.H5Dget_type(srcdid);
            sid = H5.H5Screate_simple(dims.length, dims, null);
            plist = H5.H5Dget_create_plist(srcdid);
            long[] chunks = new long[dims.length];
            boolean setChunkFlag = false;
            try {
                H5.H5Pget_chunk(plist, dims.length, chunks);
                for (int i = 0; i < dims.length; ++i) {
                    if (dims[i] >= chunks[i]) continue;
                    setChunkFlag = true;
                    chunks[i] = dims[i] == 1L ? 1L : dims[i] / 2L;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (setChunkFlag) {
                H5.H5Pset_chunk(plist, dims.length, chunks);
            }
            try {
                dstdid = H5.H5Dcreate(pgroup.getFID(), dname, tid, sid, HDF5Constants.H5P_DEFAULT, plist, HDF5Constants.H5P_DEFAULT);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    H5.H5Dclose(dstdid);
                }
                catch (Exception ex2) {}
            }
            dataset = new H5ScalarDS(pgroup.getFileFormat(), dstName, path);
            if (buff != null) {
                ((Dataset)dataset).init();
                ((Dataset)dataset).write(buff);
            }
            dstdid = ((HObject)dataset).open();
            H5File.copyAttributes(srcdid, dstdid);
        }
        finally {
            try {
                H5.H5Pclose(plist);
            }
            catch (Exception ex) {}
            try {
                H5.H5Sclose(sid);
            }
            catch (Exception ex) {}
            try {
                H5.H5Tclose(tid);
            }
            catch (Exception ex) {}
            try {
                H5.H5Dclose(srcdid);
            }
            catch (Exception ex) {}
            try {
                H5.H5Dclose(dstdid);
            }
            catch (Exception ex) {}
        }
        pgroup.addToMemberList(dataset);
        ((ScalarDS)dataset).setIsImage(this.isImage);
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws HDF5Exception {
        byte[] theData = null;
        if (this.rank <= 0) {
            this.init();
        }
        int did = this.open();
        int fspace = -1;
        int mspace = -1;
        int tid = -1;
        try {
            long[] lsize = new long[]{1L};
            for (int j = 0; j < this.selectedDims.length; ++j) {
                lsize[0] = lsize[0] * this.selectedDims[j];
            }
            fspace = H5.H5Dget_space(did);
            mspace = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            if ((long)this.rank * this.dims[0] > 1L) {
                H5.H5Sselect_hyperslab(fspace, HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
            }
            tid = H5.H5Dget_type(did);
            int size = H5.H5Tget_size(tid) * (int)lsize[0];
            theData = new byte[size];
            H5.H5Dread(did, tid, mspace, fspace, HDF5Constants.H5P_DEFAULT, theData);
        }
        finally {
            try {
                H5.H5Sclose(fspace);
            }
            catch (Exception ex2) {}
            try {
                H5.H5Sclose(mspace);
            }
            catch (Exception ex2) {}
            try {
                H5.H5Tclose(tid);
            }
            catch (HDF5Exception ex2) {}
            this.close(did);
        }
        return theData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read() throws HDF5Exception {
        String[] theData = null;
        int did = -1;
        int tid = -1;
        int[] spaceIDs = new int[]{-1, -1};
        if (this.rank <= 0) {
            this.init();
        }
        if (this.isArrayOfCompound) {
            throw new HDF5Exception("Cannot show data with dataype of ARRAY of COMPOUND.");
        }
        if (this.isExternal) {
            String pdir = this.getFileFormat().getAbsoluteFile().getParent();
            if (pdir == null) {
                pdir = ".";
            }
            H5.H5Dchdir_ext(pdir);
        }
        long[] lsize = new long[]{1L};
        try {
            did = this.open();
            lsize[0] = this.selectHyperslab(did, spaceIDs);
            if (lsize[0] == 0L) {
                throw new HDF5Exception("No data to read.\nEither the dataset or the selected subset is empty.");
            }
            try {
                long ssize = H5.H5Dget_storage_size(did);
                if (ssize <= 0L) {
                    throw new HDF5Exception("Storage space is not allocated.");
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            tid = H5.H5Dget_type(did);
            if (!this.isNativeDatatype) {
                int tmptid = -1;
                try {
                    tmptid = tid;
                    tid = H5.H5Tget_native_type(tmptid);
                }
                finally {
                    try {
                        H5.H5Tclose(tmptid);
                    }
                    catch (Exception ex2) {}
                }
            }
            boolean isREF = H5.H5Tequal(tid, HDF5Constants.H5T_STD_REF_OBJ);
            if (this.originalBuf == null || this.isText || isREF || this.originalBuf != null && lsize[0] != this.nPoints) {
                try {
                    theData = H5Datatype.allocateArray(tid, (int)lsize[0]);
                }
                catch (OutOfMemoryError err) {
                    throw new HDF5Exception("Out Of Memory.");
                }
            } else {
                theData = this.originalBuf;
            }
            if (theData != null) {
                if (this.isVLEN) {
                    H5.H5DreadVL(did, tid, spaceIDs[0], spaceIDs[1], HDF5Constants.H5P_DEFAULT, theData);
                } else {
                    H5.H5Dread(did, tid, spaceIDs[0], spaceIDs[1], HDF5Constants.H5P_DEFAULT, theData);
                    if (this.isText && this.convertByteToString) {
                        theData = H5ScalarDS.byteToString((byte[])theData, H5.H5Tget_size(tid));
                    } else if (isREF) {
                        theData = (String[])HDFNativeData.byteToLong((byte[])theData);
                    } else if (this.isEnum && this.isEnumConverted()) {
                        theData = H5Datatype.convertEnumValueToName(tid, theData, null);
                    }
                }
            }
        }
        finally {
            try {
                H5.H5Sclose(spaceIDs[0]);
            }
            catch (Exception ex) {}
            try {
                H5.H5Sclose(spaceIDs[1]);
            }
            catch (Exception ex) {}
            try {
                H5.H5Tclose(tid);
            }
            catch (Exception ex2) {}
            this.close(did);
        }
        return theData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object buf) throws HDF5Exception {
        int did = -1;
        int tid = -1;
        int[] spaceIDs = new int[]{-1, -1};
        Object tmpData = null;
        if (buf == null) {
            return;
        }
        if (this.isVLEN && !this.isText) {
            throw new HDF5Exception("Writing non-string variable-length data is not supported");
        }
        if (this.isRegRef) {
            throw new HDF5Exception("Writing region references data is not supported");
        }
        long[] lsize = new long[]{1L};
        try {
            did = this.open();
            lsize[0] = this.selectHyperslab(did, spaceIDs);
            tid = H5.H5Dget_type(did);
            if (!this.isNativeDatatype) {
                int tmptid = -1;
                try {
                    tmptid = tid;
                    tid = H5.H5Tget_native_type(tmptid);
                }
                finally {
                    try {
                        H5.H5Tclose(tmptid);
                    }
                    catch (Exception ex2) {}
                }
            }
            this.isText = H5.H5Tget_class(tid) == HDF5Constants.H5T_STRING;
            int tsize = H5.H5Tget_size(tid);
            String cname = buf.getClass().getName();
            char dname = cname.charAt(cname.lastIndexOf("[") + 1);
            boolean doConversion = tsize == 1 && dname == 'S' || tsize == 2 && dname == 'I' || tsize == 4 && dname == 'J' || this.isUnsigned && this.unsignedConverted;
            tmpData = buf;
            if (doConversion) {
                tmpData = H5ScalarDS.convertToUnsignedC(buf, null);
            } else if (this.isText && this.convertByteToString && !H5.H5Tis_variable_str(tid)) {
                tmpData = H5ScalarDS.stringToByte((String[])buf, H5.H5Tget_size(tid));
            } else if (this.isEnum && Array.get(buf, 0) instanceof String) {
                tmpData = H5Datatype.convertEnumNameToValue(tid, (String[])buf, null);
            }
            H5.H5Dwrite(did, tid, spaceIDs[0], spaceIDs[1], HDF5Constants.H5P_DEFAULT, tmpData);
        }
        finally {
            tmpData = null;
            try {
                H5.H5Sclose(spaceIDs[0]);
            }
            catch (Exception ex) {}
            try {
                H5.H5Sclose(spaceIDs[1]);
            }
            catch (Exception ex) {}
            try {
                H5.H5Tclose(tid);
            }
            catch (Exception ex) {}
            this.close(did);
        }
    }

    private long selectHyperslab(int did, int[] spaceIDs) throws HDF5Exception {
        long lsize = 1L;
        boolean isAllSelected = true;
        for (int i = 0; i < this.rank; ++i) {
            lsize *= this.selectedDims[i];
            if (this.selectedDims[i] >= this.dims[i]) continue;
            isAllSelected = false;
        }
        if (isAllSelected) {
            spaceIDs[0] = HDF5Constants.H5S_ALL;
            spaceIDs[1] = HDF5Constants.H5S_ALL;
        } else {
            spaceIDs[1] = H5.H5Dget_space(did);
            spaceIDs[0] = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            H5.H5Sselect_hyperslab(spaceIDs[1], HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
        }
        this.isDefaultImageOrder = this.rank <= 1 || this.selectedIndex[0] <= this.selectedIndex[1];
        return lsize;
    }

    @Override
    public List getMetadata() throws HDF5Exception {
        return this.getMetadata(HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata(int ... attrPropList) throws HDF5Exception {
        if (this.rank <= 0) {
            this.init();
        }
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int did = -1;
        int pid = -1;
        int indxType = HDF5Constants.H5_INDEX_NAME;
        int order = HDF5Constants.H5_ITER_INC;
        if (attrPropList.length > 0) {
            indxType = attrPropList[0];
            if (attrPropList.length > 1) {
                order = attrPropList[1];
            }
        }
        try {
            did = this.open();
            this.attributeList = H5File.getAttribute(did, indxType, order);
            pid = H5.H5Dget_create_plist(did);
            if (H5.H5Pget_layout(pid) == HDF5Constants.H5D_CHUNKED) {
                this.chunkSize = new long[this.rank];
                H5.H5Pget_chunk(pid, this.rank, this.chunkSize);
            } else {
                this.chunkSize = null;
            }
            int[] flags = new int[]{0, 0};
            long[] cd_nelmts = new long[]{2L};
            int[] cd_values = new int[]{0, 0};
            String[] cd_name = new String[]{"", ""};
            int nfilt = H5.H5Pget_nfilters(pid);
            int filter = -1;
            int[] filter_config = new int[]{1};
            this.compression = "";
            for (int i = 0; i < nfilt; ++i) {
                if (i > 0) {
                    this.compression = this.compression + ", ";
                }
                try {
                    filter = H5.H5Pget_filter(pid, i, flags, cd_nelmts, cd_values, 120L, cd_name, filter_config);
                }
                catch (Throwable err) {
                    this.compression = this.compression + "ERROR";
                    continue;
                }
                if (filter == HDF5Constants.H5Z_FILTER_DEFLATE) {
                    this.compression = this.compression + "GZIP: level = " + cd_values[0];
                    continue;
                }
                if (filter == HDF5Constants.H5Z_FILTER_FLETCHER32) {
                    this.compression = this.compression + "Error detection filter";
                    continue;
                }
                if (filter == HDF5Constants.H5Z_FILTER_SHUFFLE) {
                    this.compression = this.compression + "SHUFFLE: Nbytes = " + cd_values[0];
                    continue;
                }
                if (filter != HDF5Constants.H5Z_FILTER_SZIP) continue;
                this.compression = this.compression + "SZIP: Pixels per block = " + cd_values[1];
                int flag = -1;
                try {
                    flag = H5.H5Zget_filter_info(filter);
                }
                catch (Exception ex) {
                    flag = -1;
                }
                if (flag == HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                    this.compression = this.compression + ": H5Z_FILTER_CONFIG_DECODE_ENABLED";
                    continue;
                }
                if (flag != HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED && flag < HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED + HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) continue;
                this.compression = this.compression + ": H5Z_FILTER_CONFIG_ENCODE_ENABLED";
            }
            if (this.compression.length() == 0) {
                this.compression = "NONE";
            }
            try {
                int[] at = new int[]{0};
                H5.H5Pget_alloc_time(pid, at);
                this.compression = this.compression + ",         Storage allocation time: ";
                if (at[0] == HDF5Constants.H5D_ALLOC_TIME_EARLY) {
                    this.compression = this.compression + "Early";
                } else if (at[0] == HDF5Constants.H5D_ALLOC_TIME_INCR) {
                    this.compression = this.compression + "Incremental";
                } else if (at[0] == HDF5Constants.H5D_ALLOC_TIME_LATE) {
                    this.compression = this.compression + "Late";
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                H5.H5Pclose(pid);
            }
            catch (Exception ex) {}
            this.close(did);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object info) throws Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        boolean attrExisted = false;
        Attribute attr = (Attribute)info;
        String name = attr.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            attrExisted = this.attributeList.contains(attr);
        }
        this.getFileFormat().writeAttribute(this, attr, attrExisted);
        if (!attrExisted) {
            this.attributeList.add(attr);
            this.nAttributes = this.attributeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(Object info) throws HDF5Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        Attribute attr = (Attribute)info;
        int did = this.open();
        try {
            H5.H5Adelete(did, attr.getName());
            List attrList = this.getMetadata();
            attrList.remove(attr);
            this.nAttributes = this.attributeList.size();
        }
        finally {
            this.close(did);
        }
    }

    @Override
    public int open() {
        int did = -1;
        try {
            did = H5.H5Dopen(this.getFID(), this.getPath() + this.getName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception ex) {
            did = -1;
        }
        return did;
    }

    @Override
    public void close(int did) {
        try {
            H5.H5Fflush(did, HDF5Constants.H5F_SCOPE_LOCAL);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            H5.H5Dclose(did);
        }
        catch (HDF5Exception hDF5Exception) {
            // empty catch block
        }
    }

    @Override
    public byte[][] getPalette() {
        if (this.palette == null) {
            this.palette = this.readPalette(0);
        }
        return this.palette;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPaletteName(int idx) {
        byte[] refs = this.getPaletteRefs();
        int did = -1;
        int pal_id = -1;
        String[] paletteName = new String[]{""};
        long size = 100L;
        if (refs == null) {
            return null;
        }
        byte[] ref_buf = new byte[8];
        try {
            System.arraycopy(refs, idx * 8, ref_buf, 0, 8);
        }
        catch (Throwable err) {
            return null;
        }
        try {
            did = this.open();
            pal_id = H5.H5Rdereference(this.getFID(), HDF5Constants.H5R_OBJECT, ref_buf);
            H5.H5Iget_name(pal_id, paletteName, size);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.close(pal_id);
            this.close(did);
        }
        return paletteName[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[][] readPalette(int idx) {
        byte[][] thePalette = null;
        byte[] refs = this.getPaletteRefs();
        int did = -1;
        int pal_id = -1;
        int tid = -1;
        if (refs == null) {
            return null;
        }
        byte[] p = null;
        byte[] ref_buf = new byte[8];
        try {
            System.arraycopy(refs, idx * 8, ref_buf, 0, 8);
        }
        catch (Throwable err) {
            return null;
        }
        try {
            did = this.open();
            pal_id = H5.H5Rdereference(this.getFID(), HDF5Constants.H5R_OBJECT, ref_buf);
            tid = H5.H5Dget_type(pal_id);
            if (H5.H5Dget_storage_size(pal_id) <= 768L) {
                p = new byte[768];
                H5.H5Dread(pal_id, tid, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, p);
            }
        }
        catch (HDF5Exception ex) {
            p = null;
        }
        finally {
            try {
                H5.H5Tclose(tid);
            }
            catch (HDF5Exception ex2) {}
            this.close(pal_id);
            this.close(did);
        }
        if (p != null) {
            thePalette = new byte[3][256];
            for (int i = 0; i < 256; ++i) {
                thePalette[0][i] = p[i * 3];
                thePalette[1][i] = p[i * 3 + 1];
                thePalette[2][i] = p[i * 3 + 2];
            }
        }
        return thePalette;
    }

    private static byte[] parseFillValue(Datatype type, Object fillValue) throws Exception {
        byte[] data = null;
        if (type == null || fillValue == null) {
            return null;
        }
        int datatypeClass = type.getDatatypeClass();
        int datatypeSize = type.getDatatypeSize();
        double val_dbl = 0.0;
        String val_str = null;
        if (fillValue instanceof String) {
            val_str = (String)fillValue;
        } else if (fillValue.getClass().isArray()) {
            val_str = Array.get(fillValue, 0).toString();
        }
        if (datatypeClass != 3) {
            try {
                val_dbl = Double.parseDouble(val_str);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        try {
            switch (datatypeClass) {
                case 0: 
                case 2: 
                case 8: {
                    if (datatypeSize == 1) {
                        data = new byte[]{(byte)val_dbl};
                        break;
                    }
                    if (datatypeSize == 2) {
                        data = HDFNativeData.shortToByte((short)val_dbl);
                        break;
                    }
                    if (datatypeSize == 8) {
                        data = HDFNativeData.longToByte((long)val_dbl);
                        break;
                    }
                    data = HDFNativeData.intToByte((int)val_dbl);
                    break;
                }
                case 1: {
                    if (datatypeSize == 8) {
                        data = HDFNativeData.doubleToByte(val_dbl);
                        break;
                    }
                    data = HDFNativeData.floatToByte((float)val_dbl);
                    break;
                }
                case 3: {
                    data = val_str.getBytes();
                    break;
                }
                case 7: {
                    data = HDFNativeData.longToByte((long)val_dbl);
                }
            }
        }
        catch (Exception ex) {
            data = null;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static H5ScalarDS create(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, Object fillValue, Object data) throws Exception {
        int i;
        H5ScalarDS dataset = null;
        String fullPath = null;
        int did = -1;
        int tid = -1;
        int sid = -1;
        int plist = -1;
        if (pgroup == null || name == null || dims == null || gzip > 0 && chunks == null) {
            return null;
        }
        H5File file = (H5File)pgroup.getFileFormat();
        if (file == null) {
            return null;
        }
        String path = "/";
        if (!pgroup.isRoot()) {
            int idx;
            path = pgroup.getPath() + pgroup.getName() + "/";
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            if ((idx = name.lastIndexOf("/")) >= 0) {
                name = name.substring(idx + 1);
            }
        }
        fullPath = path + name;
        boolean isExtentable = false;
        if (maxdims != null) {
            for (i = 0; i < maxdims.length; ++i) {
                if (maxdims[i] == 0L) {
                    maxdims[i] = dims[i];
                } else if (maxdims[i] < 0L) {
                    maxdims[i] = HDF5Constants.H5S_UNLIMITED;
                }
                if (maxdims[i] == dims[i]) continue;
                isExtentable = true;
            }
        }
        if (chunks == null && isExtentable) {
            chunks = new long[dims.length];
            for (i = 0; i < dims.length; ++i) {
                chunks[i] = Math.min(dims[i], 64L);
            }
        }
        int rank = dims.length;
        try {
            tid = type.toNative();
            sid = H5.H5Screate_simple(rank, dims, maxdims);
            plist = HDF5Constants.H5P_DEFAULT;
            byte[] val_fill = null;
            try {
                val_fill = H5ScalarDS.parseFillValue(type, fillValue);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (chunks != null || val_fill != null) {
                plist = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
                if (chunks != null) {
                    H5.H5Pset_layout(plist, HDF5Constants.H5D_CHUNKED);
                    H5.H5Pset_chunk(plist, rank, chunks);
                }
                if (val_fill != null) {
                    H5.H5Pset_fill_value(plist, tid, val_fill);
                }
            }
            if (gzip > 0) {
                H5.H5Pset_deflate(plist, gzip);
            }
            int fid = file.getFID();
            did = H5.H5Dcreate(fid, fullPath, tid, sid, HDF5Constants.H5P_DEFAULT, plist, HDF5Constants.H5P_DEFAULT);
            dataset = new H5ScalarDS(file, name, path);
        }
        finally {
            try {
                H5.H5Pclose(plist);
            }
            catch (HDF5Exception ex) {}
            try {
                H5.H5Sclose(sid);
            }
            catch (HDF5Exception ex) {}
            try {
                H5.H5Tclose(tid);
            }
            catch (HDF5Exception ex) {}
            try {
                H5.H5Dclose(did);
            }
            catch (HDF5Exception ex) {}
        }
        if (dataset != null) {
            pgroup.addToMemberList(dataset);
            if (data != null) {
                dataset.write(data);
            }
        }
        return dataset;
    }

    public static H5ScalarDS create(String name, Group pgroup, Datatype type, long[] dims, long[] maxdims, long[] chunks, int gzip, Object data) throws Exception {
        return H5ScalarDS.create(name, pgroup, type, dims, maxdims, chunks, gzip, null, data);
    }

    @Override
    public byte[] getPaletteRefs() {
        if (this.rank <= 0) {
            this.init();
        }
        return this.paletteRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getPaletteRefs(int did) {
        int aid = -1;
        int sid = -1;
        int size = 0;
        int rank = 0;
        int atype = -1;
        byte[] ref_buf = null;
        try {
            aid = H5.H5Aopen_by_name(did, ".", "PALETTE", HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            sid = H5.H5Aget_space(aid);
            rank = H5.H5Sget_simple_extent_ndims(sid);
            size = 1;
            if (rank > 0) {
                long[] dims = new long[rank];
                H5.H5Sget_simple_extent_dims(sid, dims, null);
                for (int i = 0; i < rank; ++i) {
                    size *= (int)dims[i];
                }
            }
            ref_buf = new byte[size * 8];
            atype = H5.H5Aget_type(aid);
            H5.H5Aread(aid, atype, ref_buf);
        }
        catch (HDF5Exception ex) {
            ref_buf = null;
        }
        finally {
            try {
                H5.H5Tclose(atype);
            }
            catch (HDF5Exception ex2) {}
            try {
                H5.H5Sclose(sid);
            }
            catch (HDF5Exception ex2) {}
            try {
                H5.H5Aclose(aid);
            }
            catch (HDF5Exception ex2) {}
        }
        return ref_buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            int did = -1;
            int tid = -1;
            did = this.open();
            try {
                tid = H5.H5Dget_type(did);
                if (!this.isNativeDatatype) {
                    int tmptid = -1;
                    try {
                        tmptid = tid;
                        tid = H5.H5Tget_native_type(tmptid);
                    }
                    finally {
                        try {
                            H5.H5Tclose(tmptid);
                        }
                        catch (Exception ex2) {}
                    }
                }
                this.datatype = new H5Datatype(tid);
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    H5.H5Tclose(tid);
                }
                catch (HDF5Exception ex) {}
                try {
                    H5.H5Dclose(did);
                }
                catch (HDF5Exception ex) {}
            }
        }
        return this.datatype;
    }

    @Override
    public void setName(String newName) throws Exception {
        H5File.renameObject(this, newName);
        super.setName(newName);
    }

    public void extend(long[] newDims) throws HDF5Exception {
        int did = -1;
        int sid = -1;
        did = this.open();
        try {
            H5.H5Dset_extent(did, newDims);
            H5.H5Fflush(did, HDF5Constants.H5F_SCOPE_GLOBAL);
            sid = H5.H5Dget_space(did);
            long[] checkDims = new long[this.rank];
            H5.H5Sget_simple_extent_dims(sid, checkDims, null);
            for (int i = 0; i < this.rank; ++i) {
                if (checkDims[i] == newDims[i]) continue;
                throw new HDF5Exception("error extending dataset " + this.getName());
            }
            this.dims = checkDims;
        }
        catch (Exception e) {
            throw new HDF5Exception(e.getMessage());
        }
        finally {
            if (sid > 0) {
                H5.H5Sclose(sid);
            }
            this.close(did);
        }
    }
}

