/*
 * Decompiled with CFR 0.152.
 */
package neurord.disc;

import java.util.ArrayList;
import java.util.HashMap;
import neurord.geom.GRotation;
import neurord.geom.Geom;
import neurord.geom.Position;
import neurord.geom.Translation;
import neurord.geom.Vector;
import neurord.numeric.morph.CurvedVolumeElement;
import neurord.numeric.morph.TreePoint;
import neurord.numeric.morph.TriangleStrip;
import neurord.numeric.morph.TrianglesSet;
import neurord.numeric.morph.VolumeElement;

public class CurvedVolumeSlice {
    double baseDelta;
    double radiusa;
    double radiusb;
    double[] bdsa;
    double[] bdsb;
    int[] nazim;
    ArrayList<CurvedVolumeElement> elements;
    HashMap<Integer, ArrayList<CurvedVolumeElement>> radHM;
    double maxAspectRatio = 2.0;

    public CurvedVolumeSlice(double delta, double ra, double rb) {
        this.baseDelta = delta;
        this.radiusa = ra;
        this.radiusb = rb;
    }

    public double[] getRadii(int end) {
        return end == 0 ? this.bdsa : this.bdsb;
    }

    public int[] getNazimuthals() {
        return this.nazim;
    }

    public void discFill(Position pa, Position pb, String pointLabel, String regionLabel, double[] surfaceLayers, double maxAR) {
        Vector vy;
        this.maxAspectRatio = maxAR;
        double axlen = Geom.distanceBetween(pa, pb);
        Translation trans = Geom.translation(Geom.midpoint(pa, pb));
        Vector vab = Geom.fromToVector(pa, pb);
        double arotx = Geom.zElevation(vab);
        double arotz = Geom.yzRotationAngle(vab);
        GRotation rotx = Geom.aboutXRotation(arotx);
        GRotation rotz = Geom.aboutZRotation(arotz);
        GRotation rot = rotz.times(rotx);
        Position prot = rot.getRotatedPosition(Geom.endPosition(vy = Geom.unitY()));
        double da = Geom.angleBetween(vab, Geom.getToVector(prot));
        if (Math.abs(da) > 1.0E-6) {
            throw new RuntimeException("rotation angle miscalculation: residual angle is " + da);
        }
        this.elements = new ArrayList();
        double maxr = Math.max(this.radiusa, this.radiusb);
        double[] bdm = this.getRadialSplit(maxr, surfaceLayers);
        this.bdsa = this.getRadialSplit(this.radiusa, bdm.length, surfaceLayers);
        this.bdsb = this.getRadialSplit(this.radiusb, bdm.length, surfaceLayers);
        this.nazim = this.getAzimuthalSplits(maxr, bdm);
        this.radHM = new HashMap();
        for (int ir = 0; ir < this.bdsa.length; ++ir) {
            double ra1 = ir > 0 ? this.bdsa[ir - 1] : 0.0;
            double ra2 = this.bdsa[ir];
            double rb1 = ir > 0 ? this.bdsb[ir - 1] : 0.0;
            double rb2 = this.bdsb[ir];
            double rc = ((ra1 + ra2) / 2.0 + (rb1 + rb2) / 2.0) / 2.0;
            int na = this.nazim[ir];
            double eltangle = Math.PI * 2 / (double)na;
            double volouter = axlen * (ra2 * ra2 + rb2 * rb2 + ra2 * rb2) / 3.0;
            double volinner = axlen * (ra1 * ra1 + rb1 * rb1 + ra1 * rb1) / 3.0;
            double eltvol = (volouter - volinner) / (double)na;
            double surfouter = Math.PI * 2 * (ra2 + rb2) / 2.0;
            double carea = axlen * (ra2 - ra1 + (rb2 - rb1)) / 2.0;
            double subarea = axlen * 2.0 * Math.PI * (ra1 + rb1) / 2.0 / (double)na;
            ArrayList<CurvedVolumeElement> azb = null;
            double eltangleb = 1.0;
            if (ir > 0) {
                azb = this.radHM.get(ir - 1);
                eltangleb = Math.PI * 2 / (double)azb.size();
            }
            ArrayList<CurvedVolumeElement> az = new ArrayList<CurvedVolumeElement>();
            for (int ia = 0; ia < na; ++ia) {
                Position[] praw;
                double theta = (double)ia * eltangle;
                double thetaC = theta + 0.5 * eltangle;
                double vcx = rc * Math.cos(thetaC);
                double vcy = 0.0;
                double vcz = rc * Math.sin(thetaC);
                Position center = trans.getTranslated(rot.getRotatedPosition(Geom.position(vcx, 0.0, vcz)));
                double rca = (ra1 + ra2) / 2.0;
                double rcb = (rb1 + rb2) / 2.0;
                double dtheta = Math.max(eltangle / 2.0, 1.0);
                double ha = 0.5 * axlen;
                Position[] pbdry = new Position[]{Geom.position(rca * Math.cos(thetaC - dtheta), -ha, rca * Math.sin(thetaC - dtheta)), Geom.position(rcb * Math.cos(thetaC - dtheta), ha, rcb * Math.sin(thetaC - dtheta)), Geom.position(rcb * Math.cos(thetaC + dtheta), ha, rcb * Math.sin(thetaC + dtheta)), Geom.position(rca * Math.cos(thetaC + dtheta), -ha, rca * Math.sin(thetaC + dtheta))};
                for (int ib = 0; ib < pbdry.length; ++ib) {
                    pbdry[ib] = trans.getTranslated(rot.getRotatedPosition(pbdry[ib]));
                }
                if (ir == this.bdsa.length - 1) {
                    praw = new Position[]{Geom.position(ra2 * Math.cos(thetaC - dtheta), -ha, ra2 * Math.sin(thetaC - dtheta)), Geom.position(rb2 * Math.cos(thetaC - dtheta), ha, rb2 * Math.sin(thetaC - dtheta)), Geom.position(rb2 * Math.cos(thetaC + dtheta), ha, rb2 * Math.sin(thetaC + dtheta)), Geom.position(ra2 * Math.cos(thetaC + dtheta), -ha, ra2 * Math.sin(thetaC + dtheta))};
                    for (int i = 0; i < praw.length; ++i) {
                        praw[i] = trans.getTranslated(rot.getRotatedPosition(praw[i]));
                    }
                } else {
                    praw = null;
                }
                CurvedVolumeElement ve = new CurvedVolumeElement(null, regionLabel, null, pbdry, praw, praw != null ? surfouter / (double)na : 0.0, center, eltvol, 0.0);
                ve.setPositionIndexes(ir, ia);
                if (na == 2) {
                    if (ia == 1) {
                        ((CurvedVolumeElement)az.get(ia - 1)).coupleTo(ve, carea * 2.0);
                    }
                } else if (na > 2) {
                    if (ia > 0) {
                        ((CurvedVolumeElement)az.get(ia - 1)).coupleTo(ve, carea);
                    }
                    if (na > 2 && ia == na - 1) {
                        ve.coupleTo((VolumeElement)az.get(0), carea);
                    }
                }
                if (ir > 1) {
                    double thc = theta + 0.5 * eltangle;
                    int ib = (int)(thc / eltangleb);
                    azb.get(ib).coupleTo(ve, subarea);
                }
                TrianglesSet ts = this.makeTriangles(axlen, ra1, ra2, rb1, rb2, theta, eltangle);
                ts.rotate(rot);
                ts.translate(trans);
                ve.setTriangles(ts.getStripLengths(), ts.getPositions(), ts.getNormals());
                az.add(ve);
                this.elements.add(ve);
            }
            this.radHM.put(ir, az);
        }
    }

    private TrianglesSet makeTriangles(double axlen, double ra1, double ra2, double rb1, double rb2, double theta, double eltangle) {
        TrianglesSet ret = new TrianglesSet();
        double dth = 0.17453292519943295;
        int npart = (int)Math.round(eltangle / dth);
        if (npart < 1) {
            npart = 1;
        }
        if (eltangle < 5.969026041820607) {
            TriangleStrip tss = this.makeEnd(axlen, ra1, ra2, rb1, rb2, theta, -1);
            ret.add(tss);
            TriangleStrip tst = this.makeEnd(axlen, ra1, ra2, rb1, rb2, theta + eltangle, 1);
            ret.add(tst);
        }
        if (ra1 > 1.0E-7) {
            TriangleStrip tsin = this.makeConeSurfacePart(axlen, ra1, rb1, theta, eltangle, -1, npart);
            ret.add(tsin);
        }
        TriangleStrip tsout = this.makeConeSurfacePart(axlen, ra2, rb2, theta, eltangle, 1, npart);
        ret.add(tsout);
        TriangleStrip tsp = this.makeSliceSurface(-0.5 * axlen, ra1, ra2, theta, eltangle, -1, npart);
        ret.add(tsp);
        TriangleStrip tsq = this.makeSliceSurface(0.5 * axlen, rb1, rb2, theta, eltangle, 1, npart);
        ret.add(tsq);
        return ret;
    }

    private TriangleStrip makeSliceSurface(double dy, double r1, double r2, double theta, double eltangle, int idir, int npart) {
        TriangleStrip ret = new TriangleStrip();
        double xn = 0.0;
        double yn = idir;
        double zn = 0.0;
        for (int i = 0; i <= npart; ++i) {
            double a = theta + (double)i * eltangle / (double)npart;
            double ca = Math.cos(a);
            double sa = Math.sin(a);
            ret.addPoint(r1 * ca, dy, r1 * sa, xn, yn, zn);
            ret.addPoint(r2 * ca, dy, r2 * sa, xn, yn, zn);
        }
        if (idir > 0) {
            ret.flip();
        }
        return ret;
    }

    private TriangleStrip makeConeSurfacePart(double axlen, double ra, double rb, double theta, double eltangle, int idir, int npart) {
        TriangleStrip ret = new TriangleStrip();
        double ay = Math.atan2(rb - ra, axlen);
        double fy = Math.sin(ay);
        double fr = Math.cos(ay);
        double am = -0.5 * axlen;
        double ap = 0.5 * axlen;
        for (int i = 0; i < npart + 1; ++i) {
            double a = theta + (double)i * eltangle / (double)npart;
            double ca = Math.cos(a);
            double sa = Math.sin(a);
            double xn = fr * (double)idir * ca;
            double yn = -fy * (double)idir;
            double zn = fr * (double)idir * sa;
            ret.addPoint(ra * ca, am, ra * sa, xn, yn, zn);
            ret.addPoint(rb * ca, ap, rb * sa, xn, yn, zn);
        }
        if (idir < 0) {
            ret.flip();
        }
        return ret;
    }

    private TriangleStrip makeEnd(double axlen, double ra1, double ra2, double rb1, double rb2, double theta, int idir) {
        TriangleStrip ret = new TriangleStrip();
        double y = -0.5 * axlen;
        double ct = Math.cos(theta);
        double st = Math.sin(theta);
        double xn = (double)idir * st;
        double yn = 0.0;
        double zn = (double)(-idir) * ct;
        ret.addPoint(ra1 * ct, y, ra1 * st, xn, yn, zn);
        ret.addPoint(ra2 * ct, y, ra2 * st, xn, yn, zn);
        y = 0.5 * axlen;
        ret.addPoint(rb1 * ct, y, rb1 * st, xn, yn, zn);
        ret.addPoint(rb2 * ct, y, rb2 * st, zn, yn, zn);
        if (idir < 0) {
            ret.flip();
        }
        return ret;
    }

    private int[] getAzimuthalSplits(double radius, double[] bdm) {
        int[] ret = new int[bdm.length];
        int npre = 1;
        for (int i = 0; i < bdm.length; ++i) {
            double rin = i > 0 ? bdm[i - 1] : 0.0;
            double rout = bdm[i];
            double rc = (rin + rout) / 2.0;
            double dr = rout - rin;
            double circ = Math.PI * 2 * rc;
            int nfac = (int)Math.round(Math.ceil(circ / (dr * this.maxAspectRatio) / (double)npre));
            ret[i] = npre * nfac;
            npre = ret[i];
        }
        return ret;
    }

    private double[] getRadialSplit(double r, double[] sla) {
        return this.getRadialSplit(r, 0, sla);
    }

    private double[] getRadialSplit(double r, int ansplit, double[] sla) {
        int i;
        int nsur;
        double[] ret = null;
        int nsplit = ansplit;
        double rr = r;
        for (nsur = 0; nsur < sla.length && rr > 2.0 * sla[nsur]; rr -= sla[nsur], ++nsur) {
        }
        int nre = 1;
        if (ansplit > 0) {
            nre = ansplit - nsur;
        } else {
            nre = (int)Math.round(rr / this.baseDelta);
            if (nre < 1) {
                nre = 1;
            }
        }
        ret = new double[nre + nsur];
        for (i = 0; i < nre; ++i) {
            ret[i] = ((double)i + 1.0) / (double)nre * rr;
        }
        for (i = 0; i < nsur; ++i) {
            ret[nre + i] = ret[nre + i - 1] + sla[nsur - 1 - i];
        }
        assert (Math.abs(ret[nre + nsur - 1] - r) < 1.0E-6);
        String s = " ";
        for (int i2 = 0; i2 < ret.length; ++i2) {
            s = s + ret[i2] + " ";
        }
        return ret;
    }

    public CurvedVolumeElement getRAElement(int ir, int ia) {
        return this.radHM.get(ir).get(ia);
    }

    public void planeConnect(CurvedVolumeSlice vg) {
        double[] ras = this.getRadii(1);
        int[] zas = this.getNazimuthals();
        double[] rbs = vg.getRadii(0);
        int[] zbs = vg.getNazimuthals();
        double eps = 1.0E-6;
        for (int ira = 0; ira < ras.length; ++ira) {
            double ra = ras[ira];
            double ra0 = ira > 0 ? ras[ira - 1] : 0.0;
            for (int irb = 0; irb < rbs.length; ++irb) {
                double rb0;
                double rb = rbs[irb];
                double d = rb0 = irb > 0 ? rbs[irb - 1] : 0.0;
                if (rb < ra0 + eps || rb0 > ra - eps) continue;
                double ro0 = ra0 > rb0 ? ra0 : rb0;
                double ro1 = ra < rb ? ra : rb;
                double olarea = Math.PI * (ro0 * ro0 + ro1 * ro1 + ro0 * ro1) / 3.0;
                int na = zas[ira];
                int nb = zbs[irb];
                if (na == nb) {
                    double carea = olarea / (double)na;
                    for (int iz = 0; iz < na; ++iz) {
                        this.getRAElement(ira, iz).coupleTo(vg.getRAElement(irb, iz), carea);
                    }
                    continue;
                }
                double da = 1.0 / (double)na;
                double db = 1.0 / (double)nb;
                int izb = 0;
                for (int iza = 0; iza < na; ++iza) {
                    double a0 = (double)iza * da;
                    double a1 = a0 + da;
                    while ((double)izb * db < a1 - eps) {
                        double b0 = (double)izb * db;
                        double b1 = b0 + db;
                        double fc = Math.min(b1, a1) - Math.max(a0, b0);
                        if (fc > eps) {
                            this.getRAElement(ira, iza).coupleTo(vg.getRAElement(irb, izb), fc * olarea);
                        }
                        b0 = b1;
                        b1 += db;
                        ++izb;
                    }
                    --izb;
                }
            }
        }
    }

    public void subPlaneConnect(TreePoint tp, TreePoint tpn, CurvedVolumeSlice vg, double partBranchOffset) {
        this.planeConnect(vg);
    }

    public ArrayList<CurvedVolumeElement> getElements() {
        return this.elements;
    }
}

