/*
 * Decompiled with CFR 0.152.
 */
package neurord.disc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import neurord.disc.DiscretizedSpine;
import neurord.geom.GRotation;
import neurord.geom.Geom;
import neurord.geom.Position;
import neurord.geom.Translation;
import neurord.geom.Vector;
import neurord.numeric.math.MersenneTwister;
import neurord.numeric.morph.CuboidVolumeElement;
import neurord.numeric.morph.CurvedVolumeElement;
import neurord.numeric.morph.SpineDistribution;
import neurord.numeric.morph.SpinePopulation;
import neurord.numeric.morph.SpineProfile;
import neurord.numeric.morph.TriangleStrip;
import neurord.numeric.morph.TrianglesSet;
import neurord.numeric.morph.VolumeElement;
import neurord.numeric.morph.VolumeGrid;
import neurord.util.ArrayUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SpineLocator {
    static final Logger log = LogManager.getLogger();

    public static void locate(int spineSeed, SpineDistribution dist, double delta, VolumeGrid grid) {
        HashMap<SpineProfile, DiscretizedSpine> spines = new HashMap<SpineProfile, DiscretizedSpine>();
        HashSet volumes = new HashSet();
        MersenneTwister rngen = new MersenneTwister(spineSeed);
        int nblocked = 0;
        int ipop = 0;
        for (SpinePopulation sp : dist.getPopulations()) {
            ++ipop;
            String popid = sp.getID();
            if (popid == null) {
                popid = "";
            }
            double density = sp.getDensity();
            String reg = sp.getTargetRegion();
            log.info("Allocating spines in popid=\"{}\" region=\"{}\"", popid, reg);
            ArrayList<VolumeElement> surfVE = new ArrayList<VolumeElement>();
            ArrayList<Double> surfA = new ArrayList<Double>();
            for (VolumeElement ve : grid.getElementsInRegion(reg)) {
                Position[] sbdry = ve.getSurfaceBoundary();
                if (sbdry == null) continue;
                surfVE.add(ve);
                surfA.add(ve.getExposedArea());
            }
            if (surfA.isEmpty()) {
                log.warn("No surface elements labelled \"{}\" found");
                throw new RuntimeException("SpineAllocation references surface-less region");
            }
            double[] eltSA = new double[surfA.size()];
            double sum = 0.0;
            for (int i = 0; i < eltSA.length; ++i) {
                eltSA[i] = sum += ((Double)surfA.get(i)).doubleValue();
            }
            double totalArea = eltSA[eltSA.length - 1];
            double avgNoSpines = totalArea * density;
            double nspines = avgNoSpines;
            if (nspines > (double)eltSA.length) {
                log.warn("too many spines (need more than one per segment)");
                nspines = eltSA.length;
            }
            log.info("Surface area for spine group \"{}\" on \"{}\" is {} (nspines={})", popid, reg, sum, nspines);
            int ndone = 0;
            if (avgNoSpines > 0.0 && nspines == 0.0) {
                log.info("spines : although the density is non-zero, random allocation gives no spines for region \"{}\" (avg={})", reg, avgNoSpines);
            }
            ArrayList<Integer> positionA = new ArrayList<Integer>();
            while ((double)ndone < nspines) {
                double abelow = (double)rngen.random() * totalArea;
                int posInArray = ArrayUtil.findBracket(eltSA, abelow);
                if (posInArray < 0) {
                    log.info("Total area: {}", totalArea);
                    log.error("Cannot get pos {}. {}", abelow, eltSA);
                    throw new RuntimeException("Cannot get pos " + abelow);
                }
                if (volumes.contains(surfVE.get(posInArray))) {
                    ++nblocked;
                } else {
                    positionA.add(posInArray);
                    ++ndone;
                }
                if (nblocked <= 100) continue;
                throw new RuntimeException("Can't fine any vacant elements to add a spine to");
            }
            Collections.sort(positionA);
            ndone = 0;
            Iterator iterator = positionA.iterator();
            while (iterator.hasNext()) {
                int posInArray = (Integer)iterator.next();
                ArrayList<VolumeElement> elts = SpineLocator.addSpineTo(spines, delta, (VolumeElement)surfVE.get(posInArray), sp.getProfile(), popid, ndone);
                grid.addElements(elts);
                ++ndone;
            }
        }
    }

    private static ArrayList<VolumeElement> addSpineTo(HashMap<SpineProfile, DiscretizedSpine> spines, double delta, VolumeElement vedend, SpineProfile prof, String popid, int idx) {
        Vector vx;
        Position[] perim = vedend.getSurfaceBoundary();
        Vector vnorm = Geom.getUnitNormal(perim);
        Position pcen = Geom.cog(perim);
        DiscretizedSpine xw = SpineLocator.getBoundaryWidths(spines, prof, delta);
        double[] xp = xw.getBoundaries();
        double[] wb = xw.getWidths();
        String[] lbls = xw.getLabels();
        String[] rgns = xw.getRegions();
        double[] rb = new double[wb.length];
        for (int i = 0; i < wb.length; ++i) {
            rb[i] = 0.5 * wb[i];
        }
        ArrayList<VolumeElement> ret = new ArrayList<VolumeElement>();
        Translation trans = Geom.translation(pcen);
        double aroty = -Geom.zElevation(vnorm);
        double arotz = Geom.xzRotationAngle(vnorm);
        GRotation rotx = Geom.aboutYRotation(aroty);
        GRotation rotz = Geom.aboutZRotation(arotz);
        GRotation rot = rotz.times(rotx);
        Position prot = rot.getRotatedPosition(Geom.endPosition(vx = Geom.unitX()));
        double da = Geom.angleBetween(vnorm, Geom.getToVector(prot));
        if (Math.abs(da) > 1.0E-6) {
            throw new RuntimeException("rotation angle miscalculation: residual angle is " + da);
        }
        VolumeElement vprev = vedend;
        for (int i = 0; i < xp.length - 1; ++i) {
            double dx = xp[i + 1] - xp[i];
            double vol = Math.PI * dx * (rb[i] * rb[i] + rb[i + 1] * rb[i + 1] + rb[i] * rb[i + 1]) / 3.0;
            double baseArea = Math.PI * (rb[i] * rb[i]);
            VolumeElement ve = null;
            Position[] pbdry = new Position[]{Geom.position(xp[i + 1], rb[i + 1], 0.0), Geom.position(xp[i], rb[i], 0.0), Geom.position(xp[i], -rb[i], 0.0), Geom.position(xp[i + 1], -rb[i + 1], 0.0)};
            String lroot = popid + "[" + idx + "]";
            String label = lbls[i] != null ? lroot + "." + lbls[i] : null;
            String groupID = lroot;
            double deltaZ = 0.5 * (rb[i] + rb[i + 1]);
            for (int j = 0; j < pbdry.length; ++j) {
                pbdry[j] = trans.getTranslated(rot.getRotatedPosition(pbdry[j]));
            }
            Position cp = Geom.position(0.5 * (xp[i] + xp[i + 1]), 0.0, 0.0);
            Position pr = rot.getRotatedPosition(cp);
            Position center = trans.getTranslated(pr);
            if (vedend instanceof CuboidVolumeElement) {
                ve = new CuboidVolumeElement(label, rgns[i], groupID, pbdry, null, 0.0, center, 0.0, 0.0, 0.0, vol, deltaZ);
            } else if (vedend instanceof CurvedVolumeElement) {
                CurvedVolumeElement cve = new CurvedVolumeElement(label, rgns[i], groupID, pbdry, null, 0.0, center, vol, deltaZ);
                ve = cve;
                TrianglesSet ts = SpineLocator.makeTriangles(xp[i], xp[i + 1], rb[i], rb[i + 1]);
                ts.rotate(rot);
                ts.translate(trans);
                cve.setTriangles(ts.getStripLengths(), ts.getPositions(), ts.getNormals());
            } else {
                throw new RuntimeException("unknown element type " + vedend);
            }
            vprev.coupleTo(ve, baseArea);
            ret.add(ve);
            vprev = ve;
        }
        return ret;
    }

    private static DiscretizedSpine getBoundaryWidths(HashMap<SpineProfile, DiscretizedSpine> spines, SpineProfile sp, double dx) {
        int i;
        DiscretizedSpine ret = spines.get(sp);
        if (ret != null) {
            return ret;
        }
        double[] ax = sp.getXPts();
        double[] aw = sp.getWidths();
        String[] pl = sp.getLabels();
        String[] prl = sp.getRegions();
        double ltot = ax[ax.length - 1];
        int nel = (int)(ltot / dx + 0.5);
        if (nel < 1) {
            nel = 1;
        }
        double[] xbd = ArrayUtil.span(0.0, ltot, nel);
        double[] wv = ArrayUtil.interpInAtFor(aw, ax, xbd);
        String[] lbls = new String[nel];
        String[] rgns = new String[nel];
        int ipr = 0;
        for (i = 0; i < nel; ++i) {
            while (ipr < ax.length - 2 && ax[ipr + 1] < xbd[i]) {
                ++ipr;
            }
            double db = xbd[i] - ax[ipr];
            double df = ax[ipr + 1] - xbd[i];
            rgns[i] = db < df ? prl[ipr] : prl[ipr + 1];
        }
        for (i = 0; i < ax.length; ++i) {
            if (pl[i] == null) continue;
            double dmin = 1000000.0;
            int imin = 0;
            for (int j = 0; j < nel; ++j) {
                double d = Math.abs(xbd[j] - ax[i]);
                if (!(d < dmin)) continue;
                dmin = d;
                imin = j;
            }
            lbls[imin] = pl[i];
        }
        return new DiscretizedSpine(xbd, wv, lbls, rgns);
    }

    private static TrianglesSet makeTriangles(double xa, double xb, double ra, double rb) {
        TrianglesSet ret = new TrianglesSet();
        int nseg = 12;
        ret.add(SpineLocator.makeEnd(xa, ra, nseg, -1));
        ret.add(SpineLocator.makeEnd(xb, rb, nseg, 1));
        ret.add(SpineLocator.makeOuter(xa, xb, ra, rb, nseg, -1));
        return ret;
    }

    private static TriangleStrip makeEnd(double xa, double ra, int nseg, int idir) {
        TriangleStrip ret = new TriangleStrip();
        double eps = 1.0E-6;
        for (int i = 0; i < nseg + 1; ++i) {
            double theta = Math.PI * 2 * (double)i / (double)nseg;
            double ct = Math.cos(theta);
            double st = Math.sin(theta);
            ret.addPoint(xa, eps * ct, eps * st, idir, 0.0, 0.0);
            ret.addPoint(xa, ra * ct, ra * st, idir, 0.0, 0.0);
        }
        if (idir < 0) {
            ret.flip();
        }
        return ret;
    }

    private static TriangleStrip makeOuter(double xa, double xb, double ra, double rb, int nseg, int idir) {
        TriangleStrip ret = new TriangleStrip();
        double ayz = Math.atan2(rb - ra, xb - xa);
        double fyz = Math.sin(ayz);
        double fx = Math.cos(ayz);
        for (int i = 0; i < nseg + 1; ++i) {
            double a = Math.PI * 2 * (double)i / (double)nseg;
            double ca = Math.cos(a);
            double sa = Math.sin(a);
            double xn = fyz * (double)idir;
            double yn = -fx * (double)idir * ca;
            double zn = -fx * (double)idir * sa;
            ret.addPoint(xa, ra * ca, ra * sa, xn, yn, zn);
            ret.addPoint(xb, rb * ca, rb * sa, xn, yn, zn);
        }
        if (idir < 0) {
            ret.flip();
        }
        return ret;
    }
}

