/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import neurord.inter.FloatValued;
import neurord.model.Concentration;
import neurord.model.NanoMolarity;
import neurord.model.NumberDensity;
import neurord.model.Regional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConcentrationSet
implements Regional {
    static final Logger log = LogManager.getLogger();
    @XmlAttribute
    public String region;
    @XmlElements(value={@XmlElement(name="NanoMolarity", type=NanoMolarity.class), @XmlElement(name="NumberDensity", type=NumberDensity.class)})
    public ArrayList<Concentration> concentrations;
    transient HashMap<String, Concentration> concHM;

    private synchronized HashMap<String, Concentration> getConcHM() {
        if (this.concHM == null) {
            this.concHM = new HashMap();
            if (this.concentrations != null) {
                for (Concentration c : this.concentrations) {
                    this.concHM.put(c.specieID, c);
                }
            }
        }
        return this.concHM;
    }

    public Double getNanoMolarConcentration(String id) {
        Concentration conc = this.getConcHM().get(id);
        if (conc == null) {
            return null;
        }
        return conc.getNanoMolarConcentration();
    }

    @Override
    public boolean hasRegion() {
        return this.region != null;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    public void addFloatValued(ArrayList<FloatValued> afv) {
        afv.addAll(this.concentrations);
    }

    public void verify(String[] regions, String[] species) {
        if (this.hasRegion() && !Arrays.asList(regions).contains(this.region)) {
            log.error("ConcentrationSet has region \"{}\", not in {}", this.region, regions);
            throw new RuntimeException("ConcentrationSet with bad region: " + this.region);
        }
        for (Concentration conc : this.concentrations) {
            conc.verify(regions, species);
        }
    }
}

