/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.HashMap;
import javax.xml.bind.annotation.XmlAttribute;
import neurord.model.MorphPoint;
import neurord.model.Segment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EndPoint
extends MorphPoint {
    static final Logger log = LogManager.getLogger();
    @XmlAttribute
    public String on;
    @XmlAttribute
    public String at;
    @XmlAttribute
    public Double atFraction;

    private EndPoint() {
    }

    public EndPoint(String id, double x, double y, double z, double r) {
        super(id, x, y, z, r);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void resolve(HashMap<String, Segment> segmentHM, MorphPoint ep) {
        if (this.on == null) return;
        Segment tgtSeg = segmentHM.get(this.on);
        if (tgtSeg == null) {
            log.error("point refers to segment '{}' but that segment cannot be found", this.on);
            throw new RuntimeException("point refers to segment " + this.on + " but that segment cannot be found");
        }
        if (this.at != null) {
            if (this.at.equals("start")) {
                this.pointConnect(tgtSeg.getStart());
                return;
            }
            if (this.at.equals("end")) {
                this.pointConnect(tgtSeg.getEnd());
                return;
            }
            log.error("connection to segment: at value can only be 'start' or 'end', not '{}'", this.at);
            throw new RuntimeException("connection to segment: at value can only be 'start' or 'end', not " + this.at);
        }
        if (this.atFraction == null) {
            log.error("must either set 'at' or 'atFraction' if 'on' is specified");
            throw new RuntimeException("must either set 'at' or 'atFraction' if 'on' is specified");
        }
        if (this.atFraction == 0.0) {
            this.pointConnect(tgtSeg.getStart());
            return;
        }
        if (this.atFraction == 1.0) {
            this.pointConnect(tgtSeg.getEnd());
            return;
        }
        tgtSeg.checkResolved(segmentHM);
        tgtSeg.checkHasPositions();
        this.interiorPointConnect(tgtSeg, this.atFraction, ep);
    }

    private void supplySize(double x, double y, double z, double r) {
        assert (r > 0.0);
        if (this.x == null) {
            this.x = x;
        }
        if (this.y == null) {
            this.y = y;
        }
        if (this.z == null) {
            this.z = z;
        }
        if (this.r == null) {
            this.r = r;
        }
    }

    public boolean radiiDiffer(MorphPoint mp) {
        return Math.abs((this.r - mp.r) / (this.r + mp.r)) > 1.0E-4;
    }

    private void pointConnect(MorphPoint target) {
        log.debug("pointConnect: {} to {}", this, target);
        this.supplySize(target.x, target.y, target.z, target.r);
        if (this.radiiDiffer(target)) {
            target.addNeighbor(this);
            this.addNeighbor(target);
        } else {
            this.r_peerPoint = target;
        }
    }

    public void interiorPointConnect(Segment tgtSeg, double f, MorphPoint twds) {
        EndPoint st = tgtSeg.getStart();
        EndPoint ed = tgtSeg.getEnd();
        double wf = 1.0 - f;
        double cx = wf * st.x + f * ed.x;
        double cy = wf * st.y + f * ed.y;
        double cz = wf * st.z + f * ed.z;
        double cr = wf * st.r + f * ed.r;
        double dx = twds.x - cx;
        double dy = twds.y - cy;
        double dz = twds.z - cz;
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.supplySize(cx + cr * dx / d, cy + cr * dy / d, cz * cr * dz / d, cr);
        st.addOffsetChild(this);
    }

    @Override
    public String toString() {
        String on = this.on != null ? " on=" + this.on : "";
        String at = this.at != null ? " at=" + this.at : "";
        String atFraction = this.atFraction != null ? " atFraction=" + this.atFraction : "";
        return super.toString() + on + at + atFraction;
    }
}

