/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import neurord.inter.FloatValued;
import neurord.model.ConcentrationSet;
import neurord.model.FitConstraints;
import neurord.model.Regional;
import neurord.model.SurfaceDensitySet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitialConditions {
    static final Logger log = LogManager.getLogger();
    @XmlElement(name="ConcentrationSet")
    public ArrayList<ConcentrationSet> concentrationSets;
    private transient HashMap<String, ConcentrationSet> concSetHM;
    @XmlElement(name="SurfaceDensitySet")
    public ArrayList<SurfaceDensitySet> sdSets;
    private transient HashMap<String, SurfaceDensitySet> sdSetHM;
    public FitConstraints fitConstraints;
    private transient ConcentrationSet defaultConcs;

    public synchronized HashMap<String, ConcentrationSet> getConcentrationSets() {
        if (this.concSetHM == null) {
            this.concSetHM = InitialConditions.listToRegionMap(this.concentrationSets);
        }
        return this.concSetHM;
    }

    private synchronized ConcentrationSet getDefaultConcentrations() {
        if (this.defaultConcs == null) {
            if (this.concentrationSets != null) {
                for (ConcentrationSet set : this.concentrationSets) {
                    if (set.hasRegion()) continue;
                    this.defaultConcs = set;
                    break;
                }
            }
            if (this.defaultConcs == null) {
                this.defaultConcs = new ConcentrationSet();
            }
        }
        return this.defaultConcs;
    }

    public void verify(String[] regions, String[] species) {
        this.getConcentrationSets();
        this.getSurfaceDensitySets();
        if (this.concentrationSets != null) {
            for (ConcentrationSet concentrationSet : this.concentrationSets) {
                concentrationSet.verify(regions, species);
            }
        }
        if (this.sdSets != null) {
            for (SurfaceDensitySet surfaceDensitySet : this.sdSets) {
                surfaceDensitySet.verify(regions, species);
            }
        }
    }

    public double[][] makeRegionConcentrations(String[] regions, String[] species) {
        double[][] ret = new double[regions.length][];
        for (int i = 0; i < regions.length; ++i) {
            ret[i] = this.getRegionConcentration(regions[i], species);
        }
        return ret;
    }

    public double[] getRegionConcentration(String region, String[] species) {
        double[] ans = new double[species.length];
        ConcentrationSet set = this.getConcentrationSets().get(region);
        ConcentrationSet def = this.getDefaultConcentrations();
        for (int i = 0; i < species.length; ++i) {
            Double c = null;
            if (set != null) {
                c = set.getNanoMolarConcentration(species[i]);
            }
            if (c == null) {
                c = def.getNanoMolarConcentration(species[i]);
            }
            if (c == null) continue;
            ans[i] = c;
        }
        return ans;
    }

    private SurfaceDensitySet getDefaultSurfaceDensities() {
        if (this.sdSets != null) {
            for (SurfaceDensitySet set : this.sdSets) {
                if (set.hasRegion()) continue;
                return set;
            }
        }
        return null;
    }

    public double[][] makeRegionSurfaceDensities(String[] regions, String[] species) {
        double[][] ret = new double[regions.length][];
        for (int i = 0; i < regions.length; ++i) {
            ret[i] = this.getRegionSurfaceDensity(regions[i], species);
        }
        return ret;
    }

    public double[] getRegionSurfaceDensity(String region, String[] species) {
        double[] ret = new double[species.length];
        SurfaceDensitySet set = this.getSurfaceDensitySets().get(region);
        if (set == null) {
            set = this.getDefaultSurfaceDensities();
        }
        for (int j = 0; j < species.length; ++j) {
            Double val = null;
            if (set != null) {
                val = set.getSurfaceDensity(species[j]);
            }
            ret[j] = val != null ? val : Double.NaN;
        }
        return ret;
    }

    private synchronized HashMap<String, SurfaceDensitySet> getSurfaceDensitySets() {
        if (this.sdSetHM == null) {
            this.sdSetHM = InitialConditions.listToRegionMap(this.sdSets);
        }
        return this.sdSetHM;
    }

    public ArrayList<FloatValued> getFloatValuedElements() {
        ArrayList<FloatValued> afv = new ArrayList<FloatValued>();
        if (this.concentrationSets != null) {
            for (ConcentrationSet cs : this.concentrationSets) {
                cs.addFloatValued(afv);
            }
        }
        if (this.sdSets != null) {
            for (SurfaceDensitySet sdSet : this.sdSets) {
                sdSet.addFloatValued(afv);
            }
        }
        return afv;
    }

    public String[] getTotalPreserved() {
        if (this.fitConstraints != null) {
            return this.fitConstraints.getTotalPreserved();
        }
        return new String[0];
    }

    private static <T extends Regional> HashMap<String, T> listToRegionMap(List<T> list) {
        HashMap<String, Regional> hm = new HashMap<String, Regional>();
        if (list != null) {
            for (Regional item : list) {
                Regional old;
                if (!item.hasRegion() || (old = hm.put(item.getRegion(), item)) == null) continue;
                log.error("Duplicate {} for region '{}'", item.getClass().getSimpleName(), item.getRegion());
                throw new RuntimeException("Duplicate " + item.getClass());
            }
        }
        return hm;
    }
}

