/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import neurord.numeric.BaseCalc;
import neurord.util.Settings;
import neurord.xml.DoubleMatrixAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jblas.DoubleMatrix;

public class InjectionStim {
    public static final Logger log = LogManager.getLogger();
    @XmlAttribute
    public String specieID;
    @XmlAttribute
    private String injectionSite;
    @XmlAttribute
    private BaseCalc.distribution_t distribution;
    private Double rate;
    private Double onset;
    private Double duration;
    private Double period;
    private Double end;
    private Double interTrainInterval;
    private Integer numTrains;
    @XmlJavaTypeAdapter(value=DoubleMatrixAdapter.class)
    private DoubleMatrix rates;
    static final boolean injections = Settings.getProperty("neurord.injections", "Allow injections to happen", true);

    private InjectionStim() {
    }

    public InjectionStim(String species, String site, Double rate, Double onset, Double duration, Double period, Double end) {
        this.specieID = species;
        this.injectionSite = site;
        this.rate = rate;
        this.onset = onset;
        this.duration = duration;
        this.period = period;
        this.end = end;
    }

    public String getInjectionSite() {
        assert (this.injectionSite != null);
        return this.injectionSite;
    }

    public String getSpecies() {
        assert (this.specieID != null);
        return this.specieID;
    }

    public BaseCalc.distribution_t getDistribution() {
        if (this.distribution != null) {
            return this.distribution;
        }
        return BaseCalc.distribution_t.POISSON;
    }

    public double getRate() {
        if (!injections) {
            return 0.0;
        }
        return this.rate != null ? this.rate : Double.NaN;
    }

    public double getOnset() {
        return this.onset != null ? this.onset : Double.NaN;
    }

    public double getDuration() {
        return this.duration != null ? this.duration : Double.NaN;
    }

    public double getPeriod() {
        return this.period != null ? this.period : Double.NaN;
    }

    public double getEnd() {
        return this.end != null ? this.end : Double.POSITIVE_INFINITY;
    }

    public int getNumTrains() {
        return this.numTrains != null ? this.numTrains : 1;
    }

    public double getInterTrainInterval() {
        return this.interTrainInterval != null ? this.interTrainInterval : 0.0;
    }

    public double[][] getRates() {
        if (!injections) {
            return null;
        }
        if (this.rates != null) {
            assert (this.rate == null);
            assert (this.onset == null);
            assert (this.duration == null);
            assert (this.period == null);
            assert (this.end == null);
            return this.rates.toArray2();
        }
        return null;
    }
}

