/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlElement;
import neurord.model.Reaction;
import neurord.model.Specie;
import neurord.numeric.chem.ReactionTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReactionScheme {
    static final Logger log = LogManager.getLogger();
    @XmlElement(name="Specie")
    private final ArrayList<Specie> species = new ArrayList();
    @XmlElement(name="Reaction")
    private final ArrayList<Reaction> reactions = new ArrayList();
    private transient String[] species_array;

    static <T, V> void hmPut(HashMap<T, V> hm, T key, V value) {
        V old = hm.put(key, value);
        if (old != null) {
            throw new RuntimeException("overwriting key " + key + " with new value");
        }
    }

    private void resolve() {
        HashMap<String, Specie> hm = new HashMap<String, Specie>();
        int index = 0;
        this.species_array = new String[this.species.size()];
        for (Specie sp : this.species) {
            sp.setIndex(index++);
            ReactionScheme.hmPut(hm, sp.getID(), sp);
            if (!sp.getName().equals(sp.getID())) {
                ReactionScheme.hmPut(hm, sp.getName(), sp);
            }
            this.species_array[sp.getIndex()] = sp.getID();
        }
        for (Reaction r : this.reactions) {
            r.resolve(hm);
        }
    }

    public synchronized String[] getSpecies() {
        if (this.species_array == null) {
            this.resolve();
        }
        return this.species_array;
    }

    private double[] getDiffusionConstants() {
        double[] ret = new double[this.species.size()];
        for (Specie sp : this.species) {
            ret[sp.getIndex()] = sp.getDiffusionConstant();
        }
        return ret;
    }

    public synchronized ReactionTable makeReactionTable() {
        if (this.species_array == null) {
            this.resolve();
        }
        int n = 0;
        for (Reaction r : this.reactions) {
            if (r.getForwardRate() > 0.0) {
                ++n;
            }
            if (!(r.getReverseRate() > 0.0)) continue;
            ++n;
        }
        log.info("Running with {} reactions (forward and reverse)", n);
        ReactionTable rtab = new ReactionTable(n, this.getSpecies(), this.getDiffusionConstants());
        int i = 0;
        for (Reaction r : this.reactions) {
            boolean have_forward;
            int[][] reactants = r.getReactantIndices();
            int[][] products = r.getProductIndices();
            boolean bl = have_forward = r.getForwardRate() > 0.0;
            if (have_forward) {
                rtab.setReactionData(i++, reactants, products, r.getForwardRate(), false);
            }
            if (!(r.getReverseRate() > 0.0)) continue;
            rtab.setReactionData(i++, products, reactants, r.getReverseRate(), have_forward);
        }
        assert (i == n) : "ir=" + i + " n=" + n;
        return rtab;
    }
}

