/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric;

import java.util.Arrays;
import neurord.model.OutputSet;
import neurord.model.SDRun;
import neurord.numeric.BaseCalc;
import neurord.numeric.chem.ReactionTable;
import neurord.numeric.morph.VolumeGrid;

public class StaticCalc
extends BaseCalc {
    ReactionTable rtab;
    VolumeGrid vgrid;
    int nel;
    int nspec;
    String[] species;
    double[] volumes;
    boolean[] submembranes;
    String[] regionLabels;
    int[] eltregions;
    double[] surfaceAreas;
    double[][] wkA;

    public StaticCalc(int trial, SDRun sdr) {
        super(trial, sdr);
    }

    @Override
    public long getParticleCount() {
        return 0L;
    }

    @Override
    protected void _run() {
    }

    public void init() {
        this.rtab = this.sdRun.getReactionTable();
        this.vgrid = this.sdRun.getVolumeGrid();
        this.nel = this.vgrid.size();
        this.nspec = this.rtab.getNSpecies();
        this.species = this.rtab.getSpecies();
        this.volumes = this.vgrid.getElementVolumes();
        this.submembranes = this.vgrid.getSubmembranes();
        this.regionLabels = this.vgrid.getRegionLabels();
        this.surfaceAreas = this.vgrid.getExposedAreas();
        this.wkA = new double[this.nel][this.nspec];
    }

    public void reinit() {
        VolumeGrid grid = this.sdRun.getVolumeGrid();
        for (int i = 0; i < this.nel; ++i) {
            double[] rcs = this.sdRun.getRegionConcentration(grid.getElementRegion(i));
            for (int j = 0; j < this.nspec; ++j) {
                this.wkA[i][j] = rcs[j];
            }
            double a = this.surfaceAreas[i];
            if (!(a > 0.0)) continue;
            double[] scs = this.sdRun.getRegionSurfaceDensity(grid.getElementRegion(i));
            double concfac = a / this.volumes[i];
            for (int j = 0; j < this.nspec; ++j) {
                if (Double.isNaN(scs[j])) continue;
                this.wkA[i][j] = concfac * scs[j];
            }
        }
    }

    public int getNel() {
        return this.nel;
    }

    public int getNSpec() {
        return this.nspec;
    }

    public double[][] getElementConcentrations() {
        this.reinit();
        double[][] ret = new double[this.nel][this.nspec];
        for (int i = 0; i < this.nel; ++i) {
            for (int j = 0; j < this.nspec; ++j) {
                ret[i][j] = this.wkA[i][j];
            }
        }
        return ret;
    }

    public double[] getConcentrations() {
        this.reinit();
        double[] ret = new double[this.nel * this.nspec];
        for (int i = 0; i < this.nel; ++i) {
            for (int j = 0; j < this.nspec; ++j) {
                ret[this.nspec * i + j] = this.wkA[i][j];
            }
        }
        return ret;
    }

    public double[] getVolumes() {
        return this.volumes;
    }

    public int[] getSpecieIndexes(String[] sid) {
        return OutputSet.outputSpecieIndices(this.getClass().getName(), Arrays.asList(sid), this.sdRun.getSpecies());
    }
}

