/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.chem;

import java.util.Arrays;
import neurord.numeric.math.Column;
import neurord.numeric.math.Matrix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReactionTable {
    static final Logger log = LogManager.getLogger();
    public final int nreaction;
    private final String[] species;
    private final double[] diffusionConstants;
    private final int[][] reactantIndices;
    private final int[][] productIndices;
    private final int[][] reactantStoichiometry;
    private final int[][] productStoichiometry;
    private final int[][] reactantPowers;
    private final int[] reversiblePairs;
    private final double[] rates;
    private Matrix productionMatrix;

    public ReactionTable(int nreaction, String[] species, double[] diffusionConstants) {
        this.nreaction = nreaction;
        this.species = species;
        this.diffusionConstants = diffusionConstants;
        this.reactantIndices = new int[nreaction][];
        this.productIndices = new int[nreaction][];
        this.reactantStoichiometry = new int[nreaction][];
        this.productStoichiometry = new int[nreaction][];
        this.reactantPowers = new int[nreaction][];
        this.reversiblePairs = new int[nreaction];
        this.rates = new double[nreaction];
    }

    public void print() {
        StringBuffer sb = new StringBuffer();
        sb.append("nspecie = " + this.species.length + "  nreaction = " + this.nreaction + "\n");
        for (int r = 0; r < this.nreaction; ++r) {
            int i;
            sb.append("reaction " + r + ":      ");
            for (i = 0; i < this.reactantIndices[r].length; ++i) {
                sb.append(String.format("%s%d (%d/%d)", i == 0 ? "" : ", ", this.reactantIndices[r][i], this.reactantStoichiometry[r][i], this.reactantPowers[r][i]));
            }
            sb.append(" --> ");
            for (i = 0; i < this.productIndices[r].length; ++i) {
                sb.append(String.format("%s%d (%d)", i == 0 ? "" : ", ", this.productIndices[r][i], this.productStoichiometry[r][i]));
            }
            sb.append("   rate " + this.rates[r] + " \n");
        }
        log.info(sb);
    }

    static Integer findDuplicates(int[] indices) {
        int[] c = Arrays.copyOf(indices, indices.length);
        Arrays.sort(c);
        for (int i = 0; i < indices.length - 1; ++i) {
            if (c[i] != c[i + 1]) continue;
            return c[i];
        }
        return null;
    }

    public void setReactionData(int ireact, int[][] aidx, int[][] bidx, double rate, boolean is_reverse) {
        log.debug("ireact={}/{} {}\u2192{} rate={}", new Object[]{ireact, this.nreaction, aidx, bidx, rate});
        assert (this.species != null);
        Integer dupl = ReactionTable.findDuplicates(aidx[0]);
        if (dupl != null) {
            log.error("Duplicate reactant {} in reaction {}: {}", this.species[dupl], ireact, ReactionTable.getReactionSignature(aidx[0], aidx[1], bidx[0], bidx[1], this.species));
            throw new RuntimeException("Duplicate reactant in reaction " + ireact);
        }
        dupl = ReactionTable.findDuplicates(bidx[0]);
        if (dupl != null) {
            log.error("Duplicate product {} in reaction {}: {}", this.species[dupl], ireact, ReactionTable.getReactionSignature(aidx[0], aidx[1], bidx[0], bidx[1], this.species));
            throw new RuntimeException("Duplicate product in reaction " + ireact);
        }
        this.reactantIndices[ireact] = aidx[0];
        this.reactantStoichiometry[ireact] = aidx[1];
        this.reactantPowers[ireact] = aidx[2];
        this.productIndices[ireact] = bidx[0];
        this.productStoichiometry[ireact] = bidx[1];
        this.rates[ireact] = rate;
        this.reversiblePairs[ireact] = is_reverse ? ireact - 1 : -1;
    }

    public String[] getSpecies() {
        assert (this.species != null);
        return this.species;
    }

    public static String getReactionSignature(int[] rr, int[] rs, int[] pp, int[] ps, String[] ids) {
        int i;
        StringBuffer b = new StringBuffer();
        if (rr.length > 0) {
            for (i = 0; i < rr.length; ++i) {
                if (i > 0) {
                    b.append("+");
                }
                if (rs[i] > 1) {
                    b.append("" + rs[i] + "\u00d7");
                }
                b.append(ids[rr[i]]);
            }
        } else {
            b.append("nil");
        }
        b.append("\u2192");
        if (pp.length > 0) {
            for (i = 0; i < pp.length; ++i) {
                if (i > 0) {
                    b.append("+");
                }
                if (ps[i] > 1) {
                    b.append("" + ps[i] + "\u00d7");
                }
                b.append(ids[pp[i]]);
            }
        } else {
            b.append("nil");
        }
        return b.toString();
    }

    public int getNSpecies() {
        return this.species.length;
    }

    public double[] getDiffusionConstants() {
        return this.diffusionConstants;
    }

    public Column getRateColumn(Column mconc) {
        double[] c = mconc.getData();
        double[] vr = new double[this.nreaction];
        for (int ireac = 0; ireac < this.nreaction; ++ireac) {
            double r = this.rates[ireac];
            for (int index : this.reactantIndices[ireac]) {
                r *= c[index];
            }
            vr[ireac] = r;
        }
        return new Column(vr);
    }

    public Matrix getProductionMatrix() {
        if (this.productionMatrix == null) {
            double[][] a = new double[this.species.length][this.nreaction];
            for (int ireac = 0; ireac < this.nreaction; ++ireac) {
                for (int index : this.reactantIndices[ireac]) {
                    double[] dArray = a[index];
                    int n = ireac;
                    dArray[n] = dArray[n] - 1.0;
                }
                for (int index : this.productIndices[ireac]) {
                    double[] dArray = a[index];
                    int n = ireac;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
            this.productionMatrix = new Matrix(a);
        }
        return this.productionMatrix;
    }

    public Column getProductionColumn(Column mconc) {
        double[] c = mconc.getData();
        double[] vr = new double[this.species.length];
        for (int ireac = 0; ireac < this.nreaction; ++ireac) {
            int n;
            int index2;
            int[] si = this.reactantIndices[ireac];
            int[] pi = this.productIndices[ireac];
            double r = this.rates[ireac];
            for (int index2 : this.reactantIndices[ireac]) {
                r *= c[index2];
            }
            int[] nArray = this.reactantIndices[ireac];
            int n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                int n3 = index2 = nArray[n];
                vr[n3] = vr[n3] - r;
            }
            nArray = this.productIndices[ireac];
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                int n4 = index2 = nArray[n];
                vr[n4] = vr[n4] + r;
            }
        }
        return new Column(vr);
    }

    public Matrix getIncrementRateMatrix(Column mconc) {
        double[] c = mconc.getData();
        double[][] d = new double[this.species.length][this.species.length];
        for (int ireac = 0; ireac < this.nreaction; ++ireac) {
            for (int index : this.reactantIndices[ireac]) {
                double r = this.rates[ireac];
                for (int index2 : this.reactantIndices[ireac]) {
                    if (index2 == index) continue;
                    r *= c[index2];
                }
                for (int index2 : this.reactantIndices[ireac]) {
                    double[] dArray = d[index2];
                    int n = index;
                    dArray[n] = dArray[n] - r;
                }
                for (int index2 : this.productIndices[ireac]) {
                    double[] dArray = d[index2];
                    int n = index;
                    dArray[n] = dArray[n] + r;
                }
            }
        }
        return new Matrix(d);
    }

    public final Column stepResiduals(Column vc, Column vdc, double dt) {
        Column vctot = vc.plus(vdc);
        double[] ctot = vctot.getData();
        Column vret = vdc.copy();
        double[] ret = vdc.getData();
        for (int ireac = 0; ireac < this.nreaction; ++ireac) {
            int n;
            int index2;
            double r = this.rates[ireac];
            for (int index2 : this.reactantIndices[ireac]) {
                r *= ctot[index2];
            }
            int[] nArray = this.reactantIndices[ireac];
            int n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                int n3 = index2 = nArray[n];
                ret[n3] = ret[n3] + r;
            }
            nArray = this.productIndices[ireac];
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                int n4 = index2 = nArray[n];
                ret[n4] = ret[n4] - r;
            }
        }
        return vret;
    }

    public int getNReaction() {
        return this.nreaction;
    }

    public double[] getRates() {
        return this.rates;
    }

    public int[][] getReactantIndices() {
        return this.reactantIndices;
    }

    public int[][] getProductIndices() {
        return this.productIndices;
    }

    public int[][] getReactantStoichiometry() {
        return this.reactantStoichiometry;
    }

    public int[][] getProductStoichiometry() {
        return this.productStoichiometry;
    }

    public int[][] getReactantPowers() {
        return this.reactantPowers;
    }

    public int[] getReversiblePairs() {
        return this.reversiblePairs;
    }

    public int getSpecieIndex(String specieID) {
        String[] species = this.getSpecies();
        for (int i = 0; i < this.species.length; ++i) {
            if (!species[i].equals(specieID)) continue;
            return i;
        }
        log.error("Cannot find specie {}", specieID);
        throw new RuntimeException("Cannot find specie " + specieID);
    }
}

