/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.math;

import neurord.numeric.math.Column;
import org.jblas.DoubleMatrix;
import org.jblas.Solve;

public final class Matrix
implements Cloneable {
    public double[][] a;
    double[] ws;
    int n;
    int[] perm;
    int sign;
    int n1 = 0;
    int n2 = 0;
    public static int ROW = 1;
    public static int COLUMN = 2;

    public Matrix(int nnn) {
        this.n2 = this.n = nnn;
        this.n1 = this.n;
        this.a = new double[this.n][this.n];
        this.perm = new int[this.n];
        this.ws = new double[this.n];
    }

    public Matrix(int nr, int nc) {
        this.n1 = nr;
        this.n2 = nc;
        this.a = new double[this.n1][this.n2];
        if (this.n1 == this.n2) {
            this.n = this.n1;
            this.perm = new int[this.n];
            this.ws = new double[this.n];
        } else {
            this.n = -1;
        }
    }

    public Matrix(double[][] a) {
        this.a = a;
        this.n1 = a.length;
        this.n2 = a[0].length;
        if (this.n1 == this.n2) {
            this.n = a.length;
            this.perm = new int[this.n];
            this.ws = new double[this.n];
        } else {
            this.n = -1;
        }
    }

    public Matrix(int rowcol, double[] x) {
        if (rowcol == ROW) {
            this.n1 = 1;
            this.n2 = x.length;
            this.a = new double[this.n1][this.n2];
            for (int i = 0; i < this.n2; ++i) {
                this.a[0][i] = x[i];
            }
        } else if (rowcol == COLUMN) {
            this.n1 = x.length;
            this.n2 = 1;
            this.a = new double[this.n1][this.n2];
            for (int i = 0; i < this.n1; ++i) {
                this.a[i][0] = x[i];
            }
        } else {
            System.out.println("ERROR - matrix constructor must specify Matrix.ROW, or Matrix.COLUMN");
        }
    }

    public double[] flatten() {
        double[] d = new double[this.n1 * this.n2];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                d[this.n * i + j] = this.a[i][j];
            }
        }
        return d;
    }

    public void Sp(String s) {
        System.out.println(s);
    }

    public final int dim() {
        return this.n;
    }

    public Matrix copy() {
        Matrix m = new Matrix(this.n1, this.n2);
        for (int i = 0; i < this.n1; ++i) {
            for (int j = 0; j < this.n2; ++j) {
                m.a[i][j] = this.a[i][j];
            }
            m.perm[i] = this.perm[i];
        }
        m.sign = this.sign;
        return m;
    }

    public void setDims(int d1, int d2) {
        this.n1 = d1;
        this.n2 = d2;
    }

    public void identise() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.a[i][j] = 0.0;
            }
            this.a[i][i] = 1.0;
        }
    }

    public void randomise() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.a[i][j] = Math.random();
            }
        }
    }

    public void zero() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.a[i][j] = 0.0;
            }
        }
    }

    public Matrix identity() {
        Matrix m = this.copy();
        m.identise();
        return m;
    }

    public Matrix random() {
        Matrix m = this.copy();
        m.randomise();
        return m;
    }

    public void add(double d) {
        for (int i = 0; i < this.n; ++i) {
            int j = 0;
            while (j < this.n) {
                double[] dArray = this.a[i];
                int n = j++;
                dArray[n] = dArray[n] + d;
            }
        }
    }

    public static Matrix[] average(Matrix[] ma, Matrix[] mb, double f) {
        int n = ma.length;
        Matrix[] res = new Matrix[n];
        for (int i = 0; i < n; ++i) {
            res[i] = Matrix.average(ma[i], mb[i], f);
        }
        return res;
    }

    public static Matrix average(Matrix ma, Matrix mb, double f) {
        double g = 1.0 - f;
        int n = ma.n;
        Matrix res = new Matrix(n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                res.a[i][j] = f * mb.a[i][j] + g * ma.a[i][j];
            }
        }
        return res;
    }

    public void add(Matrix m) {
        if (m.n != this.n) {
            this.Sp("incompativle dims in Matrix.mplyBy " + this.n + " " + m.n);
        } else {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    double[] dArray = this.a[i];
                    int n = j;
                    dArray[n] = dArray[n] + m.a[i][j];
                }
            }
        }
    }

    public Matrix sum(Matrix m) {
        Matrix mr = this.copy();
        mr.zero();
        if (m.n != this.n) {
            this.Sp("incompativle dims in Matrix.mplyBy " + this.n + " " + m.n);
        } else {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    mr.a[i][j] = this.a[i][j] + m.a[i][j];
                }
            }
        }
        return mr;
    }

    public void mpyBy(double d) {
        for (int i = 0; i < this.n; ++i) {
            int j = 0;
            while (j < this.n) {
                double[] dArray = this.a[i];
                int n = j++;
                dArray[n] = dArray[n] * d;
            }
        }
    }

    public void mpyBy(Matrix m) {
        this.a = this.prod((Matrix)m).a;
    }

    public Matrix times(Matrix m) {
        return this.prod(m);
    }

    public String stringDims() {
        return " " + this.n1 + "x" + this.n2;
    }

    public Matrix prod(Matrix m) {
        Matrix mr = new Matrix(this.n1, m.n2);
        mr.zero();
        if (this.n2 != m.n1) {
            throw new RuntimeException("incompatible dims in Matrix.prod: A: " + this.n1 + " " + this.n2 + "   B: " + m.n1 + " " + m.n2);
        }
        for (int i = 0; i < this.n1; ++i) {
            for (int j = 0; j < m.n2; ++j) {
                for (int k = 0; k < this.n2; ++k) {
                    double[] dArray = mr.a[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.a[i][k] * m.a[k][j];
                }
            }
        }
        return mr;
    }

    public Matrix subtract(Matrix m) {
        Matrix mr = new Matrix(this.n1, this.n2);
        mr.zero();
        if (this.n1 != m.n1 || this.n2 != m.n2) {
            this.Sp("incompatible dims in Matrix.subtract " + this.n1 + " " + this.n2 + " " + m.n1 + " " + m.n2);
        } else {
            for (int i = 0; i < this.n1; ++i) {
                for (int j = 0; j < this.n2; ++j) {
                    mr.a[i][j] = this.a[i][j] - m.a[i][j];
                }
            }
        }
        return mr;
    }

    public double[] getColumnData() {
        double[] ret = new double[this.n1];
        if (this.n2 == 1) {
            for (int i = 0; i < this.n1; ++i) {
                ret[i] = this.a[i][0];
            }
        } else {
            this.Sp("ERROR - getColumnData called on matrix with n2 != 1 " + this.n2);
        }
        return ret;
    }

    public double[] lvprod(double[] v) {
        double[] r = new double[this.n];
        if (v.length != this.n) {
            this.Sp("incompatible dimensions in lvprod");
        } else {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    int n = j;
                    r[n] = r[n] + v[i] * this.a[i][j];
                }
            }
        }
        return r;
    }

    public Column times(Column v) {
        return new Column(this.rvprod(v.getData()));
    }

    public double[] rvprod(double[] v) {
        double[] r = new double[this.n];
        if (v.length != this.n) {
            this.Sp("incompatible dimensions in lvprod");
        } else {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    int n = i;
                    r[n] = r[n] + this.a[i][j] * v[j];
                }
            }
        }
        return r;
    }

    public void multiplyInto(double[] v) {
        int i;
        for (i = 0; i < this.n; ++i) {
            this.ws[i] = 0.0;
            for (int j = 0; j < this.n; ++j) {
                int n = i;
                this.ws[n] = this.ws[n] + this.a[i][j] * v[j];
            }
        }
        for (i = 0; i < this.n; ++i) {
            v[i] = this.ws[i];
        }
    }

    public void rect2rvprod(double[] v, double[] r1, double[] r2) {
        int j;
        int i;
        for (i = 0; i < this.n1; ++i) {
            this.ws[i] = 0.0;
            for (j = 0; j < this.n1; ++j) {
                int n = i;
                this.ws[n] = this.ws[n] + this.a[i][j] * v[j];
            }
        }
        for (i = 0; i < this.n2 - this.n1; ++i) {
            r2[i] = 0.0;
            for (j = 0; j < this.n1; ++j) {
                int n = i;
                r2[n] = r2[n] + this.a[i + this.n1][j] * v[j];
            }
        }
        for (i = 0; i < this.n1; ++i) {
            r1[i] = this.ws[i];
        }
    }

    public double rvprodOneElt(double[] v, int elt) {
        double r = 0.0;
        for (int j = 0; j < this.n; ++j) {
            r += this.a[elt][j] * v[j];
        }
        return r;
    }

    public Matrix transpose() {
        Matrix m = new Matrix(this.n2, this.n1);
        for (int i = 0; i < this.n1; ++i) {
            for (int j = 0; j < this.n2; ++j) {
                m.a[j][i] = this.a[i][j];
            }
        }
        return m;
    }

    public double det() {
        Matrix t = this.copy();
        t.LU();
        double d = 1.0 * (double)t.sign;
        for (int i = 0; i < this.n; ++i) {
            d *= t.a[i][i];
        }
        return d;
    }

    public double[][] copyMat() {
        double[][] ar = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                ar[i][j] = this.a[i][j];
            }
        }
        return ar;
    }

    public void LU() {
        int j;
        double big;
        int i;
        double[] vv = new double[this.n];
        double TINY = 1.0E-20;
        this.sign = 1;
        int imax = -1;
        for (i = 0; i < this.n; ++i) {
            big = 0.0;
            for (j = 0; j < this.n; ++j) {
                double d;
                double temp = Math.abs(this.a[i][j]);
                if (!(d > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                this.Sp("Singular Matrix in routine LUDCMP");
            }
            vv[i] = 1.0 / big;
        }
        for (j = 0; j < this.n; ++j) {
            double dum;
            int k;
            double sum;
            for (i = 0; i < j; ++i) {
                sum = this.a[i][j];
                for (k = 0; k < i; ++k) {
                    sum -= this.a[i][k] * this.a[k][j];
                }
                this.a[i][j] = sum;
            }
            big = 0.0;
            for (i = j; i < this.n; ++i) {
                double d;
                sum = this.a[i][j];
                for (k = 0; k < j; ++k) {
                    sum -= this.a[i][k] * this.a[k][j];
                }
                this.a[i][j] = sum;
                dum = vv[i] * Math.abs(sum);
                if (!(d >= big)) continue;
                big = dum;
                imax = i;
            }
            if (j != imax) {
                for (k = 0; k < this.n; ++k) {
                    dum = this.a[imax][k];
                    this.a[imax][k] = this.a[j][k];
                    this.a[j][k] = dum;
                }
                this.sign = -this.sign;
                vv[imax] = vv[j];
            }
            this.perm[j] = imax;
            if (this.a[j][j] == 0.0) {
                this.a[j][j] = TINY;
            }
            if (j == this.n) continue;
            dum = 1.0 / this.a[j][j];
            for (i = j + 1; i < this.n; ++i) {
                double[] dArray = this.a[i];
                int n = j;
                dArray[n] = dArray[n] * dum;
            }
        }
    }

    public Matrix inverse() {
        Matrix t = this.copy();
        Matrix r = this.copy();
        t.LU();
        double[] c = new double[this.n];
        for (int j = 0; j < this.n; ++j) {
            int i;
            for (i = 0; i < this.n; ++i) {
                c[i] = 0.0;
            }
            c[j] = 1.0;
            t.lubksb(c);
            for (i = 0; i < this.n; ++i) {
                r.a[i][j] = c[i];
            }
        }
        return r;
    }

    static DoubleMatrix makeDoubleMatrix(double[][] m) {
        int len = m[0].length;
        double[] dst = new double[m.length * len];
        for (int i = 0; i < m.length; ++i) {
            System.arraycopy(m[i], 0, dst, i * len, len);
        }
        return new DoubleMatrix(m.length, len, dst);
    }

    public static double[] LUSolve(double[][] m, double[] R) {
        DoubleMatrix M = Matrix.makeDoubleMatrix(m);
        DoubleMatrix b = new DoubleMatrix(R);
        return Solve.solve(M, b).toArray();
    }

    public Column LUSolve(Column r) {
        return new Column(Matrix.LUSolve(this.a, r.getData()));
    }

    public void invert() {
        this.a = this.inverse().a;
    }

    public Column lubksb(Column v) {
        double[] d = this.lubksb(v.getData());
        return new Column(d);
    }

    public double[] lubksb(double[] b) {
        int j;
        double sum;
        int i;
        int ii = -1;
        for (i = 0; i < this.n; ++i) {
            int ip = this.perm[i];
            sum = b[ip];
            b[ip] = b[i];
            if (ii >= 0) {
                for (j = ii; j < i; ++j) {
                    sum -= this.a[i][j] * b[j];
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i] = sum;
        }
        for (i = this.n - 1; i >= 0; --i) {
            sum = b[i];
            for (j = i + 1; j < this.n; ++j) {
                sum -= this.a[i][j] * b[j];
            }
            b[i] = sum / this.a[i][i];
        }
        return b;
    }

    public void round(double d) {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (!(Math.abs(this.a[i][j]) < d)) continue;
                this.a[i][j] = 0.0;
            }
        }
    }

    public void round() {
        this.round(1.0E-15);
    }

    public void print() {
        int i;
        String[] sa = new String[this.n1];
        for (i = 0; i < this.n1; ++i) {
            sa[i] = " ";
            for (int j = 0; j < this.n2; ++j) {
                int n = i;
                sa[n] = sa[n] + " " + this.a[i][j];
            }
        }
        this.Sp(" n1: " + this.n1 + " n2: " + this.n2);
        for (i = 0; i < sa.length; ++i) {
            this.Sp("" + i + " " + sa[i]);
        }
    }

    public double maxAbsElt() {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (!(Math.abs(this.a[i][j]) > d)) continue;
                d = Math.abs(this.a[i][j]);
            }
        }
        return d;
    }

    public Matrix power(int p) {
        Matrix mr = this.identity();
        int pg = 0;
        int pl = 1;
        Matrix mp = this.copy();
        while (pg < p) {
            if ((p & pl) > 0) {
                pg += pl;
                mr = mr.prod(mp);
            }
            pl *= 2;
            mp = mp.prod(mp);
        }
        if (pg != p) {
            this.Sp("got Matrix power wrong: " + p + " " + pg + " " + pl);
        }
        return mr;
    }

    public Matrix crudeExpOf(double t) {
        Matrix m = this.copy();
        m.mpyBy(t);
        double eps = 1.0E-8;
        double d = m.maxAbsElt();
        int p = 0;
        double f = 1.0;
        p = 0;
        while (d * f > eps) {
            f *= 0.5;
            ++p;
        }
        m.mpyBy(f);
        m.add(m.identity());
        while (p > 0) {
            m.mpyBy(m);
            --p;
        }
        return m;
    }

    public Matrix expOf(double t) {
        Matrix m = this.copy();
        m.mpyBy(t);
        double eps = 1.0E-12;
        double d = m.maxAbsElt();
        int p = 0;
        double f = 1.0;
        p = 0;
        while (d * f > eps) {
            f *= 0.5;
            ++p;
        }
        m.mpyBy(f);
        while (p > 0) {
            Matrix u = m.copy();
            u.mpyBy(u);
            m.add(m);
            m.add(u);
            --p;
        }
        m.add(m.identity());
        return m;
    }

    public int randomIndexFromColumn(int c) {
        return this.randomIndexFromColumn(c, Math.random());
    }

    public final int randomIndexFromColumn(int c, double r) {
        int ir = 0;
        while (true) {
            double d;
            r -= this.a[ir][c];
            if (!(d > 0.0)) break;
            ++ir;
        }
        return ir;
    }

    public final double[] getRow(int ic) {
        double[] c = new double[this.n2];
        for (int i = 0; i < this.n2; ++i) {
            c[i] = this.a[ic][i];
        }
        return c;
    }

    public final double[] getColumn(int ic) {
        double[] c = new double[this.n1];
        for (int i = 0; i < this.n1; ++i) {
            c[i] = this.a[i][ic];
        }
        return c;
    }

    public int randomIndexFromOffsetColumn(int c, int off) {
        double r = Math.random();
        int ir = off;
        while (true) {
            double d;
            r -= this.a[ir][c];
            if (!(d > 0.0)) break;
            ++ir;
        }
        return ir;
    }

    public double[] ev1vec(int np) {
        int i;
        Matrix q = this.copy();
        for (int i2 = 0; i2 < np; ++i2) {
            q = q.prod(q);
        }
        double[] s = new double[this.n];
        for (int i3 = 0; i3 < this.n; ++i3) {
            s[i3] = 1.0 / (double)this.n;
        }
        s = q.rvprod(s);
        double t = 0.0;
        for (i = 0; i < this.n; ++i) {
            t += s[i];
        }
        i = 0;
        while (i < this.n) {
            int n = i++;
            s[n] = s[n] / t;
        }
        if (Math.abs(t - 1.0) > 0.01) {
            this.Sp("WARNING - ev1vec in class Matrix chnaged size " + t);
        }
        return s;
    }

    public void multiplyBy(double dt) {
        for (int i = 0; i < this.n1; ++i) {
            int j = 0;
            while (j < this.n2) {
                double[] dArray = this.a[i];
                int n = j++;
                dArray[n] = dArray[n] * dt;
            }
        }
    }

    public void subtractIdentity() {
        int i = 0;
        while (i < this.n1) {
            double[] dArray = this.a[i];
            int n = i++;
            dArray[n] = dArray[n] - 1.0;
        }
    }

    public void negate() {
        for (int i = 0; i < this.n1; ++i) {
            for (int j = 0; j < this.n2; ++j) {
                this.a[i][j] = -this.a[i][j];
            }
        }
    }

    public void set(int i, int j, double d) {
        this.a[i][j] = d;
    }

    public void dump() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.n1; ++i) {
            for (int j = 0; j < this.n2; ++j) {
                sb.append(this.a[i][j]);
                sb.append("   ");
            }
            sb.append("\n");
        }
        System.out.println(sb.toString());
    }
}

