/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.morph;

import neurord.geom.Position;
import neurord.numeric.morph.VolumeElement;

public class CurvedVolumeElement
extends VolumeElement {
    int iradial;
    int iazimuthal;
    int[] stripLengths;
    float[][] verts;
    float[][] norms;

    public CurvedVolumeElement(String label, String region, String groupID, Position[] boundary, Position[] surfaceBoundary, double exposedArea, Position center, double volume, double deltaZ) {
        super(label, region, groupID, boundary, surfaceBoundary, exposedArea, center, 0.0, 0.0, 0.0, volume, deltaZ);
    }

    public void setPositionIndexes(int ir, int ia) {
        this.iradial = ir;
        this.iazimuthal = ia;
    }

    public void setTriangles(int[] sls, float[][] vs, float[][] ns) {
        this.stripLengths = sls;
        this.verts = vs;
        this.norms = ns;
    }

    public String getText3D() {
        StringBuffer sb = new StringBuffer();
        sb.append("" + this.stripLengths.length + " " + this.verts.length + "\n");
        int nsl = this.stripLengths.length;
        for (int i = 0; i < nsl; ++i) {
            sb.append("" + this.stripLengths[i] + " ");
        }
        sb.append("\n");
        int nv = this.verts.length;
        for (int i = 0; i < this.verts.length; ++i) {
            float[] fv = this.verts[i];
            float[] fn = this.norms[i];
            sb.append(String.format("%.3f %.3f %.3f %.2f %.2f %.2f\n", Float.valueOf(fv[0]), Float.valueOf(fv[1]), Float.valueOf(fv[2]), Float.valueOf(fn[0]), Float.valueOf(fn[1]), Float.valueOf(fn[2])));
        }
        return sb.toString();
    }
}

