/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.morph;

import java.util.ArrayList;
import neurord.geom.GRotation;
import neurord.geom.Geom;
import neurord.geom.Position;
import neurord.geom.Translation;
import neurord.geom.Vector;
import neurord.numeric.morph.CuboidVolumeElement;
import neurord.numeric.morph.TreePoint;
import neurord.numeric.morph.VolumeElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VolumeLine {
    static final Logger log = LogManager.getLogger();
    int nsl;
    int nreg;
    double[] slw;
    double lSize;
    double depth;
    double dsl;
    int nl;
    VolumeElement[][] elements;

    public VolumeLine(int ns, int nr, double[] sl, double w, double d) {
        this.nsl = ns;
        this.nreg = nr;
        this.slw = sl;
        this.lSize = w;
        this.depth = d;
        this.dsl = 0.0;
        for (int i = 0; i < this.nsl; ++i) {
            this.dsl += this.slw[i];
        }
        this.nl = 2 * this.nsl + this.nreg;
    }

    public VolumeElement getElement(int i) {
        return this.elements[i][0];
    }

    public void lineFill(Position pa, Position pb, String pointLabel, String regionLabel) {
        double sl = Geom.distanceBetween(pa, pb);
        Translation trans = Geom.translation(Geom.midpoint(pa, pb));
        Vector vab = Geom.fromToVector(pa, pb);
        double theta = Geom.zRotationAngle(Geom.unitY(), vab);
        GRotation rot = Geom.aboutZRotation(theta);
        this.elements = new VolumeElement[this.nl][1];
        double[][] regs = this.makeRanges();
        for (int i = 0; i < this.nl; ++i) {
            Position[] psb;
            double[] areg = regs[i];
            double dl = areg[1] - areg[0];
            double vcl = 0.5 * (areg[0] + areg[1]);
            String label = i == this.nl / 2 ? pointLabel : null;
            Position[] pbdry = new Position[]{Geom.position(vcl - 0.5 * dl, -0.5 * sl, 0.0), Geom.position(vcl - 0.5 * dl, 0.5 * sl, 0.0), Geom.position(vcl + 0.5 * dl, 0.5 * sl, 0.0), Geom.position(vcl + 0.5 * dl, -0.5 * sl, 0.0)};
            for (int ib = 0; ib < pbdry.length; ++ib) {
                pbdry[ib] = trans.getTranslated(rot.getRotatedPosition(pbdry[ib]));
            }
            if (i == 0) {
                double xb = vcl - 0.5 * dl;
                psb = new Position[]{Geom.position(xb, -0.5 * sl, -0.5 * this.depth), Geom.position(xb, -0.5 * sl, 0.5 * this.depth), Geom.position(xb, 0.5 * sl, 0.5 * this.depth), Geom.position(xb, 0.5 * sl, -0.5 * this.depth)};
            } else if (i == this.nl - 1) {
                double xb = vcl + 0.5 * dl;
                psb = new Position[]{Geom.position(xb, -0.5 * sl, -0.5 * this.depth), Geom.position(xb, 0.5 * sl, -0.5 * this.depth), Geom.position(xb, 0.5 * sl, 0.5 * this.depth), Geom.position(xb, -0.5 * sl, 0.5 * this.depth)};
            } else {
                psb = null;
            }
            if (psb != null) {
                for (int ib = 0; ib < psb.length; ++ib) {
                    psb[ib] = trans.getTranslated(rot.getRotatedPosition((Position)psb[ib]));
                }
            }
            Position cp = Geom.position(vcl, 0.0, 0.0);
            Position pr = rot.getRotatedPosition(cp);
            Position center = trans.getTranslated(pr);
            CuboidVolumeElement ve = new CuboidVolumeElement(label, regionLabel, null, pbdry, psb, psb != null ? sl * this.depth : 0.0, center, this.depth * sl, this.depth * dl, 0.0, dl * sl * this.depth, this.depth);
            this.elements[i][0] = ve;
        }
        this.neighborize();
    }

    public void neighborize() {
        for (int i = 0; i < this.nl; ++i) {
            CuboidVolumeElement cv = (CuboidVolumeElement)this.elements[i][0];
            CuboidVolumeElement cvx = null;
            if (i + 1 < this.nl) {
                cvx = (CuboidVolumeElement)this.elements[i + 1][0];
            }
            if (cv == null || cvx == null) continue;
            cv.coupleTo(cvx, cv.getAlongArea());
        }
    }

    public void planeConnect(VolumeLine tgt) {
        if (tgt.nl == this.nl) {
            for (int i = 0; i < this.nl; ++i) {
                CuboidVolumeElement va = (CuboidVolumeElement)this.getElement(i);
                CuboidVolumeElement vb = (CuboidVolumeElement)tgt.getElement(i);
                if (va == null || vb == null) continue;
                va.coupleTo(vb, va.getSideArea());
            }
        } else if (this.lSize / (double)this.nl <= tgt.lSize / (double)tgt.nl) {
            this.smallBigMatchConnect(tgt);
        } else {
            tgt.smallBigMatchConnect(this);
        }
    }

    public void subPlaneConnect(TreePoint tp, TreePoint tpl, VolumeLine tgt, double offset) {
        int i;
        log.info("segment junction: {} points across {} being connected to {} across {}", this.nl, this.lSize, tgt.nl, tgt.lSize);
        double[][] rngme = this.makeRanges();
        double[][] rngtgt = tgt.makeRanges();
        double offeff = -1.0 * (offset - 0.5 * (this.lSize - tgt.lSize));
        log.info("shifting child branch {} relative to parent center", offeff);
        for (i = 0; i < rngtgt.length; ++i) {
            double[] dArray = rngtgt[i];
            dArray[0] = dArray[0] + offeff;
            double[] dArray2 = rngtgt[i];
            dArray2[1] = dArray2[1] + offeff;
        }
        for (i = 0; i < tgt.nl; ++i) {
            VolumeElement vtgt = tgt.getElement(i);
            for (int jme = 0; jme < this.nl; ++jme) {
                double fol = this.overlapFactor(rngme[jme], rngtgt[i]);
                if (!(fol > 0.001)) continue;
                CuboidVolumeElement vme = (CuboidVolumeElement)this.getElement(jme);
                vme.coupleTo(vtgt, fol * vme.getSideArea());
                log.info("coupled parent element {} to child element {} overlap factor = {}", jme, i, fol);
            }
        }
    }

    private void smallBigMatchConnect(VolumeLine tgt) {
        double[][] rngme = this.makeRanges();
        double[][] rngtgt = tgt.makeRanges();
        for (int i = 0; i < this.nl; ++i) {
            double fol2;
            CuboidVolumeElement va = (CuboidVolumeElement)this.getElement(i);
            int ifol = this.getFirstOverlap(rngme[i], rngtgt);
            double fol1 = this.overlapFactor(rngme[i], rngtgt[ifol]);
            if (fol1 > 0.001) {
                CuboidVolumeElement vb = (CuboidVolumeElement)tgt.getElement(ifol);
                va.coupleTo(vb, fol1 * va.getSideArea());
            }
            if (ifol >= rngtgt.length - 1 || !((fol2 = this.overlapFactor(rngme[i], rngtgt[ifol + 1])) > 0.001)) continue;
            VolumeElement vb = tgt.getElement(ifol + 1);
            va.coupleTo(vb, fol2 * va.getSideArea());
        }
    }

    public int getFirstOverlap(double[] rng, double[][] tgts) {
        int iol;
        for (iol = 0; iol < tgts.length - 1 && (rng[1] <= tgts[iol][0] || rng[0] >= tgts[iol][1]); ++iol) {
        }
        return iol;
    }

    private double overlapFactor(double[] rng, double[] tgt) {
        double dr = rng[1] - rng[0];
        double ret = 0.0;
        if (rng[0] >= tgt[0] && rng[1] <= tgt[1]) {
            ret = dr;
        } else if (rng[1] <= tgt[0] || rng[0] >= tgt[1]) {
            ret = 0.0;
        } else if (rng[1] < tgt[1]) {
            ret = rng[1] - tgt[0];
        } else if (rng[1] >= tgt[1]) {
            ret = rng[0] < tgt[0] ? tgt[1] - tgt[0] : tgt[1] - rng[0];
        }
        return ret /= dr;
    }

    private double[][] makeRanges(double ltot, int nreg) {
        double[][] ret = new double[nreg][2];
        double dl = ltot / (double)nreg;
        for (int i = 0; i < nreg; ++i) {
            double rl;
            ret[i][0] = rl = -0.5 * ltot + (double)i * dl;
            ret[i][1] = rl + dl;
        }
        return ret;
    }

    public double[][] makeRanges() {
        double[][] ret = new double[this.nl][2];
        double wk = -0.5 * this.lSize;
        double dreg = (this.lSize - 2.0 * this.dsl) / (double)this.nreg;
        for (int i = 0; i < this.nl; ++i) {
            double dl = 0.0;
            dl = i < this.nsl ? this.slw[i] : (i >= this.nl - this.nsl ? this.slw[this.nl - 1 - i] : dreg);
            ret[i][0] = wk;
            ret[i][1] = wk + dl;
            wk += dl;
        }
        log.debug("nl={} nsl={} nr={} dreg={} dsl={}", this.nl, this.nsl, this.nreg, dreg, this.dsl);
        assert (Math.abs(wk - 0.5 * this.lSize) / this.lSize < 1.0E-5) : "range miscount : " + wk + " " + this.lSize;
        return ret;
    }

    public ArrayList<VolumeElement> getElements() {
        ArrayList<VolumeElement> ave = new ArrayList<VolumeElement>();
        for (int i = 0; i < this.nl; ++i) {
            VolumeElement ve = this.getElement(i);
            if (ve == null) continue;
            ave.add(ve);
        }
        return ave;
    }
}

