/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.morph;

import java.util.ArrayList;
import neurord.geom.GRotation;
import neurord.geom.Geom;
import neurord.geom.Position;
import neurord.geom.Translation;
import neurord.geom.Vector;
import neurord.numeric.morph.CuboidVolumeElement;
import neurord.numeric.morph.TreePoint;
import neurord.numeric.morph.VolumeElement;

public class VolumeSlice {
    final int nx;
    final int ny;
    double boxSize;
    double radius;
    final int icenter;
    final int jcenter;
    private final boolean[][] present;
    private CuboidVolumeElement[][] elements;

    public VolumeSlice(double delta, double r) {
        int n;
        this.boxSize = delta;
        this.radius = r;
        int nr = (int)(r / delta);
        this.nx = n = 1 + 2 * nr;
        this.ny = n;
        this.icenter = nr;
        this.jcenter = nr;
        this.present = new boolean[this.nx][this.ny];
        int nt = 0;
        int nf = 0;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                double dx = (double)(i - this.icenter) * this.boxSize;
                double dy = (double)(j - this.jcenter) * this.boxSize;
                double r2 = dx * dx + dy * dy;
                if (r2 < this.radius * this.radius) {
                    this.present[i][j] = true;
                    ++nt;
                    continue;
                }
                this.present[i][j] = false;
                ++nf;
            }
        }
    }

    public CuboidVolumeElement getElement(int i, int j) {
        return this.elements[i][j];
    }

    public void discFill(Position pa, Position pb, String pointLabel, String regionLabel) {
        double sl = Geom.distanceBetween(pa, pb);
        Translation trans = Geom.translation(Geom.midpoint(pa, pb));
        Vector vab = Geom.fromToVector(pa, pb);
        double theta = Geom.zRotationAngle(Geom.unitY(), vab);
        GRotation rot = Geom.aboutZRotation(theta);
        this.elements = new CuboidVolumeElement[this.nx][this.ny];
        double x0 = (double)(-1 * this.icenter) * this.boxSize;
        double y0 = (double)(-1 * this.jcenter) * this.boxSize;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                CuboidVolumeElement ve;
                Position[] psb;
                if (!this.present[i][j]) continue;
                double vcx = x0 + (double)i * this.boxSize;
                double vcy = y0 + (double)j * this.boxSize;
                String label = i == this.icenter && j == this.jcenter ? pointLabel : null;
                Position[] pbdry = new Position[]{Geom.position(vcx - 0.5 * this.boxSize, -0.5 * sl, vcy), Geom.position(vcx - 0.5 * this.boxSize, 0.5 * sl, vcy), Geom.position(vcx + 0.5 * this.boxSize, 0.5 * sl, vcy), Geom.position(vcx + 0.5 * this.boxSize, -0.5 * sl, vcy)};
                for (int ib = 0; ib < pbdry.length; ++ib) {
                    pbdry[ib] = trans.getTranslated(rot.getRotatedPosition(pbdry[ib]));
                }
                double hb = 0.5 * this.boxSize;
                if (i == 0 || !this.present[i - 1][j]) {
                    double xb = vcx + -0.5 * this.boxSize;
                    psb = new Position[]{Geom.position(xb, -0.5 * sl, vcy - hb), Geom.position(xb, -0.5 * sl, vcy + hb), Geom.position(xb, 0.5 * sl, vcy + hb), Geom.position(xb, 0.5 * sl, vcy - hb)};
                } else if (i == this.nx - 1 || !this.present[i + 1][j]) {
                    double xb = vcx + 0.5 * this.boxSize;
                    psb = new Position[]{Geom.position(xb, -0.5 * sl, vcy + hb), Geom.position(xb, -0.5 * sl, vcy - hb), Geom.position(xb, 0.5 * sl, vcy - hb), Geom.position(xb, 0.5 * sl, vcy + hb)};
                } else if (j == 0 || !this.present[i][j - 1]) {
                    double yb = vcy - 0.5 * this.boxSize;
                    psb = new Position[]{Geom.position(vcx + hb, -0.5 * sl, yb), Geom.position(vcx - hb, -0.5 * sl, yb), Geom.position(vcx - hb, 0.5 * sl, yb), Geom.position(vcx + hb, 0.5 * sl, yb)};
                } else if (j == this.ny - 1 || !this.present[i][j + 1]) {
                    double yb = vcy + 0.5 * this.boxSize;
                    psb = new Position[]{Geom.position(vcx - hb, -0.5 * sl, yb), Geom.position(vcx + hb, -0.5 * sl, yb), Geom.position(vcx + hb, 0.5 * sl, yb), Geom.position(vcx - hb, 0.5 * sl, yb)};
                } else {
                    psb = null;
                }
                if (psb != null) {
                    for (int ib = 0; ib < psb.length; ++ib) {
                        psb[ib] = trans.getTranslated(rot.getRotatedPosition(psb[ib]));
                    }
                }
                Position cp = Geom.position(vcx, vcy, 0.0);
                Position pr = rot.getRotatedPosition(cp);
                Position center = trans.getTranslated(pr);
                this.elements[i][j] = ve = new CuboidVolumeElement(label, regionLabel, null, pbdry, psb, psb != null ? sl * this.boxSize : 0.0, center, this.boxSize * sl, this.boxSize * this.boxSize, this.boxSize * sl, this.boxSize * this.boxSize * sl, this.boxSize);
            }
        }
        this.neighborize();
    }

    private void neighborize() {
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                CuboidVolumeElement cv = this.getElement(i, j);
                CuboidVolumeElement cvx = null;
                CuboidVolumeElement cvy = null;
                if (i + 1 < this.nx) {
                    cvx = this.getElement(i + 1, j);
                }
                if (j + 1 < this.ny) {
                    cvy = this.getElement(i, j + 1);
                }
                if (cv != null && cvx != null) {
                    cv.coupleTo(cvx, cv.getAlongArea());
                }
                if (cv == null || cvy == null) continue;
                cv.coupleTo(cvy, cv.getTopArea());
            }
        }
    }

    public void planeConnect(VolumeSlice tgt) {
        if (tgt.nx == this.nx && tgt.ny == this.ny) {
            for (int i = 0; i < this.nx; ++i) {
                for (int j = 0; j < this.ny; ++j) {
                    CuboidVolumeElement va = this.getElement(i, j);
                    CuboidVolumeElement vb = tgt.getElement(i, j);
                    if (va == null || vb == null) continue;
                    va.coupleTo(vb, va.getSideArea());
                }
            }
        } else if (tgt.nx < this.nx) {
            tgt.planeConnectUp(this);
        } else {
            this.planeConnectUp(tgt);
        }
    }

    private void planeConnectUp(VolumeSlice tgt) {
        int io = (tgt.nx - this.nx) / 2;
        int jo = (tgt.ny - this.ny) / 2;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                CuboidVolumeElement va = this.getElement(i, j);
                CuboidVolumeElement vb = tgt.getElement(io + i, jo + j);
                if (va == null || vb == null) continue;
                va.coupleTo(vb, va.getSideArea());
            }
        }
    }

    public ArrayList<VolumeElement> getElements() {
        ArrayList<VolumeElement> ave = new ArrayList<VolumeElement>();
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                CuboidVolumeElement ve = this.getElement(i, j);
                if (ve == null) continue;
                ave.add(ve);
            }
        }
        return ave;
    }

    public void subPlaneConnect(TreePoint tp, TreePoint tpn, VolumeSlice vg, double pborel) {
        double pbo = 1.0 * (pborel - (this.radius - vg.radius));
        double xtg0 = (double)(-1 * vg.icenter) * vg.boxSize;
        double ytg0 = (double)(-1 * vg.jcenter) * vg.boxSize + pbo;
        int ncpld = 0;
        for (int itg = 0; itg < vg.nx; ++itg) {
            for (int jtg = 0; jtg < vg.ny; ++jtg) {
                if (!vg.hasElement(itg, jtg)) continue;
                double cxtg = xtg0 + (double)itg * vg.boxSize;
                double cytg = ytg0 + (double)jtg * vg.boxSize;
                int ilmin = this.getIBox(cxtg);
                int jlmin = this.getJBox(cytg);
                int ilmax = this.getIBox(cxtg + vg.boxSize);
                int jlmax = this.getJBox(cytg + vg.boxSize);
                for (int il = ilmin; il <= ilmax; ++il) {
                    for (int jl = jlmin; jl <= jlmax; ++jl) {
                        double ovlp;
                        if (!this.hasElement(il, jl) || !((ovlp = this.overlapFactor(this.getX(il), this.getY(il), this.boxSize, cxtg, cytg, vg.boxSize)) > 0.0)) continue;
                        this.getElement(il, jl).coupleTo(vg.getElement(itg, jtg), ovlp * this.boxSize * this.boxSize);
                        ++ncpld;
                    }
                }
            }
        }
    }

    private double overlapFactor(double mex, double mey, double med, double tgtx, double tgty, double tgtd) {
        double fx = this.ovlp1D(mex, med, tgtx, tgtd);
        double fy = this.ovlp1D(mey, med, tgty, tgtd);
        return fx * fy;
    }

    private double ovlp1D(double mex, double med, double tgtx, double tgtd) {
        double ret = 0.0;
        ret = mex <= tgtx ? (mex + med > tgtx + tgtd ? tgtd : mex + med - tgtx) : (mex + med > tgtx + tgtd ? med : tgtx + tgtd - mex);
        return ret / med;
    }

    public double getX(int i) {
        return ((double)(-this.nx) / 2.0 + (double)i) * this.boxSize;
    }

    public double getY(int j) {
        return ((double)(-this.ny) / 2.0 + (double)j) * this.boxSize;
    }

    public boolean hasElement(int i, int j) {
        return i >= 0 && i < this.nx && j >= 0 && j < this.ny && this.present[i][j];
    }

    public int getIBox(double x) {
        return (int)(x / this.boxSize + (double)this.nx / 2.0);
    }

    public int getJBox(double y) {
        return (int)(y / this.boxSize + (double)this.ny / 2.0);
    }
}

