/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.stochastic;

import neurord.numeric.stochastic.ProbabilityTable;

public class BinomialTable
extends ProbabilityTable {
    public static final int NMAX = 140;
    private static BinomialTable instance;
    private double[][] ncmtbl = new double[140][];

    public static BinomialTable getTable() {
        if (instance == null) {
            instance = new BinomialTable();
        }
        return instance;
    }

    private BinomialTable() {
        this.ncmtbl[0] = new double[0];
        this.ncmtbl[1] = new double[1];
        this.ncmtbl[1][0] = 1.0;
        for (int i = 2; i < 140; ++i) {
            int nel = i / 2 + 1;
            double[] abv = this.ncmtbl[i - 1];
            this.ncmtbl[i] = new double[nel];
            double[] row = this.ncmtbl[i];
            row[0] = 1.0;
            for (int j = 1; j < nel; ++j) {
                row[j] = abv[j - 1] + (j < abv.length ? abv[j] : abv[j - 1]);
            }
        }
    }

    public double ncm(int n, int m) {
        return this.ncmtbl[n][m > n - m ? n - m : m];
    }

    public long ncm_l(int n, int m) {
        return Math.round(this.ncm(n, m));
    }

    public void print(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("row " + i + "  ");
            for (int j = 0; j < i; ++j) {
                System.out.print("" + this.ncm_l(i, j) + " ");
            }
            System.out.println();
        }
    }

    public static void main(String[] argv) {
        BinomialTable btbl = BinomialTable.getTable();
        btbl.print(20);
    }
}

