/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.stochastic;

import neurord.numeric.BaseCalc;
import neurord.numeric.stochastic.BinomialTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NGoTable {
    static final Logger log = LogManager.getLogger();
    public final double lnp;
    public final int n;
    final double[] cprob;
    int ncprob;
    public final BaseCalc.distribution_t mode;

    public NGoTable(int n, double lnp, BaseCalc.distribution_t mode) {
        this.lnp = lnp;
        this.n = n;
        this.mode = mode;
        double p = Math.exp(lnp);
        double lnq = Math.log(1.0 - p);
        switch (mode) {
            case BINOMIAL: {
                int i;
                BinomialTable btab = BinomialTable.getTable();
                double[] wk = new double[n + 1];
                double c = 0.0;
                this.ncprob = -1;
                for (i = n; i >= 0; --i) {
                    double pn = Math.exp((double)i * lnp + (double)(n - i) * lnq) * btab.ncm(n, i);
                    wk[i] = c += pn;
                    if (this.ncprob >= 0 || !(c > 1.0E-11)) continue;
                    this.ncprob = i;
                }
                if (this.ncprob == -1) {
                    this.ncprob = 0;
                }
                if (Math.abs(1.0 - c) > 1.0E-11) {
                    log.warn("cumulative probability miscount? " + c + " for n, p, nkept " + n + " " + p + " " + this.ncprob);
                }
                this.cprob = new double[this.ncprob + 1];
                for (i = 0; i < this.ncprob; ++i) {
                    this.cprob[i] = 1.0 - wk[i + 1];
                }
                this.cprob[this.ncprob] = 2.0;
                break;
            }
            case POISSON: {
                int i;
                double lambda = (double)n * Math.exp(lnp);
                double emlambda = Math.exp(-1.0 * lambda);
                this.ncprob = -1;
                int nmax = 4 * n + 20;
                double[] wk = new double[nmax];
                double lampnbynfac = 1.0;
                for (i = 0; i < nmax; ++i) {
                    double pn = emlambda * lampnbynfac;
                    lampnbynfac *= lambda / (double)(i + 1);
                    wk[i] = pn;
                    if (!((double)i > lambda) || this.ncprob >= 0 || !(pn < 1.0E-11)) continue;
                    this.ncprob = i;
                }
                if (this.ncprob < 0) {
                    log.warn("never terminated tabled? " + n + " " + lambda + " " + emlambda * lampnbynfac);
                }
                this.cprob = new double[this.ncprob + 1];
                this.cprob[0] = wk[0];
                for (i = 1; i < this.ncprob; ++i) {
                    this.cprob[i] = this.cprob[i - 1] + wk[i];
                }
                this.cprob[this.ncprob] = 2.0;
                break;
            }
            default: {
                throw new RuntimeException("unrecognized distribution " + (Object)((Object)mode));
            }
        }
    }

    public int nGoBS(double r) {
        int bot = 0;
        int top = this.ncprob;
        while (top - bot > 1) {
            int ic = (bot + top) / 2;
            if (r < this.cprob[ic]) {
                top = ic;
                continue;
            }
            bot = ic;
        }
        return bot;
    }

    public int nGo(double r) {
        int ret = 0;
        while (this.cprob[ret] < r) {
            ++ret;
        }
        return ret;
    }

    public double rnGo(double r) {
        double ret = 0.0;
        if (r < this.cprob[0]) {
            ret = r / this.cprob[0];
        } else {
            int ia = 1;
            while (this.cprob[ia] < r) {
                ++ia;
            }
            ret = (double)ia + (r - this.cprob[ia - 1]) / (this.cprob[ia] - this.cprob[ia - 1]);
        }
        return ret;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[n=" + this.n + " p=" + Math.exp(this.lnp) + " njmax=" + this.ncprob + " mode=" + (Object)((Object)this.mode) + "]";
    }

    public void print() {
        int i;
        System.out.print(this.toString() + "\np(n < i): ");
        for (i = 0; i < this.ncprob; ++i) {
            System.out.print(String.format("%.3g, ", this.cprob[i]));
        }
        System.out.print("\nngo, rngo for ten equally spaced randoms starting at 0.001 ");
        for (i = 0; i < 10; ++i) {
            double r = 0.001 + 0.99 * ((double)i / 9.0);
            System.out.print(String.format("(%d, %.3g) ", this.nGo(r), this.rnGo(r)));
        }
        System.out.print("\n\n");
    }

    private long lookupTimeSeq() {
        long t0 = System.currentTimeMillis();
        double rnx = 1.0E7;
        int njt = 0;
        int i = 0;
        while ((double)i < rnx) {
            njt += this.nGo((double)i / rnx);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private long lookupTimeBS() {
        long t0 = System.currentTimeMillis();
        double rnx = 1.0E7;
        int njt = 0;
        int i = 0;
        while ((double)i < rnx) {
            njt += this.nGoBS((double)i / rnx);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private long lookupTimeSwitch() {
        long t0 = System.currentTimeMillis();
        double rnx = 1.0E7;
        int njt = 0;
        int i = 0;
        while ((double)i < rnx) {
            njt += this.nGo((double)i / rnx);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static void dumpExamples() {
        new NGoTable(10, Math.log(0.1), BaseCalc.distribution_t.BINOMIAL).print();
        new NGoTable(10, Math.log(0.1), BaseCalc.distribution_t.POISSON).print();
        new NGoTable(90, Math.log(0.1), BaseCalc.distribution_t.BINOMIAL).print();
        new NGoTable(90, Math.log(0.1), BaseCalc.distribution_t.POISSON).print();
        new NGoTable(10, Math.log(0.01), BaseCalc.distribution_t.BINOMIAL).print();
        new NGoTable(10, Math.log(0.01), BaseCalc.distribution_t.POISSON).print();
        new NGoTable(90, Math.log(0.01), BaseCalc.distribution_t.BINOMIAL).print();
        new NGoTable(90, Math.log(0.01), BaseCalc.distribution_t.POISSON).print();
        new NGoTable(10, Math.log(0.001), BaseCalc.distribution_t.BINOMIAL).print();
        new NGoTable(10, Math.log(0.001), BaseCalc.distribution_t.POISSON).print();
        new NGoTable(90, Math.log(0.001), BaseCalc.distribution_t.BINOMIAL).print();
        new NGoTable(90, Math.log(0.001), BaseCalc.distribution_t.POISSON).print();
        new NGoTable(10, Math.log(1.0E-4), BaseCalc.distribution_t.BINOMIAL).print();
        new NGoTable(10, Math.log(1.0E-4), BaseCalc.distribution_t.POISSON).print();
        new NGoTable(90, Math.log(1.0E-4), BaseCalc.distribution_t.BINOMIAL).print();
        new NGoTable(90, Math.log(1.0E-4), BaseCalc.distribution_t.POISSON).print();
    }

    public static void main(String[] argv) {
        NGoTable.dumpExamples();
    }
}

