/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.stochastic;

import java.util.Random;
import neurord.numeric.math.MersenneTwister;
import neurord.numeric.math.NRRandom;

public class TimeTests {
    public static void main(String[] argv) {
        TimeTests.randomNumberTimes();
    }

    private static void randomNumberTimes() {
        long t1;
        double c;
        long t0;
        int i;
        int nrep = 3;
        double rnrn = 1.0E7;
        Random random = new Random();
        for (i = 0; i < nrep; ++i) {
            t0 = System.currentTimeMillis();
            c = 0.0;
            int j = 0;
            while ((double)j < rnrn) {
                c += (double)random.nextFloat();
                ++j;
            }
            t1 = System.currentTimeMillis();
            System.out.println("util.random t = " + (t1 - t0));
        }
        for (i = 0; i < nrep; ++i) {
            t0 = System.currentTimeMillis();
            c = 0.0;
            int j = 0;
            while ((double)j < rnrn) {
                c += NRRandom.random();
                ++j;
            }
            t1 = System.currentTimeMillis();
            System.out.println("NRRandom t = " + (t1 - t0));
        }
        MersenneTwister mtw = new MersenneTwister();
        for (int i2 = 0; i2 < nrep; ++i2) {
            long t02 = System.currentTimeMillis();
            double c2 = 0.0;
            int j = 0;
            while ((double)j < rnrn) {
                c2 += (double)mtw.random();
                ++j;
            }
            long t12 = System.currentTimeMillis();
            System.out.println("MT t = " + (t12 - t02));
        }
    }
}

