/*
 * Decompiled with CFR 0.152.
 */
package neurord.util;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import neurord.util.Settings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LibUtil {
    static final Logger log = LogManager.getLogger(LibUtil.class);

    public static void addLibraryPaths(String ... paths) {
        String var = Settings.getProperty("java.library.path");
        for (String path : paths) {
            if (Arrays.asList(var.split(File.pathSeparator)).contains(path)) continue;
            var = var.isEmpty() ? path : var + File.pathSeparator + path;
            log.debug("Added {} to java.library.path", path);
        }
        System.setProperty("java.library.path", var);
        try {
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
        }
        catch (Exception e) {
            log.warn("Failed to do the magic thing to sys_paths");
        }
    }
}

