/*
 * Decompiled with CFR 0.152.
 */
package neurord.util;

import java.util.Properties;
import neurord.util.CustomFileAppender;
import neurord.util.Settings;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public abstract class Logging {
    static final Logger log = LogManager.getLogger();
    public static final Level NOTICE = Level.forName("NOTICE", 350);

    public static boolean setLogLevel(LoggerContext context, String logger, Level level) {
        LoggerConfig loggerConfig;
        LoggerContext ctx = context != null ? context : (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        if (!logger.equals("")) {
            try {
                Class.forName(logger);
            }
            catch (ClassNotFoundException e) {
                log.warn("Failed to find logger \"{}\": {}", logger, e);
                return false;
            }
        }
        if ((loggerConfig = config.getLoggerConfig(logger)).getName().equals(logger)) {
            loggerConfig.setLevel(level);
            log.debug("Setting logger level {}={}", logger, level);
        } else {
            log.debug("Creating logger {}={}", logger, level);
            loggerConfig = new LoggerConfig(logger, level, false);
            config.addLogger(logger, loggerConfig);
        }
        if (context == null) {
            ctx.updateLoggers();
        }
        return true;
    }

    public static void setLogLevels() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        boolean any = false;
        Properties props = Settings.getProperties();
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith("log.")) continue;
            String logger = key.substring(4);
            String value = props.getProperty(key);
            Level level = Level.getLevel(value.toUpperCase());
            if (level == null) {
                log.warn("Unrecognized level \"{}\"", value);
                continue;
            }
            if (!Logging.setLogLevel(ctx, logger, level)) continue;
            any = true;
        }
        if (any) {
            ctx.updateLoggers();
        }
    }

    public static void configureConsoleLogging() {
        if (System.console() != null) {
            Logger logger = LogManager.getLogger("");
            org.apache.logging.log4j.core.Logger coreLogger = (org.apache.logging.log4j.core.Logger)logger;
            LoggerContext context = coreLogger.getContext();
            Configuration configuration = context.getConfiguration();
            coreLogger.addAppender((Appender)configuration.getAppender("Console"));
        }
    }

    public static void configureFileLogging(String logfile) {
        if (!logfile.equals("no")) {
            CustomFileAppender.addFileAppender(logfile);
        }
        Logging.setLogLevels();
    }
}

