/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import org.jblas.exceptions.LapackException;

public class JavaBlas {
    public static void rswap(int n, double[] dx, int dxIdx, int incx, double[] dy, int dyIdx, int incy) {
        if (incx == 1 && incy == 1 && dxIdx == 0 && dyIdx == 0) {
            for (int i = 0; i < n; ++i) {
                double z = dx[i];
                dx[i] = dy[i];
                dy[i] = z;
            }
        } else {
            int xi = dxIdx;
            int yi = dyIdx;
            for (int c = 0; c < n; ++c) {
                double z = dx[xi];
                dx[xi] = dy[yi];
                dy[yi] = z;
                xi += incx;
                yi += incy;
            }
        }
    }

    public static void rcopy(int n, double[] dx, int dxIdx, int incx, double[] dy, int dyIdx, int incy) {
        if (dxIdx < 0 || dxIdx + (n - 1) * incx >= dx.length) {
            throw new LapackException("Java.raxpy", "Parameters for x aren't valid! (n = " + n + ", dx.length = " + dx.length + ", dxIdx = " + dxIdx + ", incx = " + incx + ")");
        }
        if (dyIdx < 0 || dyIdx + (n - 1) * incy >= dy.length) {
            throw new LapackException("Java.raxpy", "Parameters for y aren't valid! (n = " + n + ", dy.length = " + dy.length + ", dyIdx = " + dyIdx + ", incy = " + incy + ")");
        }
        if (incx == 1 && incy == 1) {
            System.arraycopy(dx, dxIdx, dy, dyIdx, n);
        } else {
            int xi = dxIdx;
            int yi = dyIdx;
            for (int c = 0; c < n; ++c) {
                dy[yi] = dx[xi];
                xi += incx;
                yi += incy;
            }
        }
    }

    public static void raxpy(int n, double da, double[] dx, int dxIdx, int incx, double[] dy, int dyIdx, int incy) {
        if (dxIdx < 0 || dxIdx + (n - 1) * incx >= dx.length) {
            throw new LapackException("Java.raxpy", "Parameters for x aren't valid! (n = " + n + ", dx.length = " + dx.length + ", dxIdx = " + dxIdx + ", incx = " + incx + ")");
        }
        if (dyIdx < 0 || dyIdx + (n - 1) * incy >= dy.length) {
            throw new LapackException("Java.raxpy", "Parameters for y aren't valid! (n = " + n + ", dy.length = " + dy.length + ", dyIdx = " + dyIdx + ", incy = " + incy + ")");
        }
        if (incx == 1 && incy == 1 && dxIdx == 0 && dyIdx == 0) {
            if (da == 1.0) {
                for (int i = 0; i < n; ++i) {
                    int n2 = i;
                    dy[n2] = dy[n2] + dx[i];
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    int n3 = i;
                    dy[n3] = dy[n3] + da * dx[i];
                }
            }
        } else if (da == 1.0) {
            int c = 0;
            int xi = dxIdx;
            int yi = dyIdx;
            while (c < n) {
                int n4 = yi;
                dy[n4] = dy[n4] + dx[xi];
                ++c;
                xi += incx;
                yi += incy;
            }
        } else {
            int c = 0;
            int xi = dxIdx;
            int yi = dyIdx;
            while (c < n) {
                int n5 = yi;
                dy[n5] = dy[n5] + da * dx[xi];
                ++c;
                xi += incx;
                yi += incy;
            }
        }
    }

    public static void rzaxpy(int n, double[] dz, int dzIdx, int incz, double da, double[] dx, int dxIdx, int incx, double[] dy, int dyIdx, int incy) {
        if (dxIdx == 0 && incx == 1 && dyIdx == 0 && incy == 1 && dzIdx == 0 && incz == 1) {
            if (da == 1.0) {
                for (int c = 0; c < n; ++c) {
                    dz[c] = dx[c] + dy[c];
                }
            } else {
                for (int c = 0; c < n; ++c) {
                    dz[c] = da * dx[c] + dy[c];
                }
            }
        } else if (da == 1.0) {
            int c = 0;
            int xi = dxIdx;
            int yi = dyIdx;
            int zi = dzIdx;
            while (c < n) {
                dz[zi] = dx[xi] + dy[yi];
                ++c;
                xi += incx;
                yi += incy;
                zi += incz;
            }
        } else {
            int c = 0;
            int xi = dxIdx;
            int yi = dyIdx;
            int zi = dzIdx;
            while (c < n) {
                dz[zi] = da * dx[xi] + dy[yi];
                ++c;
                xi += incx;
                yi += incy;
                zi += incz;
            }
        }
    }

    public static void rzgxpy(int n, double[] dz, double[] dx, double[] dy) {
        for (int c = 0; c < n; ++c) {
            dz[c] = dx[c] + dy[c];
        }
    }

    public static double rdot(int n, double[] dx, int dxIdx, int incx, double[] dy, int dyIdx, int incy) {
        double s = 0.0;
        if (incx == 1 && incy == 1 && dxIdx == 0 && dyIdx == 0) {
            for (int i = 0; i < n; ++i) {
                s += dx[i] * dy[i];
            }
        } else {
            int c = 0;
            int xi = dxIdx;
            int yi = dyIdx;
            while (c < n) {
                s += dx[xi] * dy[yi];
                ++c;
                xi += incx;
                yi += incy;
            }
        }
        return s;
    }

    public static void rswap(int n, float[] dx, int dxIdx, int incx, float[] dy, int dyIdx, int incy) {
        if (incx == 1 && incy == 1 && dxIdx == 0 && dyIdx == 0) {
            for (int i = 0; i < n; ++i) {
                float z = dx[i];
                dx[i] = dy[i];
                dy[i] = z;
            }
        } else {
            int xi = dxIdx;
            int yi = dyIdx;
            for (int c = 0; c < n; ++c) {
                float z = dx[xi];
                dx[xi] = dy[yi];
                dy[yi] = z;
                xi += incx;
                yi += incy;
            }
        }
    }

    public static void rcopy(int n, float[] dx, int dxIdx, int incx, float[] dy, int dyIdx, int incy) {
        if (dxIdx < 0 || dxIdx + (n - 1) * incx >= dx.length) {
            throw new LapackException("Java.raxpy", "Parameters for x aren't valid! (n = " + n + ", dx.length = " + dx.length + ", dxIdx = " + dxIdx + ", incx = " + incx + ")");
        }
        if (dyIdx < 0 || dyIdx + (n - 1) * incy >= dy.length) {
            throw new LapackException("Java.raxpy", "Parameters for y aren't valid! (n = " + n + ", dy.length = " + dy.length + ", dyIdx = " + dyIdx + ", incy = " + incy + ")");
        }
        if (incx == 1 && incy == 1) {
            System.arraycopy(dx, dxIdx, dy, dyIdx, n);
        } else {
            int xi = dxIdx;
            int yi = dyIdx;
            for (int c = 0; c < n; ++c) {
                dy[yi] = dx[xi];
                xi += incx;
                yi += incy;
            }
        }
    }

    public static void raxpy(int n, float da, float[] dx, int dxIdx, int incx, float[] dy, int dyIdx, int incy) {
        if (dxIdx < 0 || dxIdx + (n - 1) * incx >= dx.length) {
            throw new LapackException("Java.raxpy", "Parameters for x aren't valid! (n = " + n + ", dx.length = " + dx.length + ", dxIdx = " + dxIdx + ", incx = " + incx + ")");
        }
        if (dyIdx < 0 || dyIdx + (n - 1) * incy >= dy.length) {
            throw new LapackException("Java.raxpy", "Parameters for y aren't valid! (n = " + n + ", dy.length = " + dy.length + ", dyIdx = " + dyIdx + ", incy = " + incy + ")");
        }
        if (incx == 1 && incy == 1 && dxIdx == 0 && dyIdx == 0) {
            if (da == 1.0f) {
                for (int i = 0; i < n; ++i) {
                    int n2 = i;
                    dy[n2] = dy[n2] + dx[i];
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    int n3 = i;
                    dy[n3] = dy[n3] + da * dx[i];
                }
            }
        } else if (da == 1.0f) {
            int c = 0;
            int xi = dxIdx;
            int yi = dyIdx;
            while (c < n) {
                int n4 = yi;
                dy[n4] = dy[n4] + dx[xi];
                ++c;
                xi += incx;
                yi += incy;
            }
        } else {
            int c = 0;
            int xi = dxIdx;
            int yi = dyIdx;
            while (c < n) {
                int n5 = yi;
                dy[n5] = dy[n5] + da * dx[xi];
                ++c;
                xi += incx;
                yi += incy;
            }
        }
    }

    public static void rzaxpy(int n, float[] dz, int dzIdx, int incz, float da, float[] dx, int dxIdx, int incx, float[] dy, int dyIdx, int incy) {
        if (dxIdx == 0 && incx == 1 && dyIdx == 0 && incy == 1 && dzIdx == 0 && incz == 1) {
            if (da == 1.0f) {
                for (int c = 0; c < n; ++c) {
                    dz[c] = dx[c] + dy[c];
                }
            } else {
                for (int c = 0; c < n; ++c) {
                    dz[c] = da * dx[c] + dy[c];
                }
            }
        } else if (da == 1.0f) {
            int c = 0;
            int xi = dxIdx;
            int yi = dyIdx;
            int zi = dzIdx;
            while (c < n) {
                dz[zi] = dx[xi] + dy[yi];
                ++c;
                xi += incx;
                yi += incy;
                zi += incz;
            }
        } else {
            int c = 0;
            int xi = dxIdx;
            int yi = dyIdx;
            int zi = dzIdx;
            while (c < n) {
                dz[zi] = da * dx[xi] + dy[yi];
                ++c;
                xi += incx;
                yi += incy;
                zi += incz;
            }
        }
    }

    public static void rzgxpy(int n, float[] dz, float[] dx, float[] dy) {
        for (int c = 0; c < n; ++c) {
            dz[c] = dx[c] + dy[c];
        }
    }

    public static float rdot(int n, float[] dx, int dxIdx, int incx, float[] dy, int dyIdx, int incy) {
        float s = 0.0f;
        if (incx == 1 && incy == 1 && dxIdx == 0 && dyIdx == 0) {
            for (int i = 0; i < n; ++i) {
                s += dx[i] * dy[i];
            }
        } else {
            int c = 0;
            int xi = dxIdx;
            int yi = dyIdx;
            while (c < n) {
                s += dx[xi] * dy[yi];
                ++c;
                xi += incx;
                yi += incy;
            }
        }
        return s;
    }
}

