/*
 * Decompiled with CFR 0.152.
 */
package neurord;

import java.lang.reflect.Constructor;
import neurord.model.SDRun;
import neurord.numeric.BaseCalc;
import neurord.numeric.grid.AdaptiveGridCalc;
import neurord.numeric.grid.DeterministicGridCalc;
import neurord.numeric.grid.SteppedStochasticGridCalc;
import neurord.numeric.pool.ForwardEulerPoolCalc;
import neurord.numeric.pool.ForwardExponentialPoolCalc;
import neurord.numeric.pool.ImplicitEulerPoolCalc;
import neurord.numeric.pool.RungeKutta4PoolCalc;
import neurord.numeric.pool.SemiImplicitEulerPoolCalc;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum SDCalcType {
    SMP_EULER(ForwardEulerPoolCalc.class),
    SMP_SEMI_IMPLICIT_EULER(SemiImplicitEulerPoolCalc.class),
    SMP_IMPLICIT_EULER(ImplicitEulerPoolCalc.class),
    SMP_FORWARD_EXPONENTIAL(ForwardExponentialPoolCalc.class),
    SMP_RK4(RungeKutta4PoolCalc.class),
    GRID_STEPPED_CONTINUOUS(DeterministicGridCalc.class),
    GRID_STEPPED_STOCHASTIC(SteppedStochasticGridCalc.class),
    GRID_EXACT(AdaptiveGridCalc.class),
    GRID_ADAPTIVE(AdaptiveGridCalc.class);

    static final Logger log;
    private final Class cls;

    private SDCalcType(Class cls) {
        this.cls = cls;
    }

    public BaseCalc getCalc(int trial, SDRun sdr) {
        try {
            Class[] argTyp = new Class[]{Integer.TYPE, SDRun.class};
            Constructor constructor = this.cls.getConstructor(argTyp);
            Object[] args = new Object[]{trial, sdr};
            return (BaseCalc)constructor.newInstance(args);
        }
        catch (Exception e) {
            log.error("{}: cannot instantiate {}", new Object[]{this, this.cls.getName(), e});
            throw new RuntimeException(e);
        }
    }

    static {
        log = LogManager.getLogger();
    }
}

