/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BatchFrame
extends JFrame {
    private JMenuBar batchMenuBar = new JMenuBar();
    private JMenu menuFile = new JMenu();
    private JMenuItem menuNew = new JMenuItem();
    private JMenuItem menuOpen = new JMenuItem();
    private JMenuItem menuSave = new JMenuItem();
    private JMenuItem menuSaveAs = new JMenuItem();
    private JMenuItem menuFileExit = new JMenuItem();
    private JMenu menuAction = new JMenu();
    private JMenuItem menuUndo = new JMenuItem();
    private JMenuItem menuAdd = new JMenuItem();
    private JMenuItem menuDel = new JMenuItem();
    private JMenuItem menuList = new JMenuItem();
    private JMenuItem menuViewBatch = new JMenuItem();
    private JMenu menuHelp = new JMenu();
    private JMenuItem menuHelpAbout = new JMenuItem();
    private JToolBar toolBar = new JToolBar();
    private JButton openButton = new JButton();
    private JButton saveButton = new JButton();
    private JButton paramFilesButton = new JButton();
    private JButton viewButton = new JButton();
    private JButton addButton = new JButton();
    private JButton delButton = new JButton();
    private JButton undoButton = new JButton();
    private JPanel batchFrameBase = new JPanel();
    private JLabel statusBar = new JLabel();
    private JLabel titleLabel = new JLabel();
    private JTabbedPane tabbedPane;
    private int tabbedCount = 0;
    private BatchElemPanel curTabbedPanel;
    private String updateCode = "NONE";
    private int updateIndex = -1;
    private BatchElemPanel updatePanel;
    private boolean dirty = false;
    private String batchFileName = null;
    private String workDirectory = null;
    private String smuWorkDir = null;
    private String smuFileName = null;
    private String laterDir = "";

    public BatchFrame(String string) {
        this.laterDir = string;
        this.workDirectory = string;
        this.smuWorkDir = string;
        this.setTitle("SNNAP:  Edit Batch File");
        Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("utshield.jpg"));
        this.setIconImage(image);
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("openFile.gif"));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("closeFile.gif"));
        ImageIcon imageIcon3 = new ImageIcon(this.getClass().getResource("param.gif"));
        ImageIcon imageIcon4 = new ImageIcon(this.getClass().getResource("add.gif"));
        ImageIcon imageIcon5 = new ImageIcon(this.getClass().getResource("cut.gif"));
        ImageIcon imageIcon6 = new ImageIcon(this.getClass().getResource("view.gif"));
        ImageIcon imageIcon7 = new ImageIcon(this.getClass().getResource("Undo24.gif"));
        TitledBorder titledBorder = new TitledBorder("");
        TitledBorder titledBorder2 = new TitledBorder("");
        TitledBorder titledBorder3 = new TitledBorder("");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.titleLabel.setForeground(new Color(0, 0, 128));
        this.titleLabel.setText("   " + this.workDirectory);
        this.titleLabel.setPreferredSize(new Dimension(500, 32));
        this.titleLabel.setToolTipText("Current working directory");
        this.statusBar.setForeground(new Color(0, 128, 255));
        this.statusBar.setPreferredSize(new Dimension(325, 40));
        this.statusBar.setHorizontalAlignment(0);
        this.statusBar.setHorizontalTextPosition(0);
        this.statusBar.setText("\ufffdThe University of Texas Health Science Center at Houston");
        this.menuFile.setText("File");
        this.menuNew.setText("New");
        this.menuNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.menuNew_actionPerformed(actionEvent);
            }
        });
        this.menuOpen.setText("Open");
        this.menuOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.menuOpen_actionPerformed(actionEvent);
            }
        });
        this.menuSave.setText("Save");
        this.menuSave.setEnabled(false);
        this.menuSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.menuSave_actionPerformed(actionEvent);
            }
        });
        this.menuSaveAs.setText("Save As");
        this.menuSaveAs.setEnabled(false);
        this.menuSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.menuSaveAs_actionPerformed(actionEvent);
            }
        });
        this.menuFileExit.setText("Exit");
        this.menuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.fileExit_actionPerformed(actionEvent);
            }
        });
        this.menuAction.setText("Action");
        this.menuAction.setEnabled(false);
        this.menuUndo.setText("Undo");
        this.menuUndo.setIcon(imageIcon7);
        this.menuUndo.setEnabled(false);
        this.menuUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.menuUndo_actionPerformed(actionEvent);
            }
        });
        this.menuAdd.setText("Add Batch Element");
        this.menuAdd.setEnabled(false);
        this.menuAdd.setIcon(imageIcon4);
        this.menuAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.menuAdd_actionPerformed(actionEvent);
            }
        });
        this.menuDel.setText("Delete Batch Element");
        this.menuDel.setEnabled(false);
        this.menuDel.setIcon(imageIcon5);
        this.menuDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.menuDel_actionPerformed(actionEvent);
            }
        });
        this.menuViewBatch.setText("Browse Batch File");
        this.menuViewBatch.setEnabled(false);
        this.menuViewBatch.setIcon(imageIcon6);
        this.menuViewBatch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.menuViewBatch_actionPerformed(actionEvent);
            }
        });
        this.menuList.setText("List Parameter File Tree");
        this.menuList.setIcon(imageIcon3);
        this.menuList.setEnabled(false);
        this.menuList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.menuList_actionPerformed(actionEvent);
            }
        });
        this.menuHelp.setText("Help");
        this.menuHelpAbout.setText("About");
        this.menuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.menuHelpAbout_actionPerformed(actionEvent);
            }
        });
        this.openButton.setIcon(imageIcon);
        this.openButton.setMaximumSize(new Dimension(45, 30));
        this.openButton.setPreferredSize(new Dimension(45, 30));
        this.openButton.setToolTipText("Open File");
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.openButton_actionPerformed(actionEvent);
            }
        });
        this.saveButton.setIcon(imageIcon2);
        this.saveButton.setEnabled(false);
        this.saveButton.setMaximumSize(new Dimension(45, 30));
        this.saveButton.setPreferredSize(new Dimension(45, 30));
        this.saveButton.setToolTipText("Save File");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.saveButton_actionPerformed(actionEvent);
            }
        });
        this.paramFilesButton.setIcon(imageIcon3);
        this.paramFilesButton.setEnabled(false);
        this.paramFilesButton.setMaximumSize(new Dimension(45, 30));
        this.paramFilesButton.setPreferredSize(new Dimension(45, 30));
        this.paramFilesButton.setToolTipText("List Paramter File Tree");
        this.paramFilesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.paramFilesButton_actionPerformed(actionEvent);
            }
        });
        this.viewButton.setIcon(imageIcon6);
        this.viewButton.setEnabled(false);
        this.viewButton.setToolTipText("Browse Batch File");
        this.viewButton.setMaximumSize(new Dimension(45, 30));
        this.viewButton.setPreferredSize(new Dimension(45, 30));
        this.viewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.viewButton_actionPerformed(actionEvent);
            }
        });
        this.addButton.setMaximumSize(new Dimension(45, 30));
        this.addButton.setPreferredSize(new Dimension(45, 30));
        this.addButton.setToolTipText("Add A Batch Element");
        this.addButton.setIcon(imageIcon4);
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.addButton_actionPerformed(actionEvent);
            }
        });
        this.delButton.setMaximumSize(new Dimension(45, 30));
        this.delButton.setPreferredSize(new Dimension(45, 30));
        this.delButton.setIcon(imageIcon5);
        this.delButton.setEnabled(false);
        this.delButton.setToolTipText("Delete A Batch Element");
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.delButton_actionPerformed(actionEvent);
            }
        });
        this.undoButton.setMaximumSize(new Dimension(45, 30));
        this.undoButton.setPreferredSize(new Dimension(45, 30));
        this.undoButton.setIcon(imageIcon7);
        this.undoButton.setMargin(new Insets(0, 1, 0, 1));
        this.undoButton.setToolTipText("Undo");
        this.undoButton.setEnabled(false);
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BatchFrame.this.undoButton_actionPerformed(actionEvent);
            }
        });
        this.batchFrameBase.setLayout(new BorderLayout(10, 10));
        this.batchFrameBase.setPreferredSize(new Dimension(325, 550));
        this.toolBar.setBackground(SystemColor.inactiveCaptionText);
        this.toolBar.setBorder(titledBorder);
        this.toolBar.setMargin(new Insets(10, 10, 10, 10));
        this.toolBar.setFloatable(false);
        this.toolBar.add(this.openButton);
        this.toolBar.add(this.saveButton);
        this.toolBar.add(Box.createRigidArea(new Dimension(10, 10)));
        this.toolBar.add(this.viewButton);
        this.toolBar.add(this.paramFilesButton);
        this.toolBar.add(Box.createRigidArea(new Dimension(10, 10)));
        this.toolBar.add(this.addButton);
        this.toolBar.add(this.delButton);
        this.toolBar.add(Box.createRigidArea(new Dimension(10, 10)));
        this.toolBar.add(this.undoButton);
        this.menuFile.add(this.menuNew);
        this.menuFile.add(this.menuOpen);
        this.menuFile.add(this.menuSave);
        this.menuFile.add(this.menuSaveAs);
        this.menuFile.addSeparator();
        this.menuFile.add(this.menuFileExit);
        this.menuAction.add(this.menuUndo);
        this.menuAction.addSeparator();
        this.menuAction.add(this.menuAdd);
        this.menuAction.add(this.menuDel);
        this.menuAction.addSeparator();
        this.menuAction.add(this.menuViewBatch);
        this.menuAction.add(this.menuList);
        this.menuHelp.add(this.menuHelpAbout);
        this.batchMenuBar.add(this.menuFile);
        this.batchMenuBar.add(this.menuAction);
        this.batchMenuBar.add(this.menuHelp);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBorder(new EmptyBorder(0, 10, 5, 10));
        this.tabbedPane.setBackground(new Color(160, 160, 160));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BatchFrame.this.tabbedPane_stateChanged(changeEvent);
            }
        });
        this.setJMenuBar(this.batchMenuBar);
        this.initBathElem();
        this.batchFrameBase.add((Component)this.titleLabel, "North");
        this.batchFrameBase.add((Component)this.tabbedPane, "Center");
        container.add((Component)this.toolBar, "North");
        container.add((Component)this.statusBar, "South");
        container.add((Component)this.batchFrameBase, "Center");
        this.setDefaultCloseOperation(0);
        this.setSize(new Dimension(450, 650));
        this.setLocation(100, 200);
    }

    private void initBathElem() {
        this.tabbedCount = 1;
        this.tabbedPane.removeAll();
        this.curTabbedPanel = new BatchElemPanel(0);
        this.tabbedPane.addTab("         ", this.curTabbedPanel);
        this.tabbedPane.setSelectedIndex(0);
        this.clean();
    }

    public String getSmuWorkDir() {
        return this.smuWorkDir;
    }

    public String getSmuFileName() {
        return this.smuFileName;
    }

    public void clean() {
        this.updateCode = "NONE";
        this.dirty = false;
        for (int i = 0; i < this.tabbedCount; ++i) {
            BatchElemPanel batchElemPanel = (BatchElemPanel)this.tabbedPane.getComponentAt(i);
            batchElemPanel.clean();
        }
    }

    public boolean parseLine(BufferedReader bufferedReader, String[] stringArray, String[] stringArray2) {
        String string = ">-------------";
        try {
            while (string.length() == 0 || string.charAt(0) == '>' || string.indexOf("-------") != -1 || string.indexOf(".......") != -1 || string.indexOf(">>") != -1) {
                string = bufferedReader.readLine();
                if (string == null) {
                    return false;
                }
                string = string.trim();
            }
            if (string.indexOf(">") != -1 && string.charAt(0) != '>') {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ">");
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                stringArray[0] = string2;
                stringArray2[0] = string3;
            } else {
                stringArray[0] = "";
                stringArray2[0] = "";
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error: " + iOException, "Error", 0);
            return false;
        }
        return true;
    }

    public void getSimulation() {
        JFileChooser jFileChooser = new JFileChooser(this.smuWorkDir);
        jFileChooser.setDialogTitle("Open File");
        jFileChooser.setFileFilter(new MyFilter("smu", "Simulation Files (*.smu)"));
        jFileChooser.setDialogType(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.smuFileName = file.getName();
            this.smuWorkDir = file.getParent() + File.separator;
        }
    }

    private void readBatchFile(String string) {
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        boolean bl = false;
        CBatchElem cBatchElem = null;
        File file = new File(string);
        char c = File.separatorChar;
        if (!file.isFile()) {
            string = string.replace('/', c);
        }
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Error: can't open " + string, "Error", 0);
            return;
        }
        this.undoButton.setEnabled(false);
        this.menuUndo.setEnabled(false);
        this.tabbedPane.removeAll();
        this.tabbedCount = 0;
        while (this.parseLine(bufferedReader, stringArray, stringArray2)) {
            this.curTabbedPanel = new BatchElemPanel(this.tabbedCount);
            if (!stringArray[0].equalsIgnoreCase("PARAMETER:")) continue;
            cBatchElem = new CBatchElem();
            cBatchElem.setWorkDir(this.workDirectory);
            cBatchElem.readParam(bufferedReader);
            this.curTabbedPanel.setBatchElem(cBatchElem);
            this.tabbedPane.addTab(this.curTabbedPanel.getParamFile(), this.curTabbedPanel);
            ++this.tabbedCount;
        }
        this.curTabbedPanel = (BatchElemPanel)this.tabbedPane.getSelectedComponent();
        try {
            fileReader.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error: can't close " + string, "Error", 0);
        }
    }

    private BatchElemPanel addBatchElem() {
        int n = 100;
        BatchElemPanel batchElemPanel = new BatchElemPanel(this.tabbedCount * 10);
        while (this.tabbedPane.indexOfComponent(batchElemPanel) >= 0) {
            batchElemPanel = new BatchElemPanel(this.tabbedCount + n);
            ++n;
        }
        this.updateCode = "ADD";
        this.updatePanel = (BatchElemPanel)this.tabbedPane.getSelectedComponent();
        this.updateIndex = this.tabbedPane.getSelectedIndex();
        this.undoButton.setEnabled(true);
        this.menuUndo.setEnabled(true);
        this.dirty = true;
        this.tabbedPane.addTab("      ", batchElemPanel);
        ++this.tabbedCount;
        this.tabbedPane.setSelectedComponent(batchElemPanel);
        this.curTabbedPanel = batchElemPanel;
        return this.curTabbedPanel;
    }

    private BatchElemPanel delBatchElem() {
        int n = -1;
        n = this.tabbedPane.getSelectedIndex();
        if (n >= 0) {
            this.updateCode = "DEL";
            this.updateIndex = n;
            this.updatePanel = (BatchElemPanel)this.tabbedPane.getSelectedComponent();
            this.undoButton.setEnabled(true);
            this.menuUndo.setEnabled(true);
            this.tabbedPane.removeTabAt(n);
            --this.tabbedCount;
            this.dirty = true;
        }
        this.curTabbedPanel = (BatchElemPanel)this.tabbedPane.getSelectedComponent();
        return this.curTabbedPanel;
    }

    private String getBatchFile() {
        String string = "";
        string = string + "        >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n";
        string = string + "        >>   Batch job file: *.bch      >>\n";
        string = string + "        >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n";
        string = string + "\n";
        String string2 = "";
        for (int i = 0; i < this.tabbedCount; ++i) {
            BatchElemPanel batchElemPanel = (BatchElemPanel)this.tabbedPane.getComponentAt(i);
            string2 = batchElemPanel.getBatchFileElem();
            if (string2.indexOf("Overflow") != -1) {
                return string2;
            }
            if (string2.length() == 0) {
                return "";
            }
            string = string + string2;
        }
        return string;
    }

    private void saveBatch(String string) {
        PrintWriter printWriter = null;
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(string);
            printWriter = new PrintWriter((Writer)fileWriter, true);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error: can't open '" + string + "' for writing", "Open Error", 0);
        }
        printWriter.println("        >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        printWriter.println("        >>   Batch job file: *.bch      >>");
        printWriter.println("        >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        printWriter.println();
        for (int i = 0; i < this.tabbedCount; ++i) {
            BatchElemPanel batchElemPanel = (BatchElemPanel)this.tabbedPane.getComponentAt(i);
            batchElemPanel.saveBatchElem(printWriter);
        }
        try {
            printWriter.flush();
            printWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error: can't close '" + string + "'", "Close Error", 0);
        }
    }

    public void fileExit_actionPerformed(ActionEvent actionEvent) {
        if (this.okToAbandon()) {
            MainMenuFrame.dirname = this.laterDir;
            this.dispose();
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201 && this.okToAbandon()) {
            MainMenuFrame.dirname = this.laterDir;
            this.dispose();
        }
    }

    private void viewBatchFile() {
        String string = this.getBatchFile();
        if (string.indexOf("Overflow") != -1) {
            return;
        }
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(this, "Some items are empty!", "Error", 0);
            return;
        }
        ViewBatchFileFrame viewBatchFileFrame = new ViewBatchFileFrame(this, this.workDirectory, this.batchFileName, string);
        viewBatchFileFrame.setLocation(this.getLocation().x + this.getWidth(), this.getLocation().y);
        viewBatchFileFrame.setVisible(true);
    }

    private int saveFile() {
        String string = this.getBatchFile();
        if (string.indexOf("Overflow") != -1) {
            return -1;
        }
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(this, "Some items are empty!", "Error", 0);
            return -1;
        }
        if (this.batchFileName == null) {
            JFileChooser jFileChooser = new JFileChooser(this.laterDir);
            jFileChooser.setDialogTitle("Save File");
            jFileChooser.setFileFilter(new MyFilter("bch", "Batch Files (*.bch)"));
            jFileChooser.setDialogType(1);
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.batchFileName = file.getPath().trim();
                if (this.batchFileName != null && !this.batchFileName.toLowerCase().endsWith(".bch")) {
                    this.batchFileName = this.batchFileName + ".bch";
                }
                this.laterDir = file.getParent() + File.separator;
                this.titleLabel.setText("   " + this.batchFileName);
            }
        }
        if (this.batchFileName != null) {
            this.saveBatch(this.batchFileName);
        }
        this.clean();
        return 1;
    }

    private void saveAsFile() {
        String string = this.getBatchFile();
        if (string.indexOf("Overflow") != -1) {
            return;
        }
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(this, "Some items are empty!", "Error", 0);
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(this.laterDir);
        if (this.batchFileName != null) {
            jFileChooser.setSelectedFile(new File(this.batchFileName));
            jFileChooser.ensureFileIsVisible(new File(this.batchFileName));
        }
        jFileChooser.setDialogTitle("Save-As File");
        jFileChooser.setFileFilter(new MyFilter("bch", "Batch Files (*.bch)"));
        jFileChooser.setDialogType(1);
        int n = jFileChooser.showSaveDialog(this);
        File file = jFileChooser.getSelectedFile();
        if (n == 0) {
            this.batchFileName = file.getPath().trim();
            if (this.batchFileName != null && !this.batchFileName.toLowerCase().endsWith(".bch")) {
                this.batchFileName = this.batchFileName + ".bch";
            }
            this.laterDir = file.getParent() + File.separator;
            this.titleLabel.setText("   " + this.batchFileName);
            this.saveBatch(this.batchFileName);
            this.clean();
        }
    }

    private boolean okToAbandon() {
        int n;
        if (!this.menuSave.isEnabled()) {
            return true;
        }
        for (n = 0; n < this.tabbedCount; ++n) {
            BatchElemPanel batchElemPanel = (BatchElemPanel)this.tabbedPane.getComponentAt(n);
            this.dirty = this.dirty || batchElemPanel.isDirty();
        }
        if (!this.dirty) {
            return true;
        }
        n = JOptionPane.showConfirmDialog(this, "File modified. Do you wish to save it?", "Save Modified File?", 1, 3);
        switch (n) {
            case 0: {
                return this.saveFile() == 1;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    private void newBatchFile() {
        if (this.okToAbandon()) {
            this.initBathElem();
            this.batchFileName = null;
            this.menuSave.setEnabled(true);
            this.menuSaveAs.setEnabled(true);
            this.menuAction.setEnabled(true);
            this.menuAdd.setEnabled(true);
            this.menuDel.setEnabled(true);
            this.menuViewBatch.setEnabled(true);
            this.menuList.setEnabled(true);
            this.saveButton.setEnabled(true);
            this.addButton.setEnabled(true);
            this.delButton.setEnabled(true);
            this.viewButton.setEnabled(true);
            this.paramFilesButton.setEnabled(true);
        }
    }

    private void openBatchFile() {
        if (this.okToAbandon()) {
            JFileChooser jFileChooser = new JFileChooser(this.laterDir);
            jFileChooser.setDialogTitle("Open File");
            jFileChooser.setFileFilter(new MyFilter("bch", "Batch Files (*.bch)"));
            jFileChooser.setDialogType(1);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.batchFileName = file.getPath().trim();
                this.laterDir = this.workDirectory = file.getParent() + File.separator;
                this.smuWorkDir = this.workDirectory;
                this.titleLabel.setText("   " + this.batchFileName);
                this.readBatchFile(this.batchFileName);
                this.clean();
                this.menuSave.setEnabled(true);
                this.menuSaveAs.setEnabled(true);
                this.menuAction.setEnabled(true);
                this.menuAdd.setEnabled(true);
                this.menuDel.setEnabled(true);
                this.menuViewBatch.setEnabled(true);
                this.menuList.setEnabled(true);
                this.saveButton.setEnabled(true);
                this.addButton.setEnabled(true);
                this.delButton.setEnabled(true);
                this.viewButton.setEnabled(true);
                this.paramFilesButton.setEnabled(true);
            }
        }
    }

    private void listParamFiles() {
        if (this.smuWorkDir == null || this.smuFileName == null) {
            this.getSimulation();
        }
        if (this.smuWorkDir != null && this.smuFileName != null) {
            ParamFilesFrame paramFilesFrame = new ParamFilesFrame(this, this.smuWorkDir, this.smuFileName);
            paramFilesFrame.setLocation(this.getLocation().x + this.getWidth(), this.getLocation().y);
            this.laterDir = this.smuWorkDir;
            paramFilesFrame.validate();
            paramFilesFrame.setVisible(true);
        }
    }

    void paramFilesFrame_mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.curTabbedPanel = (BatchElemPanel)this.tabbedPane.getSelectedComponent();
            String string = null;
            String string2 = null;
            JTree jTree = (JTree)mouseEvent.getSource();
            int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1) {
                TreePath treePath = jTree.getPathForRow(n);
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                string = treeNode.toString();
                int n2 = string.lastIndexOf(46);
                if (n2 > 0 && n2 < string.length() - 1) {
                    string2 = string.substring(n2 + 1);
                }
                if (this.curTabbedPanel != null) {
                    if (!this.updateCode.equals("OVERWRITTING") || this.updateIndex != this.tabbedPane.getSelectedIndex()) {
                        this.updateCode = "OVERWRITTING";
                        this.updatePanel = (BatchElemPanel)this.tabbedPane.getSelectedComponent();
                        this.updateIndex = this.tabbedPane.getSelectedIndex();
                        this.tabbedPane.removeTabAt(this.updateIndex);
                        int n3 = 100;
                        BatchElemPanel batchElemPanel = new BatchElemPanel(this.tabbedCount * 10);
                        while (this.tabbedPane.indexOfComponent(batchElemPanel) >= 0) {
                            batchElemPanel = new BatchElemPanel(this.tabbedCount + n3);
                            ++n3;
                        }
                        if (this.updateIndex != this.tabbedCount - 1) {
                            this.tabbedPane.insertTab("      ", null, batchElemPanel, "", this.updateIndex);
                        } else {
                            this.tabbedPane.addTab("      ", batchElemPanel);
                        }
                        this.tabbedPane.setSelectedIndex(this.updateIndex);
                        this.undoButton.setEnabled(true);
                        this.menuUndo.setEnabled(true);
                    }
                    this.curTabbedPanel = (BatchElemPanel)this.tabbedPane.getSelectedComponent();
                    this.curTabbedPanel.setParamFile(string);
                    if (string2.equalsIgnoreCase("TRT") || string2.equalsIgnoreCase("NEU")) {
                        this.curTabbedPanel.setParamType(string2);
                    } else {
                        this.curTabbedPanel.setParamType("FMU");
                    }
                    this.curTabbedPanel.resetSubBatchElemPanel(string2);
                    if (string.indexOf(File.separator) == -1) {
                        this.curTabbedPanel.readSubBatchElemParam(this.smuWorkDir + string);
                    } else {
                        this.curTabbedPanel.readSubBatchElemParam(string);
                    }
                    this.tabbedPane.setTitleAt(this.tabbedPane.getSelectedIndex(), string);
                }
            }
        }
    }

    void addButton_actionPerformed(ActionEvent actionEvent) {
        this.addBatchElem();
    }

    void delButton_actionPerformed(ActionEvent actionEvent) {
        this.delBatchElem();
    }

    void undoButton_actionPerformed(ActionEvent actionEvent) {
        if (this.updateCode.equals("ADD")) {
            this.tabbedPane.removeTabAt(--this.tabbedCount);
            this.tabbedPane.setSelectedComponent(this.updatePanel);
            this.updateCode = "NONE";
        } else if (this.updateCode.equals("DEL")) {
            this.tabbedPane.insertTab(this.updatePanel.getParamFile(), null, this.updatePanel, "", this.updateIndex);
            ++this.tabbedCount;
            this.updateCode = "NONE";
        } else if (this.updateCode.equals("OVERWRITTING")) {
            this.tabbedPane.removeTabAt(this.updateIndex);
            this.tabbedPane.insertTab(this.updatePanel.getParamFile(), null, this.updatePanel, "", this.updateIndex);
            this.updateCode = "NONE";
        }
        this.menuUndo.setEnabled(false);
        this.undoButton.setEnabled(false);
    }

    void saveButton_actionPerformed(ActionEvent actionEvent) {
        this.saveFile();
    }

    void openButton_actionPerformed(ActionEvent actionEvent) {
        this.openBatchFile();
    }

    void paramFilesButton_actionPerformed(ActionEvent actionEvent) {
        this.listParamFiles();
    }

    void viewButton_actionPerformed(ActionEvent actionEvent) {
        this.viewBatchFile();
    }

    void menuOpen_actionPerformed(ActionEvent actionEvent) {
        this.openBatchFile();
    }

    void menuSave_actionPerformed(ActionEvent actionEvent) {
        this.saveFile();
    }

    void menuSaveAs_actionPerformed(ActionEvent actionEvent) {
        this.saveAsFile();
    }

    void menuNew_actionPerformed(ActionEvent actionEvent) {
        this.newBatchFile();
    }

    void menuViewBatch_actionPerformed(ActionEvent actionEvent) {
        this.viewBatchFile();
    }

    void menuList_actionPerformed(ActionEvent actionEvent) {
        this.listParamFiles();
    }

    void menuAdd_actionPerformed(ActionEvent actionEvent) {
        this.addBatchElem();
    }

    void menuDel_actionPerformed(ActionEvent actionEvent) {
        this.delBatchElem();
    }

    void menuUndo_actionPerformed(ActionEvent actionEvent) {
        this.undoButton_actionPerformed(actionEvent);
    }

    void menuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        AboutDialog aboutDialog = new AboutDialog(this, "About", "SNNAP -- Batch Editor");
        Dimension dimension = aboutDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        aboutDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        aboutDialog.setVisible(true);
    }

    void tabbedPane_stateChanged(ChangeEvent changeEvent) {
        if (this.tabbedPane != null && this.tabbedPane.getSelectedIndex() >= 0) {
            this.curTabbedPanel = (BatchElemPanel)this.tabbedPane.getSelectedComponent();
        }
    }
}

