/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Calendar;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class SmuRun
extends JFrame
implements ActionListener {
    private final int MAX_CHNL = 20;
    private final int MAX_VAR = 60;
    private final int MAX_2FILE = 40;
    private JButton[] butt = new JButton[12];
    private SmuRun_Panel smuPanel;
    private SimuThread simulating;
    private int print_file = 0;
    private int is_2file = 0;
    private int step = 10;
    private String file_out = null;
    private String bchname = null;
    public static int colorFg = 1;
    public static int width;
    public static int height;
    public static Color bgColor;
    public static String smuname;
    public static String dirname;
    public static int flag;
    public static int stop_signal;
    public static int open_file;
    public static Vector lines;
    public static Vector cline;
    public static Vector strings;
    public static int page_num;
    public static int[] lines_size;
    public static int[] varColor;
    private boolean do_impose = true;
    private boolean do_print = false;
    protected static Properties printprops;

    public SmuRun(String string, String string2) {
        super("SNNAP:  On-Line View of Simulation");
        dirname = string;
        smuname = string2;
        if (smuname != null) {
            this.file_out = dirname + smuname.concat(".out");
        }
        if (lines != null) {
            lines = null;
        }
        lines = new Vector(8192, 2048);
        if (cline != null) {
            cline = null;
        }
        cline = new Vector(512, 128);
        if (strings != null) {
            strings = null;
        }
        strings = new Vector(256, 64);
        lines_size = new int[20];
        for (int i = 0; i < 20; ++i) {
            SmuRun.lines_size[i] = 0;
        }
        colorFg = 1;
        bgColor = Color.black;
        flag = 0;
        stop_signal = 0;
        open_file = 0;
        this.print_file = 0;
        Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("utshield.jpg"));
        this.setIconImage(image);
        Container container = this.getContentPane();
        container.setBackground(Color.lightGray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JMenuBar jMenuBar = new JMenuBar();
        this.makeFile_Menu(jMenuBar);
        this.makeGraph_Out_Menu(jMenuBar);
        this.makeData_Out_Menu(jMenuBar);
        this.makeReport_Menu(jMenuBar);
        this.makeHelp_Menu(jMenuBar);
        this.setJMenuBar(jMenuBar);
        this.butt[0] = this.makeButton("Start");
        this.butt[0].setToolTipText("Start the simulation");
        this.butt[1] = this.makeButton("Run Batch");
        this.butt[1].setToolTipText("Run batch simulation");
        this.butt[2] = this.makeButton("Abort");
        this.butt[2].setToolTipText("Abort current simulation");
        this.butt[3] = this.makeButton("Pause");
        this.butt[3].setToolTipText("Pause current simulation");
        this.butt[4] = this.makeButton("Resume");
        this.butt[4].setToolTipText("Resume paused simulation");
        this.butt[5] = this.makeButton("Clear");
        this.butt[5].setToolTipText("Clear simulation output");
        this.butt[6] = this.makeButton("Print");
        this.butt[6].setToolTipText("Print simulation output");
        this.butt[7] = this.makeButton("PS_Print");
        this.butt[7].setToolTipText("Print simulation in Postscript");
        this.butt[8] = this.makeButton("Color Fg");
        this.butt[8].setToolTipText("Toggle between color and black/white");
        this.butt[8].setActionCommand("Color Fg");
        this.butt[9] = this.makeButton("Background");
        this.butt[9].setToolTipText("Set background color");
        this.butt[10] = this.is_2file == 0 ? this.makeButton("No Save") : this.makeButton("Save to File");
        this.butt[10].setToolTipText("Toggle between save and no-save");
        this.butt[10].setActionCommand("is_2file");
        this.butt[11] = this.makeButton("Exit");
        this.butt[11].setToolTipText("Exit the simulation");
        for (int i = 0; i < 11; ++i) {
            this.butt[i].setEnabled(false);
        }
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(110, 500));
        jPanel.setBackground(new Color(224, 224, 224));
        jPanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10)));
        jPanel.setLayout(new GridLayout(0, 1, 5, 5));
        jPanel.add(this.butt[0]);
        jPanel.add(this.butt[1]);
        jPanel.add(this.butt[2]);
        jPanel.add(this.butt[3]);
        jPanel.add(this.butt[4]);
        jPanel.add(this.butt[5]);
        jPanel.add(this.butt[6]);
        jPanel.add(this.butt[7]);
        jPanel.add(this.butt[8]);
        jPanel.add(this.butt[9]);
        jPanel.add(this.butt[10]);
        jPanel.add(this.butt[11]);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        this.smuPanel = new SmuRun_Panel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(this.smuPanel, gridBagConstraints);
        container.add(this.smuPanel);
        Character c = new Character('\u00a9');
        JLabel jLabel = new JLabel(c.toString() + " The University of Texas Health Science Center at Houston", 0);
        jLabel.setForeground(new Color(64, 128, 160));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 4, 10, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                stop_signal = 1;
                SmuRun.this.simulating = null;
                strings = null;
                lines = null;
                cline = null;
                SmuRun.this.smuPanel = null;
                MainMenuFrame.dirname = dirname;
                SmuRun.this.dispose();
            }
        });
        this.setSize(860, 640);
        this.setLocation(60, 60);
        this.setVisible(true);
        if (smuname.length() > 0 && smuname.toLowerCase().endsWith(".smu")) {
            this.getJMenuBar().getMenu(0).getItem(1).setEnabled(true);
            this.loadSimulation(dirname, smuname);
            this.runSimulation();
        }
    }

    private String read_smu(String string) {
        String string2 = null;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(dirname + smuname);
            bufferedReader = new BufferedReader(fileReader);
            string2 = this.read_string(bufferedReader);
            while (string2 != null && string2.indexOf(string) == -1) {
                string2 = this.read_string(bufferedReader);
            }
            string2 = this.read_string(bufferedReader);
            fileReader.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, "Open File: " + dirname + smuname + " Failure", "Error", 0);
            string2 = null;
        }
        return string2;
    }

    private String read_string(BufferedReader bufferedReader) {
        String string = ">--------------";
        try {
            while (string.length() == 0 || string.charAt(0) == '>' || string.indexOf("-------") != -1 || string.indexOf(".......") != -1) {
                string = bufferedReader.readLine();
                if (string == null) {
                    return null;
                }
                if (string.indexOf(">") != -1 && string.charAt(0) != '>') {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ">");
                    string = stringTokenizer.nextToken();
                }
                string = string.trim();
            }
        }
        catch (IOException iOException) {
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, iOException, "Error", 0);
        }
        return string;
    }

    private JButton makeButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setRequestFocusEnabled(true);
        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
        jButton.setBackground(new Color(160, 192, 224));
        jButton.setPreferredSize(new Dimension(80, 30));
        jButton.addActionListener(this);
        return jButton;
    }

    private void setButtonStatus(boolean bl) {
        this.butt[0].setEnabled(bl);
        this.butt[1].setEnabled(bl);
        this.butt[2].setEnabled(!bl);
        this.butt[3].setEnabled(!bl);
        this.butt[4].setEnabled(false);
        this.butt[5].setEnabled(bl);
        this.butt[6].setEnabled(bl);
        this.butt[7].setEnabled(bl);
        this.butt[8].setEnabled(bl);
        this.butt[9].setEnabled(bl);
        this.butt[10].setEnabled(bl);
        this.butt[11].setEnabled(true);
    }

    private void makeFile_Menu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu("  File  ");
        JMenuItem jMenuItem = new JMenuItem("Load Simulation");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Reload Simulation");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setEnabled(false);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Modify Simulation");
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("Exit");
        jMenuItem4.addActionListener(this);
        jMenu.add(jMenuItem4);
        jMenuBar.add(jMenu);
    }

    private void makeGraph_Out_Menu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu("  Graphic Output ");
        JMenuItem jMenuItem = new JMenuItem("Show Setup");
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(false);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Modify");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        jMenuBar.add(jMenu);
    }

    private void makeData_Out_Menu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu("  Data Output ");
        JMenuItem jMenuItem = new JMenuItem("Output File Name");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Output Filter Step");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Output Variables");
        jMenuItem3.setEnabled(false);
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Modify");
        jMenuItem4.addActionListener(this);
        jMenu.add(jMenuItem4);
        jMenuBar.add(jMenu);
    }

    private void makeReport_Menu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu("  Report ");
        JMenuItem jMenuItem = new JMenuItem("Used Files");
        jMenuItem.setEnabled(false);
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
    }

    private void makeHelp_Menu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu("  Help  ");
        JMenuItem jMenuItem = new JMenuItem("About");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
    }

    private void loadSimulation(String string, String string2) {
        dirname = string;
        smuname = string2;
        this.clearwin(bgColor);
        if (smuname != null) {
            this.file_out = dirname + smuname.concat(".out");
        }
        if (lines != null) {
            lines = null;
        }
        lines = new Vector(8192, 4096);
        if (cline != null) {
            cline = null;
        }
        cline = new Vector(1024, 256);
        if (strings != null) {
            strings = null;
        }
        strings = new Vector(512, 128);
        lines_size = new int[20];
        for (int i = 0; i < 20; ++i) {
            SmuRun.lines_size[i] = 0;
        }
        if (strings != null) {
            strings.removeAllElements();
        }
        if (lines != null) {
            lines.removeAllElements();
        }
        if (cline != null) {
            cline.removeAllElements();
        }
        String string3 = this.read_smu("STORE_RESULTS:");
        try {
            this.is_2file = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            this.is_2file = 0;
        }
        this.setButtonStatus(true);
        this.getJMenuBar().getMenu(1).getItem(0).setEnabled(false);
        this.getJMenuBar().getMenu(2).getItem(2).setEnabled(false);
        this.getJMenuBar().getMenu(3).getItem(0).setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        new Rinput(dirname + smuname, 0, "0", "0");
        new Read_ing(dirname + smuname, "0", "1");
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.getJMenuBar().getMenu(0).getItem(1).setEnabled(true);
    }

    private void runSimulation() {
        if (smuname != null && flag == 0 && this.print_file == 0 && open_file == 0) {
            this.clearwin(bgColor);
            flag = 1;
            this.setButtonStatus(false);
            this.simulating = null;
            this.simulating = new SimuThread(this.smuPanel, dirname + smuname, width, height, this.is_2file, this.step, this.file_out, colorFg, null, 0, false, false, this.butt);
            this.simulating.setPriority(5);
            stop_signal = 0;
            this.simulating.start();
            this.getJMenuBar().getMenu(1).getItem(0).setEnabled(true);
            this.getJMenuBar().getMenu(2).getItem(2).setEnabled(true);
            this.getJMenuBar().getMenu(3).getItem(0).setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Load Simulation") && flag == 0 && this.print_file == 0) {
                open_file = 1;
                MyFileChooser myFileChooser = new MyFileChooser(dirname, "smu");
                int n = myFileChooser.showOpenDialog(this);
                if (n == 0) {
                    String string2 = myFileChooser.getSelectedFile().getName();
                    String string3 = myFileChooser.getCurrentDirectory().getAbsolutePath() + System.getProperty("file.separator");
                    if (string2 != null && string2.toLowerCase().endsWith(".smu")) {
                        this.loadSimulation(string3, string2);
                    }
                } else {
                    this.repaint();
                }
                open_file = 0;
            } else if (string.equals("Reload Simulation") && flag == 0 && this.print_file == 0) {
                open_file = 1;
                if (dirname != null && smuname != null && smuname.toLowerCase().endsWith(".smu")) {
                    this.clearwin(bgColor);
                    if (smuname != null) {
                        this.file_out = dirname + smuname.concat(".out");
                    }
                    if (lines != null) {
                        lines = null;
                    }
                    lines = new Vector(8192, 1024);
                    if (cline != null) {
                        cline = null;
                    }
                    cline = new Vector(256, 64);
                    if (strings != null) {
                        strings = null;
                    }
                    strings = new Vector(128, 32);
                    lines_size = new int[20];
                    for (int i = 0; i < 20; ++i) {
                        SmuRun.lines_size[i] = 0;
                    }
                    if (strings != null) {
                        strings.removeAllElements();
                    }
                    if (lines != null) {
                        lines.removeAllElements();
                    }
                    if (cline != null) {
                        cline.removeAllElements();
                    }
                    String string4 = this.read_smu("STORE_RESULTS:");
                    try {
                        this.is_2file = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.is_2file = 0;
                    }
                    this.setButtonStatus(true);
                    this.getJMenuBar().getMenu(1).getItem(0).setEnabled(false);
                    this.getJMenuBar().getMenu(2).getItem(2).setEnabled(false);
                    this.getJMenuBar().getMenu(3).getItem(0).setEnabled(false);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    new Rinput(dirname + smuname, 0, "0", "0");
                    new Read_ing(dirname + smuname, "0", "1");
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                open_file = 0;
            } else if (string.equals("Modify Simulation") && smuname != null && smuname.toLowerCase().endsWith(".smu")) {
                this.toBack();
                Edit_smu edit_smu = new Edit_smu(dirname, smuname);
                edit_smu.setVisible(true);
                edit_smu.toFront();
            } else if (string.equals("Exit") && flag == 0) {
                stop_signal = 1;
                this.simulating = null;
                strings = null;
                lines = null;
                cline = null;
                this.smuPanel = null;
                MainMenuFrame.dirname = dirname;
                this.dispose();
            } else if (string.equals("Show Setup") && smuname != null && flag == 0) {
                GraphSetup graphSetup = new GraphSetup(this, "Graphic Setup");
                graphSetup.setVisible(true);
                if (graphSetup.getAnswer().equals("Modify")) {
                    String string5 = this.read_smu("OUTPUT_SETUP:");
                    File file = new File(string5);
                    String string6 = file.getParent();
                    if (string6 == null) {
                        string6 = dirname;
                    }
                    string5 = file.getName();
                    if (string6 != null && !string6.endsWith(File.separator)) {
                        string6 = string6 + File.separator;
                    }
                    this.toBack();
                    Edit_ous edit_ous = new Edit_ous(dirname + smuname, string6, string5);
                    edit_ous.setVisible(true);
                    edit_ous.toFront();
                }
            } else if (string.equals("Output File Name") && flag == 0) {
                MyFileChooser myFileChooser;
                int n;
                File file = new File(this.file_out);
                String string7 = file.getParent();
                if (string7 == null) {
                    string7 = System.getProperty("user.dir");
                }
                if (string7 != null && !string7.endsWith(File.separator)) {
                    string7 = string7 + File.separator;
                }
                if ((n = (myFileChooser = new MyFileChooser(string7, "out")).showSaveDialog(this)) == 0) {
                    String string8 = myFileChooser.getSelectedFile().getName();
                    String string9 = myFileChooser.getCurrentDirectory().getAbsolutePath() + System.getProperty("file.separator");
                    if (string8 != null && string9 != null) {
                        this.file_out = string9 + string8;
                    }
                    if (!this.file_out.toLowerCase().endsWith(".out")) {
                        this.file_out = this.file_out + ".out";
                    }
                } else {
                    this.repaint();
                }
            } else if (string.equals("Output Filter Step") && flag == 0) {
                IntDialog intDialog = new IntDialog(this, "Output Filter", "Number of steps between saves", this.step);
                intDialog.setLocation(this.getLocation().x + this.getWidth() / 2, this.getLocation().y + this.getHeight() / 2);
                intDialog.setVisible(true);
                this.step = intDialog.getValue();
            } else if (string.equals("Output Variables") && smuname != null && flag == 0) {
                DataSetup dataSetup = new DataSetup(this, "Variables Saved to File", this.file_out, this.step);
                dataSetup.setVisible(true);
                if (dataSetup.getAnswer().equals("Modify")) {
                    String string10 = this.read_smu("OUTPUT_SETUP:");
                    File file = new File(string10);
                    String string11 = file.getParent();
                    if (string11 == null) {
                        string11 = dirname;
                    }
                    string10 = file.getName();
                    if (string11 != null && !string11.endsWith(File.separator)) {
                        string11 = string11 + File.separator;
                    }
                    this.toBack();
                    Edit_ous edit_ous = new Edit_ous(dirname + smuname, string11, string10);
                    edit_ous.setVisible(true);
                    this.toFront();
                }
            } else if (string.equals("Modify") && smuname != null && flag == 0) {
                String string12 = this.read_smu("OUTPUT_SETUP:");
                File file = new File(string12);
                String string13 = file.getParent();
                if (string13 == null) {
                    string13 = dirname;
                }
                string12 = file.getName();
                if (string13 != null && !string13.endsWith(File.separator)) {
                    string13 = string13 + File.separator;
                }
                this.toBack();
                Edit_ous edit_ous = new Edit_ous(dirname + smuname, string13, string12);
                edit_ous.setVisible(true);
                edit_ous.toFront();
            } else if (string.equals("Used Files") && dirname != null) {
                UsedFilesDialog usedFilesDialog = new UsedFilesDialog(this, "Report Used Files", dirname);
                usedFilesDialog.setVisible(true);
            } else if (string.equals("About")) {
                AboutDialog aboutDialog = new AboutDialog(this, "About", "SNNAP -- On-Line Simulation");
                Dimension dimension = aboutDialog.getPreferredSize();
                Dimension dimension2 = this.getSize();
                Point point = this.getLocation();
                aboutDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
                aboutDialog.setVisible(true);
            }
        } else if (actionEvent.getSource() instanceof JButton) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Start")) {
                this.runSimulation();
            } else if (string.equals("Run Batch") && flag == 0 && smuname != null && this.print_file == 0 && open_file == 0) {
                open_file = 1;
                JFileChooser jFileChooser = new JFileChooser(dirname);
                MyFileFilter myFileFilter = new MyFileFilter("bch", "File type");
                jFileChooser.setFileFilter(myFileFilter);
                PrintOptionPanel printOptionPanel = new PrintOptionPanel(this.do_impose, this.do_print);
                jFileChooser.setAccessory(printOptionPanel);
                int n = jFileChooser.showDialog(this, "Open");
                this.bchname = null;
                if (n == 0) {
                    String string14 = jFileChooser.getSelectedFile().getName();
                    String string15 = jFileChooser.getCurrentDirectory().getAbsolutePath() + System.getProperty("file.separator");
                    if (string14 != null && string14.toLowerCase().endsWith(".bch")) {
                        this.bchname = string15 + string14;
                        this.clearwin(bgColor);
                        this.do_impose = printOptionPanel.getImposeChecked();
                        this.do_print = printOptionPanel.getPrintEachChecked();
                        if (strings != null) {
                            strings.removeAllElements();
                        }
                        if (lines != null) {
                            lines.removeAllElements();
                        }
                        if (cline != null) {
                            cline.removeAllElements();
                        }
                    }
                }
                open_file = 0;
                if (this.bchname != null) {
                    flag = 1;
                    this.setButtonStatus(false);
                    this.simulating = null;
                    this.simulating = new SimuThread(this.smuPanel, dirname + smuname, width, height, this.is_2file, this.step, this.file_out, colorFg, this.bchname, 1, this.do_impose, this.do_print, this.butt);
                    this.simulating.setPriority(5);
                    stop_signal = 0;
                    this.simulating.start();
                    this.getJMenuBar().getMenu(1).getItem(0).setEnabled(true);
                    this.getJMenuBar().getMenu(2).getItem(2).setEnabled(true);
                    this.getJMenuBar().getMenu(3).getItem(0).setEnabled(true);
                }
            } else if (string.equals("Pause")) {
                if (this.simulating != null) {
                    this.simulating.suspend();
                }
                this.butt[3].setEnabled(false);
                this.butt[4].setEnabled(true);
            } else if (string.equals("Resume")) {
                if (this.simulating != null) {
                    this.simulating.resume();
                }
                this.butt[3].setEnabled(true);
                this.butt[4].setEnabled(false);
            } else if (string.equals("Abort")) {
                stop_signal = 1;
            } else if (string.equals("Print")) {
                if (flag == 0) {
                    this.printpage();
                }
            } else if (string.equals("PS_Print")) {
                if (flag == 0) {
                    this.printPSFile();
                }
            } else if (string.equals("Clear") && flag == 0 && this.print_file == 0) {
                this.clearwin(bgColor);
                if (strings != null) {
                    strings.removeAllElements();
                }
                if (lines != null) {
                    lines.removeAllElements();
                }
                if (cline != null) {
                    cline.removeAllElements();
                }
            } else if (string.equals("Color Fg") && flag == 0 && this.print_file == 0) {
                ++colorFg;
                if ((colorFg %= 2) == 1) {
                    this.butt[8].setText("Color Fg");
                } else {
                    this.butt[8].setText("B/W Fg");
                }
                if (bgColor.equals(Color.black)) {
                    bgColor = Color.white;
                }
                this.smuPanel.repaint();
            } else if (string.equals("Background") && flag == 0 && this.print_file == 0) {
                Color color = JColorChooser.showDialog(this, "Choose Background Color", bgColor);
                if (color != null) {
                    bgColor = color;
                    this.smuPanel.repaint();
                }
            } else if (string.equals("is_2file") && flag == 0) {
                ++this.is_2file;
                this.is_2file %= 2;
                if (this.is_2file == 1) {
                    this.butt[10].setText("Save to File");
                } else {
                    this.butt[10].setText("No Save");
                }
            } else if (string.equals("Exit") && flag == 0) {
                stop_signal = 1;
                this.simulating = null;
                strings = null;
                lines = null;
                cline = null;
                this.smuPanel = null;
                MainMenuFrame.dirname = dirname;
                this.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void printpage() {
        int n = 8;
        int n2 = 706;
        int n3 = 558;
        float f = 1.0f;
        float f2 = 1.0f;
        Graphics graphics = null;
        PrintJob printJob = null;
        Toolkit toolkit = this.smuPanel.getToolkit();
        if (smuname != null && this.print_file == 0) {
            this.print_file = 1;
            Cloneable cloneable = printprops;
            synchronized (cloneable) {
                printJob = toolkit.getPrintJob(this, dirname + smuname, printprops);
            }
            if (printJob != null) {
                cloneable = printJob.getPageDimension();
                n2 = (int)((double)((Dimension)cloneable).width * 100.0 / 110.0);
                n3 = (int)((double)((Dimension)cloneable).height * 78.5 / 85.0);
                f = Math.abs(n2 - width) < 10 ? 1.0f : (float)n2 / (float)width;
                f2 = Math.abs(n3 - height) < 10 ? 1.0f : (float)n3 / (float)height;
                n2 = (int)((float)width * f);
                n3 = (int)((float)height * f2);
                if (!this.do_print && page_num > 2) {
                    SmuRun.lines_size[1] = lines_size[page_num - 1];
                    SmuRun.lines_size[0] = 0;
                    page_num = 2;
                }
                for (int i = 1; i < page_num; ++i) {
                    Object object;
                    int n4;
                    graphics = printJob.getGraphics();
                    if (graphics == null) continue;
                    graphics.translate((((Dimension)cloneable).width - n2) * 5 / 9, (((Dimension)cloneable).height - n3) * 5 / 9);
                    graphics.drawRect(0, 0, n2, n3);
                    graphics.setFont(new Font("Serif", 0, n));
                    String string = Calendar.getInstance().getTime().toString();
                    graphics.setColor(Color.black);
                    graphics.drawLine(0, n3 - n - 8, n2, n3 - n - 8);
                    graphics.drawString("SNNAP On-Line Simulation (" + dirname + smuname + ")", 1, n3 - 5);
                    graphics.drawString(string, n2 - 170, n3 - 5);
                    if (colorFg == 1) {
                        for (n4 = 0; n4 < strings.size(); ++n4) {
                            object = (cString)strings.elementAt(n4);
                            graphics.setColor(new Color(((cString)object).color));
                            graphics.drawString(((cString)object).str, Math.round((float)((cString)object).x * f), Math.round((float)((cString)object).y * f2));
                        }
                        for (n4 = 0; n4 < cline.size(); ++n4) {
                            object = (Line)cline.elementAt(n4);
                            graphics.setColor(new Color(((Line)object).color));
                            graphics.drawLine(Math.round(f * (float)((Line)object).x1), Math.round(f2 * (float)((Line)object).y1), Math.round(f * (float)((Line)object).x2), Math.round(f2 * (float)((Line)object).y2));
                        }
                        for (n4 = lines_size[i - 1]; n4 < lines_size[i]; ++n4) {
                            object = (Curve)lines.elementAt(n4);
                            graphics.setColor(new Color(varColor[((Curve)object).varNo]));
                            graphics.drawLine(Math.round(f * ((Curve)object).x1), Math.round(f2 * ((Curve)object).y1), Math.round(f * ((Curve)object).x2), Math.round(f2 * ((Curve)object).y2));
                        }
                    } else {
                        graphics.setColor(Color.black);
                        for (n4 = 0; n4 < strings.size(); ++n4) {
                            object = (cString)strings.elementAt(n4);
                            graphics.drawString(((cString)object).str, Math.round((float)((cString)object).x * f), Math.round((float)((cString)object).y * f2));
                        }
                        for (n4 = 0; n4 < cline.size(); ++n4) {
                            object = (Line)cline.elementAt(n4);
                            graphics.drawLine(Math.round(f * (float)((Line)object).x1), Math.round(f2 * (float)((Line)object).y1), Math.round(f * (float)((Line)object).x2), Math.round(f2 * (float)((Line)object).y2));
                        }
                        graphics.setColor(Color.black);
                        for (n4 = lines_size[i - 1]; n4 < lines_size[i]; ++n4) {
                            object = (Curve)lines.elementAt(n4);
                            graphics.drawLine(Math.round(f * ((Curve)object).x1), Math.round(f2 * ((Curve)object).y1), Math.round(f * ((Curve)object).x2), Math.round(f2 * ((Curve)object).y2));
                        }
                    }
                    graphics.dispose();
                }
                PrintJob printJob2 = printJob;
                synchronized (printJob2) {
                    if (printJob != null) {
                        printJob.end();
                    }
                }
            }
        }
        this.print_file = 0;
    }

    public synchronized void clearwin(Color color) {
        Graphics graphics = this.smuPanel.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(new Color(0, 0, 64));
        graphics.fillRect(0, height - 16, width, height - 16);
        graphics.setColor(Color.white);
        graphics.setFont(new Font("Serif", 0, 13));
        String string = Calendar.getInstance().getTime().toString();
        graphics.drawString("SNNAP On-Line Simulation (" + dirname + smuname + ")", 1, height - 4);
        graphics.drawString(string, width - 170, height - 4);
        graphics.setFont(new Font("Serif", 0, 12));
        graphics.dispose();
        flag = 0;
        stop_signal = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void printPSFile() {
        int n = 32;
        int n2 = 726;
        int n3 = 558;
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 72.0;
        PrintJob printJob = null;
        Toolkit toolkit = this.smuPanel.getToolkit();
        if (smuname != null && this.print_file == 0) {
            this.print_file = 1;
            Cloneable cloneable = printprops;
            synchronized (cloneable) {
                printJob = toolkit.getPrintJob(this, dirname + smuname, printprops);
            }
            if (printJob != null) {
                block38: {
                    cloneable = printJob.getPageDimension();
                    d3 = printJob.getPageResolution();
                    n2 = (int)((double)((Dimension)cloneable).width * 100.0 / 110.0);
                    n3 = (int)((double)((Dimension)cloneable).height * 78.5 / 85.0);
                    d = Math.abs(n2 - width) < 10 ? 1.0 : (double)n2 / (double)width;
                    d2 = Math.abs(n3 - height) < 10 ? 1.0 : (double)n3 / (double)height;
                    n2 = (int)((double)width * d);
                    n3 = (int)((double)height * d2);
                    if (!this.do_print) {
                        try {
                            String string = "psPrint00.ps";
                            if (string == null) break block38;
                            PSPrint pSPrint = new PSPrint(dirname, string);
                            pSPrint.openPS();
                            PlotMessageStr plotMessageStr = new PlotMessageStr();
                            PlotPropertyStr plotPropertyStr = new PlotPropertyStr();
                            plotPropertyStr.plot_type = -6;
                            plotPropertyStr.linewidth = 1;
                            plotPropertyStr.unit = 2;
                            plotPropertyStr.xscale = 1.0f;
                            plotPropertyStr.yscale = 1.0f;
                            plotPropertyStr.xlg = 1;
                            plotPropertyStr.ylg = 1;
                            plotPropertyStr.xpos = (float)((int)((double)((float)(((Dimension)cloneable).width - n2) * 0.5f * 1000.0f) / d3)) / 1000.0f;
                            plotPropertyStr.ypos = (float)((int)((double)((float)(((Dimension)cloneable).height - n3) * 0.5f * 1000.0f) / d3)) / 1000.0f;
                            plotPropertyStr.xLen = (float)((int)((double)(1000 * n2) / d3)) / 1000.0f;
                            plotPropertyStr.yLen = (float)((int)((double)(1000 * n3) / d3)) / 1000.0f;
                            plotPropertyStr.xn = 0.0f;
                            plotPropertyStr.xm = plotPropertyStr.xLen;
                            plotPropertyStr.yn = 0.0f;
                            plotPropertyStr.ym = plotPropertyStr.yLen;
                            if (colorFg == 1) {
                                int n4;
                                for (n4 = 1; n4 < page_num; ++n4) {
                                    int n5 = lines_size[n4 - 1];
                                    int n6 = lines_size[n4];
                                    float[] fArray = new float[n6 - n5 + 2];
                                    float[] fArray2 = new float[n6 - n5 + 2];
                                    for (short i = 0; i < 60; ++i) {
                                        int n7 = 0;
                                        if (varColor[i] == -1) continue;
                                        for (int j = n5; j < n6; ++j) {
                                            Curve curve = (Curve)lines.elementAt(j);
                                            if (curve.varNo != i) continue;
                                            fArray[n7] = (float)(d * (double)curve.x1 / d3);
                                            fArray2[n7] = plotPropertyStr.yLen - (float)(d2 * (double)curve.y1 / d3);
                                            ++n7;
                                        }
                                        plotPropertyStr.plot_color = this.num2color(varColor[i]);
                                        pSPrint.subplot(n4, i, fArray, fArray2, n7, 0.1f, plotPropertyStr);
                                    }
                                }
                                for (n4 = 0; n4 < cline.size(); ++n4) {
                                    Line line = (Line)cline.elementAt(n4);
                                    pSPrint.drawLine((float)((int)(d * (double)line.x1 * 1000.0 / d3)) / 1000.0f, plotPropertyStr.yLen - (float)((int)(d2 * (double)line.y1 * 1000.0 / d3)) / 1000.0f, (float)((int)(d * (double)line.x2 * 1000.0 / d3)) / 1000.0f, plotPropertyStr.yLen - (float)((int)(d2 * (double)line.y2 * 1000.0 / d3)) / 1000.0f, 2, 2, this.num2color(line.color));
                                }
                                plotMessageStr.fontname = "Helvetica";
                                plotMessageStr.fontsize = n;
                                plotMessageStr.font_unchanged = 0;
                                plotMessageStr.unit = 2;
                                plotMessageStr.orientation = 1;
                                for (n4 = 0; n4 < strings.size(); ++n4) {
                                    cString cString2 = (cString)strings.elementAt(n4);
                                    plotMessageStr.fontcolor = this.num2color(cString2.color);
                                    plotMessageStr.msg = cString2.str;
                                    plotMessageStr.xp = (float)((int)((double)cString2.x * d * 1000.0 / d3)) / 1000.0f;
                                    plotMessageStr.yp = plotPropertyStr.yLen - (float)((int)((double)cString2.y * d2 * 1000.0 / d3)) / 1000.0f;
                                    pSPrint.showMessage(plotMessageStr, 24.0f);
                                }
                            } else {
                                int n8;
                                for (n8 = 1; n8 < page_num; ++n8) {
                                    int n9 = lines_size[n8 - 1];
                                    int n10 = lines_size[n8];
                                    float[] fArray = new float[n10 - n9 + 2];
                                    float[] fArray3 = new float[n10 - n9 + 2];
                                    plotPropertyStr.plot_color = "black";
                                    for (short i = 0; i < 60; ++i) {
                                        int n11 = 0;
                                        if (varColor[i] == -1) continue;
                                        for (int j = n9; j < n10; ++j) {
                                            Curve curve = (Curve)lines.elementAt(j);
                                            if (curve.varNo != i) continue;
                                            fArray[n11] = (float)(d * (double)curve.x1 / d3);
                                            fArray3[n11] = plotPropertyStr.yLen - (float)(d2 * (double)curve.y1 / d3);
                                            ++n11;
                                        }
                                        pSPrint.subplot(n8, i, fArray, fArray3, n11 - 1, 0.1f, plotPropertyStr);
                                    }
                                }
                                for (n8 = 0; n8 < cline.size(); ++n8) {
                                    Line line = (Line)cline.elementAt(n8);
                                    pSPrint.drawLine((float)((int)(d * (double)line.x1 * 1000.0 / d3)) / 1000.0f, plotPropertyStr.yLen - (float)((int)(d2 * (double)line.y1 * 1000.0 / d3)) / 1000.0f, (float)((int)(d * (double)line.x2 * 1000.0 / d3)) / 1000.0f, plotPropertyStr.yLen - (float)((int)(d2 * (double)line.y2 * 1000.0 / d3)) / 1000.0f, 2, 2, "black");
                                }
                                plotMessageStr.fontname = "Helvetica";
                                plotMessageStr.fontsize = n;
                                plotMessageStr.font_unchanged = 0;
                                plotMessageStr.unit = 2;
                                plotMessageStr.orientation = 1;
                                plotMessageStr.fontcolor = "black";
                                for (n8 = 0; n8 < strings.size(); ++n8) {
                                    cString cString3 = (cString)strings.elementAt(n8);
                                    plotMessageStr.msg = cString3.str;
                                    plotMessageStr.xp = (float)((int)((double)cString3.x * d * 1000.0 / d3)) / 1000.0f;
                                    plotMessageStr.yp = plotPropertyStr.yLen - (float)((int)((double)cString3.y * d2 * 1000.0 / d3)) / 1000.0f;
                                    pSPrint.showMessage(plotMessageStr, 24.0f);
                                }
                            }
                            pSPrint.drawRect(0.0f, plotPropertyStr.yLen - (float)((int)((double)(n3 * 1000) / d3)) / 1000.0f, (float)((int)((double)(n2 * 1000) / d3)) / 1000.0f, (float)((int)((double)(n3 * 1000) / d3)) / 1000.0f, 2, 1, "black");
                            pSPrint.drawLine(0.0f, plotPropertyStr.yLen - (float)((int)((double)(1000 * (n3 - n / 2)) / d3)) / 1000.0f, (float)((int)((double)(n2 * 1000) / d3)) / 1000.0f, plotPropertyStr.yLen - (float)((int)((double)(1000 * (n3 - n / 2)) / d3)) / 1000.0f, 2, 1, "black");
                            plotMessageStr.fontname = "Helvetica";
                            plotMessageStr.unit = 2;
                            plotMessageStr.fontcolor = "black";
                            plotMessageStr.msg = "SNNAP On-Line Simulation (" + dirname + smuname + ")";
                            plotMessageStr.xp = (float)((int)(1000.0 / d3)) / 1000.0f;
                            plotMessageStr.yp = plotPropertyStr.yLen - (float)((int)(1000.0 * ((double)n3 - 6.0) / d3)) / 1000.0f;
                            pSPrint.showMessage(plotMessageStr, n);
                            plotMessageStr.msg = Calendar.getInstance().getTime().toString();
                            plotMessageStr.xp = (float)((int)((double)(1000 * (n2 - 2)) / d3)) / 1000.0f;
                            plotMessageStr.yp = plotPropertyStr.yLen - (float)((int)(1000.0 * ((double)n3 - 6.0) / d3)) / 1000.0f;
                            plotMessageStr.orientation = 2;
                            pSPrint.showMessage(plotMessageStr, n);
                            pSPrint.closePS();
                        }
                        catch (IOException iOException) {
                            JFrame jFrame = new JFrame();
                            JOptionPane.showMessageDialog(jFrame, "File R/W Failure in PSPrint\n" + iOException, "Error", 0);
                        }
                    } else {
                        try {
                            for (int i = 1; i < page_num; ++i) {
                                Curve curve;
                                int n12;
                                int n13;
                                float[] fArray;
                                float[] fArray4;
                                int n14;
                                int n15;
                                String string = "";
                                if (string == null) continue;
                                string = "psPrint_" + i + ".ps";
                                PSPrint pSPrint = new PSPrint(dirname, string);
                                pSPrint.openPS();
                                PlotMessageStr plotMessageStr = new PlotMessageStr();
                                PlotPropertyStr plotPropertyStr = new PlotPropertyStr();
                                plotPropertyStr.plot_type = -6;
                                plotPropertyStr.linewidth = 1;
                                plotPropertyStr.unit = 2;
                                plotPropertyStr.xscale = 1.0f;
                                plotPropertyStr.yscale = 1.0f;
                                plotPropertyStr.xlg = 1;
                                plotPropertyStr.ylg = 1;
                                plotPropertyStr.xpos = (float)((int)((double)((float)(((Dimension)cloneable).width - n2) * 0.5f * 1000.0f) / d3)) / 1000.0f;
                                plotPropertyStr.ypos = (float)((int)((double)((float)(((Dimension)cloneable).height - n3) * 0.5f * 1000.0f) / d3)) / 1000.0f;
                                plotPropertyStr.xLen = (float)((int)((double)(1000 * n2) / d3)) / 1000.0f;
                                plotPropertyStr.yLen = (float)((int)((double)(1000 * n3) / d3)) / 1000.0f;
                                plotPropertyStr.xn = 0.0f;
                                plotPropertyStr.xm = plotPropertyStr.xLen;
                                plotPropertyStr.yn = 0.0f;
                                plotPropertyStr.ym = plotPropertyStr.yLen;
                                if (colorFg == 1) {
                                    n15 = lines_size[i - 1];
                                    n14 = lines_size[i];
                                    fArray4 = new float[n14 - n15 + 2];
                                    fArray = new float[n14 - n15 + 2];
                                    for (n13 = 0; n13 < 60; ++n13) {
                                        int n16 = 0;
                                        if (varColor[n13] == -1) continue;
                                        for (n12 = n15; n12 < n14; ++n12) {
                                            curve = (Curve)lines.elementAt(n12);
                                            if (curve.varNo != n13) continue;
                                            fArray4[n16] = (float)(d * (double)curve.x1 / d3);
                                            fArray[n16] = plotPropertyStr.yLen - (float)(d2 * (double)curve.y1 / d3);
                                            ++n16;
                                        }
                                        plotPropertyStr.plot_color = this.num2color(varColor[n13]);
                                        pSPrint.subplot(1, n13, fArray4, fArray, n16, 0.1f, plotPropertyStr);
                                    }
                                    for (n13 = 0; n13 < cline.size(); ++n13) {
                                        Line line = (Line)cline.elementAt(n13);
                                        pSPrint.drawLine((float)((int)(d * (double)line.x1 * 1000.0 / d3)) / 1000.0f, plotPropertyStr.yLen - (float)((int)(d2 * (double)line.y1 * 1000.0 / d3)) / 1000.0f, (float)((int)(d * (double)line.x2 * 1000.0 / d3)) / 1000.0f, plotPropertyStr.yLen - (float)((int)(d2 * (double)line.y2 * 1000.0 / d3)) / 1000.0f, 2, 2, this.num2color(line.color));
                                    }
                                    plotMessageStr.fontname = "Helvetica";
                                    plotMessageStr.fontsize = n;
                                    plotMessageStr.font_unchanged = 0;
                                    plotMessageStr.unit = 2;
                                    plotMessageStr.orientation = 1;
                                    for (n13 = 0; n13 < strings.size(); ++n13) {
                                        cString cString4 = (cString)strings.elementAt(n13);
                                        plotMessageStr.fontcolor = this.num2color(cString4.color);
                                        plotMessageStr.msg = cString4.str;
                                        plotMessageStr.xp = (float)((int)((double)cString4.x * d * 1000.0 / d3)) / 1000.0f;
                                        plotMessageStr.yp = plotPropertyStr.yLen - (float)((int)((double)cString4.y * d2 * 1000.0 / d3)) / 1000.0f;
                                        pSPrint.showMessage(plotMessageStr, 24.0f);
                                    }
                                } else {
                                    n15 = lines_size[i - 1];
                                    n14 = lines_size[i];
                                    fArray4 = new float[n14 - n15 + 2];
                                    fArray = new float[n14 - n15 + 2];
                                    plotPropertyStr.plot_color = "black";
                                    for (n13 = 0; n13 < 60; ++n13) {
                                        int n17 = 0;
                                        if (varColor[n13] == -1) continue;
                                        for (n12 = n15; n12 < n14; ++n12) {
                                            curve = (Curve)lines.elementAt(n12);
                                            if (curve.varNo != n13) continue;
                                            fArray4[n17] = (float)(d * (double)curve.x1 / d3);
                                            fArray[n17] = plotPropertyStr.yLen - (float)(d2 * (double)curve.y1 / d3);
                                            ++n17;
                                        }
                                        pSPrint.subplot(1, n13, fArray4, fArray, n17 - 1, 0.1f, plotPropertyStr);
                                    }
                                    for (n13 = 0; n13 < cline.size(); ++n13) {
                                        Line line = (Line)cline.elementAt(n13);
                                        pSPrint.drawLine((float)((int)(d * (double)line.x1 * 1000.0 / d3)) / 1000.0f, plotPropertyStr.yLen - (float)((int)(d2 * (double)line.y1 * 1000.0 / d3)) / 1000.0f, (float)((int)(d * (double)line.x2 * 1000.0 / d3)) / 1000.0f, plotPropertyStr.yLen - (float)((int)(d2 * (double)line.y2 * 1000.0 / d3)) / 1000.0f, 2, 2, "black");
                                    }
                                    plotMessageStr.fontname = "Helvetica";
                                    plotMessageStr.fontsize = n;
                                    plotMessageStr.font_unchanged = 0;
                                    plotMessageStr.unit = 2;
                                    plotMessageStr.orientation = 1;
                                    plotMessageStr.fontcolor = "black";
                                    for (n13 = 0; n13 < strings.size(); ++n13) {
                                        cString cString5 = (cString)strings.elementAt(n13);
                                        plotMessageStr.msg = cString5.str;
                                        plotMessageStr.xp = (float)((int)((double)cString5.x * d * 1000.0 / d3)) / 1000.0f;
                                        plotMessageStr.yp = plotPropertyStr.yLen - (float)((int)((double)cString5.y * d2 * 1000.0 / d3)) / 1000.0f;
                                        pSPrint.showMessage(plotMessageStr, 24.0f);
                                    }
                                }
                                pSPrint.drawRect(0.0f, plotPropertyStr.yLen - (float)((int)((double)(n3 * 1000) / d3)) / 1000.0f, (float)((int)((double)(n2 * 1000) / d3)) / 1000.0f, (float)((int)((double)(n3 * 1000) / d3)) / 1000.0f, 2, 1, "black");
                                pSPrint.drawLine(0.0f, plotPropertyStr.yLen - (float)((int)((double)(1000 * (n3 - n / 2)) / d3)) / 1000.0f, (float)((int)((double)(n2 * 1000) / d3)) / 1000.0f, plotPropertyStr.yLen - (float)((int)((double)(1000 * (n3 - n / 2)) / d3)) / 1000.0f, 2, 1, "black");
                                plotMessageStr.fontname = "Helvetica";
                                plotMessageStr.unit = 2;
                                plotMessageStr.fontcolor = "black";
                                plotMessageStr.msg = "SNNAP On-Line Simulation (" + dirname + smuname + ")";
                                plotMessageStr.xp = (float)((int)(1000.0 / d3)) / 1000.0f;
                                plotMessageStr.yp = plotPropertyStr.yLen - (float)((int)(1000.0 * ((double)n3 - 6.0) / d3)) / 1000.0f;
                                pSPrint.showMessage(plotMessageStr, n);
                                plotMessageStr.msg = Calendar.getInstance().getTime().toString();
                                plotMessageStr.xp = (float)((int)((double)(1000 * n2) / d3)) / 1000.0f;
                                plotMessageStr.yp = plotPropertyStr.yLen - (float)((int)(1000.0 * ((double)n3 - 6.0) / d3)) / 1000.0f;
                                plotMessageStr.orientation = 2;
                                pSPrint.showMessage(plotMessageStr, n);
                                pSPrint.closePS();
                            }
                        }
                        catch (IOException iOException) {
                            JFrame jFrame = new JFrame();
                            JOptionPane.showMessageDialog(jFrame, "File R/W Failure in PSPrint\n" + iOException, "Error", 0);
                        }
                    }
                }
                PrintJob printJob2 = printJob;
                synchronized (printJob2) {
                    if (printJob != null) {
                        printJob.end();
                    }
                }
            }
        }
        this.print_file = 0;
    }

    private String num2color(int n) {
        for (int i = 0; i < CONSTANT.color_int.length; ++i) {
            if (n != CONSTANT.color_int[i]) continue;
            return CONSTANT.color_str[i];
        }
        return "black";
    }

    static {
        bgColor = Color.black;
        smuname = null;
        dirname = null;
        flag = 0;
        stop_signal = 0;
        open_file = 0;
        page_num = 0;
        lines_size = null;
        varColor = new int[60];
        printprops = new Properties();
    }
}

