/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.text.DecimalFormat;
import javax.swing.JPanel;

class TrtPanel
extends JPanel {
    private final int MAX_cinj = 100;
    private final int MAX_minj = 100;
    private final int MAX_vclmp = 100;
    private final int MAX_iclmp = 100;
    private final int MAX_light = 100;
    private final int MAX_neuron = 10000;
    private final int X_MARGIN = 60;
    private final int Y_MARGIN = 60;
    private int ONEWIDTH = 480;
    private final int ONEHEIGHT = 150;
    private final int Y_DOWN = 12;
    private final int X_ORIGIN = 10;
    private final int Y_ORIGIN = 55;
    private final int X_WIDTH = this.ONEWIDTH + 100;
    private final int Y_HEIGHT = 200;
    private final int CINJ_PICK = 1;
    private final int MINJ_PICK = 2;
    private final int VCLMP_PICK = 3;
    private final int ICLMP_PICK = 4;
    private final int LIGHT_PICK = 5;
    private final int CUT = 10;
    private final int MODIFY = 11;
    private final int ADDCINJ = 13;
    private final int ADDMINJ = 14;
    private final int ADDVCLMP = 15;
    private final int ADDICLMP = 16;
    private final int ADDLIGHT = 17;
    private CINJ[] cinj = new CINJ[100];
    private MINJ[] minj = new MINJ[100];
    private VCLMP[] vclmp = new VCLMP[100];
    private ICLMP[] iclmp = new ICLMP[100];
    private LIGHT[] light = new LIGHT[100];
    private CINJ[] cinjbak = new CINJ[100];
    private MINJ[] minjbak = new MINJ[100];
    private VCLMP[] vclmpbak = new VCLMP[100];
    private ICLMP[] iclmpbak = new ICLMP[100];
    private LIGHT[] lightbak = new LIGHT[100];
    private NEURON[] neuron = new NEURON[10000];
    private int num_neuron = 0;
    private int n_cinj = 0;
    private int n_minj = 0;
    private int n_light = 0;
    private int n_vclmp = 0;
    private int n_iclmp = 0;
    private int treats_pick = -1;
    private int neuron_pick = -1;
    private int neuron_position = -1;
    private int item_index = -1;
    private int width;
    private int height;
    private double deltax = 0.0;
    private double deltay = 0.0;
    private int xstringstep = 1;
    private int ystringstep = 1;
    private int x;
    private int y;
    private int xx0;
    private int yy0;
    private int pre_neuron_pick = -1;
    private double[] xmax = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
    private double[] ymax = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
    private double[] xmin = new double[5];
    private double[] ymin = new double[5];

    public TrtPanel(CINJ[] cINJArray, MINJ[] mINJArray, VCLMP[] vCLMPArray, ICLMP[] iCLMPArray, LIGHT[] lIGHTArray, NEURON[] nEURONArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.cinj = cINJArray;
        this.minj = mINJArray;
        this.vclmp = vCLMPArray;
        this.iclmp = iCLMPArray;
        this.light = lIGHTArray;
        this.neuron = nEURONArray;
        this.num_neuron = n;
        this.n_cinj = n2;
        this.n_minj = n3;
        this.n_vclmp = n4;
        this.n_iclmp = n5;
        this.n_light = n6;
        this.treats_pick = n7;
        this.neuron_pick = n8;
        this.neuron_position = n9;
        this.item_index = n10;
        this.setBackground(Color.black);
        this.setOpaque(true);
    }

    public void set_para(CINJ[] cINJArray, MINJ[] mINJArray, VCLMP[] vCLMPArray, ICLMP[] iCLMPArray, LIGHT[] lIGHTArray, NEURON[] nEURONArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.cinj = cINJArray;
        this.minj = mINJArray;
        this.vclmp = vCLMPArray;
        this.iclmp = iCLMPArray;
        this.light = lIGHTArray;
        this.neuron = nEURONArray;
        this.num_neuron = n;
        this.n_cinj = n2;
        this.n_minj = n3;
        this.n_vclmp = n4;
        this.n_iclmp = n5;
        this.n_light = n6;
        this.treats_pick = n7;
        this.neuron_pick = n8;
        this.neuron_position = n9;
        this.item_index = n10;
    }

    public void paint(Graphics graphics) {
        this.width = this.getWidth();
        this.height = this.getHeight();
        graphics.setFont(new Font("Serif", 0, 12));
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.width, this.height);
        if (this.num_neuron > 0) {
            this.ONEWIDTH = this.width * 4 / 5;
            this.GetMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
            this.redraw_can(graphics);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void clearScreen() {
        Graphics graphics = this.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.dispose();
    }

    private void redraw_can(Graphics graphics) {
        if (this.num_neuron * 210 > 1200 && this.height < 1190) {
            this.setPreferredSize(new Dimension(this.width, this.num_neuron * 210));
            this.revalidate();
            this.width = this.getWidth();
            this.height = this.getHeight();
        } else if (this.num_neuron * 210 < 1200 && this.height > 1200) {
            this.setPreferredSize(new Dimension(this.width, 1200));
            this.revalidate();
            this.width = this.getWidth();
            this.height = this.getHeight();
        }
        this.x = 60;
        this.y = 60;
        this.xx0 = this.x;
        this.yy0 = this.y + 150;
        for (int i = 0; i < this.num_neuron; ++i) {
            this.drawaxis(graphics, this.x, this.y, this.xx0, this.yy0, this.ONEWIDTH, 150, this.xmin, this.xmax, this.ymin, this.ymax);
            this.drawtreats(graphics, this.neuron[i], this.xx0, this.yy0, this.ONEWIDTH, 150, this.xmin, this.xmax, this.ymin, this.ymax);
            graphics.setColor(Color.white);
            String string = "(" + this.neuron[i].name + ")";
            graphics.drawString(string, this.x + this.ONEWIDTH, this.y + 75);
            this.y += 210;
            this.yy0 += 210;
        }
        switch (this.treats_pick) {
            case 1: {
                this.drawcinj(this.item_index, this.neuron_position, graphics);
                break;
            }
            case 2: {
                this.drawminj(this.item_index, this.neuron_position, graphics);
                break;
            }
            case 3: {
                this.drawvclmp(this.item_index, this.neuron_position, graphics);
                break;
            }
            case 4: {
                this.drawiclmp(this.item_index, this.neuron_position, graphics);
                break;
            }
            case 5: {
                this.drawlight(this.item_index, this.neuron_position, graphics);
            }
        }
        if (this.pre_neuron_pick != -1) {
            graphics.setColor(Color.black);
            graphics.drawRect(5, 55 + this.pre_neuron_pick * 210, this.width - 20, 200);
        }
        if (this.neuron_pick != -1) {
            graphics.setColor(Color.cyan);
            graphics.drawRect(5, 55 + this.neuron_pick * 210, this.width - 20, 200);
            this.pre_neuron_pick = this.neuron_pick;
        }
    }

    private void GetMinMax(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n;
        for (n = 0; n < 5; ++n) {
            dArray[n] = 0.0;
            dArray3[n] = 0.0;
            dArray2[n] = 0.0;
            dArray4[n] = 0.0;
        }
        for (n = 0; n < this.num_neuron; ++n) {
            int n2;
            for (n2 = 0; n2 < this.n_cinj; ++n2) {
                if (this.neuron[n].cinjFlag[n2] != 1) continue;
                if (this.cinj[n2].start < dArray[0]) {
                    dArray[0] = this.cinj[n2].start;
                }
                if (this.cinj[n2].stop > dArray2[0]) {
                    dArray2[0] = this.cinj[n2].stop;
                }
                if (this.cinj[n2].magn > dArray4[0]) {
                    dArray4[0] = this.cinj[n2].magn;
                }
                if (!(this.cinj[n2].magn < dArray3[0])) continue;
                dArray3[0] = this.cinj[n2].magn;
            }
            for (n2 = 0; n2 < this.n_minj; ++n2) {
                if (this.neuron[n].minjFlag[n2] != 1) continue;
                if (this.minj[n2].start < dArray[0]) {
                    dArray[0] = this.minj[n2].start;
                }
                if (this.minj[n2].stop > dArray2[0]) {
                    dArray2[0] = this.minj[n2].stop;
                }
                if (this.minj[n2].magn > dArray4[1]) {
                    dArray4[1] = this.minj[n2].magn;
                }
                if (!(this.minj[n2].magn < dArray3[1])) continue;
                dArray3[1] = this.minj[n2].magn;
            }
            for (n2 = 0; n2 < this.n_iclmp; ++n2) {
                if (this.neuron[n].iclmpFlag[n2] != 1) continue;
                if (this.iclmp[n2].start < dArray[0]) {
                    dArray[0] = this.iclmp[n2].start;
                }
                if (this.iclmp[n2].stop > dArray2[0]) {
                    dArray2[0] = this.iclmp[n2].stop;
                }
                if (this.iclmp[n2].magn > dArray4[3]) {
                    dArray4[3] = this.iclmp[n2].magn;
                }
                if (!(this.iclmp[n2].magn < dArray3[3])) continue;
                dArray3[3] = this.iclmp[n2].magn;
            }
            for (n2 = 0; n2 < this.n_vclmp; ++n2) {
                if (this.neuron[n].vclmpFlag[n2] != 1) continue;
                if (this.vclmp[n2].start < dArray[0]) {
                    dArray[0] = this.vclmp[n2].start;
                }
                if (this.vclmp[n2].stop > dArray2[0]) {
                    dArray2[0] = this.vclmp[n2].stop;
                }
                if (this.vclmp[n2].magn > dArray4[2]) {
                    dArray4[2] = this.vclmp[n2].magn;
                }
                if (!(this.vclmp[n2].magn < dArray3[2])) continue;
                dArray3[2] = this.vclmp[n2].magn;
            }
            for (n2 = 0; n2 < this.n_light; ++n2) {
                if (this.neuron[n].lightFlag[n2] != 1) continue;
                if (this.light[n2].start < dArray[0]) {
                    dArray[0] = this.light[n2].start;
                }
                if (this.light[n2].stop > dArray2[0]) {
                    dArray2[0] = this.light[n2].stop;
                }
                if (this.light[n2].magn > dArray4[4]) {
                    dArray4[4] = this.light[n2].magn;
                }
                if (!(this.light[n2].magn < dArray3[4])) continue;
                dArray3[4] = this.light[n2].magn;
            }
        }
        for (n = 0; n < 5; ++n) {
            if (dArray[n] < 0.0) {
                dArray[n] = dArray[n] * 1.1;
            }
            dArray2[n] = dArray2[n] * 1.1;
            if (dArray3[n] < 0.0) {
                dArray3[n] = dArray3[n] * 1.1;
            }
            dArray4[n] = dArray4[n] * 1.1;
        }
    }

    private void drawaxis(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        String string;
        int n7;
        graphics.setColor(Color.white);
        graphics.drawLine(n, n4, n + n5, n4);
        this.draw_harrow(graphics, n + n5, n4);
        graphics.setColor(Color.red.darker());
        graphics.drawLine(n3, n2, n3, n2 + n6);
        this.draw_varrow(graphics, n3, n2);
        graphics.setColor(Color.blue.darker());
        graphics.drawLine(n3 - 10 + n5, n2 + 10, n3 - 10 + n5, n2 + n6 + 10);
        this.draw_varrow(graphics, n3 - 10 + n5, n2 + 10);
        graphics.setColor(Color.magenta.darker());
        graphics.drawLine(n3 - 20, n2 + 20, n3 - 20, n2 + n6 + 20);
        this.draw_varrow(graphics, n3 - 20, n2 + 20);
        graphics.setColor(Color.green.darker());
        graphics.drawLine(n3 - 30 + n5, n2 + 30, n3 - 30 + n5, n2 + n6 + 30);
        this.draw_varrow(graphics, n3 - 30 + n5, n2 + 30);
        graphics.setColor(Color.orange.darker());
        graphics.drawLine(n3 - 40, n2 + 40, n3 - 40, n2 + n6 + 40);
        this.draw_varrow(graphics, n3 - 40, n2 + 40);
        graphics.setColor(Color.white);
        graphics.drawLine(n3, n4, n3 - 40, n4 + 40);
        graphics.drawLine(n3 + n5, n4, n3 + n5 - 40, n4 + 40);
        double d = dArray2[0] - dArray[0];
        this.deltax = 1.0;
        this.xstringstep = 1;
        this.GetStepSize(d, 0);
        double d2 = 0.0;
        int n8 = 0;
        while (d2 < dArray2[0]) {
            int n9 = (int)((double)n3 + (d2 * (double)n5 / d + 0.5));
            n7 = n8 % this.xstringstep == 0 ? 5 : 2;
            graphics.setColor(Color.white);
            graphics.drawLine(n9, n4, n9, n4 - n7);
            if (n8 % this.xstringstep == 0) {
                string = this.UniDouble((double)n8 * this.deltax);
                graphics.drawString(string, n9, n4 + 12);
            }
            d2 += this.deltax;
            ++n8;
        }
        for (int i = 0; i < 5; ++i) {
            if (i == 0) {
                graphics.setColor(Color.red.darker());
            } else if (i == 1) {
                graphics.setColor(Color.blue.darker());
            } else if (i == 2) {
                graphics.setColor(Color.magenta.darker());
            } else if (i == 3) {
                graphics.setColor(Color.green.darker());
            } else {
                graphics.setColor(Color.orange.darker());
            }
            double d3 = dArray4[i] - dArray3[i];
            this.deltay = 1.0;
            this.ystringstep = 1;
            this.GetStepSize(d3, 1);
            double d4 = 0.0;
            n8 = 0;
            while (d4 < dArray4[i]) {
                int n10 = (int)((double)n4 - (d4 * (double)n6 / d3 + 0.5));
                n7 = n8 % this.ystringstep == 0 ? 5 : 2;
                graphics.drawLine(n3 - 10 * i + i % 2 * n5, n10 + 10 * i, n3 + n7 - 10 * i + i % 2 * n5, n10 + 10 * i);
                d4 += this.deltay;
                ++n8;
            }
            if (i > 1) {
                graphics.drawString("0.0", n3 - 10 * i + i % 2 * n5 + 4, n4 + 10 * (i + 1));
            }
            string = this.UniDouble(dArray4[i]);
            graphics.drawString(string, n - 13 * i + i % 2 * n5, n2 + 9 * i);
        }
    }

    private String UniDouble(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00##");
        return decimalFormat.format(d);
    }

    private void GetStepSize(double d, int n) {
        double d2 = 1.0;
        int n2 = 1;
        if (d <= 0.05) {
            d2 = 0.005;
            n2 = 2;
        } else if (d <= 0.1) {
            d2 = 0.01;
            n2 = 2;
        } else if (d <= 1.0) {
            d2 = 0.05;
            n2 = 4;
        } else if (d <= 3.0) {
            d2 = 0.1;
            n2 = 5;
        } else if (d <= 6.0) {
            d2 = 0.2;
            n2 = 5;
        } else if (d <= 12.0) {
            d2 = 0.5;
            n2 = 2;
        } else if (d < 30.0) {
            this.deltax = 1.0;
            n2 = 2;
        } else if (d <= 100.0) {
            d2 = 5.0;
            n2 = 2;
        } else {
            double d3 = d / 10.0;
            int n3 = (int)(d3 / 10.0);
            d2 = n3 *= 10;
            n2 = 5;
        }
        if (n == 0) {
            this.deltax = d2;
            this.xstringstep = n2;
        } else {
            this.deltay = d2;
            this.ystringstep = n2;
        }
    }

    private void drawtreats(Graphics graphics, NEURON nEURON, int n, int n2, int n3, int n4, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d;
        double d2;
        int n5;
        int n6;
        int n7;
        Point[] pointArray = new Point[1024];
        for (n7 = 0; n7 < 1024; ++n7) {
            pointArray[n7] = new Point(0, 0);
        }
        for (n6 = 0; n6 < this.n_cinj; ++n6) {
            if (nEURON.cinjFlag[n6] != 1) continue;
            n5 = 0;
            d2 = dArray2[0] - dArray[0];
            d = dArray4[0] - dArray3[0];
            pointArray[n5].x = n;
            pointArray[n5].y = n2;
            pointArray[++n5].x = n + (int)((double)n3 * this.cinj[n6].start / d2);
            pointArray[n5].y = n2;
            pointArray[++n5].x = pointArray[n5 - 1].x;
            pointArray[n5].y = n2 - (int)((double)n4 * this.cinj[n6].magn / d);
            pointArray[++n5].x = n + (int)((double)n3 * this.cinj[n6].stop / d2);
            pointArray[n5].y = pointArray[n5 - 1].y;
            pointArray[++n5].x = pointArray[n5 - 1].x;
            pointArray[n5].y = n2;
            pointArray[++n5].x = n + (int)((double)n3 * dArray2[0] / d2);
            pointArray[n5].y = n2;
            ++n5;
            for (n7 = 0; n7 < n5; ++n7) {
                ++pointArray[n7].x;
                --pointArray[n7].y;
            }
            graphics.setColor(Color.red.darker());
            for (n7 = 0; n7 < n5 - 1; ++n7) {
                graphics.drawLine(pointArray[n7].x, pointArray[n7].y, pointArray[n7 + 1].x, pointArray[n7 + 1].y);
            }
        }
        for (n6 = 0; n6 < this.n_minj; ++n6) {
            if (nEURON.minjFlag[n6] != 1) continue;
            n5 = 0;
            d2 = dArray2[0] - dArray[0];
            d = dArray4[1] - dArray3[1];
            pointArray[n5].x = n;
            pointArray[n5].y = n2;
            pointArray[++n5].x = n + (int)(this.minj[n6].start * (double)n3 / d2);
            pointArray[n5].y = n2;
            pointArray[++n5].x = pointArray[n5 - 1].x;
            pointArray[n5].y = n2 - (int)(this.minj[n6].magn * (double)n4 / d);
            pointArray[++n5].x = (int)((double)n + this.minj[n6].stop * (double)n3 / d2);
            pointArray[n5].y = pointArray[n5 - 1].y;
            pointArray[++n5].x = pointArray[n5 - 1].x;
            pointArray[n5].y = n2;
            pointArray[++n5].x = n + (int)((double)n3 * dArray2[0] / d2);
            pointArray[n5].y = n2;
            ++n5;
            for (n7 = 0; n7 < n5; ++n7) {
                pointArray[n7].x -= 9;
                pointArray[n7].y += 9;
            }
            graphics.setColor(Color.blue.darker());
            for (n7 = 0; n7 < n5 - 1; ++n7) {
                graphics.drawLine(pointArray[n7].x, pointArray[n7].y, pointArray[n7 + 1].x, pointArray[n7 + 1].y);
            }
        }
        for (n6 = 0; n6 < this.n_vclmp; ++n6) {
            if (nEURON.vclmpFlag[n6] != 1) continue;
            n5 = 0;
            d2 = dArray2[0] - dArray[0];
            d = dArray4[2] - dArray3[2];
            pointArray[n5].x = n;
            pointArray[n5].y = n2;
            pointArray[++n5].x = n + (int)(this.vclmp[n6].start * (double)n3 / d2);
            pointArray[n5].y = n2;
            pointArray[++n5].x = pointArray[n5 - 1].x;
            pointArray[n5].y = n2 - (int)(this.vclmp[n6].magn * (double)n4 / d);
            pointArray[++n5].x = n + (int)(this.vclmp[n6].stop * (double)n3 / d2);
            pointArray[n5].y = pointArray[n5 - 1].y;
            pointArray[++n5].x = pointArray[n5 - 1].x;
            pointArray[n5].y = n2;
            pointArray[++n5].x = n + (int)((double)n3 * dArray2[0] / d2);
            pointArray[n5].y = n2;
            ++n5;
            for (n7 = 0; n7 < n5; ++n7) {
                pointArray[n7].x -= 19;
                pointArray[n7].y += 19;
            }
            graphics.setColor(Color.magenta.darker());
            for (n7 = 0; n7 < n5 - 1; ++n7) {
                graphics.drawLine(pointArray[n7].x, pointArray[n7].y, pointArray[n7 + 1].x, pointArray[n7 + 1].y);
            }
        }
        for (n6 = 0; n6 < this.n_iclmp; ++n6) {
            if (nEURON.iclmpFlag[n6] != 1) continue;
            n5 = 0;
            d2 = dArray2[0] - dArray[0];
            d = dArray4[3] - dArray3[3];
            pointArray[n5].x = n;
            pointArray[n5].y = n2;
            pointArray[++n5].x = n + (int)(this.iclmp[n6].start * (double)n3 / d2);
            pointArray[n5].y = n2;
            pointArray[++n5].x = pointArray[n5 - 1].x;
            pointArray[n5].y = n2 - (int)(this.iclmp[n6].magn * (double)n4 / d);
            pointArray[++n5].x = n + (int)(this.iclmp[n6].stop * (double)n3 / d2);
            pointArray[n5].y = pointArray[n5 - 1].y;
            pointArray[++n5].x = pointArray[n5 - 1].x;
            pointArray[n5].y = n2;
            pointArray[++n5].x = n + (int)((double)n3 * dArray2[0] / d2);
            pointArray[n5].y = n2;
            ++n5;
            for (n7 = 0; n7 < n5; ++n7) {
                pointArray[n7].x -= 29;
                pointArray[n7].y += 29;
            }
            graphics.setColor(Color.green.darker());
            for (n7 = 0; n7 < n5 - 1; ++n7) {
                graphics.drawLine(pointArray[n7].x, pointArray[n7].y, pointArray[n7 + 1].x, pointArray[n7 + 1].y);
            }
        }
        for (n6 = 0; n6 < this.n_light; ++n6) {
            if (nEURON.lightFlag[n6] != 1) continue;
            n5 = 0;
            d2 = dArray2[0] - dArray[0];
            d = dArray4[4] - dArray3[4];
            pointArray[n5].x = n;
            pointArray[n5].y = n2;
            pointArray[++n5].x = n + (int)(this.light[n6].start * (double)n3 / d2);
            pointArray[n5].y = n2;
            pointArray[++n5].x = pointArray[n5 - 1].x;
            pointArray[n5].y = n2 - (int)(this.light[n6].magn * (double)n4 / d);
            pointArray[++n5].x = (int)((double)n + this.light[n6].stop * (double)n3 / d2);
            pointArray[n5].y = pointArray[n5 - 1].y;
            pointArray[++n5].x = pointArray[n5 - 1].x;
            pointArray[n5].y = n2;
            pointArray[++n5].x = n + (int)((double)n3 * dArray2[0] / d2);
            pointArray[n5].y = n2;
            ++n5;
            for (n7 = 0; n7 < n5; ++n7) {
                pointArray[n7].x -= 39;
                pointArray[n7].y += 39;
            }
            graphics.setColor(Color.orange.darker());
            for (n7 = 0; n7 < n5 - 1; ++n7) {
                graphics.drawLine(pointArray[n7].x, pointArray[n7].y, pointArray[n7 + 1].x, pointArray[n7 + 1].y);
            }
        }
    }

    private void draw_harrow(Graphics graphics, int n, int n2) {
        int n3 = n - 15;
        int n4 = n2 - 3;
        graphics.drawLine(n, n2, n3, n4);
        n4 = n2 + 3;
        graphics.drawLine(n, n2, n3, n4);
    }

    private void draw_varrow(Graphics graphics, int n, int n2) {
        int n3 = n + 3;
        int n4 = n2 + 15;
        graphics.drawLine(n, n2, n3, n4);
        n3 = n - 3;
        graphics.drawLine(n, n2, n3, n4);
    }

    private void drawcinj(int n, int n2, Graphics graphics) {
        int n3;
        Point[] pointArray = new Point[1024];
        int n4 = 60;
        int n5 = n2 * 210;
        for (n3 = 0; n3 < 1024; ++n3) {
            pointArray[n3] = new Point(0, 0);
        }
        int n6 = 0;
        double d = this.xmax[0] - this.xmin[0];
        double d2 = this.ymax[0] - this.ymin[0];
        pointArray[n6].x = n4;
        pointArray[n6].y = n5;
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.cinj[n].start / d);
        pointArray[n6].y = n5;
        pointArray[++n6].x = pointArray[n6 - 1].x;
        pointArray[n6].y = n5 - (int)(150.0 * this.cinj[n].magn / d2);
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.cinj[n].stop / d);
        pointArray[n6].y = pointArray[n6 - 1].y;
        pointArray[++n6].x = pointArray[n6 - 1].x;
        pointArray[n6].y = n5;
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.xmax[0] / d);
        pointArray[n6].y = n5;
        ++n6;
        for (n3 = 0; n3 < n6; ++n3) {
            ++pointArray[n3].x;
            --pointArray[n3].y;
        }
        graphics.setColor(Color.cyan);
        for (n3 = 0; n3 < n6 - 1; ++n3) {
            graphics.drawLine(pointArray[n3].x, pointArray[n3].y, pointArray[n3 + 1].x, pointArray[n3 + 1].y);
        }
    }

    private void drawminj(int n, int n2, Graphics graphics) {
        int n3;
        Point[] pointArray = new Point[10];
        int n4 = 60;
        int n5 = n2 * 210;
        for (n3 = 0; n3 < 10; ++n3) {
            pointArray[n3] = new Point(0, 0);
        }
        int n6 = 0;
        double d = this.xmax[0] - this.xmin[0];
        double d2 = this.ymax[1] - this.ymin[1];
        pointArray[n6].x = n4;
        pointArray[n6].y = n5;
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.minj[n].start / d);
        pointArray[n6].y = n5;
        pointArray[++n6].x = pointArray[n6 - 1].x;
        pointArray[n6].y = n5 - (int)(150.0 * this.minj[n].magn / d2);
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.minj[n].stop / d);
        pointArray[n6].y = pointArray[n6 - 1].y;
        pointArray[++n6].x = pointArray[n6 - 1].x;
        pointArray[n6].y = n5;
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.xmax[0] / d);
        pointArray[n6].y = n5;
        ++n6;
        for (n3 = 0; n3 < n6; ++n3) {
            pointArray[n3].x -= 9;
            pointArray[n3].y += 9;
        }
        graphics.setColor(Color.cyan);
        for (n3 = 0; n3 < n6 - 1; ++n3) {
            graphics.drawLine(pointArray[n3].x, pointArray[n3].y, pointArray[n3 + 1].x, pointArray[n3 + 1].y);
        }
    }

    private void drawvclmp(int n, int n2, Graphics graphics) {
        int n3;
        Point[] pointArray = new Point[10];
        int n4 = 60;
        int n5 = n2 * 210;
        for (n3 = 0; n3 < 10; ++n3) {
            pointArray[n3] = new Point(0, 0);
        }
        int n6 = 0;
        double d = this.xmax[0] - this.xmin[0];
        double d2 = this.ymax[2] - this.ymin[2];
        pointArray[n6].x = n4;
        pointArray[n6].y = n5;
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.vclmp[n].start / d);
        pointArray[n6].y = n5;
        pointArray[++n6].x = pointArray[n6 - 1].x;
        pointArray[n6].y = n5 - (int)(150.0 * this.vclmp[n].magn / d2);
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.vclmp[n].stop / d);
        pointArray[n6].y = pointArray[n6 - 1].y;
        pointArray[++n6].x = pointArray[n6 - 1].x;
        pointArray[n6].y = n5;
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.xmax[0] / d);
        pointArray[n6].y = n5;
        ++n6;
        for (n3 = 0; n3 < n6; ++n3) {
            pointArray[n3].x -= 19;
            pointArray[n3].y += 19;
        }
        graphics.setColor(Color.cyan);
        for (n3 = 0; n3 < n6 - 1; ++n3) {
            graphics.drawLine(pointArray[n3].x, pointArray[n3].y, pointArray[n3 + 1].x, pointArray[n3 + 1].y);
        }
    }

    private void drawiclmp(int n, int n2, Graphics graphics) {
        int n3;
        Point[] pointArray = new Point[10];
        int n4 = 60;
        int n5 = n2 * 210;
        for (n3 = 0; n3 < 10; ++n3) {
            pointArray[n3] = new Point(0, 0);
        }
        int n6 = 0;
        double d = this.xmax[0] - this.xmin[0];
        double d2 = this.ymax[3] - this.ymin[3];
        pointArray[n6].x = n4;
        pointArray[n6].y = n5;
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.iclmp[n].start / d);
        pointArray[n6].y = n5;
        pointArray[++n6].x = pointArray[n6 - 1].x;
        pointArray[n6].y = n5 - (int)(150.0 * this.iclmp[n].magn / d2);
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.iclmp[n].stop / d);
        pointArray[n6].y = pointArray[n6 - 1].y;
        pointArray[++n6].x = pointArray[n6 - 1].x;
        pointArray[n6].y = n5;
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.xmax[0] / d);
        pointArray[n6].y = n5;
        ++n6;
        for (n3 = 0; n3 < n6; ++n3) {
            pointArray[n3].x -= 29;
            pointArray[n3].y += 29;
        }
        graphics.setColor(Color.cyan);
        for (n3 = 0; n3 < n6 - 1; ++n3) {
            graphics.drawLine(pointArray[n3].x, pointArray[n3].y, pointArray[n3 + 1].x, pointArray[n3 + 1].y);
        }
    }

    private void drawlight(int n, int n2, Graphics graphics) {
        int n3;
        Point[] pointArray = new Point[10];
        int n4 = 60;
        int n5 = n2 * 210;
        for (n3 = 0; n3 < 10; ++n3) {
            pointArray[n3] = new Point(0, 0);
        }
        int n6 = 0;
        double d = this.xmax[0] - this.xmin[0];
        double d2 = this.ymax[4] - this.ymin[4];
        pointArray[n6].x = n4;
        pointArray[n6].y = n5;
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.light[n].start / d);
        pointArray[n6].y = n5;
        pointArray[++n6].x = pointArray[n6 - 1].x;
        pointArray[n6].y = n5 - (int)(150.0 * this.light[n].magn / d2);
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.light[n].stop / d);
        pointArray[n6].y = pointArray[n6 - 1].y;
        pointArray[++n6].x = pointArray[n6 - 1].x;
        pointArray[n6].y = n5;
        pointArray[++n6].x = n4 + (int)((double)this.ONEWIDTH * this.xmax[0] / d);
        pointArray[n6].y = n5;
        ++n6;
        for (n3 = 0; n3 < n6; ++n3) {
            pointArray[n3].x -= 39;
            pointArray[n3].y += 39;
        }
        graphics.setColor(Color.cyan);
        for (n3 = 0; n3 < n6 - 1; ++n3) {
            graphics.drawLine(pointArray[n3].x, pointArray[n3].y, pointArray[n3 + 1].x, pointArray[n3 + 1].y);
        }
    }
}

