/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public final class membrane_Dialog
extends JDialog
implements ActionListener,
ItemListener {
    private JCheckBox not_use;
    private JCheckBox do_use;
    private JCheckBox sphere;
    private JCheckBox cylinder;
    private JCheckBox both_open;
    private JCheckBox one_open;
    private JCheckBox both_close;
    private JTextField tfArea;
    private JTextField tfSphereDia;
    private JTextField tfC0;
    private JTextField tfCylinderDia;
    private JTextField tfC1;
    private JTextField tfCylinderLen;
    private int status = -1;
    private double preArea = 0.0;
    private int cur_type;
    private int N0;

    public membrane_Dialog(JFrame jFrame, String string, int n, double d, double d2, double d3, double d4, double d5, int n2, double d6) {
        super(jFrame, string, true);
        this.preArea = d;
        this.cur_type = n;
        this.N0 = n2;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(10, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 10));
        jPanel.add(new JLabel("Membrane Area"));
        this.tfArea = new JTextField("1.0", 15);
        this.tfArea.setMargin(new Insets(0, 3, 0, 3));
        this.tfArea.setDisabledTextColor(Color.darkGray);
        this.tfArea.setEnabled(false);
        MyDocumentListener myDocumentListener = new MyDocumentListener();
        this.tfArea.getDocument().addDocumentListener(myDocumentListener);
        this.tfArea.getDocument().putProperty("name", "Area");
        jPanel.add(this.tfArea);
        jPanel.add(new JLabel(" (um*um)"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1, 10, 10));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.not_use = new JCheckBox("Do not use membrane area", false);
        buttonGroup.add(this.not_use);
        this.not_use.addItemListener(this);
        jPanel2.add(this.not_use);
        this.do_use = new JCheckBox("Use membrane area directly", false);
        buttonGroup.add(this.do_use);
        this.do_use.addItemListener(this);
        jPanel2.add(this.do_use);
        this.sphere = new JCheckBox("Sphere membrane area", false);
        buttonGroup.add(this.sphere);
        this.sphere.addItemListener(this);
        jPanel2.add(this.sphere);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 0));
        jPanel3.add(new JLabel("              Diameter"));
        this.tfSphereDia = new JTextField("1.0", 10);
        this.tfSphereDia.getDocument().addDocumentListener(myDocumentListener);
        this.tfSphereDia.getDocument().putProperty("name", "SphereDia");
        jPanel3.add(this.tfSphereDia);
        jPanel3.add(new JLabel(" (um)"));
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 5, 0));
        jPanel4.add(new JLabel("Invagination factor"));
        this.tfC0 = new JTextField("1.0", 10);
        this.tfC0.getDocument().addDocumentListener(myDocumentListener);
        this.tfC0.getDocument().putProperty("name", "spFactor");
        jPanel4.add(this.tfC0);
        jPanel2.add(jPanel4);
        this.cylinder = new JCheckBox("Cylinder membrane area", false);
        buttonGroup.add(this.cylinder);
        this.cylinder.addItemListener(this);
        jPanel2.add(this.cylinder);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0, 5, 0));
        jPanel5.add(new JLabel("              Diameter"));
        this.tfCylinderDia = new JTextField("1.0", 10);
        this.tfCylinderDia.getDocument().addDocumentListener(myDocumentListener);
        this.tfCylinderDia.getDocument().putProperty("name", "CylinderDia");
        jPanel5.add(this.tfCylinderDia);
        jPanel5.add(new JLabel(" (um)"));
        jPanel2.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0, 5, 0));
        jPanel6.add(new JLabel("                  Length"));
        this.tfCylinderLen = new JTextField("10.0", 10);
        this.tfCylinderLen.getDocument().addDocumentListener(myDocumentListener);
        this.tfCylinderLen.getDocument().putProperty("name", "CylinderLen");
        jPanel6.add(this.tfCylinderLen);
        jPanel6.add(new JLabel(" (um)"));
        jPanel2.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0, 5, 0));
        jPanel7.add(new JLabel("Invagination factor"));
        this.tfC1 = new JTextField("1.0", 10);
        this.tfC1.getDocument().addDocumentListener(myDocumentListener);
        this.tfC1.getDocument().putProperty("name", "cyFactor");
        jPanel7.add(this.tfC1);
        jPanel2.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(1, 10, 0));
        jPanel8.setForeground(Color.black);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.both_open = new JCheckBox("Both ends open", true);
        buttonGroup2.add(this.both_open);
        this.both_open.addItemListener(this);
        jPanel8.add(this.both_open);
        this.one_open = new JCheckBox("One end open", false);
        buttonGroup2.add(this.one_open);
        this.one_open.addItemListener(this);
        jPanel8.add(this.one_open);
        this.both_close = new JCheckBox("Both ends closed", false);
        buttonGroup2.add(this.both_close);
        this.both_close.addItemListener(this);
        jPanel8.add(this.both_close);
        jPanel2.add(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(1, 80, 10));
        JButton jButton = this.addButton(jPanel9, "OK");
        JButton jButton2 = this.addButton(jPanel9, "Cancel");
        EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
        CompoundBorder compoundBorder = new CompoundBorder(BorderFactory.createEtchedBorder(), emptyBorder);
        jPanel2.setBorder(compoundBorder);
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "Center");
        container.add((Component)jPanel9, "South");
        container.add((Component)new JLabel(""), "West");
        container.add((Component)new JLabel(""), "East");
        this.setLocation(300, 220);
        this.pack();
        this.InitStatus(n, d, d2, d3, d4, d5, n2, d6);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        boolean bl = false;
        if (string.equals("OK")) {
            bl = true;
            try {
                Double.valueOf(this.tfArea.getText());
                Double.valueOf(this.tfSphereDia.getText());
                Double.valueOf(this.tfC0.getText());
                Double.valueOf(this.tfCylinderDia.getText());
                Double.valueOf(this.tfCylinderLen.getText());
                Double.valueOf(this.tfC1.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                JOptionPane.showMessageDialog((JFrame)this.getParent(), "Illegal digits in textfields", "Error", 0);
            }
            if (bl) {
                this.status = 1;
                this.dispose();
            }
        } else if (string.equals("Cancel")) {
            this.status = -1;
            this.dispose();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00##");
        if (this.not_use.isSelected()) {
            this.cur_type = 0;
            this.tfArea.setEnabled(false);
            this.tfArea.setText("1.0");
            this.tfSphereDia.setEnabled(false);
            this.tfC0.setEnabled(false);
            this.tfCylinderDia.setEnabled(false);
            this.tfCylinderLen.setEnabled(false);
            this.tfC1.setEnabled(false);
            this.both_open.setEnabled(false);
            this.one_open.setEnabled(false);
            this.both_close.setEnabled(false);
        } else if (this.do_use.isSelected()) {
            this.cur_type = 1;
            this.tfArea.setEnabled(true);
            String string = decimalFormat.format(this.preArea);
            this.tfArea.setText(string);
            this.tfSphereDia.setEnabled(false);
            this.tfC0.setEnabled(false);
            this.tfCylinderDia.setEnabled(false);
            this.tfCylinderLen.setEnabled(false);
            this.tfC1.setEnabled(false);
            this.both_open.setEnabled(false);
            this.one_open.setEnabled(false);
            this.both_close.setEnabled(false);
        } else if (this.sphere.isSelected()) {
            this.cur_type = 2;
            this.tfArea.setEnabled(false);
            Double d = new Double(this.tfSphereDia.getText());
            Double d2 = new Double(this.tfC0.getText());
            double d3 = Math.PI * d * d * d2;
            String string = decimalFormat.format(d3);
            this.tfArea.setText(string);
            this.tfSphereDia.setEnabled(true);
            this.tfC0.setEnabled(true);
            this.tfCylinderDia.setEnabled(false);
            this.tfCylinderLen.setEnabled(false);
            this.tfC1.setEnabled(false);
            this.both_open.setEnabled(false);
            this.one_open.setEnabled(false);
            this.both_close.setEnabled(false);
        } else if (this.cylinder.isSelected()) {
            this.cur_type = 3;
            this.tfArea.setEnabled(false);
            this.both_open.setEnabled(true);
            this.one_open.setEnabled(true);
            this.both_close.setEnabled(true);
            if (this.both_open.isSelected()) {
                this.N0 = 0;
            } else if (this.one_open.isSelected()) {
                this.N0 = 1;
            } else if (this.both_close.isSelected()) {
                this.N0 = 2;
            }
            double d = Double.valueOf(this.tfCylinderDia.getText());
            double d4 = Double.valueOf(this.tfCylinderLen.getText());
            double d5 = Double.valueOf(this.tfC1.getText());
            double d6 = (Math.PI * d * d4 + (double)this.N0 * Math.PI * d * d / 4.0) * d5;
            String string = decimalFormat.format(d6);
            this.tfArea.setText(string);
            this.tfSphereDia.setEnabled(false);
            this.tfC0.setEnabled(false);
            this.tfCylinderDia.setEnabled(true);
            this.tfCylinderLen.setEnabled(true);
            this.tfC1.setEnabled(true);
        }
    }

    private void InitStatus(int n, double d, double d2, double d3, double d4, double d5, int n2, double d6) {
        String string;
        DecimalFormat decimalFormat = new DecimalFormat("0.00##");
        if (n == 0) {
            this.tfArea.setEnabled(false);
            this.tfArea.setText("1.0");
            this.not_use.setSelected(true);
            this.tfSphereDia.setEnabled(false);
            this.tfC0.setEnabled(false);
            this.tfCylinderDia.setEnabled(false);
            this.tfCylinderLen.setEnabled(false);
            this.tfC1.setEnabled(false);
            this.both_open.setEnabled(false);
            this.one_open.setEnabled(false);
            this.both_close.setEnabled(false);
        } else if (n == 1) {
            this.tfArea.setEnabled(true);
            string = decimalFormat.format(d);
            this.tfArea.setText(string);
            this.do_use.setSelected(true);
            this.tfSphereDia.setEnabled(false);
            this.tfC0.setEnabled(false);
            this.tfCylinderDia.setEnabled(false);
            this.tfCylinderLen.setEnabled(false);
            this.tfC1.setEnabled(false);
            this.both_open.setEnabled(false);
            this.one_open.setEnabled(false);
            this.both_close.setEnabled(false);
        } else if (n == 2) {
            this.tfArea.setEnabled(false);
            string = decimalFormat.format(d2);
            this.tfSphereDia.setText(string);
            string = decimalFormat.format(d3);
            this.tfC0.setText(string);
            double d7 = Math.PI * d2 * d2 * d3;
            string = decimalFormat.format(d7);
            this.tfArea.setText(string);
            this.sphere.setSelected(true);
            this.tfSphereDia.setEnabled(true);
            this.tfC0.setEnabled(true);
            this.tfCylinderDia.setEnabled(false);
            this.tfCylinderLen.setEnabled(false);
            this.tfC1.setEnabled(false);
            this.both_open.setEnabled(false);
            this.one_open.setEnabled(false);
            this.both_close.setEnabled(false);
        } else if (n == 3) {
            this.tfArea.setEnabled(false);
            string = decimalFormat.format(d4);
            this.tfCylinderDia.setText(string);
            string = decimalFormat.format(d5);
            this.tfCylinderLen.setText(string);
            string = decimalFormat.format(d6);
            this.tfC1.setText(string);
            this.cylinder.setSelected(true);
            this.both_open.setEnabled(true);
            this.one_open.setEnabled(true);
            this.both_close.setEnabled(true);
            if (n2 == 0) {
                this.both_open.setSelected(true);
            } else if (n2 == 1) {
                this.one_open.setSelected(true);
            } else if (n2 == 2) {
                this.both_close.setSelected(true);
            }
            double d8 = (Math.PI * d4 * d5 + (double)n2 * Math.PI * d4 * d4 / 4.0) * d6;
            string = decimalFormat.format(d8);
            this.tfArea.setText(string);
            this.tfSphereDia.setEnabled(false);
            this.tfC0.setEnabled(false);
            this.tfCylinderDia.setEnabled(true);
            this.tfCylinderLen.setEnabled(true);
            this.tfC1.setEnabled(true);
        }
        string = decimalFormat.format(d2);
        this.tfSphereDia.setText(string);
        string = decimalFormat.format(d3);
        this.tfC0.setText(string);
        string = decimalFormat.format(d4);
        this.tfCylinderDia.setText(string);
        string = decimalFormat.format(d5);
        this.tfCylinderLen.setText(string);
        string = decimalFormat.format(d6);
        this.tfC1.setText(string);
    }

    private JButton addButton(Container container, String string) {
        JButton jButton = new JButton(string);
        container.add(jButton);
        jButton.addActionListener(this);
        jButton.setPreferredSize(new Dimension(60, 25));
        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
        return jButton;
    }

    public int getStatus() {
        return this.status;
    }

    public int getType() {
        return this.cur_type;
    }

    public int getN1() {
        return this.N0;
    }

    public double getArea() {
        return Double.valueOf(this.tfArea.getText());
    }

    public double getD0() {
        return Double.valueOf(this.tfSphereDia.getText());
    }

    public double getC0() {
        return Double.valueOf(this.tfC0.getText());
    }

    public double getD1() {
        return Double.valueOf(this.tfCylinderDia.getText());
    }

    public double getC1() {
        return Double.valueOf(this.tfC1.getText());
    }

    public double getL1() {
        return Double.valueOf(this.tfCylinderLen.getText());
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.textValueChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.textValueChanged(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void textValueChanged(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            DecimalFormat decimalFormat = new DecimalFormat("0.00##");
            double d = 0.0;
            String string = (String)document.getProperty("name");
            if ((string.equals("SphereDia") || string.equals("spFactor")) && membrane_Dialog.this.cur_type == 2) {
                try {
                    Double d2 = new Double(membrane_Dialog.this.tfSphereDia.getText());
                    Double d3 = new Double(membrane_Dialog.this.tfC0.getText());
                    d = Math.PI * d2 * d2 * d3;
                }
                catch (NumberFormatException numberFormatException) {
                    d = 0.0;
                }
                String string2 = decimalFormat.format(d);
                membrane_Dialog.this.tfArea.setText(string2);
            } else if ((string.equals("CylinderLen") || string.equals("CylinderDia") || string.equals("cyFactor")) && membrane_Dialog.this.cur_type == 3) {
                int n = 0;
                if (membrane_Dialog.this.both_open.isSelected()) {
                    n = 0;
                } else if (membrane_Dialog.this.one_open.isSelected()) {
                    n = 1;
                } else if (membrane_Dialog.this.both_close.isSelected()) {
                    n = 2;
                }
                try {
                    double d4 = Double.valueOf(membrane_Dialog.this.tfCylinderDia.getText());
                    double d5 = Double.valueOf(membrane_Dialog.this.tfCylinderLen.getText());
                    double d6 = Double.valueOf(membrane_Dialog.this.tfC1.getText());
                    d = (Math.PI * d4 * d5 + (double)n * Math.PI * d4 * d4 / 4.0) * d6;
                }
                catch (NumberFormatException numberFormatException) {
                    d = 0.0;
                }
                String string3 = decimalFormat.format(d);
                membrane_Dialog.this.tfArea.setText(string3);
            } else if (document.getProperty("name").equals("Area") && membrane_Dialog.this.tfArea.isEnabled()) {
                try {
                    membrane_Dialog.this.preArea = Double.valueOf(membrane_Dialog.this.tfArea.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    membrane_Dialog.this.preArea = 0.0;
                }
            }
        }
    }
}

