/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

final class GraphSetup
extends JDialog
implements ActionListener {
    private String answer = null;

    public GraphSetup(JFrame jFrame, String string) {
        super(jFrame, string, true);
        Object object;
        int n;
        Container container = this.getContentPane();
        container.setBackground(Color.lightGray);
        container.setLayout(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel("Output Variables:");
        jLabel.setBorder(new EmptyBorder(15, 10, 5, 10));
        jLabel.setForeground(new Color(0, 128, 255));
        container.add((Component)jLabel, "North");
        final String[] stringArray = new String[]{"Channel", "X Axis", "Y Axis", "Color"};
        final Object[][] objectArray = new Object[Math.max(ReadFile.n_var2graph, 8)][4];
        for (n = 0; n < ReadFile.n_var2graph; ++n) {
            int n2 = ReadFile.yplot[n].chn_id;
            object = ReadFile.yplot[n].name;
            if (ReadFile.yplot[n].name2.length() > 6) {
                object = ReadFile.yplot[n].name + "x" + ReadFile.yplot[n].name2;
            }
            objectArray[n][0] = new Integer(n2 + 1);
            objectArray[n][1] = ReadFile.xplot[n2].name;
            objectArray[n][2] = object;
            objectArray[n][3] = ReadFile.yplot[n].color;
        }
        for (n = ReadFile.n_var2graph; n < 8; ++n) {
            objectArray[n][3] = "   ";
        }
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public int getColumnCount() {
                return stringArray.length;
            }

            public int getRowCount() {
                return objectArray.length;
            }

            public Object getValueAt(int n, int n2) {
                return objectArray[n][n2];
            }

            public String getColumnName(int n) {
                return stringArray[n];
            }

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
                objectArray[n][n2] = object;
            }
        };
        JTable jTable = new JTable(abstractTableModel);
        object = new DefaultTableCellRenderer(){

            public void setValue(Object object) {
                Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(16);
                for (int i = 0; i < 16; ++i) {
                    hashtable.put(CONSTANT.color_str[i], new Integer(CONSTANT.color_int[i]));
                }
                if (object instanceof String) {
                    Integer n = (Integer)hashtable.get(object);
                    if (n != null) {
                        Color color = new Color(n);
                        ColoredSquare coloredSquare = new ColoredSquare(color, 4);
                        this.setIcon(coloredSquare);
                        this.setText((String)object);
                        this.setIconTextGap(12);
                    } else {
                        this.setIcon(null);
                        this.setText("");
                    }
                }
            }
        };
        ((JLabel)object).setHorizontalAlignment(2);
        jTable.getColumn("Color").setCellRenderer((TableCellRenderer)object);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        jTable.getColumn("Channel").setCellRenderer(defaultTableCellRenderer);
        jTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        jTable.getColumnModel().getColumn(3).setPreferredWidth(30);
        jTable.setAutoResizeMode(2);
        jTable.setSelectionMode(0);
        jTable.setRowSelectionAllowed(true);
        jTable.setShowHorizontalLines(true);
        jTable.setShowVerticalLines(true);
        jTable.setIntercellSpacing(new Dimension(10, 4));
        jTable.setRowHeight(22);
        jTable.getTableHeader().setForeground(Color.blue);
        jTable.setPreferredScrollableViewportSize(new Dimension(300, 180));
        JScrollPane jScrollPane = new JScrollPane(jTable, 22, 32);
        jScrollPane.setBorder(new SoftBevelBorder(1));
        container.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 120, 10));
        JButton jButton = new JButton("Modify");
        jButton.setPreferredSize(new Dimension(80, 30));
        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
        jButton.setBackground(new Color(160, 176, 192));
        jPanel.add(jButton);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Close");
        jButton2.setPreferredSize(new Dimension(80, 30));
        jButton2.setBorder(BorderFactory.createRaisedBevelBorder());
        jButton2.setBackground(new Color(160, 176, 192));
        jPanel.add(jButton2);
        jButton2.addActionListener(this);
        container.add((Component)jPanel, "South");
        container.add((Component)new JLabel(" "), "West");
        container.add((Component)new JLabel(" "), "East");
        this.setLocation(300, 200);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.answer = actionEvent.getActionCommand();
        this.dispose();
    }

    public String getAnswer() {
        return this.answer;
    }
}

