/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class MainMenuFrame
extends JFrame
implements ActionListener {
    private String snnap_name = "Simulator for Neural Networks and Action Potentials";
    private String version = "V 8.1";
    private String rev_date = "October 10, 2006";
    private String copyright_uthsc = "The University of Texas Health Science Center at Houston";
    private String copyright = "Copyright(C) 1994-2003. All Rights Reserved";
    private String currentUI = "Metal";
    private String macClassName = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private String metalClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
    private String motifClassName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private String windowsClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private JRadioButtonMenuItem macMenuItem;
    private JRadioButtonMenuItem metalMenuItem;
    private JRadioButtonMenuItem motifMenuItem;
    private JRadioButtonMenuItem windowsMenuItem;
    private JButton jButton1 = new JButton();
    private JButton jButton2 = new JButton();
    private JButton jButton3 = new JButton();
    private JButton jButton4 = new JButton();
    private JButton jButton5 = new JButton();
    private JButton jButton6 = new JButton();
    private JButton jButton7 = new JButton();
    private JButton jButton8 = new JButton();
    private JButton jButton9 = new JButton();
    private SmuRun sim = null;
    private Edit_olv olv = null;
    private Edit_trt trt = null;
    private EDIT_ntw ntw = null;
    private EDIT_neu neu = null;
    private Edit_ous ous = null;
    private BatchFrame bch = null;
    public static String dirname = null;
    private String filename = null;
    public static Color bgColor = Color.lightGray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MainMenuFrame(String string) {
        super("SNNAP");
        dirname = System.getProperty("snnaphome");
        String string2 = System.getProperty("file.separator");
        if (dirname != null) {
            dirname = dirname + string2;
        } else {
            dirname = System.getProperty("user.dir");
            System.out.println();
            System.out.println(" If you need default input_file_directory,");
            System.out.println(" please use 'java -Dsnnaphome=Input_File_Path -jar SNNAP.jar'");
        }
        if (dirname != null && !dirname.endsWith(File.separator)) {
            dirname = dirname + File.separator;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("utshield.jpg"));
        this.setIconImage(image);
        this.setJMenuBar(this.createMenuBar());
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout(0, 0));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setCursor(Cursor.getPredefinedCursor(3));
        JPanel jPanel2 = new JPanel(){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                Insets insets = this.getInsets();
                graphics.translate(insets.left, insets.top);
                int n = this.getWidth();
                int n2 = this.getHeight();
                graphics.setColor(Color.darkGray);
                graphics.setFont(new Font("Dialog", 1, 40));
                graphics.drawString("S N N A P", n / 2 - 100 + 1, 46);
                graphics.drawString("S N N A P", n / 2 - 100 + 2, 47);
                graphics.setColor(Color.white);
                graphics.drawString("S N N A P", n / 2 - 100, 45);
                graphics.setFont(new Font("Dialog", 0, 13));
                graphics.setColor(Color.black);
                graphics.drawString(MainMenuFrame.this.snnap_name, n / 2 - 150 - 1, 69);
                graphics.drawString(MainMenuFrame.this.version, n / 2 + 110 - 1, 44);
                graphics.drawString(MainMenuFrame.this.rev_date, n / 2 - 50 - 1, 89);
                graphics.setColor(Color.white);
                graphics.drawString(MainMenuFrame.this.snnap_name, n / 2 - 150, 70);
                graphics.drawString(MainMenuFrame.this.version, n / 2 + 110, 45);
            }
        };
        jPanel2.setBackground(new Color(16, 148, 180));
        jPanel2.setOpaque(true);
        jPanel2.setPreferredSize(new Dimension(400, 100));
        jPanel2.setBorder(new EtchedBorder());
        JPanel jPanel3 = new JPanel(){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                Insets insets = this.getInsets();
                int n = this.getWidth();
                int n2 = this.getHeight();
                graphics.setFont(new Font("Dialog", 0, 13));
                graphics.setColor(Color.black);
                graphics.drawString(MainMenuFrame.this.copyright_uthsc, n / 2 - 170 - 1, n2 - 40 - 1);
                graphics.drawString(MainMenuFrame.this.copyright, n / 2 - 110 - 1, n2 - 15 - 1);
                graphics.setColor(Color.white);
                graphics.drawString(MainMenuFrame.this.copyright_uthsc, n / 2 - 170, n2 - 40);
                graphics.drawString(MainMenuFrame.this.copyright, n / 2 - 110, n2 - 15);
            }
        };
        jPanel3.setBackground(new Color(16, 152, 180));
        jPanel3.setOpaque(true);
        jPanel3.setPreferredSize(new Dimension(400, 80));
        jPanel3.setBorder(new EtchedBorder());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.createButtonPanel(), "Center");
        jPanel.add((Component)jPanel3, "South");
        this.setLocation(dimension.width / 2 - 200, dimension.height / 2 - 200);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.pack();
        this.setLocation(200, 50);
        this.setVisible(true);
        if (!string.equalsIgnoreCase("") && string.endsWith(".smu")) {
            this.toBack();
            MainMenuFrame mainMenuFrame = this;
            synchronized (mainMenuFrame) {
                File file = new File(string);
                SmuRun smuRun = new SmuRun(file.getParent() + System.getProperty("file.separator"), file.getName());
                this.setLookFeel(smuRun);
                smuRun.setVisible(true);
                smuRun.toFront();
            }
        }
    }

    private JPanel createButtonPanel() {
        this.jButton1.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jButton1.setText("Run Simulation");
        this.jButton1.setBackground(new Color(160, 208, 240));
        this.jButton1.setPreferredSize(new Dimension(80, 40));
        this.jButton1.addActionListener(this);
        this.jButton2.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jButton2.setBackground(new Color(160, 208, 240));
        this.jButton2.setPreferredSize(new Dimension(80, 40));
        this.jButton2.setText("Edit Simulation");
        this.jButton2.addActionListener(this);
        this.jButton3.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jButton3.setBackground(new Color(160, 208, 240));
        this.jButton3.setPreferredSize(new Dimension(80, 40));
        this.jButton3.setText("View Data");
        this.jButton3.addActionListener(this);
        this.jButton4.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jButton4.setBackground(new Color(160, 208, 240));
        this.jButton4.setPreferredSize(new Dimension(80, 40));
        this.jButton4.setText("Edit Network");
        this.jButton4.addActionListener(this);
        this.jButton5.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jButton5.setBackground(new Color(160, 208, 240));
        this.jButton5.setPreferredSize(new Dimension(80, 40));
        this.jButton5.setText("Edit Treatment");
        this.jButton5.addActionListener(this);
        this.jButton6.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jButton6.setBackground(new Color(160, 208, 240));
        this.jButton6.setPreferredSize(new Dimension(80, 40));
        this.jButton6.setText("Edit Neuron");
        this.jButton6.addActionListener(this);
        this.jButton7.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jButton7.setBackground(new Color(160, 208, 240));
        this.jButton7.setPreferredSize(new Dimension(80, 40));
        this.jButton7.setText("Edit OutScreen");
        this.jButton7.addActionListener(this);
        this.jButton8.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jButton8.setBackground(new Color(160, 208, 240));
        this.jButton8.setPreferredSize(new Dimension(80, 40));
        this.jButton8.setText("Edit Formula");
        this.jButton8.addActionListener(this);
        this.jButton9.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jButton9.setBackground(new Color(160, 208, 240));
        this.jButton9.setPreferredSize(new Dimension(80, 40));
        this.jButton9.setText("Edit Batch");
        this.jButton9.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 20, 30));
        jPanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(20, 20, 20, 20)));
        jPanel.setBackground(new Color(16, 152, 180));
        jPanel.add(this.jButton1);
        jPanel.add(this.jButton2);
        jPanel.add(this.jButton3);
        jPanel.add(this.jButton4);
        jPanel.add(this.jButton6);
        jPanel.add(this.jButton5);
        jPanel.add(this.jButton7);
        jPanel.add(this.jButton9);
        jPanel.add(this.jButton8);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.jButton1)) {
            this.jButton1_actionPerformed(actionEvent);
        } else if (object.equals(this.jButton2)) {
            this.jButton2_actionPerformed(actionEvent);
        } else if (object.equals(this.jButton3)) {
            this.jButton3_actionPerformed(actionEvent);
        } else if (object.equals(this.jButton4)) {
            this.jButton4_actionPerformed(actionEvent);
        } else if (object.equals(this.jButton5)) {
            this.jButton5_actionPerformed(actionEvent);
        } else if (object.equals(this.jButton6)) {
            this.jButton6_actionPerformed(actionEvent);
        } else if (object.equals(this.jButton7)) {
            this.jButton7_actionPerformed(actionEvent);
        } else if (object.equals(this.jButton8)) {
            this.jButton8_actionPerformed(actionEvent);
        } else if (object.equals(this.jButton9)) {
            this.jButton9_actionPerformed(actionEvent);
        }
    }

    void jButton1_actionPerformed(ActionEvent actionEvent) {
        if (this.sim == null || !this.sim.isShowing()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.sim = new SmuRun(dirname, "");
            this.setLookFeel(this.sim);
            this.sim.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            JOptionPane.showMessageDialog(this, "Each time only one 'Run Simulation' can be run. \nPlease close previous one! ", "Warning", 2);
        }
    }

    void jButton2_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Edit_smu edit_smu = new Edit_smu(dirname, "");
        this.setLookFeel(edit_smu);
        edit_smu.setVisible(true);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    void jButton3_actionPerformed(ActionEvent actionEvent) {
        if (this.olv == null || !this.olv.isShowing()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.olv = new Edit_olv(dirname, "");
            this.setLookFeel(this.olv);
            this.olv.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            JOptionPane.showMessageDialog(this, "Each time only one 'View Data' can be run. \nPlease close previous one! ", "Warning", 2);
        }
    }

    void jButton4_actionPerformed(ActionEvent actionEvent) {
        if (this.ntw == null || !this.ntw.isShowing()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.ntw = new EDIT_ntw(null, dirname, "");
            this.setLookFeel(this.ntw);
            this.ntw.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            JOptionPane.showMessageDialog(this, "Each time only one 'Edit Network' can be run. \nPlease close previous one! ", "Warning", 2);
        }
    }

    void jButton5_actionPerformed(ActionEvent actionEvent) {
        if (this.trt == null || !this.trt.isShowing()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.trt = new Edit_trt(null, dirname, "");
            this.setLookFeel(this.trt);
            this.trt.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            JOptionPane.showMessageDialog(this, "Each time only one 'Edit Treatment' can be run. \nPlease close previous one! ", "Warning", 2);
        }
    }

    void jButton6_actionPerformed(ActionEvent actionEvent) {
        if (this.neu == null || !this.neu.isShowing()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.neu = new EDIT_neu(null, dirname, "");
            this.setLookFeel(this.neu);
            this.neu.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            JOptionPane.showMessageDialog(this, "Each time only one 'Edit Neuron' can be run. \nPlease close previous one! ", "Warning", 2);
        }
    }

    void jButton7_actionPerformed(ActionEvent actionEvent) {
        if (this.ous == null || !this.ous.isShowing()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.ous = new Edit_ous(null, dirname, "");
            this.setLookFeel(this.ous);
            this.ous.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            JOptionPane.showMessageDialog(this, "Each time only 'Edit OutScreen' can be run. \nPlease close previous one! ", "Warning", 2);
        }
    }

    void jButton8_actionPerformed(ActionEvent actionEvent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        EDIT_fmu eDIT_fmu = new EDIT_fmu(dirname, "");
        this.setLookFeel(eDIT_fmu);
        eDIT_fmu.setVisible(true);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    void jButton9_actionPerformed(ActionEvent actionEvent) {
        if (this.bch == null || !this.bch.isShowing()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.bch = new BatchFrame(dirname);
            this.setLookFeel(this.bch);
            this.bch.setVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            JOptionPane.showMessageDialog(this, "Each time only one 'Edit Batch' can be run. \nPlease close previous one! ", "Warning", 2);
        }
    }

    protected boolean isAvailableLookAndFeel(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
            return lookAndFeel.isSupportedLookAndFeel();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.getAccessibleContext().setAccessibleName("Swing menus");
        JMenu jMenu = jMenuBar.add(new JMenu("File"));
        jMenu.setMnemonic('F');
        jMenu.addSeparator();
        JMenuItem jMenuItem = jMenu.add(new JMenuItem("Exit"));
        jMenuItem.setMnemonic('x');
        jMenuItem.getAccessibleContext().setAccessibleDescription("Exit the SwingSet application");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        JMenu jMenu2 = jMenuBar.add(new JMenu("Options"));
        jMenu2.setMnemonic('O');
        ButtonGroup buttonGroup = new ButtonGroup();
        ToggleUIListener toggleUIListener = new ToggleUIListener();
        this.metalMenuItem = (JRadioButtonMenuItem)jMenu2.add(new JRadioButtonMenuItem("Java Look and Feel"));
        this.metalMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Metal"));
        this.metalMenuItem.setSelected(true);
        this.metalMenuItem.setEnabled(this.isAvailableLookAndFeel(this.metalClassName));
        buttonGroup.add(this.metalMenuItem);
        this.metalMenuItem.addItemListener(toggleUIListener);
        this.metalMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        this.motifMenuItem = (JRadioButtonMenuItem)jMenu2.add(new JRadioButtonMenuItem("Motif Look and Feel"));
        this.motifMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("CDE/Motif"));
        this.motifMenuItem.setEnabled(this.isAvailableLookAndFeel(this.motifClassName));
        buttonGroup.add(this.motifMenuItem);
        this.motifMenuItem.addItemListener(toggleUIListener);
        this.motifMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        this.windowsMenuItem = (JRadioButtonMenuItem)jMenu2.add(new JRadioButtonMenuItem("Windows Style Look and Feel"));
        this.windowsMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Windows"));
        this.windowsMenuItem.setEnabled(this.isAvailableLookAndFeel(this.windowsClassName));
        buttonGroup.add(this.windowsMenuItem);
        this.windowsMenuItem.addItemListener(toggleUIListener);
        this.windowsMenuItem.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        this.macMenuItem = (JRadioButtonMenuItem)jMenu2.add(new JRadioButtonMenuItem("Macintosh Look and Feel"));
        this.macMenuItem.setSelected(UIManager.getLookAndFeel().getName().equals("Macintosh"));
        this.macMenuItem.setEnabled(this.isAvailableLookAndFeel(this.macClassName));
        buttonGroup.add(this.macMenuItem);
        this.macMenuItem.addItemListener(toggleUIListener);
        this.macMenuItem.setAccelerator(KeyStroke.getKeyStroke(52, 8));
        jMenu2.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenu2.add(new JCheckBoxMenuItem("Show ToolTips"));
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (jCheckBoxMenuItem.isSelected()) {
                    ToolTipManager.sharedInstance().setEnabled(true);
                } else {
                    ToolTipManager.sharedInstance().setEnabled(false);
                }
            }
        });
        JMenu jMenu3 = jMenuBar.add(new JMenu("Graphics"));
        jMenu3.setMnemonic('G');
        JMenuItem jMenuItem2 = jMenu3.add(new JMenuItem("Background Color (system-wide)"));
        jMenuItem2.setMnemonic('B');
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenuFrame.this.menuBackgroundColor_actionPerformed(actionEvent);
            }
        });
        JMenu jMenu4 = jMenuBar.add(new JMenu("Help"));
        jMenu4.setMnemonic('H');
        JMenuItem jMenuItem3 = jMenu4.add(new JMenuItem("About"));
        jMenuItem3.setMnemonic('A');
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainMenuFrame.this.menuHelpAbout_actionPerformed(actionEvent);
            }
        });
        return jMenuBar;
    }

    void menuBackgroundColor_actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Choose System-wide Background Color", bgColor);
        if (color != null) {
            bgColor = color;
        }
    }

    void menuHelpAbout_actionPerformed(ActionEvent actionEvent) {
        AboutDialog aboutDialog = new AboutDialog(this, "About", "SNNAP 8.1");
        Dimension dimension = aboutDialog.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        aboutDialog.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        aboutDialog.setVisible(true);
    }

    private Container getRootComponent() {
        return this;
    }

    private void setLookFeel(Component component) {
        try {
            if (this.currentUI.equals("Windows")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                SwingUtilities.updateComponentTreeUI(component);
            } else if (this.currentUI.equals("Macintosh")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.mac.MacLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this.getRootComponent());
            } else if (this.currentUI.equals("Motif")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this.getRootComponent());
            } else if (this.currentUI.equals("Metal")) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                SwingUtilities.updateComponentTreeUI(this.getRootComponent());
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            System.err.println("Unsupported LookAndFeel: " + this.currentUI);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Could not load LookAndFeel: " + this.currentUI);
        }
    }

    class ToggleUIListener
    implements ItemListener {
        ToggleUIListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Container container = MainMenuFrame.this.getRootComponent();
            container.setCursor(Cursor.getPredefinedCursor(3));
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)itemEvent.getSource();
            try {
                if (jRadioButtonMenuItem.isSelected() && jRadioButtonMenuItem.getText().equals("Windows Style Look and Feel")) {
                    MainMenuFrame.this.currentUI = "Windows";
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(MainMenuFrame.this.getRootComponent());
                } else if (jRadioButtonMenuItem.isSelected() && jRadioButtonMenuItem.getText().equals("Macintosh Look and Feel")) {
                    MainMenuFrame.this.currentUI = "Macintosh";
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.mac.MacLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(MainMenuFrame.this.getRootComponent());
                } else if (jRadioButtonMenuItem.isSelected() && jRadioButtonMenuItem.getText().equals("Motif Look and Feel")) {
                    MainMenuFrame.this.currentUI = "Motif";
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(MainMenuFrame.this.getRootComponent());
                } else if (jRadioButtonMenuItem.isSelected() && jRadioButtonMenuItem.getText().equals("Java Look and Feel")) {
                    MainMenuFrame.this.currentUI = "Metal";
                    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    SwingUtilities.updateComponentTreeUI(MainMenuFrame.this.getRootComponent());
                }
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                jRadioButtonMenuItem.setEnabled(false);
                System.err.println("Unsupported LookAndFeel: " + jRadioButtonMenuItem.getText());
                try {
                    MainMenuFrame.this.currentUI = "Metal";
                    MainMenuFrame.this.metalMenuItem.setSelected(true);
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    SwingUtilities.updateComponentTreeUI(MainMenuFrame.this.getRootComponent());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("Could not load LookAndFeel: " + exception);
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                jRadioButtonMenuItem.setEnabled(false);
                exception.printStackTrace();
                System.err.println("Could not load LookAndFeel: " + jRadioButtonMenuItem.getText());
                exception.printStackTrace();
            }
            container.setCursor(Cursor.getPredefinedCursor(12));
        }
    }
}

