/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class PSPrint {
    private final int LIN = 1;
    private final int LOG = 2;
    private final int PORTRAIT = 1;
    private final int LANDSCAPE = 2;
    private final int HISBIN = -5;
    private final int HISBIN_SOLID = -6;
    private final int DOT_RASTER = -7;
    private final int XYTYPE = 999;
    private final int SH = 1;
    private final int LSH = 2;
    private final int VSH = 3;
    private final int VDSH = 4;
    private final int OTIC = 1;
    private final int ITIC = 2;
    private final int GRID = 3;
    private final int MM = 1;
    private final int INCH = 2;
    private final int LINESZ = 10;
    private final int NLINE = 10;
    private final int BLKSZ = 100;
    private String PSorient = "LANDSCAPE";
    private int pgCount = 0;
    private URL headFile;
    private InputStream fin = null;
    private InputStreamReader readerIn = null;
    private BufferedReader myIn = null;
    private String psFile;
    private FileWriter fout = null;
    private PrintWriter myOut = null;
    private String psDirName = "";

    public PSPrint(String string, String string2) {
        this.psDirName = string;
        this.psFile = string2;
    }

    public void openPS() {
        this.headFile = this.getClass().getResource("PSHeader.hdr");
        try {
            this.fin = this.headFile.openStream();
            this.readerIn = new InputStreamReader(this.fin);
            this.myIn = new BufferedReader(this.readerIn);
            this.fout = new FileWriter(this.psDirName + this.psFile);
            this.myOut = new PrintWriter((Writer)this.fout, true);
            String string = " ";
            while ((string = this.myIn.readLine()) != null) {
                if (string.indexOf("%%Orientation") >= 0) {
                    this.myOut.println("%%%Orientation: " + this.PSorient);
                    continue;
                }
                this.myOut.println(string);
            }
            this.myIn.close();
            this.readerIn.close();
            this.fin.close();
            this.pageSetup();
        }
        catch (IOException iOException) {
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, " File Read/Write Failure\n" + iOException, "Error", 0);
        }
    }

    public void closePS() {
        try {
            this.trailer();
            this.myOut.flush();
            this.fout.close();
            this.myOut.close();
        }
        catch (IOException iOException) {
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, " File Read/Write Failure\n" + iOException, "Error", 0);
        }
    }

    public int subplot(int n, int n2, float[] fArray, float[] fArray2, int n3, float f, PlotPropertyStr plotPropertyStr) throws IOException {
        int n4;
        int n5;
        float f2 = 0.0f;
        float f3 = 0.0f;
        String string = "";
        int[] nArray = new int[100];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        float f4 = 300.0f;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = " ";
        float f5 = 1.0f;
        float f6 = 1.0f;
        bl = fArray == null;
        bl2 = bl && plotPropertyStr.xlg == 1 && plotPropertyStr.ylg == 1 && plotPropertyStr.plot_type < 0;
        float f7 = plotPropertyStr.xn;
        float f8 = plotPropertyStr.xm;
        float f9 = plotPropertyStr.yn;
        float f10 = plotPropertyStr.ym;
        if (plotPropertyStr.xlg == 2) {
            f7 = (float)Math.log(f7);
            f8 = (float)Math.log(f8);
        }
        if (plotPropertyStr.ylg == 2) {
            f9 = (float)Math.log(f9);
            f10 = (float)Math.log(f10);
        }
        if (plotPropertyStr.unit == 2) {
            string2 = new String("inch");
            f6 = 1.0f;
            f5 = 12.0f;
        } else {
            plotPropertyStr.unit = 1;
            string2 = new String("mm");
            f6 = 25.4f;
            f5 = (float)Math.floor(120.0f / f6) / 10.0f;
        }
        this.myOut.println();
        if (n == 1 && n2 == 0) {
            this.myOut.println(plotPropertyStr.xpos + " " + string2 + " " + plotPropertyStr.ypos + " " + string2 + " neworigin");
            this.myOut.println(plotPropertyStr.xLen + " " + string2 + " " + plotPropertyStr.yLen + " " + string2 + " plotsize");
            this.myOut.println("false false setlog");
            this.myOut.print(plotPropertyStr.xn + " " + plotPropertyStr.xm + " " + plotPropertyStr.yn + " " + plotPropertyStr.ym + " XYminmax");
            if (Math.abs((double)plotPropertyStr.xscale - 1.0) < 1.0E-4 && Math.abs((double)plotPropertyStr.yscale - 1.0) < 1.0E-4) {
                this.myOut.println();
            } else {
                this.myOut.println(" " + plotPropertyStr.xscale + " " + plotPropertyStr.yscale + " XYlabelscale");
            }
        }
        this.myOut.println();
        if (n2 == 0) {
            this.myOut.println("%% =================  Iteration " + n + " ===================");
        }
        this.myOut.println("%% Curve " + (n2 + 1) + " Begin");
        this.myOut.println("SPB");
        float f11 = 20.0f;
        do {
            n5 = (int)((double)(f11 * plotPropertyStr.xLen * f4 / f6 / (f8 - f7)) + 0.5);
            f11 = (float)((double)f11 * 10.0);
        } while (n5 == 0);
        f11 = 20.0f;
        do {
            n4 = (int)((double)(f11 * plotPropertyStr.yLen * f4 / f6 / (f10 - f9)) + 0.5);
            f11 = (float)((double)f11 * 10.0);
        } while (n4 == 0);
        this.myOut.println(n5 + " " + n4 + " " + f + "  SSL");
        this.myOut.println(plotPropertyStr.plot_color + " /lw {" + Math.max(plotPropertyStr.linewidth, 1) + "} def");
        this.myOut.println();
        for (int i = 0; i < n3; i += 100) {
            int n9;
            for (int j = 0; j < 10 && (n9 = 0) + j * 10 + i < n3; ++j) {
                int n10;
                for (n9 = 0; n9 < 10 && (n10 = n9 + j * 10 + i) < n3; ++n9) {
                    int n11;
                    float f12;
                    if (n10 == i) {
                        f3 = 0.0f;
                        f2 = 0.0f;
                        if (i == 0) {
                            f11 = bl ? plotPropertyStr.xn : fArray[0];
                            f12 = fArray2[0];
                        } else {
                            f11 = bl ? f * (float)(i - 1) + plotPropertyStr.xn : fArray[i - 1];
                            f12 = fArray2[i - 1];
                        }
                        if (plotPropertyStr.xlg == 2) {
                            f11 = (float)Math.log(f11);
                        }
                        if (plotPropertyStr.ylg == 2) {
                            f12 = (float)Math.log(f12);
                        }
                        if (bl) {
                            int n12 = n8 = i != 0 ? i - 1 : 0;
                            if (plotPropertyStr.plot_type < 0) {
                                this.myOut.println(f12 + " " + n8 + " gsnm");
                            } else {
                                this.myOut.println("(" + plotPropertyStr.plot_type + ") " + f12 + " " + n8 + " gsnms");
                            }
                        } else if (plotPropertyStr.plot_type < 0) {
                            this.myOut.println(f12 + " " + f11 + " gsnmx");
                        } else {
                            this.myOut.println("(" + plotPropertyStr.plot_type + ") " + f12 + " " + f11 + " gsnmxs");
                        }
                    }
                    if (bl2 && j + n9 + i != 0) {
                        int n13 = n10;
                        int n14 = n13 + 100 >= n3 ? n3 : n13 + 100;
                        for (n10 = n13; n10 < n14; ++n10) {
                            f12 = fArray2[n10] - fArray2[n10 - 1];
                            if ((double)(f3 += (f12 *= (float)n4) - (float)(n11 = (int)f12)) > 1.0) {
                                f3 -= 1.0f;
                            } else if ((double)f3 < -1.0) {
                                --n11;
                                f3 += 1.0f;
                            }
                            nArray[n10 - n13] = ++n11;
                        }
                        for (n10 = 0; n10 < n14 - n13; ++n10) {
                            int n15 = 0;
                            while (n10 < n14 - n13 - 1 && nArray[n10 + 1] == nArray[n10]) {
                                ++n10;
                                ++n15;
                            }
                            if (n15 >= 3) {
                                if ((n10 - n15) % 10 + n15 > 9) {
                                    this.myOut.print(nArray[n10] + " " + n15 + 1 + " EM\n");
                                    continue;
                                }
                                this.myOut.print(nArray[n10] + " " + n15 + 1 + " EM ");
                                continue;
                            }
                            if ((n6 = 10 - (n10 -= n15) % 10 + n10) > n14 - n13) {
                                n6 = n14 - n13;
                            }
                            if (n6 - n10 <= 3) {
                                if (nArray[n10] >= 0) {
                                    if (n10 % 10 == 9) {
                                        this.myOut.print(nArray[n10] + " E\n");
                                        continue;
                                    }
                                    this.myOut.print(nArray[n10] + " E ");
                                    continue;
                                }
                                if (n10 % 10 == 9) {
                                    this.myOut.print(-nArray[n10] + " N\n");
                                    continue;
                                }
                                this.myOut.print(-nArray[n10] + " N ");
                                continue;
                            }
                            n15 = 0;
                            for (n7 = n10; n7 < n6; ++n7) {
                                if (nArray[n7] > 0) {
                                    ++n15;
                                    continue;
                                }
                                if (nArray[n7] >= 0) continue;
                                --n15;
                            }
                            for (n7 = n10; n7 < n6; ++n7) {
                                if (n15 >= 0) {
                                    this.myOut.print(nArray[n7] + " ");
                                    continue;
                                }
                                this.myOut.print(-nArray[n7] + " ");
                            }
                            if (n15 >= 0) {
                                this.myOut.println(n6 - n10 + " F");
                            } else {
                                this.myOut.println(n6 - n10 + " G");
                            }
                            n10 = n6 - 1;
                        }
                        n9 = 10;
                        j = 10;
                        continue;
                    }
                    if (j + n9 + i == 0) continue;
                    f12 = plotPropertyStr.ylg != 2 ? fArray2[n10] - fArray2[n10 - 1] : (float)(Math.log(fArray2[n10]) - Math.log(fArray2[n10 - 1]));
                    n11 = (int)(f12 *= (float)n4);
                    if ((double)(f3 += f12 - (float)n11) > 1.0) {
                        ++n11;
                        f3 -= 1.0f;
                    } else if ((double)f3 < -1.0) {
                        --n11;
                        f3 += 1.0f;
                    }
                    if (!bl) {
                        f11 = plotPropertyStr.xlg != 2 ? fArray[n10] - fArray[n10 - 1] : (float)(Math.log(fArray[n10]) - Math.log(fArray[n10 - 1]));
                        int n16 = (int)(f11 *= (float)n5);
                        if ((double)(f2 += f11 - (float)n16) > 1.0) {
                            ++n16;
                            f2 -= 1.0f;
                        } else if ((double)f2 < -1.0) {
                            --n16;
                            f2 += 1.0f;
                        }
                        if (plotPropertyStr.plot_type < 0) {
                            if (n9 == 9) {
                                this.myOut.print(n11 + " " + n16 + " Ex\n");
                                continue;
                            }
                            this.myOut.print(n11 + " " + n16 + " Ex ");
                            continue;
                        }
                        if (n9 == 9) {
                            this.myOut.print("(" + (char)plotPropertyStr.plot_type + ") " + n11 + " " + n16 + " Exs\n");
                            continue;
                        }
                        this.myOut.print("(" + (char)plotPropertyStr.plot_type + ") " + n11 + " " + n16 + " Exs ");
                        continue;
                    }
                    if (plotPropertyStr.plot_type >= 0) {
                        if (n9 == 9) {
                            this.myOut.print("(" + (char)plotPropertyStr.plot_type + ") " + n11 + " Es\n");
                            continue;
                        }
                        this.myOut.print("(" + (char)plotPropertyStr.plot_type + ") " + n11 + " Es ");
                        continue;
                    }
                    if (n11 >= 0) {
                        if (n9 == 9) {
                            this.myOut.print(n11 + " E\n");
                            continue;
                        }
                        this.myOut.print(n11 + " E ");
                        continue;
                    }
                    if (n9 == 9) {
                        this.myOut.print(-n11 + " N\n");
                        continue;
                    }
                    this.myOut.print(-n11 + " N ");
                }
            }
            this.myOut.println("lw ssgr\n");
        }
        this.myOut.println("SPE");
        this.myOut.println("%% Curve " + (n2 + 1) + " End");
        return 1;
    }

    private void pageSetup() throws IOException {
        ++this.pgCount;
        this.myOut.println();
        this.myOut.println("%% Page: " + this.pgCount);
        this.myOut.println("%% BeginPageSetup");
        this.myOut.println("CN24Dict begin");
        this.myOut.println(this.PSorient.equals("PORTRAIT") ? "BP 0 0 ST" : "BP 0 -2550 SRT");
        this.myOut.println("%% EndPageSetup");
    }

    public void showMessage(PlotMessageStr plotMessageStr, float f) throws IOException {
        String string = "";
        if (plotMessageStr.msg != null) {
            if (plotMessageStr.font_unchanged == 0) {
                if (plotMessageStr.fontcolor == null) {
                    plotMessageStr.fontcolor = " ";
                }
                if (plotMessageStr.fontname == null) {
                    plotMessageStr.fontname = "Helvetica";
                }
                if (plotMessageStr.fontsize < 1.0f) {
                    plotMessageStr.fontsize = f;
                }
                this.myOut.println(plotMessageStr.fontcolor + " /" + plotMessageStr.fontname + " " + plotMessageStr.fontsize + " SF");
            }
            if (plotMessageStr.unit != 2) {
                plotMessageStr.unit = 1;
            }
            this.showString(plotMessageStr.msg, plotMessageStr.xp, plotMessageStr.yp, plotMessageStr.orientation, plotMessageStr.unit);
        }
    }

    public void showString(String string, float f, float f2, int n, int n2) throws IOException {
        String string2 = " ";
        string2 = n2 == 2 ? new String(" inch") : (n2 == 1 ? new String(" mm") : new String(" "));
        this.myOut.print(f + string2 + " " + f2 + string2 + " mvt (");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '(' || c == ')' || c == '\\') {
                this.myOut.print("\\" + c);
                continue;
            }
            this.myOut.print(c);
        }
        if (n == 2) {
            this.myOut.println(") lsh");
        } else if (n == 3) {
            this.myOut.println(") vsh");
        } else if (n == 4) {
            this.myOut.println(") vdsh");
        } else {
            this.myOut.println(") sh");
        }
    }

    private void trailer() throws IOException {
        String string = Calendar.getInstance().getTime().toString();
        this.myOut.println();
        this.myOut.println("EP");
        this.myOut.println("end %% CN24Dict");
        this.myOut.println();
        this.myOut.println("%% Trailer");
        this.myOut.println("%% Pages: " + this.pgCount);
        this.myOut.println("%% CreationDate: " + string);
        this.myOut.println("%% DocumentNeededResources: font Helvetica");
        this.myOut.println("%% DocumentSuppliedResources: procset CN24Dict");
        this.myOut.println("%% EOF");
    }

    private String getticgridname(int n) {
        String string = "";
        string = n == 1 ? new String("otic") : (n == 2 ? new String("itic") : (n == 3 ? new String("grid") : new String("false")));
        return string;
    }

    public void drawLine(float f, float f2, float f3, float f4, int n, int n2, String string) throws IOException {
        String string2 = " ";
        if (n == 2) {
            string2 = new String(" inch");
        } else if (n == 1) {
            string2 = new String(" mm");
        }
        this.myOut.print("np " + f + string2 + " " + f2 + string2 + " mvt " + f3 + string2 + " " + f4 + string2 + " lnt ");
        if (n2 > 0) {
            this.myOut.print(n2 + " slw ");
        }
        if (string != null) {
            this.myOut.print(string + " ");
        }
        this.myOut.println("stk");
    }

    public void drawRect(float f, float f2, float f3, float f4, int n, int n2, String string) throws IOException {
        String string2 = " ";
        if (n == 2) {
            string2 = new String(" inch");
        } else if (n == 1) {
            string2 = new String(" mm");
        }
        this.myOut.print("np " + f + string2 + " " + f2 + string2 + " mvt 0 " + f4 + string2 + " rlt " + f3 + string2 + " 0 rlt 0 " + -f4 + string2 + " rlt closepath ");
        if (n2 > 0) {
            this.myOut.print(n2 + " slw ");
        }
        if (string != null) {
            this.myOut.print(string + " ");
        }
        this.myOut.println("stk");
    }
}

