/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

public class ParamFilesFrame
extends JDialog {
    private String workDir;
    private String fileName;
    private CSimulationParam smuParam;
    private BatchFrame mainFrame;
    private JTree filesTree;
    private JButton openButton = new JButton();
    private JButton closeButton = new JButton();
    private JPanel buttonPanel = new JPanel();
    private JScrollPane treeScrollPanel;
    private JLabel titleLabel = new JLabel();

    public ParamFilesFrame(BatchFrame batchFrame, String string, String string2) {
        super(batchFrame, "List All Files in SMU File", false);
        this.workDir = string;
        this.fileName = string2;
        this.mainFrame = batchFrame;
        this.titleLabel.setText("  " + string);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.smuParam = new CSimulationParam(this.workDir, this.fileName);
        this.filesTree = new JTree(this.getTreeModel());
        this.filesTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ParamFilesFrame.this.mainFrame.paramFilesFrame_mousePressed(mouseEvent);
            }
        });
        this.buttonPanel.setPreferredSize(new Dimension(400, 50));
        this.buttonPanel.setLayout(new FlowLayout(1, 40, 12));
        this.openButton.setBackground(new Color(160, 176, 192));
        this.openButton.setPreferredSize(new Dimension(80, 28));
        this.openButton.setText("Open");
        this.openButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParamFilesFrame.this.openButton_actionPerformed(actionEvent);
            }
        });
        this.closeButton.setPreferredSize(new Dimension(80, 28));
        this.closeButton.setBackground(new Color(160, 176, 192));
        this.closeButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParamFilesFrame.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.treeScrollPanel = new JScrollPane(this.filesTree);
        this.treeScrollPanel.setPreferredSize(new Dimension(400, 400));
        this.titleLabel.setForeground(new Color(0, 0, 128));
        this.titleLabel.setPreferredSize(new Dimension(400, 28));
        this.titleLabel.setHorizontalAlignment(2);
        this.titleLabel.setHorizontalTextPosition(0);
        this.buttonPanel.add(this.openButton);
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.titleLabel, "North");
        this.getContentPane().add((Component)this.treeScrollPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        this.setLocation(500, 200);
    }

    protected TreeModel getTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.smuParam.getFileName());
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.smuParam.getTreatmentParam().getFileName());
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.getNodesFromCS(defaultMutableTreeNode, this.smuParam.getNetworkParam().getChemicalSynapses());
        this.getNodesFromMS(defaultMutableTreeNode, this.smuParam.getNetworkParam().getModulatorySynapses());
        this.getNodesFromES(defaultMutableTreeNode, this.smuParam.getNetworkParam().getElectricalSynapses());
        this.getNodesFromWS(defaultMutableTreeNode, this.smuParam.getNetworkParam().getWeights());
        this.getNodesFromCell(defaultMutableTreeNode, this.smuParam.getNetworkParam().getCells());
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("");
        Vector vector = this.smuParam.getNetworkParam().getNeurons();
        Vector<String> vector2 = new Vector<String>();
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode4;
            CParamFile cParamFile;
            int n;
            Object object;
            String string2;
            Object object2;
            Object object3;
            DefaultMutableTreeNode defaultMutableTreeNode5;
            CNeuron cNeuron = (CNeuron)vector.elementAt(i);
            CNeuronParam cNeuronParam = cNeuron.getParamFile();
            string = cNeuronParam.getFileName();
            if (vector2.indexOf(string) != -1) continue;
            defaultMutableTreeNode3 = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            vector2.addElement(string);
            CTransmitterParam cTransmitterParam = cNeuronParam.getTransmtr();
            if (cTransmitterParam != null) {
                defaultMutableTreeNode5 = new DefaultMutableTreeNode(cTransmitterParam.getFileName());
                defaultMutableTreeNode3.add(defaultMutableTreeNode5);
            }
            defaultMutableTreeNode5 = new DefaultMutableTreeNode("");
            Vector vector3 = cNeuron.getParamFile().getConductances();
            Vector<String> vector4 = new Vector<String>();
            String string3 = "";
            for (int j = 0; j < vector3.size(); ++j) {
                object3 = (CConductance)vector3.elementAt(j);
                string3 = ((CParamFile)object3).getFileName();
                if (vector4.indexOf(string3) != -1) continue;
                defaultMutableTreeNode5 = new DefaultMutableTreeNode(string3);
                defaultMutableTreeNode3.add(defaultMutableTreeNode5);
                vector4.addElement(string3);
                object2 = new DefaultMutableTreeNode("");
                Vector vector5 = ((CConductance)object3).getModels();
                for (int k = 0; k < vector5.size(); ++k) {
                    string2 = (String)vector5.elementAt(k);
                    object2 = new DefaultMutableTreeNode(string2);
                    defaultMutableTreeNode5.add((MutableTreeNode)object2);
                }
            }
            vector3 = cNeuron.getParamFile().getList_ion();
            object3 = new Vector();
            object2 = "";
            for (int j = 0; j < vector3.size(); ++j) {
                CListIon cListIon = (CListIon)vector3.elementAt(j);
                object2 = cListIon.getFileName();
                if (((Vector)object3).indexOf(object2) != -1) continue;
                DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(object2);
                defaultMutableTreeNode3.add(defaultMutableTreeNode6);
                ((Vector)object3).addElement(object2);
            }
            vector3 = cNeuron.getParamFile().getList_sm();
            Vector<String> vector6 = new Vector<String>();
            string2 = "";
            for (int j = 0; j < vector3.size(); ++j) {
                object = (CListSm)vector3.elementAt(j);
                string2 = ((CParamFile)object).getFileName();
                if (vector6.indexOf(string2) != -1) continue;
                DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(string2);
                defaultMutableTreeNode3.add(defaultMutableTreeNode7);
                vector6.addElement(string2);
            }
            Vector<Object> vector7 = new Vector<Object>();
            object = "";
            vector3 = cNeuron.getParamFile().getCond_by_ion();
            for (n = 0; n < vector3.size(); ++n) {
                cParamFile = (CConductanceByIon)vector3.elementAt(n);
                object = cParamFile.getFileName();
                if (vector7.indexOf(object) != -1) continue;
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                vector7.addElement(object);
            }
            vector3 = cNeuron.getParamFile().getCond_by_sm();
            for (n = 0; n < vector3.size(); ++n) {
                cParamFile = (CConductanceBySm)vector3.elementAt(n);
                object = cParamFile.getFileName();
                if (vector7.indexOf(object) != -1) continue;
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                vector7.addElement(object);
            }
            vector3 = cNeuron.getParamFile().getTrnsmtr_by_ion();
            for (n = 0; n < vector3.size(); ++n) {
                cParamFile = (CTransmitterByIon)vector3.elementAt(n);
                object = cParamFile.getFileName();
                if (vector7.indexOf(object) != -1) continue;
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                vector7.addElement(object);
            }
            vector3 = cNeuron.getParamFile().getTrnsmtr_by_sm();
            for (n = 0; n < vector3.size(); ++n) {
                cParamFile = (CTransmitterBySm)vector3.elementAt(n);
                object = cParamFile.getFileName();
                if (vector7.indexOf(object) != -1) continue;
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                vector7.addElement(object);
            }
        }
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    private void getNodesFromCell(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        String string = "";
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("");
        for (int i = 0; i < vector.size(); ++i) {
            CCell cCell = (CCell)vector.elementAt(i);
            string = cCell.getFileName();
            if (vector2.indexOf(string) != -1) continue;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            vector2.addElement(string);
        }
    }

    private void getNodesFromCS(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        String string = "";
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("");
        for (int i = 0; i < vector.size(); ++i) {
            CChemicalSynapse cChemicalSynapse = (CChemicalSynapse)vector.elementAt(i);
            string = cChemicalSynapse.getFileName();
            if (vector2.indexOf(string) != -1) continue;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            vector2.addElement(string);
            this.getNodesFromfAts(defaultMutableTreeNode2, cChemicalSynapse.getfAts());
            this.getNodesFromfAvts(defaultMutableTreeNode2, cChemicalSynapse.getfAvts());
            this.getNodesFromRs(defaultMutableTreeNode2, cChemicalSynapse.getRs());
        }
    }

    private void getNodesFromMS(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        String string = "";
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("");
        for (int i = 0; i < vector.size(); ++i) {
            CModulatorySynapse cModulatorySynapse = (CModulatorySynapse)vector.elementAt(i);
            string = cModulatorySynapse.getFileName();
            if (vector2.indexOf(string) != -1) continue;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            vector2.addElement(string);
            this.getNodesFromfAts(defaultMutableTreeNode2, cModulatorySynapse.getfAts());
            this.getNodesFromfAvts(defaultMutableTreeNode2, cModulatorySynapse.getfAvts());
        }
    }

    private void getNodesFromES(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        String string = "";
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("");
        for (int i = 0; i < vector.size(); ++i) {
            CElectricalSynapse cElectricalSynapse = (CElectricalSynapse)vector.elementAt(i);
            string = cElectricalSynapse.getFileName();
            if (vector2.indexOf(string) != -1) continue;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            vector2.addElement(string);
            this.getNodesFromRs(defaultMutableTreeNode2, cElectricalSynapse.getRs());
        }
    }

    private void getNodesFromWS(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        String string = "";
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("");
        for (int i = 0; i < vector.size(); ++i) {
            CWeights cWeights = (CWeights)vector.elementAt(i);
            string = cWeights.getFileName();
            if (vector2.indexOf(string) != -1) continue;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            vector2.addElement(string);
        }
    }

    private void getNodesFromfAts(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            CTimeActivation cTimeActivation = (CTimeActivation)vector.elementAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(cTimeActivation.getFileName());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.getNodesFromXts(defaultMutableTreeNode2, cTimeActivation.getXts());
        }
    }

    private void getNodesFromfAvts(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            CTimeVoltageActivation cTimeVoltageActivation = (CTimeVoltageActivation)vector.elementAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(cTimeVoltageActivation.getFileName());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.getNodesFromXts(defaultMutableTreeNode2, cTimeVoltageActivation.getXts());
            this.getNodesFromModels(defaultMutableTreeNode2, cTimeVoltageActivation.getModels());
        }
    }

    private void getNodesFromRs(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            CRandom cRandom = (CRandom)vector.elementAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(cRandom.getFileName());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private void getNodesFromXts(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            CTimeSynapticDriver cTimeSynapticDriver = (CTimeSynapticDriver)vector.elementAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(cTimeSynapticDriver.getFileName());
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private void getNodesFromModels(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    void openButton_actionPerformed(ActionEvent actionEvent) {
        this.mainFrame.getSimulation();
        this.smuParam = new CSimulationParam(this.mainFrame.getSmuWorkDir(), this.mainFrame.getSmuFileName());
        this.titleLabel.setText("  " + this.mainFrame.getSmuWorkDir());
        this.getContentPane().remove(this.treeScrollPanel);
        this.filesTree = new JTree(this.getTreeModel());
        this.filesTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ParamFilesFrame.this.mainFrame.paramFilesFrame_mousePressed(mouseEvent);
            }
        });
        this.treeScrollPanel = new JScrollPane(this.filesTree);
        this.getContentPane().add((Component)this.treeScrollPanel, "Center");
        this.getContentPane().repaint();
        this.getContentPane().validate();
    }

    void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

