/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

final class HardcopyWriter
extends Writer {
    protected PrintJob job;
    protected Graphics page;
    protected String jobname;
    protected int fontsize;
    protected String time;
    protected Dimension pagesize;
    protected int pagedpi;
    protected Font font;
    protected Font headerfont;
    protected FontMetrics metrics;
    protected FontMetrics headermetrics;
    protected int x0;
    protected int y0;
    protected int width;
    protected int height;
    protected int headery;
    protected int charwidth;
    protected int lineheight;
    protected int lineascent;
    protected int chars_per_line;
    protected int lines_per_page;
    protected int charnum = 0;
    protected int linenum = 0;
    protected int pagenum = 0;
    private boolean last_char_was_return = false;
    protected static Properties printprops = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardcopyWriter(JFrame jFrame, String string, int n, double d, double d2, double d3, double d4) throws PrintCanceledException {
        Serializable serializable = printprops;
        synchronized (serializable) {
            this.job = jFrame.getToolkit().getPrintJob(jFrame, string, printprops);
        }
        if (this.job == null) {
            throw new PrintCanceledException("print request canceled");
        }
        this.pagesize = this.job.getPageDimension();
        this.pagedpi = this.job.getPageResolution();
        this.x0 = (int)(d * (double)this.pagesize.width);
        this.y0 = (int)(d3 * (double)this.pagesize.height);
        this.width = this.pagesize.width - (int)((d + d2) * (double)this.pagesize.width);
        this.height = this.pagesize.height - (int)((d3 + d4) * (double)this.pagesize.height);
        if (this.width < 300 || this.height < 300) {
            serializable = new JFrame();
            JOptionPane.showMessageDialog((Component)serializable, "Page size is not correct!", "Error", 0);
        }
        this.font = new Font("MonoSpaced", 0, n);
        this.metrics = jFrame.getFontMetrics(this.font);
        this.lineheight = this.metrics.getHeight();
        this.lineascent = this.metrics.getAscent();
        this.charwidth = this.metrics.charWidth('0');
        this.chars_per_line = this.width / this.charwidth;
        this.lines_per_page = this.height / this.lineheight;
        this.headerfont = new Font("Serif", 2, n);
        this.headermetrics = jFrame.getFontMetrics(this.headerfont);
        this.headery = this.y0 - (int)(d3 / 4.0 * (double)this.pagesize.height) - this.headermetrics.getHeight() + this.headermetrics.getAscent();
        serializable = DateFormat.getDateTimeInstance(1, 3);
        ((DateFormat)serializable).setTimeZone(TimeZone.getDefault());
        this.time = ((DateFormat)serializable).format(new Date());
        this.jobname = string;
        this.fontsize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = n; i < n + n2; ++i) {
                if (this.page == null) {
                    this.newpage();
                }
                if (cArray[i] == '\n') {
                    if (this.last_char_was_return) continue;
                    this.newline();
                    continue;
                }
                if (cArray[i] == '\r') {
                    this.newline();
                    this.last_char_was_return = true;
                    continue;
                }
                this.last_char_was_return = false;
                if (Character.isWhitespace(cArray[i]) && !Character.isSpaceChar(cArray[i]) && cArray[i] != '\t') continue;
                if (this.charnum >= this.chars_per_line) {
                    this.newline();
                    if (this.page == null) {
                        this.newpage();
                    }
                }
                if (Character.isSpaceChar(cArray[i])) {
                    ++this.charnum;
                    continue;
                }
                if (cArray[i] == '\t') {
                    this.charnum += 8 - this.charnum % 8;
                    continue;
                }
                this.page.drawChars(cArray, i, 1, this.x0 + this.charnum * this.charwidth, this.y0 + this.linenum * this.lineheight + this.lineascent);
                ++this.charnum;
            }
        }
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.page != null) {
                this.page.dispose();
            }
            this.job.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFontStyle(int n) {
        Object object = this.lock;
        synchronized (object) {
            Font font = this.font;
            try {
                this.font = new Font("MonoSpaced", n, this.fontsize);
            }
            catch (Exception exception) {
                this.font = font;
            }
            if (this.page != null) {
                this.page.setFont(this.font);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageBreak() {
        Object object = this.lock;
        synchronized (object) {
            this.newpage();
        }
    }

    public int getCharactersPerLine() {
        return this.lines_per_page;
    }

    public int getLinesPerPage() {
        return this.lines_per_page;
    }

    protected void newline() {
        this.charnum = 0;
        ++this.linenum;
        if (this.linenum >= this.lines_per_page) {
            this.page.dispose();
            this.page = null;
        }
    }

    protected void newpage() {
        this.page = this.job.getGraphics();
        this.linenum = 0;
        this.charnum = 0;
        ++this.pagenum;
        this.page.setFont(this.headerfont);
        this.page.drawString(this.jobname, this.x0, this.headery);
        String string = "- " + this.pagenum + " -";
        int n = this.headermetrics.stringWidth(string);
        this.page.drawString(string, this.x0 + 2 * (this.width - n) / 3, this.headery);
        n = this.headermetrics.stringWidth(this.time);
        this.page.drawString(this.time, this.x0 + this.width - n, this.headery);
        int n2 = this.headery + this.headermetrics.getDescent() + 1;
        this.page.drawLine(this.x0, n2, this.x0 + this.width, n2);
        this.page.setFont(this.font);
    }

    public static class PrintCanceledException
    extends Exception {
        public PrintCanceledException(String string) {
            super(string);
        }
    }
}

