/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class printList
extends JDialog
implements ActionListener,
FilenameFilter {
    private JList list;
    private DefaultListModel listModel;
    private JTextField tfFileName;
    private JTextField tfDirName;
    private JComboBox cbFileType;
    private JButton okButton;
    private JButton cancelButton;
    private File currentDir;
    private String file0;
    private String dir0;
    private String old_dir;
    private String suffix;
    private String[] files;
    public static final int READ = 0;
    public static final int SAVE = 1;
    private int mode = 0;
    private String ans = "Yes";
    private JFrame curFrame;
    private JCheckBox impose = null;
    private JCheckBox printeach = null;

    public printList(JFrame jFrame, String string, String string2, int n) {
        super((Frame)jFrame, true);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(15, 10));
        this.suffix = string2;
        this.mode = n;
        this.curFrame = jFrame;
        if (this.mode == 0) {
            this.setTitle("Read a file");
        } else {
            this.setTitle("Save a file");
        }
        this.file0 = null;
        this.dir0 = null;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)new JLabel(""), "East");
        jPanel.add((Component)new JLabel(""), "West");
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = printList.this.list.getSelectedIndex() - 1;
                if (n < 0) {
                    return;
                }
                String string = printList.this.files[n];
                File file = new File(printList.this.currentDir, string);
                if (!file.exists()) {
                    throw new IllegalArgumentException("fileList: no such file or directory");
                }
                if (!file.isDirectory()) {
                    printList.this.tfFileName.setText(string);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 10));
        JLabel jLabel = new JLabel("  Directory:");
        jPanel2.add(jLabel);
        this.tfDirName = new JTextField(28);
        this.tfDirName.setMargin(new Insets(0, 2, 0, 2));
        this.tfDirName.addActionListener(this);
        jPanel2.add(this.tfDirName);
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 60, 0));
        this.impose = new JCheckBox("Superimpose Results When Displaying", true);
        jPanel4.add(this.impose);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0, 60, 0));
        this.printeach = new JCheckBox("Print Results for Each Iteration", false);
        jPanel5.add(this.printeach);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel3.add(jPanel5);
        JLabel jLabel2 = new JLabel("File name:");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel3.add(jLabel2);
        this.tfFileName = new JTextField(10);
        this.tfFileName.setMargin(new Insets(0, 2, 0, 2));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 10, 20);
        gridBagLayout.setConstraints(this.tfFileName, gridBagConstraints);
        jPanel3.add(this.tfFileName);
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(this);
        this.okButton.setPreferredSize(new Dimension(60, 25));
        this.okButton.setBorder(BorderFactory.createRaisedBevelBorder());
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 20);
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        jPanel3.add(this.okButton);
        JLabel jLabel3 = new JLabel("File type: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel3.add(jLabel3);
        this.cbFileType = new JComboBox();
        this.cbFileType.addItem("*" + string2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 20);
        gridBagLayout.setConstraints(this.cbFileType, gridBagConstraints);
        jPanel3.add(this.cbFileType);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setPreferredSize(new Dimension(60, 25));
        this.cancelButton.setBorder(BorderFactory.createRaisedBevelBorder());
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 20);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        jPanel3.add(this.cancelButton);
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "North");
        container.add((Component)jPanel3, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                printList.this.dir0 = null;
                printList.this.file0 = null;
                printList.this.dispose();
            }
        });
        this.setLocation(300, 150);
        this.pack();
        this.old_dir = string;
        this.listDirectory(string);
    }

    public boolean accept(File file, String string) {
        if (string.endsWith(this.suffix)) {
            return true;
        }
        return new File(file, string).isDirectory();
    }

    private void listDirectory(String string) {
        File file;
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        if (!(file = new File(string)).isDirectory()) {
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, "No such directory!", "Error", 0);
            this.tfDirName.setText(this.old_dir);
        } else {
            this.files = file.list(this);
            this.listModel.removeAllElements();
            this.listModel.addElement(".." + File.separator);
            for (int i = 0; i < this.files.length; ++i) {
                this.listModel.addElement(this.files[i]);
            }
            this.old_dir = string;
            this.tfDirName.setText(string);
            this.currentDir = file;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.cancelButton)) {
            this.dir0 = null;
            this.file0 = null;
            this.dispose();
        } else if (actionEvent.getSource().equals(this.okButton)) {
            int n = this.list.getSelectedIndex();
            if (n == 0) {
                this.up();
                this.tfFileName.setText("");
            } else {
                String string = this.files[n - 1];
                File file = new File(this.currentDir, string);
                String string2 = file.getAbsolutePath();
                if (file.isDirectory()) {
                    this.listDirectory(string2);
                    this.tfFileName.setText("");
                } else {
                    this.dir0 = this.tfDirName.getText();
                    this.file0 = this.tfFileName.getText();
                    File file2 = new File(this.file0);
                    if (file2.getParent() != null) {
                        this.dir0 = file2.getParent();
                        this.file0 = file2.getName();
                    }
                    if (this.dir0 != null && this.dir0.trim().length() == 0) {
                        this.dir0 = null;
                    }
                    if (this.file0 != null && this.file0.trim().length() == 0) {
                        this.file0 = null;
                    }
                    if (this.dir0 != null && !this.dir0.endsWith(File.separator)) {
                        this.dir0 = this.dir0 + File.separator;
                    }
                    if (this.dir0 != null && this.file0 != null) {
                        int n2 = 0;
                        file = new File(this.dir0, this.file0);
                        if (this.mode == 1 && file.exists()) {
                            n2 = JOptionPane.showConfirmDialog((JFrame)this.getParent(), "File exist, overwrite it?", "File Save", 0, 2);
                        }
                        if (n2 == 0) {
                            this.dispose();
                        }
                    }
                }
            }
        } else if (actionEvent.getSource().equals(this.tfDirName)) {
            String string = this.tfDirName.getText();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
                this.tfDirName.setText(string);
            }
            this.tfFileName.setText("");
            this.listDirectory(string);
        }
    }

    private void up() {
        String string = this.currentDir.getParent();
        if (string != null) {
            this.listDirectory(string);
        }
    }

    public static void usage() {
        JFrame jFrame = new JFrame();
        JOptionPane.showMessageDialog(jFrame, "Usage: FileLister(parent,tfDirName,suffix, mode)", "Error", 0);
    }

    public String getFile() {
        return this.file0;
    }

    public String getDirectory() {
        return this.dir0;
    }

    public boolean getImpose() {
        return this.impose.isSelected();
    }

    public boolean getPrinteach() {
        return this.printeach.isSelected();
    }
}

