/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CSimulationParam
extends CParamFile {
    String networkName = null;
    String onlineGraph = null;
    String storeResults = null;
    String integrationMethod = null;
    String startVal = null;
    String stopVal = null;
    String stepVal = null;
    CNetworkParam network = null;
    CTreatmentParam treatment = null;

    public CSimulationParam(String string, String string2) {
        this.fileName = string2;
        this.workDir = string;
        this.readParam();
    }

    public CSimulationParam(String string) {
        this.fileName = string;
        File file = new File(".");
        this.workDir = file.getAbsolutePath();
        this.readParam();
    }

    public CSimulationParam() {
        this.fileName = null;
        this.workDir = null;
    }

    public void readParam() {
        if (this.fileName.indexOf(File.separator) == -1) {
            this.readSimulationFile(this.workDir + this.fileName);
        } else {
            this.readSimulationFile(this.fileName);
        }
    }

    public void saveParam() {
    }

    public CTreatmentParam getTreatmentParam() {
        return this.treatment;
    }

    public CNetworkParam getNetworkParam() {
        return this.network;
    }

    public String getStartValue() {
        return this.startVal;
    }

    public String getStopValue() {
        return this.stopVal;
    }

    public String getStepValue() {
        return this.stepVal;
    }

    public void setStartValue(String string) {
        this.startVal = string;
    }

    public void setStopValue(String string) {
        this.stopVal = string;
    }

    public void setStepValue(String string) {
        this.stepVal = string;
    }

    private void readSimulationFile(String string) {
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        while (this.parseLine(bufferedReader, stringArray, stringArray2)) {
            if (stringArray[0].equalsIgnoreCase("LOGICAL_NAME:")) {
                if (this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    this.networkName = stringArray[0];
                    continue;
                }
                JFrame jFrame = new JFrame();
                JOptionPane.showMessageDialog(jFrame, "Invalid simulation file", "Error", 0);
                return;
            }
            if (stringArray[0].equalsIgnoreCase("Timing:")) {
                if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    JFrame jFrame = new JFrame();
                    JOptionPane.showMessageDialog(jFrame, "Invalid simulation file", "Error", 0);
                    return;
                }
                this.startVal = stringArray[0];
                if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    JFrame jFrame = new JFrame();
                    JOptionPane.showMessageDialog(jFrame, "Invalid simulation file", "Error", 0);
                    return;
                }
                this.stopVal = stringArray[0];
                if (this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    this.stepVal = stringArray[0];
                    continue;
                }
                JFrame jFrame = new JFrame();
                JOptionPane.showMessageDialog(jFrame, "Invalid simulation file", "Error", 0);
                return;
            }
            if (stringArray[0].equalsIgnoreCase("ON_LINE_GRAPH:")) {
                if (this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    this.onlineGraph = stringArray[0];
                    continue;
                }
                JFrame jFrame = new JFrame();
                JOptionPane.showMessageDialog(jFrame, "Invalid simulation file", "Error", 0);
                return;
            }
            if (stringArray[0].equalsIgnoreCase("STORE_RESULTS:")) {
                if (this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    this.storeResults = stringArray[0];
                    continue;
                }
                JFrame jFrame = new JFrame();
                JOptionPane.showMessageDialog(jFrame, "Invalid simulation file", "Error", 0);
                return;
            }
            if (stringArray[0].equalsIgnoreCase("INT_METHOD:")) {
                if (this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    this.integrationMethod = stringArray[0];
                    continue;
                }
                JFrame jFrame = new JFrame();
                JOptionPane.showMessageDialog(jFrame, "Invalid simulation file", "Error", 0);
                return;
            }
            if (stringArray[0].equalsIgnoreCase("NETWORK:")) {
                if (this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    this.network = new CNetworkParam(this.workDir, stringArray[0]);
                    continue;
                }
                JFrame jFrame = new JFrame();
                JOptionPane.showMessageDialog(jFrame, "Invalid ntw in smu file", "Error", 0);
                return;
            }
            if (stringArray[0].equalsIgnoreCase("OUTPUT_SETUP:")) {
                if (this.parseLine(bufferedReader, stringArray, stringArray2)) continue;
                JFrame jFrame = new JFrame();
                JOptionPane.showMessageDialog(jFrame, "Invalid ous in smu file", "Error", 0);
                return;
            }
            if (!stringArray[0].equalsIgnoreCase("TREATMENTS:")) continue;
            if (this.parseLine(bufferedReader, stringArray, stringArray2)) {
                this.treatment = new CTreatmentParam(this.workDir, stringArray[0]);
                continue;
            }
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, "Invalid trt in smu file", "Error", 0);
            return;
        }
        try {
            fileReader.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

