/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class TrtBatchElemPanel
extends SubBatchElemPanel {
    JPanel trtBatchElemBase = new JPanel();
    JPanel injectPanel = new JPanel();
    XYLayout xYLayout1 = new XYLayout();
    XYLayout xYLayout2 = new XYLayout();
    JLabel lb_cell = new JLabel();
    JLabel lb_injectType = new JLabel();
    JLabel lb_timeType = new JLabel();
    JComboBox cb_injectType = new JComboBox();
    JComboBox cb_cell = new JComboBox();
    JComboBox cb_content = new JComboBox();
    CTreatment treatment;
    CTrtBatchElem trtBatchElem = null;
    BatchElemPanel batchElemPanel = null;

    public TrtBatchElemPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TrtBatchElemPanel(BatchElemPanel batchElemPanel) {
        this.batchElemPanel = batchElemPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.trtBatchElemBase.setLayout(this.xYLayout1);
        this.injectPanel.setBorder(new TitledBorder(""));
        this.injectPanel.setPreferredSize(new Dimension(400, 150));
        this.injectPanel.setLayout(this.xYLayout2);
        this.lb_cell.setText("Neuron Name");
        this.lb_injectType.setText("Injection Type");
        this.lb_timeType.setText("Content");
        this.cb_injectType.addActionListener(new TrtBatchElemPanel_cb_injectType_actionAdapter(this));
        this.cb_injectType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrtBatchElemPanel.this.cb_injectType_actionPerformed(actionEvent);
            }
        });
        this.cb_cell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrtBatchElemPanel.this.cb_cell_actionPerformed(actionEvent);
            }
        });
        this.cb_content.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrtBatchElemPanel.this.cb_content_actionPerformed(actionEvent);
            }
        });
        this.injectPanel.add((Component)this.cb_injectType, new XYConstraints(200, 5, 180, 29));
        this.injectPanel.add((Component)this.cb_cell, new XYConstraints(200, 40, 180, 29));
        this.injectPanel.add((Component)this.cb_content, new XYConstraints(200, 75, 180, 29));
        this.injectPanel.add((Component)this.lb_cell, new XYConstraints(44, 43, 104, -1));
        this.injectPanel.add((Component)this.lb_injectType, new XYConstraints(44, 8, -1, -1));
        this.injectPanel.add((Component)this.lb_timeType, new XYConstraints(44, 78, 104, -1));
        this.cb_content.addItem("START INJECTION");
        this.cb_content.addItem("STOP INJECTION");
        this.cb_content.addItem("MAGNITUDE");
        this.dirty = false;
        this.trtBatchElemBase.add((Component)this.injectPanel, new XYConstraints(1, 6, 398, 121));
        this.add((Component)this.trtBatchElemBase, "Center");
    }

    public String getInjectType() {
        String string = (String)this.cb_injectType.getSelectedItem();
        if (string.equalsIgnoreCase("CURNT_INJ:")) {
            return "0";
        }
        if (string.equalsIgnoreCase("MOD_INJ:")) {
            return "1";
        }
        if (string.equalsIgnoreCase("ICLAMP:")) {
            return "3";
        }
        if (string.equalsIgnoreCase("VCLAMP:")) {
            return "2";
        }
        return "9";
    }

    public void setSelectedInjectType(String string) {
        Object[] objectArray = new Object[1];
        if (string.equalsIgnoreCase("0")) {
            objectArray[0] = "CURNT_INJ:";
        } else if (string.equalsIgnoreCase("1")) {
            objectArray[0] = "MOD_INJ:";
        } else if (string.equalsIgnoreCase("3")) {
            objectArray[0] = "ICLAMP:";
        } else if (string.equalsIgnoreCase("2")) {
            objectArray[0] = "VCLAMP:";
        }
        this.cb_injectType.setSelectedItem(objectArray[0]);
    }

    public String getCell() {
        return String.valueOf(this.cb_cell.getSelectedIndex());
    }

    public void setSelectedCell(String string) {
        int n = Integer.parseInt(string);
        if (this.cb_cell.getItemCount() - 1 < n) {
            JOptionPane.showMessageDialog(this, "Neuron index " + n + " is wrong!", "Error", 0);
            return;
        }
        this.cb_cell.setSelectedIndex(n);
    }

    public String getContent() {
        String string = (String)this.cb_content.getSelectedItem();
        if (string.equalsIgnoreCase("START INJECTION")) {
            return "0";
        }
        if (string.equalsIgnoreCase("STOP INJECTION")) {
            return "1";
        }
        if (string.equalsIgnoreCase("MAGNITUDE")) {
            return "2";
        }
        return "9";
    }

    public void setSelectedContent(String string) {
        Object[] objectArray = new Object[]{string.equalsIgnoreCase("0") ? "START INJECTION" : (string.equalsIgnoreCase("1") ? "STOP INJECTION" : "MAGNITUDE")};
        this.cb_content.setSelectedItem(objectArray[0]);
    }

    public void setInjectType(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.cb_injectType.addItem(vector.elementAt(i));
        }
        this.cb_injectType.setSelectedIndex(0);
        this.injectPanel.revalidate();
        this.injectPanel.repaint();
    }

    private void setInjectionType() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.treatment.getInjectionNumber(); ++i) {
            vector.addElement(this.treatment.getInjectionAt(i).getType());
        }
        this.setInjectType(vector);
    }

    public void setCell(Vector vector) {
        this.cb_cell.removeAllItems();
        for (int i = 0; i < vector.size(); ++i) {
            this.cb_cell.addItem(vector.elementAt(i));
        }
        this.injectPanel.revalidate();
        this.injectPanel.repaint();
    }

    public void setCell() {
        int n;
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < this.treatment.getInjectionNumber() && !this.treatment.getInjectionAt(n).getType().equalsIgnoreCase((String)this.cb_injectType.getSelectedItem()); ++n) {
        }
        for (int i = 0; i < this.treatment.getInjectionAt(n).getInjectionCellsNumber(); ++i) {
            vector.addElement(this.treatment.getInjectionAt(n).getInjectCellAt(i).getNeuron());
        }
        this.setCell(vector);
    }

    public void setContent(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.cb_content.addItem(vector.elementAt(i));
        }
        this.injectPanel.revalidate();
        this.injectPanel.repaint();
    }

    public void setTreatment(CTreatment cTreatment) {
        this.treatment = cTreatment;
        this.setInjectionType();
        this.setCell();
    }

    public void setSubBatchElem(CSubBatchElem cSubBatchElem) {
        this.trtBatchElem = (CTrtBatchElem)cSubBatchElem;
        this.setSelectedParam();
    }

    public void setSelectedParam() {
        this.setSelectedInjectType(this.trtBatchElem.getInjectType());
        this.setSelectedCell(this.trtBatchElem.getCell());
        this.setSelectedContent(this.trtBatchElem.getContent());
    }

    public String getBatchFileElem() {
        if (this.getInjectType().trim().length() == 0 || this.getCell().trim().length() == 0 || this.getContent().trim().length() == 0) {
            return "";
        }
        String string = "";
        String string2 = ">----------------------->------------------------------->\n";
        String string3 = ">.......................>...............................>\n";
        string = string + "\t" + this.getInjectType() + "\t\t> cinj=0,minj=1,vclmp=2,iclmp=3\t>\n";
        string = string + "\t" + this.getCell() + "\t\t> which inject start from 0\t>\n";
        string = string + "\t" + this.getContent() + "\t\t> start=0, stop=1, magn=2\t>\n";
        string = string + string2;
        return string;
    }

    public void saveBatchElem(PrintWriter printWriter) {
        String string = ">----------------------->------------------------------->";
        String string2 = ">.......................>...............................>";
        printWriter.println("\t" + this.getInjectType() + "\t\t> cinj=0,minj=1,vclmp=2,iclmp=3\t>");
        printWriter.println("\t" + this.getCell() + "\t\t> which inject start from 0\t>");
        printWriter.println("\t" + this.getContent() + "\t\t> start=0, stop=1, magn=2\t>");
        printWriter.println(string);
    }

    private void readTreatment(String string, CTreatment cTreatment) {
        boolean bl = false;
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        String string2 = string;
        File file = new File(string);
        char c = File.separatorChar;
        if (!file.isFile()) {
            string = string.replace('/', c);
        }
        if (!(file = new File(string)).isFile()) {
            String string3 = file.getParent();
            String string4 = file.getName();
            file = new File(string3);
            String string5 = file.getName();
            string3 = file.getParent();
            file = new File(string3);
            string = file.getParent() + File.separator + string5 + File.separator + string4;
        }
        if (!(file = new File(string)).isFile()) {
            file = new File(string2);
            string = file.getParent() + File.separator + "trt" + File.separator + file.getName();
        }
        try {
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Error: can't open " + string, "Error", 0);
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (this.parseLine(bufferedReader, stringArray, stringArray2)) {
            CInjectionCell cInjectionCell;
            CInjection cInjection;
            String string6;
            if (stringArray[0].equalsIgnoreCase("CURNT_INJ:")) {
                string6 = stringArray[0];
                cInjection = new CInjection();
                bl = false;
                while (this.parseLine(bufferedReader, stringArray, stringArray2) && stringArray2[0].equalsIgnoreCase("NAME OF NEURON")) {
                    bl = true;
                    cInjectionCell = new CInjectionCell();
                    cInjectionCell.setNeuron(stringArray[0] + " --- " + n);
                    ++n;
                    if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                        JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                        return;
                    }
                    cInjectionCell.setStartValue(stringArray[0]);
                    if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                        JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                        return;
                    }
                    cInjectionCell.setStopValue(stringArray[0]);
                    if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                        JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                        return;
                    }
                    cInjectionCell.setMagnitudeValue(stringArray[0]);
                    cInjection.addInjectionCell(cInjectionCell);
                }
                if (!bl) continue;
                cInjection.setType(string6);
                cTreatment.addInjection(cInjection);
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("MOD_INJ:")) {
                string6 = stringArray[0];
                cInjection = new CInjection();
                bl = false;
                while (this.parseLine(bufferedReader, stringArray, stringArray2) && stringArray2[0].equalsIgnoreCase("NAME OF NEURON")) {
                    bl = true;
                    cInjectionCell = new CInjectionCell();
                    cInjectionCell.setNeuron(stringArray[0] + " --- " + n2);
                    ++n2;
                    if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                        JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                        return;
                    }
                    cInjectionCell.setModulator(stringArray[0]);
                    if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                        JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                        return;
                    }
                    cInjectionCell.setSM(stringArray[0]);
                    if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                        JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                        return;
                    }
                    cInjectionCell.setStartValue(stringArray[0]);
                    if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                        JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                        return;
                    }
                    cInjectionCell.setStopValue(stringArray[0]);
                    if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                        JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                        return;
                    }
                    cInjectionCell.setMagnitudeValue(stringArray[0]);
                    cInjection.addInjectionCell(cInjectionCell);
                }
                if (!bl) continue;
                cInjection.setType(string6);
                cTreatment.addInjection(cInjection);
                continue;
            }
            if (stringArray[0].equalsIgnoreCase("VCLAMP:")) {
                string6 = stringArray[0];
                cInjection = new CInjection();
                bl = false;
                while (this.parseLine(bufferedReader, stringArray, stringArray2) && stringArray2[0].equalsIgnoreCase("NAME OF NEURON")) {
                    bl = true;
                    cInjectionCell = new CInjectionCell();
                    cInjectionCell.setNeuron(stringArray[0] + " --- " + n3);
                    ++n3;
                    if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                        JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                        return;
                    }
                    cInjectionCell.setStartValue(stringArray[0]);
                    if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                        JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                        return;
                    }
                    cInjectionCell.setStopValue(stringArray[0]);
                    if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                        JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                        return;
                    }
                    cInjectionCell.setMagnitudeValue(stringArray[0]);
                    cInjection.addInjectionCell(cInjectionCell);
                }
                if (!bl) continue;
                cInjection.setType(string6);
                cTreatment.addInjection(cInjection);
                continue;
            }
            if (!stringArray[0].equalsIgnoreCase("ICLAMP:")) continue;
            string6 = stringArray[0];
            cInjection = new CInjection();
            bl = false;
            while (this.parseLine(bufferedReader, stringArray, stringArray2) && stringArray2[0].equalsIgnoreCase("NAME OF NEURON")) {
                bl = true;
                cInjectionCell = new CInjectionCell();
                cInjectionCell.setNeuron(stringArray[0] + " --- " + n4);
                ++n4;
                if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                    return;
                }
                cInjectionCell.setConductance(stringArray[0]);
                if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                    return;
                }
                cInjectionCell.setStartValue(stringArray[0]);
                if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                    return;
                }
                cInjectionCell.setStopValue(stringArray[0]);
                if (!this.parseLine(bufferedReader, stringArray, stringArray2)) {
                    JOptionPane.showMessageDialog(this, string + "format is wrong", "Error", 0);
                    return;
                }
                cInjectionCell.setMagnitudeValue(stringArray[0]);
                cInjection.addInjectionCell(cInjectionCell);
            }
            if (!bl) continue;
            cInjection.setType(string6);
            cTreatment.addInjection(cInjection);
        }
        try {
            fileReader.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Error: can't close " + string, "Error", 0);
        }
    }

    public void readParam(String string) {
        CTreatment cTreatment = new CTreatment();
        this.readTreatment(string, cTreatment);
        this.setTreatment(cTreatment);
    }

    void cb_injectType_actionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        this.cb_cell.removeAllItems();
        this.setCell();
    }

    void cb_cell_actionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
    }

    void cb_content_actionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
    }
}

