/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class IncrementPanel
extends JPanel {
    JPanel incrementBase = new JPanel();
    XYLayout xYLayout1 = new XYLayout();
    XYLayout xYLayout3 = new XYLayout();
    XYLayout xYLayout4 = new XYLayout();
    XYLayout xYLayout5 = new XYLayout();
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    TitledBorder titledBorder3;
    JTextField tf_startVal = new JTextField();
    JTextField tf_incrVal = new JTextField();
    JTextField tf_stopVal = new JTextField();
    JLabel lb_startVal = new JLabel("Start");
    JLabel lb_incrVal = new JLabel("Increment");
    JLabel lb_stopVal = new JLabel("Stop");
    JRadioButton rd_auto = new JRadioButton();
    JRadioButton rd_manual = new JRadioButton();
    JPanel autoPanel = new JPanel();
    JPanel manualPanel = new JPanel();
    JPanel rdPanel = new JPanel();
    JTable incrValTable;
    DefaultTableModel model = new MyTableModel(25, 2);
    boolean dirty = false;
    CIncrementBatchElem incrementBatchElem = null;

    public IncrementPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.titledBorder2 = new TitledBorder("");
        this.titledBorder3 = new TitledBorder("");
        this.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BorderLayout());
        this.incrementBase.setLayout(this.xYLayout1);
        this.rdPanel.setLayout(this.xYLayout3);
        this.rd_auto.setText("Auto");
        this.rd_auto.setForeground(new Color(0, 96, 192));
        this.rd_auto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IncrementPanel.this.rd_auto_actionPerformed(actionEvent);
            }
        });
        this.rd_auto.setSelected(true);
        this.rd_manual.setText("Manual");
        this.rd_manual.setForeground(new Color(0, 96, 192));
        this.rd_manual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IncrementPanel.this.rd_manual_actionPerformed(actionEvent);
            }
        });
        this.rdPanel.setBorder(this.titledBorder1);
        this.rdPanel.setPreferredSize(new Dimension(400, 50));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.autoPanel.setBorder(this.titledBorder3);
        this.autoPanel.setPreferredSize(new Dimension(400, 120));
        this.tf_startVal.setMargin(new Insets(0, 2, 0, 2));
        this.tf_incrVal.setMargin(new Insets(0, 2, 0, 2));
        this.tf_stopVal.setMargin(new Insets(0, 2, 0, 2));
        this.tf_startVal.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                IncrementPanel.this.tf_startVal_keyTyped(keyEvent);
            }
        });
        this.tf_incrVal.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                IncrementPanel.this.tf_incrVal_keyTyped(keyEvent);
            }
        });
        this.tf_stopVal.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                IncrementPanel.this.tf_stopVal_keyTyped(keyEvent);
            }
        });
        this.lb_stopVal.setPreferredSize(new Dimension(120, 12));
        this.lb_startVal.setPreferredSize(new Dimension(120, 12));
        this.lb_incrVal.setPreferredSize(new Dimension(120, 12));
        buttonGroup.add(this.rd_manual);
        buttonGroup.add(this.rd_auto);
        this.autoPanel.setLayout(this.xYLayout4);
        this.incrementBase.add((Component)this.rdPanel, new XYConstraints(0, 16, 398, 46));
        this.rdPanel.add((Component)this.rd_auto, new XYConstraints(101, 8, -1, -1));
        this.rdPanel.add((Component)this.rd_manual, new XYConstraints(16, 8, -1, -1));
        this.incrementBase.add((Component)this.autoPanel, new XYConstraints(0, 60, 398, 132));
        this.autoPanel.add((Component)this.tf_startVal, new XYConstraints(200, 16, 170, 28));
        this.autoPanel.add((Component)this.tf_incrVal, new XYConstraints(200, 51, 170, 28));
        this.autoPanel.add((Component)this.tf_stopVal, new XYConstraints(200, 86, 170, 28));
        this.autoPanel.add((Component)this.lb_incrVal, new XYConstraints(44, 59, -1, -1));
        this.autoPanel.add((Component)this.lb_startVal, new XYConstraints(44, 24, -1, -1));
        this.autoPanel.add((Component)this.lb_stopVal, new XYConstraints(44, 94, -1, -1));
        this.manualPanel.setLayout(this.xYLayout5);
        this.manualPanel.setBorder(this.titledBorder2);
        Object[] objectArray = new Object[2];
        this.incrValTable = new JTable(this.model);
        objectArray[0] = "No.";
        objectArray[1] = "Increment Items";
        this.model.addColumn(objectArray);
        for (int i = 0; i < 25; ++i) {
            objectArray[0] = new Integer(i + 1);
            this.model.setValueAt(objectArray[0], i, 0);
            objectArray[1] = " ";
            this.model.setValueAt(objectArray[1], i, 1);
        }
        this.incrValTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                IncrementPanel.this.model_tableChanged(tableModelEvent);
            }
        });
        this.incrValTable.setIntercellSpacing(new Dimension(16, 4));
        this.incrValTable.setRowHeight(22);
        JScrollPane jScrollPane = new JScrollPane(this.incrValTable);
        this.incrValTable.setPreferredScrollableViewportSize(new Dimension(400, 70));
        this.manualPanel.add((Component)jScrollPane, new XYConstraints(100, 15, 228, 93));
        this.dirty = false;
        this.add((Component)this.incrementBase, "Center");
    }

    public String getIncrType() {
        if (this.rd_manual.isSelected()) {
            return "0";
        }
        if (this.rd_auto.isSelected()) {
            return "1";
        }
        return "9";
    }

    private void setManualType() {
        this.rd_manual.setSelected(true);
        this.incrementBase.remove(this.autoPanel);
        this.incrementBase.revalidate();
        this.incrementBase.repaint();
        this.incrementBase.add((Component)this.manualPanel, new XYConstraints(0, 60, 398, 132));
        this.incrementBase.revalidate();
        this.incrementBase.repaint();
        this.revalidate();
    }

    public void setAutoType() {
        this.rd_auto.setSelected(true);
        this.incrementBase.remove(this.manualPanel);
        this.incrementBase.revalidate();
        this.incrementBase.repaint();
        this.incrementBase.add((Component)this.autoPanel, new XYConstraints(0, 60, 398, 132));
        this.autoPanel.setVisible(true);
        this.incrementBase.revalidate();
        this.incrementBase.repaint();
        this.revalidate();
    }

    public void setUnit(String string) {
        Object[] objectArray = new Object[2];
        int n = 0;
        this.lb_startVal.setText("Start Value (" + string + ")");
        this.lb_incrVal.setText("Increment (" + string + ")");
        this.lb_stopVal.setText("Stop Value (" + string + ")");
        objectArray[0] = new String("No.");
        objectArray[1] = new String("Increment (") + string + ")";
        this.model.setColumnIdentifiers(objectArray);
        n = 40;
        TableColumn tableColumn = this.incrValTable.getColumn(objectArray[0]);
        tableColumn.setMaxWidth(n);
        tableColumn.setMinWidth(n);
        n = 200;
        tableColumn = this.incrValTable.getColumn(objectArray[1]);
        tableColumn.setMaxWidth(n);
        tableColumn.setMinWidth(n);
    }

    public String getStartValue() {
        return this.tf_startVal.getText();
    }

    public String getStopValue() {
        return this.tf_stopVal.getText();
    }

    public String getIncrementValue() {
        return this.tf_incrVal.getText();
    }

    public Vector getManualValue() {
        Vector<String> vector = new Vector<String>();
        String string = null;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            string = (String)this.model.getValueAt(i, 1);
            if (string.trim().length() == 0) continue;
            vector.addElement(string);
        }
        return vector;
    }

    public void setIncrementType(String string) {
        if (string.equalsIgnoreCase("0")) {
            this.setManualType();
        } else {
            this.setAutoType();
        }
    }

    public void setManualIncrement(String string, int n) {
        Object[] objectArray = new Object[]{new Integer(this.model.getRowCount() + 1), string};
        if (n < this.model.getRowCount()) {
            this.model.setValueAt(string, n, 1);
        } else {
            this.model.addRow(objectArray);
        }
    }

    public void setAutoStartValue(String string) {
        this.tf_startVal.setText(string);
    }

    public void setAutoStopValue(String string) {
        this.tf_stopVal.setText(string);
    }

    public void setAutoIncrementValue(String string) {
        this.tf_incrVal.setText(string);
    }

    public void cleanTable() {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.model.removeRow(i);
        }
    }

    public void clean() {
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setSubBatchElem(CSubBatchElem cSubBatchElem) {
        this.incrementBatchElem = (CIncrementBatchElem)cSubBatchElem;
        this.setSelectedParam();
    }

    public void setSelectedParam() {
        this.setIncrementType(this.incrementBatchElem.getIncrementType());
        if (this.incrementBatchElem.getIncrementType().equalsIgnoreCase("0")) {
            Vector vector = this.incrementBatchElem.getManualIncrementValue();
            for (int i = 0; i < vector.size(); ++i) {
                this.setManualIncrement((String)vector.elementAt(i), i);
            }
        } else {
            this.setAutoStartValue(this.incrementBatchElem.getAutoStartValue());
            this.setAutoStopValue(this.incrementBatchElem.getAutoStopValue());
            this.setAutoIncrementValue(this.incrementBatchElem.getAutoIncrementValue());
        }
    }

    public void readParam(String string) {
    }

    public String getBatchFileElem() {
        String string;
        String string2;
        String string3;
        if (this.getIncrType().equalsIgnoreCase("1")) {
            string3 = this.getStartValue().trim();
            string2 = this.getIncrementValue().trim();
            string = this.getStopValue().trim();
            double d = Double.valueOf(string3);
            double d2 = Double.valueOf(string2);
            double d3 = Double.valueOf(string);
            if (string3.length() == 0 || string2.trim().length() == 0 || string.trim().length() == 0) {
                return "";
            }
            if (Math.abs(d2) > 1.0E-12 && Math.abs((d3 - d) / d2) > 24.0) {
                return "Overflow";
            }
        } else {
            if (this.getManualValue().size() < 1) {
                return "";
            }
            if (this.getManualValue().size() > 25) {
                return "Overflow";
            }
        }
        string3 = "";
        string2 = ">----------------------->------------------------------->\n";
        string = ">.......................>...............................>\n";
        string3 = string3 + "\t" + this.getIncrType() + "\t\t>\tManual=0, Auto=1\t>\n";
        string3 = string3 + string2;
        if (this.getIncrType().equalsIgnoreCase("1")) {
            string3 = string3 + "\t" + this.getStartValue() + "\t\t>\tStart value\t\t>\n";
            string3 = string3 + string2;
            string3 = string3 + "\t" + this.getIncrementValue() + "\t\t>\tIncrement\t\t>\n";
            string3 = string3 + string2;
            string3 = string3 + "\t" + this.getStopValue() + "\t\t>\tStop value\t\t>\n";
            string3 = string3 + string2;
        } else {
            Vector vector = this.getManualValue();
            string3 = string3 + "\t" + vector.size() + "\t\t>   number of parameter values\t>\n";
            string3 = string3 + string2;
            for (int i = 0; i < vector.size(); ++i) {
                string3 = string3 + "\t" + vector.elementAt(i) + "\t\t>\tOne value\t\t>\n";
                string3 = string3 + string2;
            }
        }
        return string3;
    }

    public void saveBatchElem(PrintWriter printWriter) {
        String string = ">----------------------->------------------------------->";
        String string2 = ">.......................>...............................>";
        printWriter.println("\t" + this.getIncrType() + "\t\t>\tManual=0, Auto=1\t>");
        printWriter.println(string);
        if (this.getIncrType().equalsIgnoreCase("1")) {
            printWriter.println("\t" + this.getStartValue() + "\t\t>\tStart value\t\t>");
            printWriter.println(string);
            printWriter.println("\t" + this.getIncrementValue() + "\t\t>\tIncrement\t\t>");
            printWriter.println(string);
            printWriter.println("\t" + this.getStopValue() + "\t\t>\tStop value\t\t>");
            printWriter.println(string);
        } else {
            Vector vector = this.getManualValue();
            printWriter.println("\t" + vector.size() + "\t\t>   number of parameter values\t>");
            printWriter.println(string);
            for (int i = 0; i < vector.size(); ++i) {
                printWriter.println("\t" + vector.elementAt(i) + "\t\t>\tOne value\t\t>");
                printWriter.println(string);
            }
        }
    }

    void model_tableChanged(TableModelEvent tableModelEvent) {
        this.dirty = true;
    }

    void rd_manual_actionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        this.setManualType();
    }

    void rd_auto_actionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        this.setAutoType();
    }

    void tf_stopVal_keyTyped(KeyEvent keyEvent) {
        this.dirty = true;
    }

    void tf_startVal_keyTyped(KeyEvent keyEvent) {
        this.dirty = true;
    }

    void tf_incrVal_keyTyped(KeyEvent keyEvent) {
        this.dirty = true;
    }

    void incrValTable_keyTyped(KeyEvent keyEvent) {
        this.dirty = true;
    }
}

