/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public final class cell_Dialog
extends JDialog
implements ActionListener {
    private int width = 18;
    private int height = 19;
    private int which_cell = 0;
    private int cur_cell = 0;
    private double[] prm_cell = new double[10];
    private double transThresh = 0.0;
    private double threshold = 0.0;
    private double SD = 0.0;
    private double Cm = 1.0;
    private int waveForm = 1;
    private double refractory = 0.0;
    private Rectangle transThresh_Rect = null;
    private Rectangle threshold_Rect = null;
    private Rectangle Cm_Rect = null;
    private Rectangle waveForm_Rect = null;
    private Rectangle refractory_Rect = null;
    private int which_Rect = 0;
    private JButton open_butt;
    private JButton save_butt;
    private JButton saveas_butt;
    private JButton edit_butt;
    private JButton browse_butt;
    private JButton ok_butt;
    private String dirname = null;
    private String cell_name = null;
    private String tmpStr = null;
    private int modified = 0;
    private JLabel lbTitle;

    public cell_Dialog(JFrame jFrame, String string, String string2, String string3) {
        super(jFrame, string, true);
        this.dirname = string2;
        this.cell_name = string3;
        this.readAll_cell(string2 + this.cell_name, "0");
        this.transThresh = this.prm_cell[0];
        if (this.cur_cell >= 2) {
            this.threshold = this.prm_cell[1];
        }
        if (this.cur_cell == 3) {
            this.SD = this.prm_cell[2];
            this.Cm = this.prm_cell[3];
            this.waveForm = (int)(this.prm_cell[4] + 0.5);
            this.refractory = this.prm_cell[5];
        }
        Container container = this.getContentPane();
        container.setLayout(null);
        this.lbTitle = new JLabel(this.dirname + this.cell_name, 2);
        this.lbTitle.setForeground(new Color(0, 128, 255));
        this.lbTitle.setBounds(15, 0, 280, 25);
        this.lbTitle.setToolTipText("Current working directory and file");
        container.add(this.lbTitle);
        this.open_butt = this.makeButton("Open", 15, 35, 60, 25);
        container.add(this.open_butt);
        this.save_butt = this.makeButton("Save", 80, 35, 60, 25);
        container.add(this.save_butt);
        this.saveas_butt = this.makeButton("Save As", 145, 35, 60, 25);
        container.add(this.saveas_butt);
        this.edit_butt = this.makeButton("Edit", 210, 35, 60, 25);
        container.add(this.edit_butt);
        this.browse_butt = this.makeButton("Browse", 15, 385, 80, 25);
        this.browse_butt.setBorder(BorderFactory.createRaisedBevelBorder());
        container.add(this.browse_butt);
        this.ok_butt = this.makeButton("Ok", 240, 385, 80, 25);
        this.ok_butt.setBorder(BorderFactory.createRaisedBevelBorder());
        container.add(this.ok_butt);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                cell_Dialog.this.getParent().setVisible(true);
                cell_Dialog.this.dispose();
            }
        });
        this.enableEvents(16L);
        this.setResizable(false);
        this.setLocation(250, 120);
        this.setSize(340, 450);
    }

    public JButton makeButton(String string, int n, int n2, int n3, int n4) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setMargin(new Insets(1, 2, 1, 2));
        jButton.setBounds(n, n2, n3, n4);
        return jButton;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        graphics.setColor(Color.gray);
        graphics.drawLine(0, 25, this.getWidth(), 25);
        graphics.setColor(Color.white);
        graphics.drawLine(0, 26, this.getWidth(), 26);
        graphics.setColor(Color.white);
        graphics.fillRect(15, 70, this.getWidth() - 30 - insets.left - insets.right, this.getHeight() - 70 - 80);
        graphics.setColor(Color.darkGray);
        graphics.drawRect(15, 70, this.getWidth() - 30 - insets.left - insets.right, this.getHeight() - 70 - 80);
        graphics.setFont(new Font("Serif", 2, 18));
        this.threshold_Rect = null;
        this.Cm_Rect = null;
        this.transThresh_Rect = null;
        this.waveForm_Rect = null;
        this.refractory_Rect = null;
        switch (this.cur_cell) {
            case 1: {
                this.transThresh_Rect = new Rectangle(52, 247, this.width + 76, this.height);
                graphics.setColor(Color.lightGray);
                graphics.fillRoundRect(this.transThresh_Rect.x, this.transThresh_Rect.y, this.transThresh_Rect.width, this.transThresh_Rect.height, 5, 5);
                graphics.setColor(Color.blue.darker());
                graphics.setFont(new Font("Serif", 2, 18));
                graphics.drawString("Net = ", 50, 120);
                this.drawSigma(graphics, 80, 120, "i = 0", "#synapse");
                graphics.setFont(new Font("Serif", 1, 24));
                graphics.drawString("I", 140, 124);
                graphics.setFont(new Font("Serif", 2, 16));
                graphics.drawString("i", 150, 128);
                graphics.setFont(new Font("Serif", 2, 15));
                graphics.drawString("V = 1/(1+exp(-Net))", 90, 170);
                graphics.setColor(Color.black);
                graphics.setFont(new Font("Serif", 0, 16));
                graphics.drawString(" {", 35, 260);
                graphics.setFont(new Font("Serif", 2, 16));
                graphics.drawString("threshold_t_r   =  " + this.transThresh, 55, 260);
                break;
            }
            case 2: {
                this.transThresh_Rect = new Rectangle(52, 247, this.width + 76, this.height);
                this.threshold_Rect = new Rectangle(52, 272, this.width + 50, this.height);
                graphics.setColor(Color.lightGray);
                graphics.fillRoundRect(this.transThresh_Rect.x, this.transThresh_Rect.y, this.transThresh_Rect.width, this.transThresh_Rect.height, 5, 5);
                graphics.fillRoundRect(this.threshold_Rect.x, this.threshold_Rect.y, this.threshold_Rect.width, this.threshold_Rect.height, 5, 5);
                graphics.setColor(Color.blue.darker());
                graphics.setFont(new Font("Serif", 2, 18));
                graphics.drawString("Net = ", 50, 120);
                this.drawSigma(graphics, 80, 120, "i = 0", "#synapse");
                graphics.setFont(new Font("Serif", 1, 24));
                graphics.drawString("I", 140, 124);
                graphics.setFont(new Font("Serif", 2, 15));
                graphics.drawString("i", 150, 128);
                this.drawBracet(graphics, 95, 176, 14);
                graphics.drawString("1    if  Net > threshold", 110, 170);
                graphics.drawString("0    else ", 110, 195);
                graphics.drawString("Out = ", 50, 180);
                graphics.setColor(Color.black);
                this.drawBracet(graphics, 40, 268, 18);
                graphics.setFont(new Font("Serif", 2, 16));
                graphics.drawString("threshold_t_r  =  " + this.transThresh, 55, 260);
                graphics.drawString("threshold        =  " + this.threshold, 55, 285);
                break;
            }
            case 3: {
                this.transThresh_Rect = new Rectangle(57, 237, this.width + 76, this.height);
                this.threshold_Rect = new Rectangle(57, 262, this.width + 50, this.height);
                this.Cm_Rect = new Rectangle(158, 147, this.width + 6, this.height);
                this.waveForm_Rect = new Rectangle(57, 312, this.width + 56, this.height);
                this.refractory_Rect = new Rectangle(57, 337, this.width + 54, this.height);
                graphics.setColor(Color.lightGray);
                graphics.fillRoundRect(this.transThresh_Rect.x, this.transThresh_Rect.y, this.transThresh_Rect.width, this.transThresh_Rect.height, 5, 5);
                graphics.fillRoundRect(this.threshold_Rect.x, this.threshold_Rect.y, this.threshold_Rect.width, this.threshold_Rect.height, 5, 5);
                graphics.fillRoundRect(this.Cm_Rect.x, this.Cm_Rect.y, this.Cm_Rect.width, this.Cm_Rect.height, 5, 5);
                graphics.fillRoundRect(this.waveForm_Rect.x, this.waveForm_Rect.y, this.waveForm_Rect.width, this.waveForm_Rect.height, 5, 5);
                graphics.fillRoundRect(this.refractory_Rect.x, this.refractory_Rect.y, this.refractory_Rect.width, this.refractory_Rect.height, 5, 5);
                graphics.setColor(Color.blue.darker());
                graphics.setFont(new Font("Serif", 2, 18));
                graphics.drawString("V = ", 50, 150);
                this.drawSigma(graphics, 85, 125, " i = 0", "#steps");
                this.drawSigma(graphics, 130, 125, " j = 0", "#synapse");
                graphics.setFont(new Font("Serif", 1, 24));
                graphics.drawString("dt   I", 182, 130);
                graphics.setFont(new Font("Serif", 2, 15));
                graphics.drawString("ij    ij", 205, 135);
                graphics.drawLine(85, 145, 240, 145);
                graphics.drawString("Cm", 160, 160);
                graphics.setColor(Color.black);
                this.drawBracet(graphics, 40, 296, 50);
                graphics.setFont(new Font("Serif", 2, 16));
                graphics.drawString("threshold_t_r  = " + this.transThresh, 60, 250);
                graphics.drawString("threshold  = Gaussian(" + this.threshold + ", " + this.SD + ")", 60, 275);
                graphics.drawString("Cm   = " + this.Cm, 60, 300);
                graphics.drawString("waveForm  = " + this.waveForm, 60, 325);
                graphics.drawString("refractory  = " + this.refractory, 60, 350);
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void drawSigma(Graphics graphics, int n, int n2, String string, String string2) {
        graphics.setFont(new Font("Serif", 0, 13));
        graphics.drawString(string, n + 15, n2 + 16);
        graphics.drawString(string2, n + 15, n2 - 20);
        graphics.drawLine(n += 16, n2 -= 14, n + 20, n2);
        graphics.drawLine(n, n2, n + 8, n2 + 9);
        graphics.drawLine(n + 8, n2 + 9, n, n2 + 18);
        graphics.drawLine(n, n2 + 18, n + 20, n2 + 18);
    }

    private void drawBracet(Graphics graphics, int n, int n2, int n3) {
        int n4 = Math.max(n3 / 10, 2);
        graphics.drawLine(n, n2, n + n4, n2 - n4);
        graphics.drawLine(n, n2, n + n4, n2 + n4);
        graphics.drawLine(n + n4, n2 - n4, n + n4, n2 - n3);
        graphics.drawLine(n + n4, n2 + n4, n + n4, n2 + n3);
        graphics.drawLine(n + n4, n2 - n3, n + n4 * 2, n2 - n3 - n4);
        graphics.drawLine(n + n4, n2 + n3, n + n4 * 2, n2 + n3 + n4);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            Graphics graphics = this.getGraphics();
            Insets insets = this.getInsets();
            graphics.translate(insets.left, insets.top);
            this.which_Rect = 0;
            int n = mouseEvent.getX() - insets.left;
            int n2 = mouseEvent.getY() - insets.top;
            if (this.transThresh_Rect != null && this.transThresh_Rect.contains(n, n2)) {
                this.which_Rect = 1;
            } else if (this.threshold_Rect != null && this.threshold_Rect.contains(n, n2)) {
                this.which_Rect = 2;
            } else if (this.Cm_Rect != null && this.Cm_Rect.contains(n, n2)) {
                this.which_Rect = 3;
            } else if (this.waveForm_Rect != null && this.waveForm_Rect.contains(n, n2)) {
                this.which_Rect = 4;
            } else if (this.refractory_Rect != null && this.refractory_Rect.contains(n, n2)) {
                this.which_Rect = 5;
            }
            graphics.setColor(Color.cyan);
            if (this.which_Rect == 1) {
                graphics.drawRoundRect(this.transThresh_Rect.x, this.transThresh_Rect.y, this.transThresh_Rect.width, this.transThresh_Rect.height, 5, 5);
            } else if (this.which_Rect == 2) {
                graphics.drawRoundRect(this.threshold_Rect.x, this.threshold_Rect.y, this.threshold_Rect.width, this.threshold_Rect.height, 5, 5);
            } else if (this.which_Rect == 3) {
                graphics.drawRoundRect(this.Cm_Rect.x, this.Cm_Rect.y, this.Cm_Rect.width, this.Cm_Rect.height, 5, 5);
            } else if (this.which_Rect == 4) {
                graphics.drawRoundRect(this.waveForm_Rect.x, this.waveForm_Rect.y, this.waveForm_Rect.width, this.waveForm_Rect.height, 5, 5);
            } else if (this.which_Rect == 5) {
                graphics.drawRoundRect(this.refractory_Rect.x, this.refractory_Rect.y, this.refractory_Rect.width, this.refractory_Rect.height, 5, 5);
            }
            if (this.which_Rect == 1) {
                DoubleDialog doubleDialog = new DoubleDialog((JFrame)this.getParent(), this.cell_name, "Parameter transThresh:", this.transThresh);
                doubleDialog.setLocation(this.getLocation().x + n + 50, this.getLocation().y + n2);
                doubleDialog.setVisible(true);
                this.prm_cell[0] = this.transThresh = doubleDialog.getValue();
                this.repaint();
                this.modified = 1;
            } else if (this.which_Rect == 2) {
                if (this.cur_cell != 3) {
                    DoubleDialog doubleDialog = new DoubleDialog((JFrame)this.getParent(), this.cell_name, "Parameter threshold:", this.threshold);
                    doubleDialog.setLocation(this.getLocation().x + n + 50, this.getLocation().y + n2);
                    doubleDialog.setVisible(true);
                    this.prm_cell[1] = this.threshold = doubleDialog.getValue();
                    this.repaint();
                    this.modified = 1;
                } else {
                    Gaussian_Dialog gaussian_Dialog = new Gaussian_Dialog((JFrame)this.getParent(), this.cell_name + " -- Threshold", this.threshold, this.SD);
                    gaussian_Dialog.setLocation(this.getLocation().x + this.getWidth(), this.getLocation().y + 244);
                    gaussian_Dialog.setVisible(true);
                    this.threshold = gaussian_Dialog.getMean();
                    this.SD = gaussian_Dialog.getSD();
                    this.prm_cell[1] = this.threshold;
                    this.prm_cell[2] = this.SD;
                    this.repaint();
                    this.modified = 1;
                }
            } else if (this.which_Rect == 3) {
                DoubleDialog doubleDialog = new DoubleDialog((JFrame)this.getParent(), this.cell_name, "Parameter Cm:", this.Cm);
                doubleDialog.setLocation(this.getLocation().x + n + 50, this.getLocation().y + n2);
                doubleDialog.setVisible(true);
                this.prm_cell[3] = this.Cm = doubleDialog.getValue();
                this.repaint();
                this.modified = 1;
            } else if (this.which_Rect == 4) {
                WaveForm_Dialog waveForm_Dialog = new WaveForm_Dialog((JFrame)this.getParent(), "cell spike -- Wave Form");
                waveForm_Dialog.setLocation(this.getLocation().x + this.getWidth(), this.getLocation().y + 260);
                waveForm_Dialog.setVisible(true);
                int n3 = waveForm_Dialog.getEquation();
                if (n3 != 0) {
                    this.waveForm = n3;
                    this.prm_cell[4] = this.waveForm;
                }
                this.repaint();
                this.modified = 1;
            } else if (this.which_Rect == 5) {
                DoubleDialog doubleDialog = new DoubleDialog((JFrame)this.getParent(), this.cell_name, "Parameter refractory:", this.refractory);
                doubleDialog.setLocation(this.getLocation().x + n + 50, this.getLocation().y + n2);
                doubleDialog.setVisible(true);
                this.prm_cell[5] = this.refractory = doubleDialog.getValue();
                this.repaint();
                this.modified = 1;
            }
            graphics.dispose();
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    public void readAll_cell(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        if (string2.equals("1")) {
            System.out.println("Reading 'cell' file: " + string);
        }
        try {
            int n5;
            fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            while ((n5 = this.which_section_cell(bufferedReader)) != 0) {
                switch (n5) {
                    case 1: {
                        this.prm_cell[0] = this.read_ln_double(this.tmpStr);
                        break;
                    }
                    case 2: {
                        n3 = RW_all.read_int(bufferedReader);
                        break;
                    }
                    case 3: {
                        n2 = RW_all.read_int(bufferedReader);
                        switch (n2) {
                            case 1: {
                                n4 = 0;
                                break;
                            }
                            case 2: {
                                n4 = 1;
                                break;
                            }
                            case 3: {
                                n4 = 5;
                            }
                        }
                        this.which_cell = this.cur_cell = n2;
                        for (n = 1; n <= n4; ++n) {
                            this.prm_cell[n] = RW_all.read_double(bufferedReader);
                        }
                        break;
                    }
                }
            }
            fileReader.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, string + " openig failure!", "Error", 0);
        }
    }

    private double read_ln_double(String string) {
        double d = 0.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            string = stringTokenizer.nextToken();
        } else {
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, "Read_ln_double error!", "Error", 0);
        }
        string = string.trim();
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            JFrame jFrame = new JFrame();
            JOptionPane.showMessageDialog(jFrame, numberFormatException, "Error", 0);
            d = 0.0;
        }
        return d;
    }

    private int which_section_cell(BufferedReader bufferedReader) {
        int n = 0;
        this.tmpStr = RW_all.read_string(bufferedReader);
        if (this.tmpStr == null) {
            return 0;
        }
        if (this.tmpStr.indexOf("THRESHOLD:") != -1) {
            n = 1;
        }
        if (this.tmpStr.equals("Net:")) {
            n = 2;
        } else if (this.tmpStr.equals("Out:")) {
            n = 3;
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Open")) {
            String[] stringArray = new String[]{"cell", "CELL"};
            MyFileChooser myFileChooser = new MyFileChooser(this.dirname, stringArray);
            int n = myFileChooser.showOpenDialog((JFrame)this.getParent());
            if (n == 0) {
                String string2 = myFileChooser.getSelectedFile().getName();
                String string3 = myFileChooser.getCurrentDirectory().getAbsolutePath() + System.getProperty("file.separator");
                this.cell_name = null;
                if (string2 != null && string2.toLowerCase().endsWith(".cell")) {
                    this.dirname = string3;
                    this.cell_name = string2;
                }
                myFileChooser = null;
                if (this.dirname != null && this.cell_name != null && this.cell_name.toLowerCase().endsWith(".cell")) {
                    this.readAll_cell(this.dirname + this.cell_name, "0");
                    this.lbTitle.setText(this.dirname + this.cell_name);
                    this.transThresh = this.prm_cell[0];
                    if (this.cur_cell >= 2) {
                        this.threshold = this.prm_cell[1];
                    }
                    if (this.cur_cell == 3) {
                        this.SD = this.prm_cell[2];
                        this.Cm = this.prm_cell[3];
                        this.waveForm = (int)(this.prm_cell[4] + 0.5);
                        this.refractory = this.prm_cell[5];
                    }
                    this.repaint();
                }
            }
        } else if (string.equals("Save")) {
            RW_cell rW_cell = new RW_cell(this.dirname, this.cell_name, this.prm_cell, this.cur_cell);
            if (rW_cell.write_cell(this.dirname, this.cell_name) != -1) {
                this.modified = 0;
            } else {
                JOptionPane.showMessageDialog((JFrame)this.getParent(), "Save failed! ", "Error", 0);
            }
        } else if (string.equals("Save As")) {
            MyFileChooser myFileChooser = new MyFileChooser(this.dirname, "cell");
            int n = myFileChooser.showSaveDialog((JFrame)this.getParent());
            if (n == 0) {
                String string4 = myFileChooser.getSelectedFile().getName();
                String string5 = myFileChooser.getCurrentDirectory().getAbsolutePath() + System.getProperty("file.separator");
                if (string4 != null && !string4.toLowerCase().endsWith(".cell")) {
                    string4 = string4 + ".cell";
                }
                if (string4 != null && string4.toLowerCase().endsWith(".cell")) {
                    RW_cell rW_cell = new RW_cell(this.dirname, this.cell_name, this.prm_cell, this.cur_cell);
                    if (rW_cell.write_cell(string5, string4) != -1) {
                        this.modified = 0;
                        this.dirname = string4;
                        this.cell_name = string4;
                        this.lbTitle.setText(this.dirname + this.cell_name);
                    }
                } else {
                    JOptionPane.showMessageDialog((JFrame)this.getParent(), "Save failed! ", "Error", 0);
                }
            }
        } else if (string.equals("Edit")) {
            cellfx_Dialog cellfx_Dialog2 = new cellfx_Dialog((JFrame)this.getParent(), "cell- Equations");
            cellfx_Dialog2.setLocation(this.getLocation().x + this.getWidth(), this.getLocation().y);
            cellfx_Dialog2.setVisible(true);
            int n = cellfx_Dialog2.getEquation();
            if (this.cur_cell != n && n != 0) {
                this.cur_cell = n;
                RW_cell rW_cell = new RW_cell(this.dirname, this.cell_name, this.prm_cell, this.cur_cell);
                rW_cell.read_cell();
                rW_cell.get_prm_cell(this.prm_cell);
                rW_cell = null;
                this.transThresh = this.prm_cell[0];
                if (this.cur_cell >= 2) {
                    this.threshold = this.prm_cell[1];
                }
                if (this.cur_cell == 3) {
                    this.SD = this.prm_cell[2];
                    this.Cm = this.prm_cell[3];
                    this.waveForm = (int)(this.prm_cell[4] + 0.5);
                    this.refractory = this.prm_cell[5];
                }
                this.modified = 1;
                this.repaint();
            }
        } else if (string.equals("Browse")) {
            BrowseDialog browseDialog = new BrowseDialog((JFrame)this.getParent(), "SNNAP:  Browse Input File", this.dirname + this.cell_name);
            browseDialog.setVisible(true);
        } else if (string.equals("Ok")) {
            RW_cell rW_cell;
            int n = 1;
            if (this.modified == 1) {
                n = JOptionPane.showConfirmDialog((JFrame)this.getParent(), "File modified.  Do you wish to save it?", "Save Modified File?", 1, 3);
            }
            if (n == 2 || n == -1) {
                return;
            }
            if (n == 0 && (rW_cell = new RW_cell(this.dirname, this.cell_name, this.prm_cell, this.cur_cell)).write_cell(this.dirname, this.cell_name) != -1) {
                this.modified = 0;
            }
            this.getParent().setVisible(true);
            this.dispose();
        }
    }
}

