function [] = generate_param_based_FlyGlom_odour_response(odour_ID,N)
% This function uses the parameter structure generated by the
% convert_PNrep_to_fly_glom.m function to create multiple trial
% responses to a given odour. Takes odour ID and N (number of odour
% responses required as input.
    for n = 1:N
        if isa(odour_ID, 'char')
        else    
            error('odour_ID must be of type char')
        end

        foldername = strcat('/home/adithya/Documents/MATLAB/Odour_PNresponse_params_300PNs/',odour_ID);

        cd(foldername);

        files_in_folder = dir(foldername);

        param_filename = 'parameters_FlyGlom.mat';

        number_exisitng_response_matrices = length(dir(foldername)) - 3;

        trial_number = number_exisitng_response_matrices + 1;

        load(param_filename);


        % generate the odour representation matrix : # of rows = # of PNs; # of
        % columns = trial duration


        odour_onset_time = 500; %(ms)
        number_PNs = 300; % number of Projection Neurons (PNs) in the system 
        trial_duration = 3000; % duration of the trial (ms)

        odour_rep_PN = zeros(number_PNs, trial_duration);

        % Create baseline spiking reponse for all neurons
        for i = 1:number_PNs
            n_b = round(2.23*randn(1) + 3.87); % n_b - baseline number of spikes generated by the neuron
            while n_b < 0 
                n_b = round(2.23*randn(1) + 3.87);
            end
            spike_location = randi(trial_duration,n_b,1); % defines location of spikes in time
            for j = 1:length(spike_location)
                odour_rep_PN(i,spike_location(j)) = 1;
            end    
        end

        % Create odour induced spiking response.
        for k = 1:50
            activity = PNrep_F.n_r(k);
            if activity ~= 0
                n_r = PNrep_F.n_r(k);
                n_e = PNrep_F.n_e(k);
                d_f = PNrep_F.d_f(k);
                s_c = PNrep_F.s_c(k);
            
                for n = 1:6
                    for l = 1:n_e
                        odour_spike_locations = round(12*randn(s_c)+25);
                        for m = 1:length(odour_spike_locations)
                            if odour_spike_locations(m) <0 || odour_spike_locations(m) >50
                                odour_spike_locations(m) = round(12*randn(1)+25);
                            end
                            % This step adds spikes to the odour_rep_PN matrix at position
                            % [Number of responding PN, 500ms(time of odour onset) +
                            % 50ms(starting time for one cycle of LFP)*lth cycle in which that
                            % neuron fires + location of spike in that cycle]
                            odour_rep_PN(((k-1)*6+n),odour_onset_time +(d_f+l-1)*50+odour_spike_locations(m)) = 1; 
                        end    
                    end
                end 
            
            end 

        end

        filename = sprintf('trial%d',trial_number);
        xlswrite(filename, odour_rep_PN);
    end
end