/*----------------------------------------------------------------
$Header$
diecc1f.asc  translated Tue Oct 26 17:43:54 1993 by ntscable 2.0
source file syntax: Eutectic
output file syntax: NEURON
soma: diameter = 9.6822 um  length = 16.3865 um  area = 498.436 um2
      11 three-D points; 12 outline points numbered 1-12
      outline diameter = 13.5288 um; z coordinates averaged
5 primary neurites
44 branches totaling 7576.54 um in length, 31225.5 um2 in area
2204 tree points translated to 198 segments (1 requested)
Neurites divided into segments of equal dx between adjacent digitized
branch points.
Segment length constrained to be < 50 um.
No. points   2216
No. trees       6

Cell 51/2A - Cat SS cortex, layer 6, pyr.  
Cell traced by A Destexhe in D. Amaral's lab at Salk Institute (1993)

Layer VI cortical pyramidal cell from cat somatosensory cortex.  The
physiology of that cell and the modeling are described in:

  Contreras, D., Destexhe, A. and Steriade, M. (1997) Intracellular and
  computational characterization of the intracortical inhibitory control of
  synchronized thalamic inputs in vivo.  
  Journal of Neurophysiology 78: 335-350, 1997.  

Please cite this reference if you use that geometry
 
----------------------------------------------------------------*/

					/* make geometry explicit */
primary_branches_cell = 5
branches_cell = 44
max_dx_cell = 50
points_cell = 2204
nseg_cell = 198
double sections_cell[5]
sections_cell[0] = 13
sections_cell[1] = 3
sections_cell[2] = 19
sections_cell[3] = 9
sections_cell[4] = 39
nsec_cell = 84

strdef name_soma, name_section
name_soma = "soma"
name_section = "dend"
use_axon = 0					/* create sections */
create    soma,\
          dend1[13],\
          dend2[3],\
          dend3[19],\
          dend4[9],\
          dend5[39]



/*----------------------------------------------------------------*/
proc geometry() { local i, j

						/* soma geometry */
    soma {
        nseg = 1
        pt3dclear()
        for j = 1, fscan() {
            pt3dadd(fscan(),fscan(),fscan(),fscan())
        }
    }

					/* connect primary neurites */
    soma connect dend1[0] (0), 0.5
    soma connect dend2[0] (0), 0.5
    soma connect dend3[0] (0), 0.5
    soma connect dend4[0] (0), 0.5
    soma connect dend5[0] (0), 0.5


					/* neurite geometry*/
    for i = 0,12 {
        dend1[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,2 {
        dend2[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,18 {
        dend3[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,8 {
        dend4[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,38 {
        dend5[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }



					/* branching topology*/
    for i = 1,12 {
        dend1[fscan()] connect dend1[i] (0), fscan()
    }

    for i = 1,2 {
        dend2[fscan()] connect dend2[i] (0), fscan()
    }

    for i = 1,18 {
        dend3[fscan()] connect dend3[i] (0), fscan()
    }

    for i = 1,8 {
        dend4[fscan()] connect dend4[i] (0), fscan()
    }

    for i = 1,38 {
        dend5[fscan()] connect dend5[i] (0), fscan()
    }

}

geometry()


SOMA COORDINATES AND DIAMETERS:

    11
      -9    -14.5  -43.167        0
      -9   -12.25  -43.167      4.5
      -8  -11.917  -43.167   9.8333
    -7.5   -12.35  -43.167     11.3
    -5.5   -12.25  -43.167     13.5
    -4.5  -12.571  -43.167   13.857
      -2  -12.889  -43.167   13.778
       0  -13.667  -43.167   12.667
       1  -13.667  -43.167   11.333
       3  -15.167  -43.167   5.6667
       4    -14.5  -43.167        0


NEURITE COORDINATES AND DIAMETERS:

    1 3
     0.5       -8    -64.5      3.9
     5.5       -3      -66        4
       6        5      -70      2.4

    1 2
       6        5      -70      2.4
      11      6.5      -77      1.7

    2 15
      11      6.5      -77      1.7
      15        7    -79.5      1.3
      18      3.5      -83      1.3
    19.5        4      -86        1
    22.5        3      -89        1
    22.5        1      -91        1
      25        0      -93        1
      26        2      -95        1
    27.5        2    -96.5        1
    30.5      1.5      -99        1
    30.5      1.5   -101.5        1
      32        0   -106.5        1
    34.5     -0.5   -111.5        1
      39     -0.5     -118        1
      42       -3     -124        1

    2 26
      42       -3     -124        1
    47.5     -4.5   -123.5        1
    47.5     -4.5   -123.5        1
      54     -2.5   -122.5        1
      54     -2.5     -122        1
      59     -2.5     -122        1
      59     -2.5     -122        1
      61      0.5     -122        1
      61      0.5     -122        1
      62        4     -122        1
      62        4     -122        1
      64        8     -122        1
      64        8     -122        1
      67     12.5   -122.5        1
      67     12.5     -123        1
    67.5       16   -124.5        1
    67.5       16   -125.5        1
    73.5       16     -126        1
    73.5       16     -126        1
      79     12.5     -126        1
      79     12.5     -127        1
    83.5      9.5   -128.5        1
    83.5      9.5     -130        1
    87.5      5.5   -131.5        1
    87.5      5.5   -132.5        1
    93.5      2.5     -133        1

    2 28
      42       -3     -124        1
      44     -4.5   -122.5        1
      49       -5   -121.5        1
      49       -5   -121.5        1
    52.5       -8     -122        1
    52.5       -8   -123.5        1
      55     -6.5     -126        1
      55     -6.5   -127.5        1
    57.5    -10.5     -128        1
    57.5    -10.5   -127.5        1
    65.5    -10.5     -128        1
    65.5    -10.5     -130        1
    68.5    -13.5   -132.5        1
    68.5    -13.5     -134        1
    72.5    -11.5   -135.5        1
    72.5    -11.5   -136.5        1
      76      -12   -138.5        1
      76      -12   -140.5        1
    77.5      -15   -142.5        1
    77.5      -15   -143.5        1
      82      -16   -143.5        1
      82      -16     -144        1
      84    -17.5   -147.5        1
      87      -17   -151.5        1
      89    -17.5     -155        1
      89    -17.5     -156        1
      89    -17.5   -156.5        1
      89    -17.5   -156.5        1

    2 13
      11      6.5      -77      1.7
       9     11.5      -81        1
     7.5     14.5      -86      0.9
       9       17    -90.5      0.9
       9       17    -93.5      0.9
      10     19.5    -96.5      0.9
       8     20.5    -99.5      0.9
     7.5     18.5     -103      0.9
      11     19.5     -106      0.9
      11     19.5     -108      0.9
      12     21.5     -110      0.9
     9.5       22   -113.5      0.9
       8       22   -118.5      0.9

    1 2
       6        5      -70      2.4
     7.5     10.5      -63      1.8

    4 75
     7.5     10.5      -63      1.8
    11.5       11      -63      0.6
    11.5       11      -63      0.6
    14.5       11    -63.5      0.6
    17.5       10      -64      0.6
    17.5       10      -64      0.6
    20.5      8.5      -64      0.6
    20.5      8.5      -64      0.6
    23.5      6.5    -63.5      0.6
    23.5      6.5      -63      0.6
      27        6      -63      0.6
      27        6      -63      0.6
    28.5      5.5    -62.5      0.6
      31      4.5    -61.5      0.6
      32        4    -60.5      0.6
      34        3    -60.5      0.6
      36        3    -60.5      0.6
      38        2      -61      0.6
      41      1.5      -61      0.6
    44.5        1      -61      0.6
    44.5        1      -61      0.6
    47.5        0    -60.5      0.6
    47.5        0    -60.5      0.6
    50.5      0.5    -60.5      0.6
    53.5        0      -61      0.6
    55.5        0    -60.5      0.6
    57.5       -1      -60      0.6
      60       -1      -59      0.6
      62       -2      -59      0.6
      62       -2    -58.5      0.6
      64     -2.5    -58.5      0.6
      66       -3      -58      0.6
    67.5       -4    -57.5      0.6
    68.5     -4.5    -56.5      0.6
    70.5     -5.5      -56      0.6
      72     -6.5    -55.5      0.6
    73.5     -7.5    -55.5      0.6
    75.5       -9    -55.5      0.6
      77     -9.5    -55.5      0.6
    79.5    -10.5      -56      0.6
      81      -11    -56.5      0.6
      83      -11    -56.5      0.6
    84.5      -10      -56      0.6
    86.5    -10.5    -55.5      0.6
    88.5    -10.5      -56      0.6
    89.5       -9    -56.5      0.6
      90     -8.5      -58      0.6
      92       -8      -59      0.6
      93       -7      -60      0.6
      95       -6    -60.5      0.6
      97     -5.5    -61.5      0.6
      99     -5.5      -63      0.6
   100.5       -5      -64      0.6
     101     -3.5    -64.5      0.6
     103     -3.5      -65      0.6
     103     -1.5    -65.5      0.6
   103.5        0      -66      0.6
     104        2    -66.5      0.6
     105        4    -66.5      0.6
     105        5    -66.5      0.6
   106.5      6.5    -66.5      0.6
     108      7.5    -65.5      0.6
   109.5      8.5    -63.5      0.6
     111      9.5    -60.5      0.6
   109.5     11.5    -57.5      0.6
     107       11    -55.5      0.6
   107.5     12.5      -54      0.6
     105       14      -54      0.6
     105       14    -54.5      0.6
     107       16    -54.5      0.6
     107       16      -54      0.6
   110.5     16.5      -53      0.6
   110.5     16.5    -52.5      0.6
     112     17.5      -53      0.6
   114.5       18      -54      0.6

    1 2
     7.5     10.5      -63      1.8
       6       15      -70      2.7

    1 4
       6       15      -70      2.7
     2.5     18.5      -71      1.1
     0.5       21    -71.5      1.1
       0     23.5      -72      1.1

    3 36
       0     23.5      -72      1.1
      -4       25      -72      0.9
      -6     27.5    -72.5      0.9
   -12.5     31.5      -77      0.9
   -12.5     31.5      -81      0.9
     -15       34    -84.5      0.9
     -15       34    -87.5      0.9
   -17.5       34      -91      0.9
   -16.5     30.5      -94      0.9
   -16.5     30.5    -95.5      0.9
   -14.5       30    -96.5      0.9
   -13.5     27.5    -97.5      0.9
     -15       26      -99      0.9
     -11     24.5   -100.5      0.9
     -11     24.5   -102.5      0.9
   -10.5       22   -104.5      0.9
      -7     20.5     -107      0.9
      -7     20.5     -109      0.9
      -5     20.5     -111      0.9
    -3.5     20.5     -116      0.9
       2       23     -121        1
       2       23     -125        1
       5       22     -126        1
       5       22     -126        1
     7.5       25     -126        1
     7.5       25     -127        1
     9.5     21.5     -128        1
     9.5     21.5     -129        1
      13     21.5   -130.5        1
    14.5       16   -131.5        1
    14.5       16     -132        1
    19.5     10.5     -132        1
    19.5     10.5   -132.5        1
    24.5       10   -133.5        1
    24.5       10     -135        1
      27      7.5   -136.5        1

    4 85
       0     23.5      -72      1.1
       0     25.5      -70      0.9
      -2     27.5      -69      0.9
      -2     27.5    -68.5      0.9
    -3.5     29.5      -68      0.9
      -5       31      -67      0.9
    -7.5     32.5      -67      0.9
    -7.5     32.5      -67      0.9
      -9     35.5      -67      0.9
      -9     35.5    -66.5      0.9
   -11.5     37.5      -66      0.9
   -11.5     37.5    -65.5      0.9
     -13       40    -65.5      0.9
     -13       40    -65.5      0.9
     -15       42      -65      0.9
     -15       42      -65      0.9
     -19     43.5      -65      0.9
     -19     43.5    -63.5      0.9
   -22.5       46    -61.5      0.9
   -22.5       46    -59.5      0.9
     -25     49.5      -59      0.9
     -25     49.5      -59      0.9
   -29.5     53.5      -59      0.9
   -29.5     53.5    -59.5      0.9
     -30     55.5      -60      0.9
   -32.5     59.5    -59.5      0.9
   -32.5     59.5      -59      0.9
   -35.5       62    -58.5      0.9
   -35.5       62      -58      0.9
     -36       64    -56.5      0.9
   -38.5       67    -55.5      0.9
   -38.5       67      -54      0.9
   -41.5       71      -53      0.9
   -41.5       71      -52      0.9
     -45       74      -52      0.9
     -45       74      -52      0.9
     -48       76      -52      0.9
     -48       76    -52.5      0.9
   -50.5       79    -52.5      0.9
   -50.5       79    -52.5      0.9
     -54     81.5    -52.5      0.9
     -54     81.5      -52      0.9
     -57     83.5      -52      0.9
     -57     83.5      -52      0.9
   -59.5       87    -51.5      0.9
   -59.5       87    -50.5      0.9
     -61     89.5    -49.5      0.9
     -61     89.5    -48.5      0.9
     -61     89.5    -48.5      0.9
     -61     89.5      -48      0.9
     -63     90.5      -48      0.9
   -63.5     92.5      -48      0.9
     -68       96      -48      0.9
     -68       96    -47.5      0.9
   -71.5       97      -47      0.9
   -71.5       97    -46.5      0.9
     -75     99.5    -46.5      0.9
     -75     99.5    -46.5      0.9
     -76      103      -46      0.9
     -76      103      -45      0.9
     -80      106    -44.5      0.9
     -80      106    -44.5      0.9
     -82      109      -46      0.9
     -82      109      -48      0.9
   -86.5      113      -50      0.9
   -86.5      113      -51      0.9
   -85.5      116      -52      0.9
   -85.5      116      -52      0.9
   -88.5      119      -52      0.9
   -88.5      119      -52      0.9
     -92    122.5    -51.5      0.9
     -92    122.5    -50.5      0.9
     -92      125    -49.5      0.9
   -93.5      128    -48.5      0.9
   -93.5      128    -48.5      0.9
     -94      131    -48.5      0.9
   -95.5      137      -48      0.9
   -95.5      137      -47      0.9
   -99.5      140    -45.5      0.9
   -99.5      140    -44.5      0.9
  -100.5      143    -43.5      0.9
  -100.5      143      -43      0.9
    -100    147.5      -43      0.9
    -100    147.5      -43      0.9
     -99      149      -43      0.9

    14 300
       6       15      -70      2.7
       9     16.5    -73.5      2.2
    10.5       20    -76.5      2.2
    10.5       20    -78.5      2.2
    10.5     20.5      -79      2.2
    11.5       23      -79      2.2
    13.5     24.5    -77.5        2
      16       27      -76        2
      16       27    -75.5        2
      17       29    -76.5        2
    17.5       33    -78.5        2
    17.5       33    -80.5        2
      20       36    -82.5        2
      20       36    -83.5        2
      21       38    -84.5        2
      24     41.5    -84.5        2
      24     41.5    -84.5        2
    25.5       46    -84.5        2
    25.5       46    -84.5        2
      27     49.5    -84.5        2
      27     49.5      -85        2
      29     50.5    -86.5        2
    29.5       55      -89        2
    29.5       55    -90.5        2
      29       58    -91.5      1.8
      30     60.5      -92      1.8
      30     63.5    -92.5      1.8
    31.5     66.5      -93      1.8
    31.5     66.5    -93.5      1.8
    29.5     68.5    -93.5      1.8
    29.5     68.5    -93.5      1.8
      31     71.5    -93.5      1.8
      31     71.5    -93.5      1.8
      32     73.5    -93.5      1.8
      32     76.5    -93.5      1.8
    31.5     80.5    -93.5      1.8
    31.5     80.5    -93.5      1.8
    31.5       84    -93.5      1.8
    31.5       87      -94      1.8
    30.5       88    -94.5      1.8
      30     89.5    -94.5      1.8
    31.5       90      -95      1.8
      32       91      -95      1.8
      32     92.5      -95      1.8
      33       94      -95      1.8
      33     95.5    -94.5      1.8
    32.5     97.5      -94      1.8
    35.5    102.5    -92.5      1.8
    35.5    102.5      -92      1.8
    35.5      105    -91.5      1.8
    38.5    107.5    -91.5      1.8
    38.5    107.5    -91.5      1.8
      40    110.5    -91.5      1.8
      40    110.5    -91.5      1.8
    44.5      114    -91.5      1.8
    44.5      114    -91.5      1.8
    44.5    117.5    -91.5      1.8
      48    120.5    -91.5      1.8
      48    120.5    -91.5      1.8
      48    124.5      -91      1.8
      48    124.5      -90      1.8
    51.5    125.5      -89      1.8
    51.5    125.5      -88      1.8
      53    129.5      -88      1.8
      53    129.5    -88.5      1.8
    54.5    131.5    -89.5      1.8
    55.5    133.5    -91.5      1.8
    55.5    135.5    -92.5      1.8
    58.5      136    -93.5      1.8
      61      138    -93.5      1.8
      61      138    -93.5      1.8
      62      141    -93.5      1.8
      62      141    -93.5      1.8
      63      143    -93.5      1.8
      64      144    -93.5      1.8
    64.5      146    -93.5      1.8
    65.5    148.5    -93.5      1.8
      66    150.5    -93.5      1.8
      68      153    -93.5      1.8
      68      153    -93.5      1.8
      68      156    -93.5      1.8
      68    158.5    -93.5      1.8
      70      160    -93.5      1.8
      72      162    -93.5      1.8
      72      162    -93.5      1.8
    72.5    164.5    -93.5      1.8
    74.5    167.5    -93.5      1.8
    74.5    167.5    -93.5      1.8
    77.5      170    -93.5      1.8
    77.5      170    -93.5      1.8
      78      173    -93.5      1.8
      78      176      -93      1.8
    80.5      176    -92.5      1.8
    81.5      179      -92      1.8
    81.5      179    -91.5      1.8
      84    181.5    -91.5      1.8
      84    181.5    -91.5      1.8
    86.5    184.5    -91.5      1.8
    86.5    184.5    -91.5      1.8
    86.5      188    -91.5      1.8
      90    188.5    -91.5      1.8
      90    188.5    -91.5      1.8
      92    191.5    -91.5      1.8
      92    191.5      -92      1.8
      92    194.5      -92      1.8
    92.5    196.5    -91.5      1.8
    94.5      196      -90      1.8
      99    198.5      -89      1.8
      99    198.5    -88.5      1.8
   100.5      201      -89      1.6
   100.5      201    -89.5      1.6
   101.5      204      -90      1.6
   101.5      204      -90      1.6
     106    208.5      -90      1.6
     106    208.5      -90      1.6
   106.5    209.5      -90      1.6
     106    211.5      -90      1.6
     106      214      -90      1.6
   106.5    217.5      -89      1.6
   106.5    217.5      -88      1.6
     108    219.5      -86      1.6
     110      223      -85      1.6
     110      223    -84.5      1.6
   110.5    225.5      -85      1.6
   112.5      227    -85.5      1.6
     114    228.5    -85.5      1.6
     116      230      -85      1.6
     117    232.5      -85      1.6
     117      235      -85      1.6
     117      237      -85      1.6
     120    237.5      -85      1.6
   121.5    240.5    -83.5      1.6
   121.5    240.5      -83      1.6
   121.5    244.5    -82.5      1.6
   121.5    244.5    -82.5      1.6
     125      247      -82      1.6
     125      247    -80.5      1.6
     125      250      -79      1.6
   124.5    253.5    -77.5      1.6
   124.5    253.5      -77      1.6
     125      256      -77      1.6
     127    258.5      -77      1.6
     127    258.5      -77      1.6
   128.5    261.5      -77      1.6
   128.5    261.5      -77      1.6
     131      263      -77      1.6
     131      263      -77      1.6
     131      266      -77      1.6
   132.5    268.5      -77      1.6
   132.5    268.5      -77      1.6
   132.5    270.5      -77      1.6
     134      273      -77      1.6
     134      273      -77      1.6
     137      276      -78      1.6
     137    276.5      -79      1.6
     135    278.5    -79.5      1.6
     135    278.5    -79.5      1.6
   132.5      282      -79      1.6
   132.5      282    -78.5      1.6
   134.5      284    -77.5      1.6
   134.5      284    -76.5      1.6
     135    286.5      -76      1.6
   137.5    289.5    -75.5      1.6
   137.5    289.5    -75.5      1.6
   135.5      292    -75.5      1.1
   135.5      292    -75.5      1.1
   137.5      294    -75.5      1.1
   137.5      294    -75.5      1.1
     138      298    -75.5      1.1
     138      298    -75.5      1.1
   135.5    299.5    -75.5      1.1
   135.5    299.5    -75.5      1.1
   136.5    303.5    -75.5      1.1
   136.5    303.5      -76      1.1
   134.5    306.5    -75.5      1.1
   134.5    306.5    -74.5      1.1
   136.5      310    -72.5      1.1
   136.5      310    -70.5      1.1
     137    313.5      -70      1.1
     137    313.5      -70      1.1
   136.5    316.5      -70      1.1
   136.5      319      -70      1.1
   136.5    322.5      -70      1.1
   136.5    325.5    -70.5      1.1
     136      328      -71      1.1
   137.5      330    -71.5      1.1
     137    332.5      -72      1.1
     139      337      -72      1.1
     139      337      -72      1.1
     139    339.5      -72      1.1
     141      342      -72      1.1
     141      342      -72      1.1
     142      345    -72.5      1.1
     142      345    -73.5      1.1
   145.5      345      -75      1.1
   145.5    346.5    -76.5      1.1
   145.5    349.5      -77      1.1
   147.5      352      -77      1.1
   147.5      352      -77      1.1
     149      355    -76.5      1.1
     149      355      -76      1.1
     150    357.5      -76      1.1
   151.5      360    -76.5      1.1
   151.5      360    -77.5      1.1
     153      363    -78.5      1.1
     153      363    -78.5      1.1
   153.5      366      -79      1.1
     155    368.5      -79      1.1
     155    368.5      -79      1.1
   155.5      374      -79      1.1
   155.5      374      -79      1.1
   156.5    377.5      -79      1.1
   156.5    377.5      -79      1.1
     157    381.5      -79      1.1
     157    381.5      -79      1.1
   158.5    386.5      -78      1.1
   158.5    386.5      -77      1.1
     159    390.5      -75      1.1
     159    390.5      -74      1.1
   159.5      395      -73      1.1
   159.5      395      -72      1.1
     160      399      -71      1.1
     160      399      -70      1.1
   161.5      403    -69.5      1.1
   161.5      403    -68.5      1.1
   163.5      407    -67.5      1.1
   163.5      407      -66      1.1
     165      412      -64      1.1
     165      412      -62      1.1
     166      416      -60      1.1
     166      416    -58.5      1.1
   167.5    420.5    -58.5      1.1
   167.5    420.5    -58.5      1.1
     168      425      -59      1.1
     168      425    -59.5      1.1
   167.5    428.5    -60.5      1.1
   167.5    428.5    -60.5      1.1
     169    431.5      -61      1.1
     169    431.5      -61      1.1
     169      435      -61      1.1
     171      439      -61      1.1
     171      439      -61      1.1
     173      442      -61      1.1
     173      442      -61      1.1
   174.5    444.5      -61      1.1
   174.5    444.5      -61      1.1
   177.5    446.5    -60.5      1.1
   177.5    446.5    -60.5      1.1
   177.5      450    -59.5      1.1
   179.5    452.5      -59      1.1
   179.5    452.5      -59      1.1
     179    456.5      -59      1.1
     179    456.5      -59      1.1
     182    458.5      -59      1.1
     182    458.5      -59      1.1
   183.5    461.5      -59      1.1
   183.5    461.5      -59      1.1
   184.5      465      -59      1.1
   184.5      465      -59      1.1
   186.5      466    -58.5      1.1
     187      469      -58      1.1
     189    471.5    -56.5      1.1
     189    471.5      -56      1.1
   189.5      473    -55.5      1.1
     192      473    -55.5      1.1
     192    476.5    -55.5      1.1
   194.5    479.5    -55.5      1.1
   194.5    479.5    -55.5      1.1
   194.5      482    -55.5      1.1
     197      483    -55.5      1.1
   196.5      485    -55.5      1.1
   200.5    487.5      -55      1.1
   200.5    487.5      -55      1.1
     202      491    -54.5      1.1
     202      491      -54      1.1
     204    495.5      -54      1.1
     204    495.5      -54      1.1
     207    499.5      -54      1.1
     207    499.5      -54      1.1
   208.5      504      -54      1.1
   208.5      504      -54      1.1
   211.5      508      -54      0.8
   211.5      508      -54      0.8
     214    513.5      -54      0.8
     214    513.5      -54      0.8
   216.5      518      -54      0.8
   216.5      518      -54      0.8
   217.5    522.5      -54      0.8
   217.5    522.5      -54      0.8
     220    526.5      -54      0.8
     220    526.5    -54.5      0.8
   221.5      532      -55      0.8
   221.5      532      -55      0.8
   223.5      539    -55.5      0.8
   223.5      539    -55.5      0.8
     226    545.5    -55.5      0.8
     226    545.5    -55.5      0.8
   228.5      550      -56      0.8
   228.5      550      -58      0.8
     231      555      -61      0.8

    1 7
       2       -9      -45      1.5
     6.5       -8    -32.5      1.5
      10     -4.5    -22.5      1.5
      14     -4.5      -16      1.5
      12      -10    -12.5      1.5
    15.5       -9      -11      1.5
    14.5    -13.5    -10.5      1.5

    4 28
    14.5    -13.5    -10.5      1.5
      12       -9       -6        1
       0     -2.5        0        1
     -11      1.5     11.5        1
   -12.5        5       18        1
   -12.5        5       22        1
     -17        3     24.5        1
     -17        3     24.5        1
     -21      3.5       26        1
     -21      3.5       28        1
     -26      0.5     30.5        1
     -26      0.5     32.5        1
   -34.5      1.5       34        1
   -34.5      1.5       36        1
   -45.5      1.5     40.5        1
   -45.5      1.5     44.5        1
     -51     -1.5       50        1
     -51     -1.5       54        1
     -55       -4       58        1
     -55       -4     60.5        1
   -58.5       -4     63.5        1
     -58     -7.5     66.5        1
     -58     -7.5       70        1
     -58      -12       74        1
     -58      -12       76        1
     -61      -15     77.5        1
     -61      -15     79.5        1
   -63.5     -9.5     82.5        1

    3 48
    14.5    -13.5    -10.5      1.5
      14      -17     -8.5        1
      14    -22.5       -7        1
      14    -22.5       -7        1
    16.5    -24.5       -7        1
    16.5    -24.5       -7        1
    15.5    -27.5       -7        1
      17      -31       -7        1
      19      -33       -7        1
    26.5      -41       -7        1
      29      -43     -6.5        1
      29      -43     -6.5        1
    31.5    -45.5     -5.5        1
    31.5    -45.5       -5        1
      34    -47.5       -5        1
      34    -47.5       -5        1
    36.5    -48.5       -5        1
      39      -52       -5        1
      39      -52       -5        1
      42      -53     -5.5        1
      42      -53     -7.5        1
    44.5      -54      -10        1
    46.5      -56    -11.5        1
    46.5      -56    -12.5        1
      49      -58    -12.5        1
      49      -58    -12.5        1
    51.5    -60.5    -12.5        1
    51.5    -60.5    -12.5        1
      54      -63    -12.5        1
      54      -63    -12.5        1
    56.5      -66    -12.5        1
    56.5      -66    -12.5        1
      58      -68    -12.5        1
    59.5    -70.5    -12.5        1
    59.5    -70.5    -12.5        1
    62.5      -74    -12.5        1
    62.5      -74    -12.5        1
      66      -77    -11.5        1
      66      -77    -10.5        1
      71    -80.5     -8.5        1
      71    -80.5       -7        1
    76.5      -83       -6        1
    76.5      -83       -6        1
      81    -85.5       -7        1
      81    -85.5     -8.5        1
    85.5      -89     -9.5        1
    85.5      -89     -8.5        1
    85.5      -93       -5        1

    1 3
      -7     -8.5      -45        4
   -11.5     -7.5      -41      2.6
     -21       -2      -36      2.6

    1 3
     -21       -2      -36      2.6
     -26     -1.5    -36.5      3.1
   -28.5       -1    -37.5        3

    1 2
   -28.5       -1    -37.5        3
     -31       -1    -37.5        3

    1 2
     -31       -1    -37.5        3
   -44.5       -4      -23      2.4

    10 147
   -44.5       -4      -23      2.4
   -50.5     -6.5      -23        2
   -50.5     -6.5      -23        2
     -57       -7      -22        2
     -57       -7    -20.5        2
     -60       -9    -18.5        2
     -60       -9    -16.5        2
   -62.5    -10.5      -16        2
   -62.5    -10.5      -16        2
     -69      -11      -16        2
     -69      -11      -16        2
     -73      -12      -16        2
     -73      -12      -16        2
     -76    -12.5      -16        2
     -81    -12.5      -16        2
     -81    -12.5      -16        2
     -85      -12      -16        2
     -85      -12      -16        2
   -87.5    -11.5      -16        2
   -89.5      -12      -16        2
   -92.5      -14    -15.5        2
   -92.5      -14    -15.5        2
     -96      -16    -14.5        2
     -96      -16      -14        2
    -100    -17.5      -14        2
    -100    -17.5      -14        2
    -102    -20.5      -14        2
    -102    -20.5      -14        2
    -104    -20.5      -14        2
    -107      -22      -14        2
    -107      -22      -14        2
  -109.5    -22.5      -14        2
  -111.5    -24.5      -14        2
  -111.5    -24.5      -14        2
  -114.5    -23.5      -14        2
  -114.5    -23.5      -14        2
  -117.5      -24    -13.5        2
    -119      -25      -12        2
    -122      -25    -10.5        2
  -125.5    -25.5     -9.5        2
  -125.5    -25.5       -9        2
    -129    -26.5       -9        2
    -129    -26.5       -9        2
  -133.5      -27       -9        2
  -133.5      -27       -9        2
  -136.5      -27       -9        2
    -139    -26.5       -9        2
    -142      -27       -9        2
    -145    -26.5       -9        2
  -148.5    -26.5       -9        2
  -151.5    -26.5       -9        2
  -155.5    -26.5       -9        2
  -155.5    -26.5     -8.5        2
    -158    -26.5       -7        2
  -162.5    -26.5       -5        2
    -169      -25       -3      1.3
    -169      -25       -2      1.3
  -173.5    -23.5     -1.5      1.3
  -173.5    -23.5     -1.5      1.3
    -178      -23     -1.5      1.3
    -178      -23     -1.5      1.3
  -184.5      -23       -1      1.3
  -184.5      -23     -0.5      1.3
  -190.5      -24      0.5      1.3
  -190.5      -24        1      1.3
    -196      -24        1      1.3
    -196      -24        1      1.3
  -201.5    -23.5        1      1.3
  -201.5    -23.5      1.5      1.3
    -206    -23.5        3      1.3
    -206    -23.5      4.5      1.3
  -210.5      -23      5.5      1.3
  -210.5      -23      7.5      1.3
    -214      -23        9      1.3
    -218      -23     10.5      1.3
    -218      -23     10.5      1.3
  -222.5      -21       11      1.3
  -222.5      -21       12      1.3
    -228    -21.5     14.5      1.3
    -228    -21.5     16.5      1.3
    -234      -23       19      1.3
    -234      -23       21      1.3
  -236.5      -25     23.5      1.3
  -236.5      -25     25.5      1.3
    -241    -26.5       27      1.3
    -241    -26.5       28      1.3
  -245.5      -27     28.5      1.3
  -245.5      -27     28.5      1.3
  -248.5    -28.5     28.5      1.3
  -248.5    -28.5     28.5      1.3
    -249    -25.5     28.5      1.3
  -252.5    -25.5     28.5      1.3
  -255.5    -29.5     29.5      1.3
  -255.5    -29.5     31.5      1.3
    -259      -34       35      1.3
    -259      -34       38      1.3
    -263      -35       41      1.3
    -263      -35     41.5      1.3
    -269      -36       42      1.3
    -269      -36       42      1.3
    -274    -38.5     42.5      1.3
    -274    -38.5       43      1.3
  -279.5      -41     44.5      1.3
  -279.5      -41       46      1.3
    -283    -44.5       48      1.3
    -283    -44.5     49.5      1.3
  -290.5      -45       50      1.3
  -290.5      -45       50      1.3
    -298      -46       50      1.3
    -298      -46       50      1.3
  -306.5      -47       50      1.3
  -306.5      -47       50      1.3
    -315    -47.5     50.5      1.3
    -315    -47.5     52.5      1.3
  -319.5      -51       55      1.3
  -319.5      -51     56.5      1.3
    -328      -53     57.5      1.3
    -328      -53     57.5      1.3
  -338.5    -55.5     57.5      1.3
  -338.5    -55.5     57.5      1.3
  -344.5      -61     57.5      1.3
  -344.5      -61     57.5      1.3
    -353      -59     58.5      1.3
    -353      -59       61      1.3
    -360      -60     64.5      1.3
    -360      -60     66.5      1.3
  -365.5    -61.5       68      1.3
  -365.5    -61.5       68      1.3
    -370      -65       68      1.3
    -370      -65     68.5      1.3
  -377.5      -67     69.5      1.3
  -377.5      -67     69.5      1.3
    -386    -65.5       70      1.3
    -386    -65.5       70      1.3
  -389.5      -63       70      1.3
  -389.5      -63       70      1.3
  -396.5      -64       71      1.3
  -396.5      -64       73      1.3
  -402.5    -63.5       76      1.3
  -402.5    -63.5       78      1.3
  -407.5      -62       79      1.3
  -407.5      -62       79      1.3
  -413.5    -60.5       79      1.3
  -413.5    -60.5       79      1.3
  -419.5    -61.5     78.5      1.3
  -419.5    -61.5       78      1.3
  -427.5      -61       77      1.3

    4 46
   -44.5       -4      -23      2.4
     -50     -2.5      -32      1.5
   -52.5     -0.5    -37.5      1.5
   -52.5     -0.5    -39.5      1.5
   -64.5        4    -39.5      1.5
     -69        8    -39.5      1.5
     -69        8    -39.5      1.5
     -72     11.5      -39      1.5
     -72     11.5    -38.5      1.5
   -75.5       14      -38      1.5
   -75.5       14    -37.5      1.5
     -80       17    -37.5      1.5
     -80       17    -37.5      1.5
   -82.5     18.5    -37.5      1.5
   -82.5     18.5    -37.5      1.5
   -82.5     18.5    -37.5      1.5
   -84.5       22    -37.5      1.5
   -84.5       22    -37.5      1.5
   -87.5       23    -37.5      1.5
   -87.5       23    -37.5      1.5
   -89.5       26    -37.5      1.5
   -89.5       26      -38      1.5
   -92.5     28.5    -38.5      1.5
   -92.5     28.5      -39      1.5
   -95.5       31    -39.5      1.5
   -95.5       31    -39.5      1.5
    -101     32.5    -39.5      1.5
    -101     32.5    -39.5      1.5
  -105.5       34    -39.5      1.5
  -105.5       34    -39.5      1.5
    -108     37.5    -38.5      1.5
    -108     37.5    -36.5      1.5
    -107     42.5    -33.5      1.5
    -107     42.5    -30.5      1.5
    -109       43    -28.5      1.5
  -107.5     45.5    -26.5      1.5
  -107.5     45.5    -25.5      1.5
    -109       46      -25      1.5
    -110       49      -25      1.5
    -110       49      -25      1.5
    -114       51      -26      1.5
  -118.5     56.5    -26.5      1.5
  -120.5       59    -26.5      1.5
    -126       66      -24      1.5
    -128       71      -24      1.5
    -127       78      -25      1.5

    1 2
     -31       -1    -37.5        3
     -31      0.5    -28.5      1.5

    4 52
     -31      0.5    -28.5      1.5
     -34        4    -25.5      1.5
     -40        6      -23      1.5
   -47.5       13      -21      1.5
     -60     17.5      -21      1.5
   -66.5       23    -21.5      1.5
   -66.5       23    -21.5      1.5
   -70.5       26    -21.5      1.5
   -70.5       26    -21.5      1.5
   -72.5       29    -21.5      1.5
   -72.5       29    -21.5      1.5
     -79     31.5    -21.5      1.5
     -79     31.5    -21.5      1.5
     -81       35    -20.5      1.5
     -81       35      -19      1.5
     -85       37    -16.5      1.5
     -85       37    -14.5      1.5
     -85     40.5      -14      1.5
   -87.5     41.5    -14.5      1.5
   -91.5     42.5    -15.5      1.5
   -91.5     42.5    -15.5      1.5
   -91.5       46      -16      1.5
     -97       48      -16      1.5
     -97       48      -15      1.5
     -97       50    -13.5      1.5
    -104     50.5      -11      1.5
    -104     50.5     -9.5      1.5
    -111       55       -9      1.5
    -111       55       -9      1.5
  -110.5     57.5       -9      1.5
  -113.5       60       -9      1.5
  -113.5       60       -9      1.5
    -114       64       -9      1.5
    -114       64       -9      1.5
  -116.5       64       -9      1.5
  -116.5       67       -9      1.5
    -120       67       -9      1.5
    -126       69       -9      1.5
    -126       69       -9      1.5
    -130       71       -9      1.5
    -130       71       -9      1.5
  -132.5     73.5       -9      1.5
  -132.5     73.5       -9      1.5
    -136       76       -9      1.5
    -136       76       -9      1.5
    -135     82.5       -9      1.5
    -135     82.5       -9      1.5
  -137.5       87       -9      1.5
  -137.5       87       -9      1.5
    -139       91       -8      1.5
    -139       91       -5      1.5
  -140.5     96.5        0      1.5

    1 4
     -31      0.5    -28.5      1.5
   -34.5      7.5    -25.5      1.5
   -39.5       12      -23      1.5
     -46       15    -19.5      1.5

    3 23
     -46       15    -19.5      1.5
   -42.5     20.5       -1      1.5
   -49.5       17       14        1
     -49     20.5       18        1
     -49     20.5       21        1
   -51.5       21     23.5        1
     -50       24       26        1
     -50       24       28        1
   -52.5       25     30.5        1
     -54       28       33        1
     -54       28     34.5        1
   -57.5     29.5     36.5        1
   -57.5     29.5     38.5        1
   -60.5     27.5       41        1
   -60.5     27.5     43.5        1
   -62.5     25.5       48        1
   -62.5     25.5     53.5        1
     -63     23.5       58        1
   -61.5       20     61.5        1
   -61.5       20     62.5        1
   -59.5       16       63        1
   -59.5       16       63        1
     -60     13.5       63        1

    3 35
     -46       15    -19.5      1.5
     -47     18.5    -19.5      1.5
     -58       32    -19.5      1.5
   -61.5     36.5    -19.5      1.5
   -61.5     36.5    -19.5      1.5
   -63.5     40.5      -18      1.5
   -63.5     40.5      -15      1.5
     -69       41      -11      1.5
     -69       41       -8      1.5
     -67       43       -7      1.5
     -67       43       -7      1.5
     -70       45       -7      1.5
     -70       45       -7      1.5
   -72.5       45       -7      1.5
   -72.5     48.5       -7      1.5
     -78       47     -6.5      1.5
     -78       47     -5.5      1.5
     -79       51       -3      1.5
   -82.5     52.5        0      1.3
     -86     59.5      5.5      1.3
     -86     59.5      7.5      1.3
   -89.5       62      9.5      1.3
   -89.5       62     10.5      1.3
     -92     65.5     11.5      1.3
     -92     65.5       12      1.3
     -96       65       13      1.3
     -96       65       14      1.3
    -100       67     16.5      1.3
    -100       67       20      1.3
  -102.5       66     22.5      1.3
  -103.5       69     24.5      1.3
  -103.5       69     26.5      1.3
  -105.5     68.5       29      1.3
    -109     68.5       32      1.3
  -116.5     69.5       34      1.3

    5 61
   -28.5       -1    -37.5        3
     -36    -10.5      -23      1.5
     -40      -16    -18.5      1.5
     -41    -22.5      -14      1.5
   -43.5      -25      -10      1.5
     -46      -22       -7      1.5
     -46      -27     -5.5      1.5
     -46      -27       -5      1.5
     -48    -25.5       -5      1.5
     -50    -27.5       -5      1.5
     -50    -27.5       -5      1.5
   -51.5    -24.5     -4.5      1.5
   -51.5    -24.5       -3      1.5
   -54.5      -29        1      1.5
   -53.5    -32.5        7      1.3
     -50    -31.5     14.5      1.3
     -50    -36.5     21.5      1.3
     -51      -38       26      1.3
     -54      -39     29.5      1.3
     -54      -39       31      1.3
     -53      -42     32.5      1.3
     -53      -42       34      1.3
   -54.5      -44       35      1.3
   -57.5    -41.5       36      1.3
   -57.5    -41.5       37      1.3
     -61    -43.5     37.5      1.3
     -61    -43.5     37.5      1.3
   -59.5    -47.5     37.5      1.3
   -59.5    -47.5     37.5      1.3
     -60      -52     37.5      1.3
     -60      -52     37.5      1.3
   -58.5      -56     37.5      1.3
   -58.5      -56     37.5      1.3
   -58.5    -60.5     37.5      1.3
   -58.5    -60.5     37.5      1.3
   -56.5    -64.5     37.5      1.3
   -56.5    -64.5     37.5      1.3
   -56.5      -68     37.5      1.3
     -56      -72     36.5      1.3
     -56      -72     34.5      1.3
   -55.5    -76.5     31.5      1.3
   -55.5    -76.5     29.5      1.3
   -55.5    -79.5     28.5      1.3
     -60    -79.5     28.5      1.3
     -60    -79.5     29.5      1.3
   -59.5      -82     31.5      1.3
   -64.5    -82.5     34.5      1.3
   -64.5    -82.5     36.5      1.3
     -69      -87     37.5        1
     -69      -87     37.5        1
     -71      -91     37.5        1
     -71      -91     37.5        1
     -73    -95.5     37.5        1
     -73    -95.5     37.5        1
     -80      -97     37.5        1
     -80      -97     37.5        1
     -85    -95.5     37.5        1
     -85    -95.5     37.5        1
     -90      -93       37        1
     -90      -93     36.5        1
   -94.5      -86       36        1

    1 5
     -21       -2      -36      2.6
   -28.5      4.5      -33      1.5
   -40.5     16.5      -33      1.5
   -48.5       25      -27      1.5
     -51       28    -21.5      1.5

    1 2
     -51       28    -21.5      1.5
     -57       33      -27      1.5

    3 37
     -57       33      -27      1.5
   -62.5       44      -22      1.5
     -65     45.5    -21.5      1.5
     -63     49.5    -21.5      1.5
     -66     51.5    -20.5      1.5
     -68       60    -19.5      1.5
     -67       64    -17.5      1.5
     -67       67    -16.5      1.5
   -66.5     71.5      -16      1.5
   -66.5     71.5      -16      1.5
     -68     74.5      -16      1.5
     -68     74.5      -17      1.5
   -65.5       75      -20      1.5
   -66.5       78      -24      1.5
   -66.5       78      -27      1.5
   -65.5     80.5    -28.5      1.5
   -67.5     82.5    -28.5      1.5
   -67.5     82.5    -28.5      1.5
   -67.5     83.5    -28.5      1.5
   -69.5       84    -28.5      1.5
     -69     88.5    -28.5      1.5
     -69     88.5    -28.5      1.5
     -66       91    -28.5      1.5
     -66       91    -28.5      1.5
     -65       95    -28.5      1.5
     -65       95      -29      1.5
   -63.5       99    -29.5      1.5
   -63.5       99      -30      1.5
   -62.5    103.5    -30.5      1.5
   -62.5    103.5    -31.5      1.5
   -65.5      106    -32.5      1.5
   -65.5      106    -33.5      1.5
   -68.5    108.5      -34      1.5
   -68.5    108.5      -34      1.5
   -68.5      111      -34      1.5
     -71      112      -34      1.5
   -74.5      112      -34      1.5

    1 10
     -57       33      -27      1.5
     -55     37.5    -35.5      1.5
   -56.5     41.5    -40.5      1.5
   -56.5     41.5      -42      1.5
     -59       44      -42      1.5
     -59       44      -42      1.5
     -60     46.5    -42.5      1.5
   -65.5       51    -42.5      1.5
   -65.5       51    -41.5      1.5
   -69.5       56    -39.5      1.5

    1 3
   -69.5       56    -39.5      1.5
     -72       65      -13      1.5
     -77     67.5     -1.5      1.5

    2 19
   -69.5       56    -39.5      1.5
   -74.5       56    -42.5      1.5
     -83     62.5      -45      1.5
     -83     62.5      -45      1.5
   -85.5       68      -45      1.5
   -85.5       68      -45      1.5
   -90.5     71.5      -45      1.5
   -90.5     71.5      -45      1.5
     -95       75      -45      1.5
     -95       75      -45      1.5
     -99       76      -45      1.5
     -99       76      -45      1.5
     -99       76      -45      1.5
  -102.5     78.5    -45.5      1.5
  -102.5     78.5      -49      1.5
  -104.5     77.5      -55      1.5
  -106.5     79.5    -63.5      1.5
  -106.5     79.5    -72.5      1.5
    -109     81.5    -82.5      1.5

    2 29
     -51       28    -21.5      1.5
   -46.5       31    -19.5      1.5
   -44.5       29      -18      1.5
     -41     31.5      -17      1.5
   -40.5       28      -16      1.5
   -34.5       30      -14      1.5
   -34.5       30      -13      1.5
     -32     27.5    -12.5      1.5
     -32     27.5    -12.5      1.5
   -28.5     29.5    -12.5      1.5
   -28.5     29.5    -12.5      1.5
   -25.5       32    -12.5      1.5
   -25.5       32    -12.5      1.5
     -22     34.5    -12.5      1.5
     -22     34.5    -12.5      1.5
   -18.5       37    -12.5      1.5
   -16.5       40    -11.5      1.5
   -16.5       40      -10      1.5
   -18.5     45.5     -7.5      1.5
   -18.5     45.5     -5.5      1.5
     -20       49       -5      1.5
     -20       49       -5      1.5
   -25.5     51.5       -5      1.5
   -25.5     51.5       -5      1.5
     -30       56     -5.5      1.5
     -30       56     -7.5      1.5
     -36     57.5       -9      1.5
     -36     57.5       -8      1.5
     -43       61       -5      1.5

    1 2
    -9.5      -16      -52      4.3
     -12    -15.5      -59      3.2

    1 2
     -12    -15.5      -59      3.2
   -14.5    -14.5      -61      3.2

    1 2
   -14.5    -14.5      -61      3.2
   -17.5    -12.5      -59      3.2

    4 46
   -17.5    -12.5      -59      3.2
   -22.5      -12      -58      1.3
     -25     -9.5    -57.5      1.3
   -28.5       -9      -59      1.3
     -37      1.5      -67      1.3
   -40.5      6.5      -70      1.3
   -43.5       22    -72.5      1.3
   -44.5     29.5      -73      1.3
     -47       31      -73      1.3
   -44.5       34      -72      1.3
     -42     35.5    -68.5      1.3
     -44     41.5    -60.5      1.3
   -40.5     43.5    -58.5      1.3
   -40.5     43.5      -57      1.3
     -43     45.5    -55.5      1.3
     -43     45.5    -54.5      1.3
     -43       48      -54      1.3
   -46.5     48.5      -54      1.3
   -46.5     48.5      -54      1.3
     -44     51.5      -54      1.3
     -44     51.5      -54      1.3
     -44     54.5    -54.5      1.3
   -45.5       57    -54.5      1.3
   -45.5       57    -54.5      1.3
   -44.5     61.5    -54.5      1.3
   -44.5     61.5      -54      1.3
   -43.5       65      -54      1.3
   -43.5       65      -54      1.3
     -44       67    -54.5      1.3
     -41     68.5      -55      1.3
     -41     68.5    -55.5      1.3
     -40       71      -56      1.3
     -40       76    -56.5      1.3
     -40       76    -56.5      1.3
   -39.5       80      -55      1.3
   -39.5       80    -52.5      1.3
     -40     84.5      -50      1.3
     -40     84.5    -48.5      1.3
   -39.5     88.5    -48.5      1.3
   -39.5     88.5      -48      1.3
     -40       93    -46.5      1.3
     -40       93      -46      1.3
     -43       97      -46      1.3
     -43       97      -46      1.3
     -45     98.5    -46.5      1.3
     -49      100    -46.5      1.3

    2 22
   -17.5    -12.5      -59      3.2
   -25.5     -7.5    -61.5      1.3
     -29       -5    -63.5      1.3
     -38      1.5    -71.5      1.3
   -47.5        6    -75.5      1.3
     -50        8    -75.5      1.3
     -50      7.5    -75.5      1.3
     -54      7.5    -75.5      1.3
     -54      7.5    -75.5      1.3
     -57       10    -75.5      1.3
     -57       10    -75.5      1.3
   -59.5      8.5    -75.5      1.3
   -59.5      8.5    -75.5      1.3
   -65.5     10.5    -75.5      1.3
   -65.5     10.5    -76.5      1.3
   -67.5      5.5    -77.5      1.3
   -67.5      5.5    -78.5      1.3
   -67.5      0.5      -80      1.3
   -67.5      0.5    -82.5      1.3
   -69.5     -3.5      -86      1.3
   -69.5     -3.5      -89      1.3
   -69.5       -9    -91.5      1.3

    1 8
   -14.5    -14.5      -61      3.2
     -22    -15.5      -52      1.3
     -29      -14      -46      1.3
     -33      -13    -45.5      1.3
     -44      -16      -43      1.3
     -44      -16      -42      1.3
   -48.5      -18    -41.5      1.3
   -47.5      -20      -41      1.3

    1 7
     -12    -15.5      -59      3.2
   -13.5      -13    -63.5      1.3
     -16    -11.5    -68.5      1.3
   -13.5     -7.5    -73.5      1.3
     -19       -8    -78.5      1.3
   -24.5       -6      -82      1.3
   -24.5     -4.5    -84.5      1.3

    1 4
   -24.5     -4.5    -84.5      1.3
     -27     -3.5    -84.5      1.3
     -28       -1    -86.5      1.3
   -30.5       -6      -90      1.3

    4 50
   -24.5     -4.5    -84.5      1.3
   -22.5       -3    -82.5      1.3
   -23.5     -0.5      -82      1.3
   -26.5        1    -82.5      1.3
   -26.5        1    -83.5      1.3
     -24      3.5      -85      1.3
     -24      3.5    -85.5      1.3
     -26      6.5      -86      1.3
     -26      6.5      -86      1.3
   -25.5       10      -86      1.3
   -25.5       10      -86      1.3
     -24       13    -86.5      1.3
     -24       13      -87      1.3
   -28.5       17      -88        1
   -28.5       17      -88        1
     -27       21      -89        1
     -27       21      -93        1
   -29.5       21    -97.5        1
     -28     23.5     -101        1
     -28     23.5     -102        1
     -34       23   -102.5        1
     -34       23   -102.5        1
   -35.5     28.5   -102.5        1
   -35.5     28.5   -102.5        1
     -40       32   -102.5        1
     -40       32   -102.5        1
   -43.5       38   -102.5        1
   -43.5       38     -103        1
   -50.5       42     -104        1
   -50.5       42   -105.5        1
   -55.5       46   -107.5        1
   -55.5       46     -109        1
   -59.5     49.5   -109.5        1
   -59.5     49.5     -110        1
     -65       50     -111        1
     -65       50   -111.5        1
   -69.5     52.5   -112.5        1
   -69.5     52.5   -112.5        1
     -74     55.5     -113        1
     -74     55.5     -113        1
     -80       57     -113        1
     -80       57     -113        1
   -83.5       61     -113        1
   -83.5       61     -113        1
     -87       65     -113        1
     -87       65     -113        1
     -90       71     -113        1
     -90       71   -113.5        1
   -92.5       79   -114.5        1
   -92.5     82.5     -117        1

    1 3
    -2.5      -22    -46.5      5.2
      -4    -30.5      -49      4.4
      -6      -33      -50        3

    1 4
      -6      -33      -50        3
    -9.5    -42.5    -49.5        3
     -12      -46      -49        3
   -11.5    -50.5    -48.5      3.9

    1 3
   -11.5    -50.5    -48.5      3.9
   -15.5    -52.5    -56.5      2.5
     -19    -52.5      -63      4.4

    1 3
     -19    -52.5      -63      4.4
   -27.5      -60      -55      2.2
   -30.5      -62      -54      2.2

    1 21
   -30.5      -62      -54      2.2
     -37      -65    -55.5      2.2
     -39      -67      -57      2.2
     -39      -67    -58.5      2.2
   -41.5    -70.5      -59      2.2
   -41.5    -70.5      -59      2.2
     -43      -73      -59      2.2
     -43      -73      -59      2.2
     -44    -75.5      -59      2.2
   -44.5    -77.5      -59      2.2
   -46.5      -79      -59      2.2
     -49    -81.5      -59      2.2
     -49    -81.5    -58.5      2.2
   -51.5      -82      -58      2.2
   -54.5    -83.5    -56.5      2.2
   -54.5    -83.5      -56      2.2
     -57    -86.5    -55.5      2.2
     -57    -86.5    -55.5      2.2
     -57    -89.5    -55.5      2.2
     -57    -92.5    -55.5      2.2
   -56.5      -95    -55.5      2.9

    1 22
   -56.5      -95    -55.5      2.9
     -58      -97    -55.5      1.8
     -59    -99.5    -55.5      1.8
   -59.5     -103    -55.5      1.8
   -59.5     -103    -55.5      1.8
   -59.5   -106.5    -55.5      1.8
   -57.5     -110    -55.5      1.8
   -57.5     -110    -55.5      1.8
   -56.5   -113.5    -55.5      1.8
   -56.5   -113.5    -55.5      1.8
   -57.5   -116.5    -55.5      1.8
   -57.5   -116.5    -55.5      1.8
   -59.5   -118.5    -55.5      1.8
   -59.5   -118.5    -55.5      1.8
   -62.5     -122    -55.5      1.8
   -62.5     -122    -55.5      1.8
     -64   -125.5    -55.5      1.8
     -64   -125.5    -55.5      1.8
   -64.5   -128.5    -55.5      1.8
   -65.5   -131.5    -55.5      1.8
   -65.5   -131.5    -55.5      1.8
   -65.5   -133.5    -55.5      1.8

    3 31
   -65.5   -133.5    -55.5      1.8
     -65     -136    -52.5      1.8
     -65     -140    -50.5      1.8
     -65     -140      -50      1.8
     -66   -144.5      -50      1.8
     -66   -144.5      -50      1.8
     -68     -149      -50      1.8
     -68     -149      -50      1.8
     -70     -153      -50      1.8
     -70     -153      -50      1.8
     -71     -158      -49      1.8
     -71     -158    -47.5      1.8
   -71.5     -163    -45.5      1.8
   -71.5     -163    -43.5      1.8
     -73   -167.5      -43      1.8
     -73   -167.5      -43      1.8
     -73     -173      -42      1.8
     -73     -173      -41      1.8
     -72     -181      -39      1.8
     -72     -181      -37      1.8
   -68.5   -184.5    -34.5      1.8
   -68.5   -184.5      -33      1.8
   -65.5     -189    -31.5      1.8
     -65   -189.5      -31      1.8
   -63.5     -194      -32      1.8
   -63.5     -194      -34      1.8
     -62   -198.5      -37      1.8
     -62   -198.5    -39.5      1.8
   -59.5   -204.5    -40.5      1.8
   -59.5   -204.5    -38.5      1.8
     -60     -206      -34      1.8

    3 41
     -60     -206      -34      1.8
   -58.5     -209    -36.5      1.8
     -58     -214      -40      1.8
   -55.5   -216.5      -44      1.8
   -51.5   -218.5      -48      1.8
     -54     -222    -50.5      1.8
   -52.5   -225.5    -51.5      1.3
   -52.5   -225.5      -52      1.3
   -54.5   -229.5      -52      1.3
   -54.5   -229.5      -52      1.3
     -53   -232.5      -52      1.3
     -53   -232.5      -52      1.3
     -53   -232.5      -53      1.3
   -53.5     -237      -54      1.3
   -53.5     -237      -55      1.3
   -53.5   -240.5    -55.5      1.3
   -52.5     -244    -55.5      1.3
   -52.5     -244    -55.5      1.3
   -49.5   -246.5      -55      1.3
   -49.5   -246.5      -54      1.3
   -47.5     -250      -54      1.3
   -47.5     -250    -55.5      1.3
   -44.5   -253.5    -59.5      1.3
   -44.5   -253.5    -62.5      1.3
     -42   -257.5      -65      1.3
     -42   -257.5      -66      1.3
   -39.5     -261    -66.5      1.3
   -39.5     -261    -67.5      1.3
     -37   -264.5    -68.5      1.3
     -37   -264.5    -69.5      1.3
     -34     -268      -71      1.3
     -34     -268      -73      1.3
     -31   -271.5    -75.5      1.3
     -31   -271.5    -77.5      1.3
     -28   -274.5    -77.5      1.3
     -28   -274.5      -77      1.3
   -24.5   -276.5    -77.5      1.3
   -24.5   -276.5      -79      1.3
     -21     -280    -81.5      1.3
     -21     -280      -85      1.3
     -19   -284.5      -90      1.3

    3 56
     -60     -206      -34      1.8
     -62   -209.5    -30.5      1.5
   -59.5   -219.5    -27.5      1.5
   -59.5   -219.5      -27      1.5
     -60     -223      -27      1.5
     -60     -223      -27      1.5
   -60.5   -227.5      -27      1.5
   -60.5   -227.5      -27      1.5
   -60.5     -231      -27      1.5
   -62.5   -235.5      -26      1.5
   -62.5   -235.5    -24.5      1.5
   -62.5   -239.5      -22      1.5
   -62.5   -239.5      -20      1.5
     -65   -243.5    -19.5      1.5
     -65   -243.5    -19.5      1.5
   -67.5   -246.5    -19.5      1.5
   -67.5   -246.5    -19.5      1.5
   -67.5   -251.5    -19.5      1.5
   -67.5   -251.5    -19.5      1.5
   -69.5   -254.5      -19      1.5
   -69.5   -254.5      -19      1.5
   -67.5   -258.5    -18.5      1.5
   -67.5   -258.5      -18      1.5
     -70   -262.5      -18      1.5
     -70   -262.5      -18      1.5
   -71.5     -266    -17.5      1.5
   -71.5     -266      -17      1.5
     -73   -270.5    -16.5      1.5
     -73   -270.5      -16      1.5
     -72   -275.5      -15      1.5
     -72   -275.5      -14      1.5
   -69.5     -278      -12      1.5
   -69.5     -278      -11      1.5
     -66   -281.5    -10.5      1.5
     -66   -281.5    -10.5      1.5
     -61     -285      -10      1.5
     -61     -285      -10      1.5
   -57.5   -287.5     -9.5      1.5
   -57.5   -287.5       -9      1.5
   -53.5   -289.5       -9      1.5
   -53.5   -289.5       -9      1.5
     -49   -291.5       -9      1.5
     -49   -291.5       -9      1.5
   -46.5     -297       -9      1.5
   -46.5     -297       -9      1.5
   -45.5     -301       -9      1.5
   -45.5     -301     -9.5      1.5
   -41.5     -302     -9.5      1.5
   -41.5     -302     -9.5      1.5
     -37     -305     -9.5      1.5
     -37     -305       -9      1.5
     -32     -308       -9      1.5
     -32     -308       -9      1.5
   -27.5   -312.5       -9      1.5
   -27.5   -312.5       -9      1.5
   -26.5     -314       -9      1.5

    1 6
   -26.5     -314       -9      1.5
   -20.5     -313     -7.5      1.3
     -12     -314       -7      1.3
    -6.5     -314     -6.5      1.3
      -1   -316.5       -6      1.3
       8     -319       -5      1.3

    2 13
   -26.5     -314       -9      1.5
     -18     -323      -11      1.3
     -16     -327      -11      1.3
   -13.5     -329    -10.5      1.3
     -15   -333.5    -10.5      1.3
   -11.5     -333    -10.5      1.3
      -3     -340      -10      1.3
     0.5   -347.5     -9.5      1.3
       2   -351.5       -9      1.3
     1.5   -356.5     -8.5      1.3
       6   -356.5     -8.5      1.3
      10   -358.5       -9      1.3
      17     -361    -10.5      1.3

    3 54
   -65.5   -133.5    -55.5      1.8
     -69     -132    -54.5      1.5
     -69     -132      -54      1.5
     -73     -133      -54      1.5
     -73     -133      -54      1.5
     -77     -133      -54      1.5
     -77     -133      -55      1.5
     -81   -132.5      -56      1.5
     -81   -132.5      -57      1.5
     -86   -132.5    -57.5      1.5
     -86   -132.5    -57.5      1.5
     -92   -132.5    -57.5      1.5
     -92   -132.5    -57.5      1.5
   -97.5   -131.5      -57      1.5
   -97.5   -131.5    -56.5      1.5
    -103     -131    -56.5      1.5
    -103     -131      -57      1.5
    -106   -132.5      -58      1.5
    -106   -132.5    -58.5      1.5
  -110.5     -136      -59      1.5
  -110.5     -136      -59      1.5
    -114   -136.5      -59      1.5
    -114   -136.5      -59      1.5
    -117   -139.5    -59.5      1.5
    -117   -139.5    -61.5      1.5
    -121   -138.5      -64      1.5
    -121   -138.5    -65.5      1.5
    -123     -140    -66.5      1.5
    -128   -138.5    -66.5      1.5
    -128   -138.5    -66.5      1.5
    -130     -141      -66      1.5
    -130     -141    -65.5      1.5
  -133.5   -139.5      -65      1.5
  -133.5   -139.5    -64.5      1.5
    -136     -145    -64.5      1.5
    -136     -145    -64.5      1.5
  -138.5   -143.5    -64.5      1.5
  -138.5   -143.5    -64.5      1.5
    -141     -145    -64.5      1.5
    -141     -145    -64.5      1.5
  -144.5   -144.5      -65      1.5
  -144.5   -144.5    -67.5      1.5
    -148   -144.5    -71.5      1.5
  -150.5   -144.5    -75.5      1.5
    -154   -145.5      -78      1.5
    -154   -145.5      -79      1.5
    -156     -148    -79.5      1.5
    -156     -148    -81.5      1.5
  -159.5   -146.5    -83.5      1.5
  -159.5   -146.5      -85      1.5
    -165   -148.5      -86      1.5
    -165   -148.5      -86      1.5
    -170   -148.5      -87      1.5
  -170.5   -148.5      -88      1.5

    2 19
   -56.5      -95    -55.5      2.9
   -52.5    -97.5      -52      1.5
   -50.5   -101.5    -49.5      1.5
     -48   -103.5      -48      1.5
   -46.5   -107.5      -47      1.5
   -47.5     -112      -46      1.5
   -47.5     -112    -44.5      1.5
   -46.5     -115    -42.5      1.5
   -46.5     -115      -41      1.5
     -44   -118.5    -39.5      1.5
     -44   -118.5      -39      1.5
     -46   -122.5      -38      1.5
     -46   -122.5    -37.5      1.5
     -46   -126.5    -37.5      1.5
     -46   -126.5      -37      1.5
     -46   -129.5    -35.5      1.5
   -46.5   -134.5      -34      1.5
   -46.5   -134.5    -32.5      1.5
     -48     -136      -32      1.5

    6 68
     -48     -136      -32      1.5
   -46.5     -139      -29      1.5
   -46.5     -139    -26.5      1.5
     -47     -144      -23      1.5
     -47     -144    -19.5      1.5
     -45   -147.5      -16      1.5
     -45   -147.5      -14      1.5
   -48.5   -150.5      -13      1.5
   -48.5   -150.5    -13.5      1.5
   -51.5     -154    -14.5      1.5
   -51.5     -154      -15      1.5
     -53     -156      -14      1.5
   -50.5     -159      -12      1.5
   -50.5     -159      -10      1.5
   -49.5   -163.5       -8      1.5
   -49.5   -163.5     -6.5      1.5
     -52     -169     -4.5      1.5
   -52.5   -172.5     -0.5        1
   -52.5   -172.5        2        1
   -54.5   -176.5        5        1
   -54.5   -176.5        6        1
   -57.5   -178.5        8        1
   -57.5   -178.5       10        1
     -55   -180.5       13        1
     -55   -180.5       15        1
   -57.5     -188       16        1
   -57.5     -188       17        1
     -63     -193       18        1
     -63     -193       19        1
   -62.5     -198       20        1
   -62.5     -198       21        1
   -65.5   -200.5       23        1
   -65.5   -200.5       24        1
   -65.5   -205.5       26        1
   -65.5   -205.5     28.5        1
   -69.5     -210       32        1
   -69.5     -210     34.5        1
   -67.5   -215.5       36        1
   -67.5   -215.5       36        1
     -69   -223.5       37        1
     -69   -223.5       40        1
   -70.5   -230.5       44        1
   -70.5   -230.5       47        1
   -67.5   -234.5     48.5        1
   -67.5   -234.5     48.5        1
     -60   -238.5     48.5        1
     -60   -238.5     48.5        1
     -56   -246.5     48.5        1
     -56   -246.5     48.5        1
   -50.5   -252.5     48.5        1
   -50.5   -252.5     48.5        1
     -49   -261.5     48.5        1
     -49   -261.5     48.5        1
     -47     -269     48.5        1
     -47     -269     48.5        1
     -46     -274     48.5        1
     -46     -274     48.5        1
   -43.5   -277.5     48.5        1
   -43.5   -277.5     48.5        1
   -41.5     -285     48.5        1
   -41.5     -285     48.5        1
   -37.5   -289.5     48.5        1
   -37.5   -289.5     49.5        1
     -36   -296.5     50.5        1
     -36   -296.5     51.5        1
     -35   -305.5       52        1
     -35   -305.5     52.5        1
   -37.5     -312       54        1

    1 9
     -48     -136      -32      1.5
   -51.5   -133.5      -31      1.2
     -58     -130    -30.5      1.2
     -58     -130    -29.5      1.2
   -62.5   -127.5      -29      1.2
   -62.5   -127.5    -28.5      1.2
     -68     -126    -28.5      1.2
     -68     -126      -28      1.2
     -78   -121.5      -25      0.9

    4 53
   -30.5      -62      -54      2.2
     -32    -59.5    -49.5      1.2
     -32    -59.5      -47      1.2
     -34    -57.5    -46.5      1.2
     -34    -57.5      -47      1.2
     -37      -58    -47.5      1.2
   -40.5    -55.5    -47.5      1.2
   -40.5    -55.5      -46      1.2
     -42    -57.5    -43.5      1.2
   -46.5      -57    -41.5      1.2
   -46.5      -57      -41      1.2
     -48    -59.5    -38.5      1.2
     -48    -59.5      -34      1.2
     -50    -58.5      -28      1.2
     -50    -61.5      -24      1.2
   -51.5      -63    -22.5      1.2
     -53      -61    -22.5      1.2
     -55    -62.5      -22      1.2
     -57      -65      -20      1.2
     -57      -65      -18      1.2
     -60    -67.5      -16      1.2
     -60    -67.5    -14.5      1.2
   -61.5    -70.5      -14      1.2
   -61.5    -70.5      -14      1.2
     -63      -73      -14      1.2
     -63      -73      -14      1.2
   -66.5    -75.5      -14      1.2
   -66.5    -75.5      -14      1.2
     -70    -75.5      -14      1.2
   -74.5      -76      -14      1.2
   -74.5      -76    -14.5      1.2
   -79.5    -76.5    -15.5      1.2
   -79.5    -76.5    -15.5      1.2
     -82    -78.5      -16      1.2
     -82    -78.5      -16      1.2
     -85    -78.5      -15      1.2
     -88    -78.5      -14      1.2
     -91      -78    -10.5      1.2
  -100.5      -78     -2.5      1.3
  -100.5      -78        0      1.3
  -105.5      -78        3      1.3
  -105.5      -78        5      1.3
    -110      -79        9      1.3
    -110      -79       12      1.3
    -115      -78     15.5      1.3
    -115      -78     17.5      1.3
  -121.5      -76     18.5      1.3
  -121.5      -76       18      1.3
    -126    -74.5     16.5      1.3
    -126    -74.5       15      1.3
    -132    -73.5     13.5      1.3
    -132    -73.5     13.5      1.3
  -138.5      -73       14      1.3

    1 8
     -19    -52.5      -63      4.4
     -27      -45      -64      1.5
     -27      -45    -64.5      1.5
     -32      -47    -65.5      1.5
     -32      -47      -68      1.5
   -34.5      -44    -71.5      1.5
   -34.5      -44    -73.5      1.5
   -36.5      -43    -73.5      1.5

    2 29
   -36.5      -43    -73.5      1.5
   -36.5    -46.5      -80      1.5
   -38.5      -50      -84      1.5
   -38.5      -50    -85.5      1.5
   -41.5      -51    -86.5      1.5
   -41.5      -51      -87      1.5
     -43    -42.5      -89        1
     -43    -41.5      -90        1
   -44.5    -38.5      -92        1
   -44.5    -38.5      -94        1
   -47.5      -34    -95.5        1
   -50.5      -31    -96.5        1
   -50.5      -31    -96.5        1
   -50.5      -27    -95.5        1
   -50.5      -27      -95        1
     -55    -25.5      -95        1
     -55    -25.5      -95        1
   -56.5      -22      -95        1
   -56.5      -22    -95.5        1
     -59    -20.5    -96.5        1
     -59    -20.5    -98.5        1
   -59.5      -18   -101.5        1
   -65.5    -17.5   -106.5        1
   -65.5    -17.5   -109.5        1
     -66    -13.5   -111.5        1
     -66    -13.5   -112.5        1
   -68.5      -10     -114        1
   -68.5      -10   -115.5        1
   -68.5     -5.5     -117        1

    1 10
   -68.5     -5.5     -117        1
     -66        0   -123.5        1
     -66        0     -128        1
     -69      4.5   -129.5        1
     -69      4.5   -129.5        1
   -75.5        7   -129.5        1
   -75.5        7   -129.5        1
     -80     11.5     -130        1
     -80     11.5   -131.5        1
   -82.5       15     -135        1

    2 15
   -68.5     -5.5     -117        1
   -73.5       -2   -119.5        1
   -73.5       -2   -121.5        1
     -78     -0.5     -122        1
     -78     -0.5     -122        1
   -83.5        0     -122        1
   -83.5        0     -122        1
     -92       -1     -122        1
     -92       -1     -122        1
   -97.5       -3     -122        1
   -97.5       -3     -122        1
  -105.5     -0.5     -122        1
  -110.5      5.5   -122.5        1
  -110.5      5.5   -124.5        1
  -112.5     10.5   -127.5        1

    1 16
   -36.5      -43    -73.5      1.5
     -41      -43    -73.5      1.3
     -43      -40    -73.5      1.3
     -43      -40    -73.5      1.3
   -48.5    -38.5    -73.5      1.3
   -48.5    -38.5    -73.5      1.3
   -53.5      -37    -73.5      1.3
   -53.5      -37    -73.5      1.3
   -56.5      -37      -74      1.3
     -58      -40    -75.5      1.3
   -55.5    -40.5    -78.5      1.3
   -53.5    -43.5    -80.5      1.3
   -53.5    -43.5      -82      1.3
   -54.5    -46.5      -83      1.3
   -54.5    -46.5      -85      1.3
   -50.5    -46.5      -88      1.3

    1 2
   -11.5    -50.5    -48.5      3.9
      -8    -51.5      -54      1.8

    5 79
      -8    -51.5      -54      1.8
      -5    -52.5    -52.5        1
      -5    -52.5      -52        1
      -2    -57.5      -52        1
      -2    -57.5    -52.5        1
    -1.5    -64.5    -53.5        1
    -1.5    -64.5      -55        1
    -0.5    -68.5      -57        1
       6      -75    -58.5        1
    10.5      -84    -58.5        1
    12.5      -86      -59        1
    12.5      -86      -59        1
    15.5    -89.5    -59.5        1
    15.5    -89.5    -61.5        1
      19      -91      -64        1
      19      -91    -65.5        1
      19    -95.5    -66.5        1
      19    -95.5    -66.5        1
    22.5    -98.5    -66.5        1
    22.5    -98.5      -67        1
      26     -103    -67.5        1
      26     -103    -68.5        1
    29.5   -105.5    -69.5        1
    29.5   -105.5    -69.5        1
    30.5     -109    -70.5        1
    30.5     -109    -71.5        1
      34     -113      -74        1
      34     -113      -76        1
    37.5     -118      -78        1
    37.5     -118      -79        1
    39.5   -121.5      -80        1
    39.5   -121.5      -81        1
      43   -125.5    -81.5        1
      43   -125.5    -80.5        1
    45.5   -129.5      -79        1
    45.5   -129.5    -77.5        1
    48.5   -133.5      -77        1
    48.5   -133.5      -77        1
    50.5     -137    -76.5        1
    50.5     -137    -76.5        1
    53.5   -139.5      -76        1
    53.5   -139.5    -75.5        1
      57     -143      -75        1
      57     -143    -74.5        1
      59   -146.5      -74        1
      59   -146.5      -73        1
      61     -150    -72.5        1
      61     -150      -73        1
      64     -153      -74        1
      64     -153      -75        1
    67.5   -156.5    -75.5        1
    67.5   -156.5    -75.5        1
      73     -162    -75.5        1
      73     -162    -76.5        1
      74   -167.5    -77.5        1
      74   -167.5    -78.5        1
      77   -171.5      -79        1
      77   -171.5      -79        1
      80   -176.5      -79        1
      80   -176.5      -79        1
      80     -181      -79        1
      80     -181      -79        1
    81.5   -184.5    -79.5        1
    81.5   -184.5    -81.5        1
    84.5   -187.5      -85        1
      86     -190    -87.5        1
      86     -190    -88.5        1
      89   -194.5      -89        1
      89   -194.5      -90        1
      94     -197    -91.5        1
      94     -197    -92.5        1
      96     -201    -93.5        1
      96     -201    -94.5        1
    99.5   -201.5    -95.5        1
    99.5   -201.5      -96        1
     101   -204.5    -95.5        1
     101   -204.5      -95        1
     103   -207.5      -94        1
   106.5     -212    -93.5        1

    1 6
      -8    -51.5      -54      1.8
    -6.5    -55.5    -49.5        1
    -3.5      -62      -47        1
     4.5    -70.5    -44.5        1
     4.5      -77      -43        1
       5      -79      -41        1

    3 22
       5      -79      -41        1
       8      -81      -38        1
       8      -81    -35.5        1
      11      -81      -33        1
      12      -86      -29        1
      12      -86      -26        1
      17      -88      -23        1
      17      -88      -22        1
    18.5    -91.5      -21        1
    18.5    -91.5    -20.5        1
    21.5      -94      -20        1
    21.5      -94      -19        1
    25.5      -97      -18        1
    25.5      -97    -16.5        1
      29    -99.5    -14.5        1
      29    -99.5    -10.5        1
    25.5     -107       -5        1
    18.5   -107.5        0        1
      16   -104.5      3.5        1
     7.5   -108.5        5        1
     2.5     -105        5        1
     -17    -96.5        5        1

    2 32
       5      -79      -41        1
       2      -81      -39        1
       2      -81      -38        1
    -0.5      -81      -38        1
    -3.5      -79    -38.5        1
    -3.5      -79      -39        1
      -7      -77    -39.5        1
      -7      -77    -39.5        1
    -9.5    -75.5    -39.5        1
    -9.5    -75.5    -39.5        1
     -11    -72.5    -39.5        1
     -11    -72.5    -39.5        1
     -13    -70.5    -39.5        1
     -13    -70.5    -39.5        1
     -13    -67.5    -39.5        1
   -14.5    -63.5    -39.5        1
   -14.5    -63.5    -39.5        1
   -16.5      -59    -39.5        1
   -16.5      -59    -40.5        1
     -19      -57    -41.5        1
     -19      -57    -42.5        1
   -21.5    -52.5      -43        1
   -21.5    -52.5      -43        1
     -25    -49.5      -43        1
     -25    -49.5      -43        1
     -28      -44    -41.5        1
     -28      -44    -39.5        1
     -28    -40.5    -35.5        1
     -32    -38.5      -33        1
     -32    -38.5      -32        1
   -34.5    -37.5      -33        1
     -36      -36      -34        1

    1 3
      -6      -33      -50        3
      -2    -31.5    -52.5      1.8
    -0.5      -33    -55.5      1.5

    1 7
    -0.5      -33    -55.5      1.5
     2.5      -37    -57.5      1.5
     6.5      -38    -58.5      1.5
      12    -42.5    -58.5      1.5
      12    -46.5      -58      1.5
      20      -51      -57      1.5
    22.5    -55.5    -55.5      1.5

    1 2
    22.5    -55.5    -55.5      1.5
      26    -58.5      -61      1.5

    14 155
      26    -58.5      -61      1.5
    28.5    -61.5      -64        1
      33    -65.5      -66        1
      33    -65.5    -67.5        1
      39    -69.5    -68.5        1
      39    -69.5    -69.5        1
    44.5    -74.5      -70        1
    44.5    -74.5      -70        1
      52      -81      -70        1
      52      -81    -70.5        1
    56.5      -84      -71        1
    56.5      -84    -71.5        1
      60      -87      -72        1
      60      -87      -72        1
      63      -90      -72        1
      63      -90      -72        1
      67    -94.5      -72        1
      67    -94.5      -73        1
      71    -98.5    -73.5        1
      71    -98.5    -73.5        1
    73.5     -102    -73.5        1
    73.5     -102    -74.5        1
      77     -105    -76.5        1
      77     -105    -78.5        1
    81.5   -108.5      -80        1
    81.5   -108.5    -80.5        1
    84.5   -112.5      -81        1
    84.5   -112.5      -81        1
      88   -115.5      -81        1
      88   -115.5      -81        1
    92.5   -118.5      -81        1
    92.5   -118.5      -81        1
      97   -122.5      -81        1
      97   -122.5      -81        1
      97   -122.5      -81        1
     100     -126      -81        1
     100     -126      -81        1
     104   -130.5      -81        1
     104   -130.5      -81        1
   112.5     -139      -81      1.5
   112.5     -139      -81      1.5
     117   -140.5      -81      1.5
     117   -140.5    -81.5      1.5
   120.5   -147.5      -83      1.5
   120.5   -147.5      -85      1.5
   125.5     -151    -88.5      1.5
   125.5     -151    -90.5      1.5
     130     -155      -91      1.5
     130     -155      -91      1.5
     136   -159.5    -90.5      1.5
     136   -159.5    -90.5      1.5
     141   -165.5      -91      1.5
     141   -165.5      -91      1.5
     147   -168.5    -91.5      1.5
     147   -168.5    -91.5      1.5
   150.5     -173    -91.5      1.5
   150.5     -173    -91.5      1.5
   156.5     -179    -91.5      1.5
   156.5     -179    -91.5      1.5
   165.5     -187    -91.5      1.5
   165.5     -187    -91.5      1.5
     170   -190.5    -91.5      1.5
     170   -190.5      -92      1.5
     176     -198    -92.5      1.5
     176     -198      -93      1.5
   179.5   -198.5    -93.5      1.5
   179.5   -198.5    -93.5      1.5
     187   -209.5    -93.5      1.5
     187   -209.5    -93.5      1.5
     191     -210      -95      1.5
     191     -210      -98      1.5
   193.5   -215.5     -103      1.5
   193.5   -215.5     -106      1.5
     198   -217.5     -108      1.5
     198   -217.5     -108      1.5
     198   -220.5     -108      1.5
   205.5     -222     -108      1.5
   205.5     -222     -108      1.5
   205.5   -226.5     -108      1.5
   205.5   -226.5     -108      1.5
     213   -232.5     -108      1.5
     213   -232.5     -108      1.5
   213.5     -236     -108      1.5
   213.5     -236     -108      1.5
     217   -237.5     -108      1.5
     217   -237.5     -108      1.5
   220.5   -239.5     -109      1.5
   220.5   -239.5   -111.5      1.5
     225   -244.5     -115      1.5
     225   -244.5     -117      1.5
   226.5   -247.5   -118.5      1.5
   226.5   -247.5   -118.5      1.5
   232.5     -249   -118.5      1.5
   232.5     -249   -118.5      1.5
   233.5   -253.5     -118      1.5
   233.5   -253.5     -117      1.5
     239     -257     -116      1.5
     239     -257     -115      1.5
   241.5   -261.5     -115      1.2
   241.5   -261.5     -115      1.2
   245.5     -263     -115      1.2
   245.5     -263     -116      1.2
   251.5     -273   -117.5      1.2
   251.5     -273   -119.5      1.2
   259.5   -275.5     -121      1.2
   259.5   -275.5   -121.5      1.2
     261     -279   -121.5      1.2
     261     -279   -121.5      1.2
   266.5   -285.5   -121.5      1.2
   266.5   -285.5     -123      1.2
   271.5     -293     -125      1.2
   271.5     -293   -126.5      1.2
   277.5     -298   -127.5      1.2
   277.5     -298   -127.5      1.2
   282.5   -304.5     -128      1.2
   282.5   -304.5     -130      1.2
   290.5     -308     -132      1.2
   290.5     -308     -133      1.2
   296.5   -314.5   -133.5      1.2
   296.5   -314.5     -133      1.2
   300.5     -318   -133.5      1.2
   300.5     -318   -134.5      1.2
   306.5     -325   -136.5      1.2
   306.5     -325   -137.5      1.2
   313.5   -331.5   -138.5      1.2
   313.5   -331.5   -138.5      1.2
   319.5     -337   -138.5      1.2
   319.5     -337   -138.5      1.2
     325     -340   -138.5      1.2
     325     -340   -138.5      1.2
     332     -347   -138.5      1.2
     332     -347   -138.5      1.2
     338     -352   -138.5      1.2
     338     -352   -138.5      1.2
     347     -357   -138.5      1.2
     347     -357   -138.5      1.2
   349.5   -359.5     -138      1.2
   349.5   -359.5   -137.5      1.2
   349.5   -365.5     -137      1.2
   351.5     -369   -136.5      1.2
   365.5     -377   -136.5      1.2
   378.5   -386.5   -137.5      1.2
   378.5   -386.5   -137.5      1.2
     399     -403   -136.5      1.2
   412.5   -414.5   -136.5      1.2
     428     -430   -137.5      1.2
     432     -430     -140      1.2
     445     -440   -146.5      1.2
     450     -442   -148.5      1.2
   457.5   -452.5   -149.5      1.2
     466   -458.5   -150.5      1.2
   471.5     -461   -151.5      1.2
   477.5   -467.5     -153      1.2
   476.5     -473     -155      1.2
     486     -478   -156.5      1.2

    4 44
      26    -58.5      -61      1.5
    30.5    -68.5      -64        1
    30.5    -68.5      -64        1
    33.5      -75      -63        1
    33.5      -75      -62        1
      39    -81.5      -61        1
      39    -81.5    -60.5        1
    43.5    -86.5    -59.5        1
    43.5    -86.5    -58.5        1
    48.5    -93.5    -57.5        1
    48.5    -93.5      -57        1
      50    -96.5      -56        1
      50    -96.5      -54        1
      50    -99.5      -52        1
    52.5     -102      -49        1
    52.5     -102      -48        1
    51.5   -109.5    -47.5        1
    51.5   -109.5      -48        1
      57   -112.5      -48        1
      57   -112.5      -47        1
    57.5     -116      -46        1
    57.5     -116    -45.5        1
      62     -118      -45        1
      62     -118      -43        1
      67   -123.5      -41        1
      67   -123.5    -39.5        1
    68.5     -128    -39.5        1
    68.5     -128      -39        1
    68.5     -133    -37.5        1
    68.5     -133    -36.5        1
    66.5     -139    -35.5        1
    66.5     -139    -34.5        1
    60.5   -139.5      -32        1
    60.5   -139.5      -29        1
    57.5     -140      -25        1
      56   -141.5      -23        1
      58     -145    -22.5        1
      58     -145    -22.5        1
      58     -149    -22.5        1
      58     -149    -22.5        1
    59.5     -152    -21.5        1
    59.5     -152      -21        1
    60.5   -154.5      -20        1
      57   -156.5    -19.5        1

    1 6
    22.5    -55.5    -55.5      1.5
    27.5    -56.5    -62.5        1
      30      -60    -66.5        1
    38.5    -63.5      -68        1
    38.5    -63.5      -68        1
    41.5    -65.5      -68        1

    4 40
    41.5    -65.5      -68        1
      48    -70.5      -68        1
      48    -70.5      -68        1
    52.5      -74      -68        1
    52.5      -74    -68.5        1
      58      -77    -69.5        1
      58      -77      -70        1
      64    -79.5    -71.5        1
      64    -79.5    -72.5        1
    70.5      -83      -74        1
    70.5      -83    -75.5        1
    75.5      -86    -76.5        1
    75.5      -86    -76.5        1
      82    -89.5    -77.5        1
      82    -89.5      -79        1
    84.5      -92      -81        1
    84.5      -92      -83        1
    91.5      -96    -85.5        1
    91.5      -96    -85.5        1
      97      -98      -85        1
      97      -98    -85.5        1
     102   -101.5    -86.5        1
     102   -101.5    -87.5        1
   106.5   -103.5      -88        1
   106.5   -103.5    -88.5        1
     113   -105.5      -89        1
     113   -105.5    -89.5        1
   117.5     -110    -90.5        1
   117.5     -110    -91.5        1
     123   -108.5      -93        1
     123   -108.5    -94.5        1
     132     -114    -94.5        1
     132     -114      -94        1
   134.5   -118.5    -92.5        1
   134.5   -118.5      -92        1
     142   -121.5    -91.5        1
     142   -121.5    -91.5        1
   150.5     -129      -92        1
   150.5     -129      -94        1
   159.5   -138.5      -97        1

    2 31
    41.5    -65.5      -68        1
    45.5      -66      -71        1
    45.5      -66      -73        1
      50      -67      -74        1
      50      -67    -74.5        1
      50    -62.5    -75.5        1
      50    -62.5    -76.5        1
      50    -59.5      -77        1
      48      -56      -78        1
      48      -56      -79        1
    48.5    -53.5    -80.5        1
    47.5      -50    -82.5        1
    47.5      -50      -83        1
    49.5      -48      -83        1
    49.5      -48    -83.5        1
      57    -47.5    -84.5        1
      57    -47.5    -85.5        1
    58.5      -51      -86        1
    58.5      -51      -86        1
    65.5    -53.5      -86        1
    65.5    -53.5      -86        1
    65.5      -57      -86        1
      69    -61.5      -86        1
      69    -61.5      -86        1
    75.5    -62.5      -86        1
    75.5    -62.5      -86        1
      78    -58.5      -86        1
      78    -58.5      -86        1
      78      -54    -86.5        1
      78      -54      -89        1
    76.5      -50    -93.5        1

    2 7
    -0.5      -33    -55.5      1.5
    -4.5    -34.5    -37.5        1
      -3      -38      -25        1
    -6.5    -42.5    -17.5        1
      -4    -46.5    -13.5        1
    -5.5      -51      -11        1
    -2.5      -56    -10.5        1

    1 14
    -2.5      -56    -10.5        1
    -5.5      -54     -9.5        1
    -5.5      -54     -9.5        1
      -6    -50.5     -9.5        1
      -6    -50.5      -10        1
      -3    -43.5    -11.5        1
      -3    -43.5    -10.5        1
    -5.5      -39     -7.5        1
    -5.5      -39       -4        1
      -5    -31.5     -1.5        1
      -5    -31.5     -0.5        1
      -2    -30.5        0        1
      -2    -30.5      1.5        1
     0.5    -27.5      3.5        1

    1 8
     0.5    -27.5      3.5        1
    -1.5      -23        4        1
    -1.5      -23      5.5        1
       0      -20        9        1
       0      -20       12        1
    -2.5    -17.5       16        1
    -2.5    -17.5       20        1
    -6.5    -13.5       25        1

    1 8
     0.5    -27.5      3.5        1
     2.5      -25      3.5        1
     2.5      -25      3.5        1
     4.5      -23      3.5        1
     4.5      -23      3.5        1
       9    -24.5      3.5        1
       9    -24.5      3.5        1
      15    -26.5      3.5        1

    3 30
    -2.5      -56    -10.5        1
     0.5    -59.5     -8.5        1
     0.5    -59.5       -7        1
     1.5      -64       -7        1
     1.5      -64       -7        1
       2    -68.5       -6        1
       2    -68.5     -3.5        1
      -2    -73.5        1        1
    -3.5      -69        8        1
    -3.5      -69     13.5        1
    -6.5      -68     18.5        1
    -6.5      -68     20.5        1
    -4.5      -65     21.5        1
    -4.5      -65     22.5        1
    -7.5      -64     24.5        1
    -7.5      -64     27.5        1
      -6    -60.5     31.5        1
      -6    -60.5     34.5        1
    -6.5      -65     37.5        1
    -6.5      -65       39        1
    -9.5    -72.5     40.5        1
    -9.5    -72.5     40.5        1
   -15.5    -74.5       41        1
   -15.5    -74.5       41        1
   -21.5      -75       41        1
   -21.5      -75       41        1
   -23.5    -78.5       41        1
   -23.5    -78.5     41.5        1
   -23.5    -81.5       44        1
     -27    -85.5     48.5        1


CONNECTIONS:

        0    1
        1    1
        2    1
        2    1
        1    1
        0    1
        6    1
        6    1
        8    1
        9    1
        9    1
        8    1

        0    1
        0    1

        0    1
        1    1
        2    1
        3    1
        3    1
        2    1
        6    1
        6    1
        8    1
        8    1
        1    1
        0    1
       12    1
       13    1
       13    1
       15    1
       15    1
       12    1

        0    1
        1    1
        2    1
        2    1
        1    1
        0    1
        6    1
        6    1

        0    1
        1    1
        2    1
        3    1
        4    1
        5    1
        6    1
        6    1
        8    1
        8    1
        5    1
        4    1
       12    1
       12    1
        3    1
        2    1
       16    1
       17    1
       17    1
       16    1
        1    1
       21    1
       21    1
       23    1
       23    1
        0    1
       26    1
       27    1
       28    1
       28    1
       27    1
       31    1
       31    1
       26    1
       34    1
       35    1
       35    1
       34    1


/*----------------------------------------------------------------*/
proc geometry() { 

	/* NULL geometry procedure: keeps the user from
	calling the geometry procedure in isolation. */

    printf("\nYou must re-read the entire geometry\n")
    printf("file to execute geometry().\n\n")
}

