# Matlab code for Pu and Thomas' Neural Computation paper
## Fast and Accurate Langevin Simulations of Stochas-tic Hodgkin-Huxley Dynamics
1. Figure 1 (HH diagram) is generated by the tex code.
2. Figure 2 (4D and 14D HH models) can be generated from codes in folder "Figure2". It takes roughly 3-5 minutes to run the script Fig2.m on a laptop.
3. Figure 3 (convergence to the multinomial submanifold) can be generated by codes in folder "Figure3".  It takes roughly 3-5 minutes to run the script Fig3.m on a laptop.
4. Figure 4 (Edge importance under voltage clamp) is reproduced with permission from Figs. 10 & 13 of [Schmidt and Thmas (2014) paper](https://pubmed.ncbi.nlm.nih.gov/24742077/).  Code is reproduced with permission.  
5. Figure 5 (edge importance under current clamp) can be reproduced from codes in folder "Figure5". 
   - to generate figure 5, one needs to run hundreds repeated simulations, high performance computing is recommended
   - one can modify the code gene_data_SS.m to generate as many samples as desired 
   - fig5data.mat can be loaded and viewed by plot_fig5.m
6. Figure 6 (pathwise equivalency) can be generated by the code Fig6.m, which takes roughly 1-2 minutes to run on a laptop.
7. Figures 7, 8 and 9, as well as codes for generating Table 3, are included in the folder "All_models"
   - cluster computing or high performance computing is recommended for generating the data for these tables and figures
   - details of the simulation for the paper is specified in Section 5
   - simulation efficiency is computed through the same laptop computer; the time might be different using different machines but the ratio should  be roughly the same
   - since the data for all plots in Figs. 7-9 and Table 3 are more than 500 MB, data for the plots are not uploaded here but one should be able to re-generate the data with the provided code

