import ajustador as aju

def params_fitness(morph_file,ntype,modeltype,ghkkluge=1):

    P = aju.optimize.AjuParam
    params = aju.optimize.ParamSet(
        P('junction_potential', -12e-3, min=-20e-3, max = 20e-3),
        P('RA',                 2.5,  min=.3,      max=4),
        P('RM',                2.3,   min=0.01,      max=100),
        P('CM',                 0.014, min=0.005,      max=0.02),
        P('Cond_Kir_0',      9.3,      min=1, max=50),
        P('Cond_Kir_1',      9.3,      min=1, max=50),
        P('Cond_Kir_2',      5.3,      min=1, max=15),
        P('Eleak', -0.07, min=-0.09, max=-0.020),
        P('Cond_NaF_0',      153e3,      min=10e3, max=10000e3),
        P('Cond_NaF_1',      10000,      min=1, max=100e3),
        P('Cond_NaF_2',      100,      min=1, max=300),
        P('Cond_KaS_0',      200,        min=1, max=1000),
        P('Cond_KaS_1',      100,        min=1, max=1000),
        P('Cond_KaS_2',      30,        min=1, max=100),
        P('Cond_KaF_0',      1228,        min=10, max=10000),
        P('Cond_KaF_1',      1624,        min=10, max=10000),
        P('Cond_KaF_2',      40,        min=1, max=100),
        P('Cond_Krp',      0.06,        min=0.01, max=100),
        #P('Cond_Krp_1',      0.05,        min=0, max=50),
        #P('Cond_Krp_2',      0.05,        min=0, max=50),
        P('Cond_SKCa', 1.3, min=.1, max=10),
        P('Cond_CaCC', 1.9, min=.1, max=100),
        P('Cond_BKCa', 10, min=.1, max=100),
        P('Cond_CaN_0',      8*ghkkluge,      min=1e-3, max=10*ghkkluge),
        P('Cond_CaT32_1',      0.01*ghkkluge,      min=1e-3, max=10*ghkkluge),
        P('Cond_CaT32_2',      2.3*ghkkluge,      min=1e-3, max=10*ghkkluge),
        P('Cond_CaT33_1',      0.01*ghkkluge,      min=1e-3, max=10*ghkkluge),
        P('Cond_CaT33_2',      2.3*ghkkluge,      min=1e-3, max=10*ghkkluge),P('Cond_CaL12_0',    2.5*ghkkluge,      min=1e-3, max=20*ghkkluge),
        P('Cond_CaL12_1',    3.5*ghkkluge,      min=1e-3, max=20*ghkkluge),
        P('Cond_CaL12_2',    3*ghkkluge,      min=1e-3, max=20*ghkkluge),
        P('Cond_CaL13_0',   5.5*ghkkluge,      min=1e-3, max=20*ghkkluge),
        P('Cond_CaL13_1',    0.15*ghkkluge,      min=1e-3, max=20*ghkkluge),
        P('Cond_CaL13_2',    0.12*ghkkluge,      min=1e-3, max=20*ghkkluge),
        P('Cond_CaR_0',     5*ghkkluge,      min=1e-3, max=60*ghkkluge),
        P('Cond_CaR_1',     10*ghkkluge,      min=1e-3, max=60*ghkkluge),
        P('Cond_CaR_2',     20*ghkkluge,      min=1e-3, max=60*ghkkluge),
        P('Chan_NaF_vshift_X', 0.0004, min=-0.02, max=0.02),
        P('Chan_NaF_vshift_Y', 0.009, min=-0.02, max=0.02),
        P('Chan_NaF_taumul_X', 1.35, min=0.25, max=3),
        P('Chan_NaF_taumul_Y', 1.34, min=0.25, max=3),
        P('Chan_KaF_vshift_X', -0.003, min=-0.02, max=0.02),
        P('Chan_KaF_vshift_Y', 0.0048, min=-0.02, max=0.02),
        P('Chan_KaF_taumul_X', 0.63, min=0.25, max=3),
        P('Chan_KaF_taumul_Y', .88, min=0.25, max=3),
        P('Chan_KaS_vshift_X', -0.02, min=-0.030, max=0.020),
        P('Chan_KaS_vshift_Y', 0.0015, min=-0.020, max=0.020),
        P('Chan_KaS_taumul_X', .3, min=0.2, max=4),
        P('Chan_KaS_taumul_Y', 1.01, min=0.25, max=3),
        #P('Chan_CaCC_vshift', 0.0, min=-0.01, max=0.01),
        P('Chan_CaCC_taumul', 1.0, min=0.5, max=2),
        P('Chan_Kir_vshift', 0.012, min = -.02, max = .03),
        P('Chan_Kir_taumul', 1.7, min = .25, max = 3),
        P('morph_file', morph_file, fixed=1),
        P('neuron_type', ntype,                     fixed=1),
        P('model',           modeltype,     fixed=1))

    #fitness=aju.fitnesses.combined_fitness('new_combined_fitness')
    fitness = aju.fitnesses.combined_fitness('empty',
                                             response=3,
                                             baseline_pre=2,
                                             baseline_post=2,
                                             rectification=1,
                                             falling_curve_time=1,
                                             spike_time=3,
                                             spike_width=2,
                                             spike_height=10,
                                             spike_latency=2,
                                             spike_count=3,
                                             spike_ahp=1,
                                             ahp_curve=2,
                                             charging_curve_time=2,
                                             charging_curve_full=4,
                                             spike_range_y_histogram=1,
                                             mean_isi=2,
                                             isi_spread=2,
                                             #spike_threshold=1,
                                             #response_variance=0.05,
                                             post_injection_curve_tau = 2)
    return params,fitness
