import ajustador as aju

def params_fitness(morph_file,ntype,modeltype,ghkkluge=1):

    P = aju.optimize.AjuParam
    params = aju.optimize.ParamSet(
        P('junction_potential', -11e-3, min=-20e-3, max = 20e-3),
        P('RA',                 1.05,  min=.4,      max=4),
        P('RM',                4.5,   min=0.01,      max=100),
        P('CM',                 0.0112, min=0.0025,      max=0.05),
        P('Cond_Kir',      7.7,      min=1, max=50),
        P('Eleak', -0.09, min=-0.1, max=-0.020),
        P('Cond_NaF_0',      581e3,      min=20e3, max=10000e3),
        P('Cond_NaF_1',      1927,      min=0, max=100e3),
        P('Cond_NaF_2',      990,      min=0, max=100e3),
        P('Cond_KaS_0',      60,        min=1, max=10000),
        P('Cond_KaS_1',      485,        min=1, max=10000),
        P('Cond_KaS_2',      33,        min=1, max=10000),
        P('Cond_KaF_0',      753,        min=10, max=10000),
        P('Cond_KaF_1',      991,        min=10, max=10000),
        P('Cond_KaF_2',      85,        min=10, max=10000),
        P('Cond_Krp_0',      0.05,        min=0, max=100),
        P('Cond_Krp_1',      0.05,        min=0, max=50),
        P('Cond_Krp_2',      0.05,        min=0, max=50),
        P('Cond_SKCa', 2.0, min=0, max=10),
        P('Cond_CaCC', 2.13, min=.1, max=100),
        P('Cond_BKCa', 6.6, min=1, max=100),
        P('Cond_CaN_0',      3*ghkkluge,      min=0, max=10*ghkkluge),
        P('Cond_CaT_1',      0.03*ghkkluge,      min=0, max=10*ghkkluge),
        P('Cond_CaT_2',      4*ghkkluge,      min=0, max=10*ghkkluge),
        P('Cond_CaL12_0',    7.3*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaL12_1',    2.4*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaL12_2',    2.1*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaL13_0',   9.7*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaL13_1',    2.1*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaL13_2',    5.6*ghkkluge,      min=0, max=20*ghkkluge),
        P('Cond_CaR_0',     30*ghkkluge,      min=0, max=60*ghkkluge),
        P('Cond_CaR_1',     30*ghkkluge,      min=0, max=60*ghkkluge),
        P('Cond_CaR_2',     30*ghkkluge,      min=0, max=60*ghkkluge),
        P('Chan_NaF_vshift_X', 0.007, min=-0.02, max=0.02),
        P('Chan_NaF_vshift_Y', 0.008, min=-0.02, max=0.02),
        P('Chan_NaF_taumul_X', 0.57, min=0.25, max=3),
        P('Chan_NaF_taumul_Y', 1.0, min=0.25, max=3),
        P('Chan_KaF_vshift_X', -0.01, min=-0.02, max=0.02),
        P('Chan_KaF_vshift_Y', 0.01, min=-0.02, max=0.02),
        P('Chan_KaF_taumul_X', 0.51, min=0.25, max=3),
        P('Chan_KaF_taumul_Y', 1.38, min=0.25, max=3),
        P('Chan_KaS_vshift_X', -0.01, min=-0.020, max=0.020),
        P('Chan_KaS_vshift_Y', 0.002, min=-0.020, max=0.020),
        P('Chan_KaS_taumul_X', 1.77, min=0.25, max=3),
        P('Chan_KaS_taumul_Y', 1.49, min=0.25, max=3),
        #P('Chan_Krp_vshift', -0.004, min=-0.01, max=0.01),
        #P('Chan_Krp_taumul', 1.2, min=0.5, max=2),
        P('Chan_Kir_vshift', 0, min = -.02, max = .02),
        P('Chan_Kir_taumul', 1.0, min = .25, max = 3),
        P('morph_file', morph_file, fixed=1),
        P('neuron_type', ntype,                     fixed=1),
        P('model',           modeltype,     fixed=1))

    #fitness=aju.fitnesses.combined_fitness('new_combined_fitness')
    fitness = aju.fitnesses.combined_fitness('empty',
                                             response=2,
                                             baseline_pre=1,
                                             baseline_post=1,
                                             rectification=1,
                                             falling_curve_time=1,
                                             spike_time=2,
                                             spike_width=2,
                                             spike_height=10,
                                             spike_latency=1,
                                             spike_count=1,
                                             spike_ahp=2,
                                             ahp_curve=2,
                                             charging_curve_time=2,
                                             spike_range_y_histogram=1,
                                             mean_isi=2,
                                             isi_spread=2,
                                             spike_threshold=1,
                                             response_variance=0.05)
    return params,fitness
